/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.typ.TYPFile;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.imgfmt.app.typ.TypLabelException;
import uk.me.parabola.imgfmt.app.typ.TypParam;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.main.MapProcessor;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.typ.TypTextReader;

public class TypCompiler
implements MapProcessor {
    @Override
    public String makeMap(CommandArgs args, String filename) {
        int last;
        File outFile;
        String outName;
        TypData data;
        assert (filename.toLowerCase().endsWith(".txt"));
        CharsetProbe probe = new CharsetProbe();
        String readCharset = probe.probeCharset(filename);
        try {
            data = this.compile(filename, readCharset, args.getSort());
        }
        catch (SyntaxException e) {
            throw new MapFailedException("Compiling TYP txt file: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new MapFailedException("Could not open TYP file " + filename + " to read");
        }
        TypParam param = data.getParam();
        int family = args.get("family-id", -1);
        int product = args.get("product-id", -1);
        int cp = args.get("code-page", -1);
        if (family != -1) {
            param.setFamilyId(family);
        }
        if (product != -1) {
            param.setProductId(product);
        }
        if (cp != -1) {
            param.setCodePage(cp);
        }
        if ((outName = (outFile = new File(filename)).getName()).length() > 4 && (last = outName.lastIndexOf(46)) > 0) {
            outName = outName.substring(0, last);
        }
        outName = outName + ".typ";
        outFile = new File(args.getOutputDir(), outName);
        try {
            this.writeTyp(data, outFile);
        }
        catch (TypLabelException e) {
            throw new MapFailedException("TYP file cannot be written in code page " + data.getSort().getCodepage());
        }
        catch (IOException e) {
            throw new MapFailedException("Error while writing typ file", e);
        }
        return outFile.getPath();
    }

    private TypData compile(String filename, String charset, Sort sort) throws FileNotFoundException, SyntaxException {
        TypTextReader tr = new TypTextReader();
        TypData data = tr.getData();
        data.setSort(sort);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), charset));
            tr.read(filename, r);
        }
        catch (UnsupportedEncodingException e) {
            throw new MapFailedException("Unsupported character set", e);
        }
        return tr.getData();
    }

    private void writeTyp(TypData data, File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel channel = raf.getChannel();
        channel.truncate(0L);
        FileImgChannel w = new FileImgChannel(channel);
        TYPFile typ = new TYPFile(w);
        typ.setData(data);
        typ.write();
        typ.close();
    }

    public static void main(String[] args) throws IOException {
        String in = "default.txt";
        if (args.length > 0) {
            in = args[0];
        }
        String out = "OUT.TYP";
        if (args.length > 1) {
            out = args[1];
        }
        new TypCompiler().standAloneRun(in, out);
    }

    private void standAloneRun(String in, String out) {
        TypData data;
        CharsetProbe probe = new CharsetProbe();
        String readCharset = probe.probeCharset(in);
        try {
            data = this.compile(in, readCharset, null);
        }
        catch (SyntaxException e) {
            System.out.println(e.getMessage());
            return;
        }
        catch (FileNotFoundException e) {
            throw new MapFailedException("Could not open TYP file " + in + " to read");
        }
        try {
            this.writeTyp(data, new File(out));
        }
        catch (IOException e) {
            System.out.println("Error writing file: " + e.getMessage());
        }
    }

    class CharsetProbe {
        private String codePage;
        private CharsetEncoder encoder;

        public CharsetProbe() {
            this.setCodePage("latin1");
        }

        private void setCodePage(String codePage) {
            this.codePage = codePage;
            this.encoder = Charset.forName(codePage).newEncoder();
        }

        private String probeCharset(String file) {
            String readingCharset = "utf-8";
            try {
                this.tryCharset(file, readingCharset);
                return readingCharset;
            }
            catch (TypLabelException e) {
                try {
                    readingCharset = e.getCharsetName();
                    this.tryCharset(file, readingCharset);
                }
                catch (Exception e1) {
                    return "utf-8";
                }
                return readingCharset;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void tryCharset(String file, String readingCharset) {
            block14: {
                block13: {
                    is = null;
                    try {
                        is = new FileInputStream(file);
                        br = new BufferedReader(new InputStreamReader((InputStream)is, readingCharset));
lbl5:
                        // 5 sources

                        while ((line = br.readLine()) != null) {
                            if (line.isEmpty()) continue;
                            if (line.charAt(0) == '\ufeff') {
                                break block13;
                            }
                            ** GOTO lbl-1000
                        }
                        break block14;
                    }
                    catch (UnsupportedEncodingException e) {
                        try {
                            throw new TypLabelException(this.codePage);
                            catch (CharacterCodingException e) {
                                throw new TypLabelException(this.codePage);
                            }
                            catch (FileNotFoundException e) {
                                throw new ExitException("File not found " + file);
                            }
                            catch (IOException e) {
                                throw new ExitException("Could not read file " + file);
                            }
                        }
                        catch (Throwable var8_12) {
                            Utils.closeFile(is);
                            throw var8_12;
                        }
                    }
                }
                Utils.closeFile(is);
                return;
lbl-1000:
                // 1 sources

                {
                    if (line.startsWith("CodePage")) {
                        split = line.split("=");
                        try {
                            this.setCodePage("cp" + Integer.decode(split[1].trim()));
                        }
                        catch (NumberFormatException e) {
                            this.setCodePage("cp1252");
                        }
                    }
                    if (!line.startsWith("String")) ** GOTO lbl5
                    cb = CharBuffer.wrap(line);
                    if (this.encoder == null) ** GOTO lbl5
                    this.encoder.encode(cb);
                    ** GOTO lbl5
                }
            }
            Utils.closeFile(is);
        }
    }
}

