/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.osmstyle.ActionRule;
import uk.me.parabola.mkgmap.osmstyle.DirectoryFileLoader;
import uk.me.parabola.mkgmap.osmstyle.ExpressionRule;
import uk.me.parabola.mkgmap.osmstyle.RuleSet;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;
import uk.me.parabola.mkgmap.osmstyle.TypeReader;
import uk.me.parabola.mkgmap.osmstyle.actions.ActionList;
import uk.me.parabola.mkgmap.osmstyle.actions.ActionReader;
import uk.me.parabola.mkgmap.osmstyle.eval.AbstractBinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.AndOp;
import uk.me.parabola.mkgmap.osmstyle.eval.BinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ExistsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ExpressionReader;
import uk.me.parabola.mkgmap.osmstyle.eval.LinkedOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NodeType;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.osmstyle.eval.OrOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ValueOp;
import uk.me.parabola.mkgmap.osmstyle.function.StyleFunction;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class RuleFileReader {
    private static final Logger log = Logger.getLogger(RuleFileReader.class);
    private final FeatureKind kind;
    private final TypeReader typeReader;
    private final RuleSet rules;
    private RuleSet finalizeRules;
    private final boolean performChecks;
    private final Map<Integer, List<Integer>> overlays;
    private boolean inFinalizeSection = false;

    public RuleFileReader(FeatureKind kind, LevelInfo[] levels, RuleSet rules, boolean performChecks, Map<Integer, List<Integer>> overlays) {
        this.kind = kind;
        this.rules = rules;
        this.performChecks = performChecks;
        this.overlays = overlays;
        this.typeReader = new TypeReader(kind, levels);
    }

    public void load(StyleFileLoader loader, String name) throws FileNotFoundException {
        this.loadFile(loader, name);
        this.rules.prepare();
        if (this.finalizeRules != null) {
            this.finalizeRules.prepare();
            this.rules.setFinalizeRule(this.finalizeRules);
        }
    }

    private void loadFile(StyleFileLoader loader, String name) throws FileNotFoundException {
        Reader r = loader.open(name);
        TokenScanner scanner = new TokenScanner(name, r);
        scanner.setExtraWordChars("-:.");
        ExpressionReader expressionReader = new ExpressionReader(scanner, this.kind);
        ActionReader actionReader = new ActionReader(scanner);
        scanner.skipSpace();
        while (!scanner.isEndOfFile()) {
            if (this.checkCommand(loader, scanner)) continue;
            if (scanner.isEndOfFile()) break;
            Op expr = expressionReader.readConditions();
            ActionList actionList = actionReader.readActions();
            GType type = null;
            if (scanner.checkToken("[")) {
                type = this.typeReader.readType(scanner, this.performChecks, this.overlays);
            } else if (actionList == null) {
                throw new SyntaxException(scanner, "No type definition given");
            }
            this.saveRule(scanner, expr, actionList, type);
            scanner.skipSpace();
        }
        this.rules.addUsedTags(expressionReader.getUsedTags());
        this.rules.addUsedTags(actionReader.getUsedTags());
    }

    private boolean checkCommand(StyleFileLoader currentLoader, TokenScanner scanner) {
        scanner.skipSpace();
        if (scanner.isEndOfFile()) {
            return false;
        }
        if (scanner.checkToken("include")) {
            Token token = scanner.nextToken();
            scanner.skipSpace();
            Token next = scanner.peekToken();
            if (next.getType() == TokType.TEXT || next.getType() == TokType.SYMBOL && (next.isValue("'") || next.isValue("\""))) {
                String filename = scanner.nextWord();
                StyleFileLoader loader = currentLoader;
                scanner.skipSpace();
                if (scanner.checkToken("from")) {
                    scanner.nextToken();
                    String styleName = scanner.nextWord();
                    if (styleName.equals(";")) {
                        throw new SyntaxException(scanner, "No style name after 'from'");
                    }
                    try {
                        loader = StyleFileLoader.createStyleLoader(null, styleName);
                    }
                    catch (FileNotFoundException e) {
                        throw new SyntaxException(scanner, "Cannot find style: " + styleName);
                    }
                }
                scanner.validateNext(";");
                try {
                    this.loadFile(loader, filename);
                    boolean styleName = true;
                    return styleName;
                }
                catch (FileNotFoundException e) {
                    throw new SyntaxException(scanner, "Cannot open included file: " + filename);
                }
                finally {
                    if (loader != currentLoader) {
                        Utils.closeFile(loader);
                    }
                }
            }
            scanner.pushToken(token);
        } else if (scanner.checkToken("<")) {
            Token token = scanner.nextToken();
            if (scanner.checkToken("finalize")) {
                Token finalizeToken = scanner.nextToken();
                if (scanner.checkToken(">")) {
                    if (this.inFinalizeSection) {
                        throw new SyntaxException(scanner, "There is only one finalize section allowed");
                    }
                    scanner.nextToken();
                    this.inFinalizeSection = true;
                    this.finalizeRules = new RuleSet();
                    return true;
                }
                scanner.pushToken(finalizeToken);
                scanner.pushToken(token);
            } else {
                scanner.pushToken(token);
            }
        }
        scanner.skipSpace();
        return false;
    }

    private void saveRule(TokenScanner scanner, Op op, ActionList actions, GType gt) {
        log.debug("EXP", op, ", type=", gt);
        if (this.inFinalizeSection && gt != null) {
            throw new SyntaxException(scanner, "Element type definition is not allowed in <finalize> section");
        }
        Op op2 = RuleFileReader.rearrangeExpression(op);
        if (op2 instanceof BinaryOp) {
            this.optimiseAndSaveBinaryOp(scanner, (BinaryOp)op2, actions, gt);
        } else {
            this.optimiseAndSaveOtherOp(scanner, op2, actions, gt);
        }
    }

    private static Op rearrangeExpression(Op op) {
        if (RuleFileReader.isFinished(op)) {
            return op;
        }
        if (op.isType(NodeType.AND)) {
            RuleFileReader.rearrangeExpression(op.getFirst());
            RuleFileReader.rearrangeExpression(op.getSecond());
            RuleFileReader.swapForSelectivity((BinaryOp)op);
            while (op.getFirst().isType(NodeType.AND)) {
                Op aAndB = op.getFirst();
                Op c = op.getSecond();
                op.setFirst(aAndB.getFirst());
                aAndB.setFirst(aAndB.getSecond());
                ((BinaryOp)aAndB).setSecond(c);
                ((BinaryOp)op).setSecond(aAndB);
            }
            Op op1 = op.getFirst();
            Op op2 = op.getSecond();
            if (RuleFileReader.isSolved(op1)) {
                return RuleFileReader.rearrangeAnd((BinaryOp)op, op1, op2);
            }
            if (RuleFileReader.isSolved(op2)) {
                return RuleFileReader.rearrangeAnd((BinaryOp)op, op2, op1);
            }
        }
        return op;
    }

    private static void swapForSelectivity(BinaryOp op) {
        Op second;
        int sel2;
        Op first = op.getFirst();
        int sel1 = RuleFileReader.selectivity(first);
        if (sel1 > (sel2 = RuleFileReader.selectivity(second = op.getSecond()))) {
            op.setFirst(second);
            op.setSecond(first);
        }
    }

    private static BinaryOp rearrangeAnd(BinaryOp top, Op op1, Op op2) {
        if (RuleFileReader.isIndexable(op1)) {
            top.setFirst(op1);
            top.setSecond(op2);
            return top;
        }
        if (op1.isType(NodeType.AND)) {
            Op first = op1.getFirst();
            if (RuleFileReader.isIndexable(first)) {
                top.setFirst(first);
                op1.setFirst(op2);
                RuleFileReader.swapForSelectivity((AndOp)op1);
                top.setSecond(op1);
                return top;
            }
        } else {
            if (op1.isType(NodeType.OR)) {
                return RuleFileReader.distrubute(op1, top.getSecond());
            }
            throw new SyntaxException("X3:" + (Object)((Object)op1.getType()));
        }
        return top;
    }

    private static OrOp distrubute(Op op1, Op topSecond) {
        Op first = op1.getFirst();
        OrOp orOp = new OrOp();
        AndOp and1 = new AndOp();
        and1.setFirst(first);
        and1.setSecond(topSecond);
        AbstractBinaryOp and2 = new AndOp();
        Op second = RuleFileReader.rearrangeExpression(op1.getSecond());
        if (second.isType(NodeType.OR)) {
            and2 = RuleFileReader.distrubute(second, topSecond);
        } else {
            and2.setFirst(second);
            and2.setSecond(topSecond);
        }
        orOp.setFirst(and1);
        orOp.setSecond(and2);
        return orOp;
    }

    private static boolean isIndexable(Op op) {
        return op.isType(NodeType.EQUALS) && ((ValueOp)op.getFirst()).isIndexable() && op.getSecond().isType(NodeType.VALUE) || op.isType(NodeType.EXISTS) && ((ValueOp)op.getFirst()).isIndexable();
    }

    private static boolean isSolved(Op op) {
        return RuleFileReader.isIndexable(op) || RuleFileReader.isIndexable(op.getFirst());
    }

    private static boolean isFinished(Op op) {
        if (op.isType(NodeType.AND) && RuleFileReader.selectivity(op.getFirst()) > RuleFileReader.selectivity(op.getSecond())) {
            return false;
        }
        if (RuleFileReader.isSolved(op)) {
            return true;
        }
        NodeType type = op.getType();
        switch (type) {
            case AND: {
                return false;
            }
            case OR: {
                return false;
            }
        }
        return true;
    }

    private static int selectivity(Op op) {
        switch (op.getType()) {
            case EQUALS: {
                return 0;
            }
            case EXISTS: {
                return 10;
            }
            case AND: {
                return Math.min(RuleFileReader.selectivity(op.getFirst()), RuleFileReader.selectivity(op.getSecond()));
            }
            case OR: {
                return Math.max(RuleFileReader.selectivity(op.getFirst()), RuleFileReader.selectivity(op.getSecond()));
            }
        }
        return 1000;
    }

    private void optimiseAndSaveOtherOp(TokenScanner scanner, Op op, ActionList actions, GType gt) {
        if (!op.isType(NodeType.EXISTS)) {
            throw new SyntaxException(scanner, "Cannot start expression with: " + op);
        }
        this.createAndSaveRule(op.getFirst().getKeyValue() + "=*", op, actions, gt);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void optimiseAndSaveBinaryOp(TokenScanner scanner, BinaryOp op, ActionList actions, GType gt) {
        String keystring;
        block8: {
            Op second;
            Op first;
            block10: {
                block9: {
                    first = op.getFirst();
                    second = op.getSecond();
                    log.debug(new Object[]{"binop", op.getType(), first.getType()});
                    if (!op.isType(NodeType.EQUALS) || !first.isType(NodeType.FUNCTION) || !second.isType(NodeType.VALUE)) break block9;
                    keystring = first.getKeyValue() + "=" + second.getKeyValue();
                    break block8;
                }
                if (!op.isType(NodeType.AND)) break block10;
                if (first.isType(NodeType.EQUALS)) {
                    keystring = first.getFirst().getKeyValue() + "=" + first.getSecond().getKeyValue();
                    break block8;
                } else if (first.isType(NodeType.EXISTS)) {
                    keystring = first.getFirst().getKeyValue() + "=*";
                    break block8;
                } else {
                    if (first.isType(NodeType.NOT_EXISTS)) {
                        throw new SyntaxException(scanner, "Cannot start rule with tag!=*");
                    }
                    if (first.getFirst() != null && first.getFirst().getType() == NodeType.FUNCTION && ((StyleFunction)first.getFirst()).isIndexable()) {
                        AndOp aop = this.combineWithExists(new ValueOp(first.getFirst().getKeyValue()), op);
                        this.optimiseAndSaveBinaryOp(scanner, aop, actions, gt);
                        return;
                    }
                    throw new SyntaxException(scanner, "Invalid rule expression: " + op);
                }
            }
            if (op.isType(NodeType.OR)) {
                LinkedOp op1 = LinkedOp.create(first, true);
                this.saveRule(scanner, op1, actions, gt);
                this.saveRestOfOr(scanner, actions, gt, second, op1);
                return;
            }
            if (first.isType(NodeType.FUNCTION) && ((StyleFunction)first).isIndexable()) {
                AndOp andOp = this.combineWithExists(first, op);
                this.optimiseAndSaveBinaryOp(scanner, andOp, actions, gt);
                return;
            }
            throw new SyntaxException("Cannot use " + first + " without tag matches");
        }
        this.createAndSaveRule(keystring, op, actions, gt);
    }

    private AndOp combineWithExists(Op first, BinaryOp op) {
        ExistsOp existsOp = new ExistsOp();
        existsOp.setFirst(first);
        AndOp andOp = new AndOp();
        andOp.setFirst(existsOp);
        andOp.setSecond(op);
        return andOp;
    }

    private void saveRestOfOr(TokenScanner scanner, ActionList actions, GType gt, Op second, LinkedOp op1) {
        if (second.isType(NodeType.OR)) {
            LinkedOp nl = LinkedOp.create(second.getFirst(), false);
            op1.setLink(nl);
            this.saveRule(scanner, nl, actions, gt);
            this.saveRestOfOr(scanner, actions, gt, second.getSecond(), op1);
        } else {
            LinkedOp op2 = LinkedOp.create(second, false);
            op1.setLink(op2);
            this.saveRule(scanner, op2, actions, gt);
        }
    }

    private void createAndSaveRule(String keystring, Op expr, ActionList actions, GType gt) {
        Rule rule = actions.isEmpty() ? new ExpressionRule(expr, gt) : new ActionRule(expr, actions.getList(), gt);
        if (this.inFinalizeSection) {
            this.finalizeRules.add(keystring, rule, actions.getChangeableTags());
        } else {
            this.rules.add(keystring, rule, actions.getChangeableTags());
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length > 0) {
            RuleSet rs = new RuleSet();
            RuleFileReader rr = new RuleFileReader(FeatureKind.POLYLINE, LevelInfo.createFromString("0:24 1:20 2:18 3:16 4:14"), rs, false, Collections.emptyMap());
            DirectoryFileLoader loader = new DirectoryFileLoader(new File(args[0]).getAbsoluteFile().getParentFile());
            String fname = new File(args[0]).getName();
            rr.load(loader, fname);
            System.out.println("Result: " + rs);
        } else {
            System.err.println("Usage: RuleFileReader <file>");
        }
    }
}

