/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.Option;
import uk.me.parabola.mkgmap.OptionProcessor;
import uk.me.parabola.mkgmap.Options;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LineAdder;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.osmstyle.OverlayReader;
import uk.me.parabola.mkgmap.osmstyle.RuleFileReader;
import uk.me.parabola.mkgmap.osmstyle.RuleSet;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;
import uk.me.parabola.mkgmap.osmstyle.StylePrinter;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.StyleInfo;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.util.EnhancedProperties;

public class StyleImpl
implements Style {
    private static final Logger log = Logger.getLogger(StyleImpl.class);
    public static final boolean WITH_CHECKS = true;
    public static final boolean WITHOUT_CHECKS = false;
    private static final int VERSION = 1;
    private static final Collection<String> OPTION_LIST = new ArrayList<String>(Arrays.asList("levels", "overview-levels", "extra-used-tags"));
    private static final String FILE_VERSION = "version";
    private static final String FILE_INFO = "info";
    private static final String FILE_OPTIONS = "options";
    private static final String FILE_OVERLAYS = "overlays";
    private static final Pattern COMMA_OR_SPACE_PATTERN = Pattern.compile("[,\\s]+");
    private final StyleFileLoader fileLoader;
    private final String location;
    private StyleInfo info = new StyleInfo();
    private final List<StyleImpl> baseStyles = new ArrayList<StyleImpl>();
    private List<String> nameTagList;
    private final Map<String, String> generalOptions = new HashMap<String, String>();
    private final RuleSet lines = new RuleSet();
    private final RuleSet polygons = new RuleSet();
    private final RuleSet nodes = new RuleSet();
    private final RuleSet relations = new RuleSet();
    private OverlayReader overlays;
    private final boolean performChecks;

    public StyleImpl(String loc, String name) throws FileNotFoundException {
        this(loc, name, new EnhancedProperties(), false);
    }

    public StyleImpl(String loc, String name, EnhancedProperties props, boolean performChecks) throws FileNotFoundException {
        this.location = loc;
        this.fileLoader = StyleFileLoader.createStyleLoader(loc, name);
        this.performChecks = performChecks;
        this.nameTagList = LocatorUtil.getNameTags(props);
        this.checkVersion();
        this.readInfo();
        for (String baseName : this.info.baseStyles()) {
            this.readBaseStyle(baseName, props);
        }
        for (StyleImpl baseStyle : this.baseStyles) {
            this.mergeOptions(baseStyle);
        }
        this.readOptions();
        this.readOverlays();
        this.readRules();
        ListIterator<StyleImpl> listIterator = this.baseStyles.listIterator(this.baseStyles.size());
        while (listIterator.hasPrevious()) {
            this.mergeRules(listIterator.previous());
        }
    }

    @Override
    public String getOption(String name) {
        return this.generalOptions.get(name);
    }

    @Override
    public StyleInfo getInfo() {
        return this.info;
    }

    @Override
    public Rule getNodeRules() {
        this.nodes.prepare();
        return this.nodes;
    }

    @Override
    public Rule getWayRules() {
        RuleSet r = new RuleSet();
        r.addAll(this.lines);
        r.addAll(this.polygons);
        r.prepare();
        return r;
    }

    @Override
    public Rule getLineRules() {
        this.lines.prepare();
        return this.lines;
    }

    @Override
    public Rule getPolygonRules() {
        this.polygons.prepare();
        return this.polygons;
    }

    @Override
    public Rule getRelationRules() {
        this.relations.prepare();
        return this.relations;
    }

    @Override
    public LineAdder getOverlays(final LineAdder lineAdder) {
        LineAdder adder = null;
        if (this.overlays != null) {
            adder = new LineAdder(){

                @Override
                public void add(MapLine element) {
                    StyleImpl.this.overlays.addLine(element, lineAdder);
                }
            };
        }
        return adder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getUsedTags() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.relations.getUsedTags());
        set.addAll(this.lines.getUsedTags());
        set.addAll(this.polygons.getUsedTags());
        set.addAll(this.nodes.getUsedTags());
        String s = this.getOption("extra-used-tags");
        if (s != null && !s.trim().isEmpty()) {
            set.addAll(Arrays.asList(COMMA_OR_SPACE_PATTERN.split(s)));
        }
        if (this.nameTagList != null) {
            set.addAll(this.nameTagList);
        }
        InputStream is = this.getClass().getResourceAsStream("/styles/builtin-tag-list");
        try {
            if (is != null) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    set.add(line);
                }
            }
        }
        catch (IOException e) {
            System.err.println("warning: built in tag list not found");
        }
        finally {
            Utils.closeFile(is);
        }
        return set;
    }

    private void readRules() {
        RuleFileReader reader;
        String l = this.generalOptions.get("levels");
        if (l == null) {
            l = "0:24, 1:22, 2:20, 3:18, 4:16";
        }
        Object[] levels = LevelInfo.createFromString(l);
        if (this.performChecks && levels[0].getBits() <= 10) {
            System.err.println("Warning: Resolution values <= 10 may confuse MapSource: " + l);
        }
        if ((l = this.generalOptions.get("overview-levels")) != null) {
            LevelInfo[] ovLevels = LevelInfo.createFromString(l);
            if (this.performChecks) {
                if (ovLevels[0].getBits() <= 10) {
                    System.err.println("Warning: Resolution values <= 10 may confuse MapSource: " + l);
                }
                if (levels[0].getLevel() >= ovLevels[ovLevels.length - 1].getLevel()) {
                    System.err.println("Warning: Overview level not higher than highest normal level. " + l);
                }
            }
            ArrayList<LevelInfo> tmp = new ArrayList<LevelInfo>();
            tmp.addAll(Arrays.asList(levels));
            tmp.addAll(Arrays.asList(ovLevels));
            levels = tmp.toArray(new LevelInfo[tmp.size()]);
            Arrays.sort(levels);
        }
        try {
            reader = new RuleFileReader(FeatureKind.RELATION, (LevelInfo[])levels, this.relations, this.performChecks, this.getOverlaidTypeMap());
            reader.load(this.fileLoader, "relations");
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"no relations file");
        }
        try {
            reader = new RuleFileReader(FeatureKind.POINT, (LevelInfo[])levels, this.nodes, this.performChecks, this.getOverlaidTypeMap());
            reader.load(this.fileLoader, "points");
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"no points file");
        }
        try {
            reader = new RuleFileReader(FeatureKind.POLYLINE, (LevelInfo[])levels, this.lines, this.performChecks, this.getOverlaidTypeMap());
            reader.load(this.fileLoader, "lines");
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"no lines file");
        }
        try {
            reader = new RuleFileReader(FeatureKind.POLYGON, (LevelInfo[])levels, this.polygons, this.performChecks, this.getOverlaidTypeMap());
            reader.load(this.fileLoader, "polygons");
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"no polygons file");
        }
    }

    private void readOptions() {
        try {
            Reader r = this.fileLoader.open(FILE_OPTIONS);
            Options opts = new Options(new OptionProcessor(){

                @Override
                public void processOption(Option opt) {
                    String key = opt.getOption();
                    String val = opt.getValue();
                    if (key.equals("name-tag-list")) {
                        if (!"name".equals(val)) {
                            System.err.println("Warning: option name-tag-list used in the style options is ignored. Please use only the command line option to specify this value.");
                        }
                    } else if (OPTION_LIST.contains(key)) {
                        StyleImpl.this.generalOptions.put(key, val);
                    }
                }
            });
            opts.readOptionFile(r, FILE_OPTIONS);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"no options file");
        }
    }

    private void readInfo() {
        try {
            BufferedReader br = new BufferedReader(this.fileLoader.open(FILE_INFO));
            this.info = new StyleInfo();
            Options opts = new Options(new OptionProcessor(){

                @Override
                public void processOption(Option opt) {
                    String word = opt.getOption();
                    String value = opt.getValue();
                    if (word.equals("summary")) {
                        StyleImpl.this.info.setSummary(value);
                    } else if (word.equals(StyleImpl.FILE_VERSION)) {
                        StyleImpl.this.info.setVersion(value);
                    } else if (word.equals("base-style")) {
                        StyleImpl.this.info.addBaseStyleName(value);
                    } else if (word.equals("description")) {
                        StyleImpl.this.info.setLongDescription(value);
                    }
                }
            });
            opts.readOptionFile(br, FILE_INFO);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"no info file");
        }
    }

    private void readOverlays() {
        try {
            Reader r = this.fileLoader.open(FILE_OVERLAYS);
            this.overlays = new OverlayReader(r, FILE_OVERLAYS);
            this.overlays.readOverlays();
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"no overlay file");
        }
    }

    private void readBaseStyle(String name, EnhancedProperties props) {
        if (name == null) {
            return;
        }
        try {
            this.baseStyles.add(new StyleImpl(this.location, name, props, this.performChecks));
        }
        catch (SyntaxException e) {
            System.err.println("Error in style: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            log.debug("could not open base style file", e);
            try {
                this.baseStyles.add(new StyleImpl(null, name, props, this.performChecks));
            }
            catch (SyntaxException se) {
                System.err.println("Error in style: " + se.getMessage());
            }
            catch (FileNotFoundException e1) {
                log.error((Object)"Could not find base style", e);
            }
        }
    }

    private void mergeOptions(StyleImpl other) {
        for (Map.Entry<String, String> ent : other.generalOptions.entrySet()) {
            String opt = ent.getKey();
            String val = ent.getValue();
            if (!OPTION_LIST.contains(opt)) continue;
            this.generalOptions.put(opt, val);
        }
    }

    private void mergeRules(StyleImpl other) {
        this.lines.merge(other.lines);
        this.polygons.merge(other.polygons);
        this.nodes.merge(other.nodes);
        this.relations.merge(other.relations);
    }

    private void checkVersion() throws FileNotFoundException {
        int version;
        Reader r = this.fileLoader.open(FILE_VERSION);
        TokenScanner scan = new TokenScanner(FILE_VERSION, r);
        try {
            version = scan.nextInt();
            log.debug("Got version", version);
        }
        catch (NumberFormatException e) {
            version = 0;
        }
        if (version > 1) {
            System.err.println("Warning: unrecognised style version " + version + ", but only versions up to " + 1 + " are understood");
        }
    }

    void dumpToFile(Writer out) {
        StylePrinter stylePrinter = new StylePrinter(this);
        stylePrinter.setGeneralOptions(this.generalOptions);
        stylePrinter.setRelations(this.relations);
        stylePrinter.setLines(this.lines);
        stylePrinter.setNodes(this.nodes);
        stylePrinter.setPolygons(this.polygons);
        stylePrinter.dumpToFile(out);
    }

    private Map<Integer, List<Integer>> getOverlaidTypeMap() {
        if (this.overlays != null) {
            return this.overlays.getOverlays();
        }
        return Collections.emptyMap();
    }

    public static Style readStyle(EnhancedProperties props) {
        StyleImpl style;
        String loc = props.getProperty("style-file");
        if (loc == null) {
            loc = props.getProperty("map-features");
        }
        String name = props.getProperty("style");
        if (loc == null && name == null) {
            name = "default";
        }
        if (name == null) {
            StyleFileLoader loader = null;
            try {
                loader = StyleFileLoader.createStyleLoader(loc, null);
                int numEntries = loader.list().length;
                if (numEntries > 1) {
                    throw new ExitException("Style file " + loc + " contains multiple styles, use option --style to select one.");
                }
            }
            catch (FileNotFoundException e) {
                throw new ExitException("Could not open style file " + loc);
            }
            finally {
                Utils.closeFile(loader);
            }
        }
        try {
            style = new StyleImpl(loc, name, props, false);
        }
        catch (SyntaxException e) {
            System.err.println("Error in style: " + e.getMessage());
            throw new ExitException("Could not open style " + (name == null ? "" : name));
        }
        catch (FileNotFoundException e) {
            String msg = "Could not open style ";
            if (name != null) {
                msg = msg + name;
                if (loc != null) {
                    msg = msg + " in " + loc;
                }
            } else {
                msg = msg + loc + " . Make sure that it points to a style or add the --style option.";
            }
            throw new ExitException(msg);
        }
        return style;
    }

    @Override
    public void reportStats() {
        this.relations.printStats("relations");
        this.nodes.printStats("points");
        this.lines.printStats("lines");
        this.polygons.printStats("polygons");
    }

    public static void main(String[] args) throws FileNotFoundException {
        String file = args[0];
        String name = null;
        if (args.length > 1) {
            name = args[1];
        }
        StyleImpl style = new StyleImpl(file, name, new EnhancedProperties(), true);
        style.dumpToFile(new OutputStreamWriter(System.out));
    }
}

