/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.ConvertedWay;
import uk.me.parabola.mkgmap.reader.osm.CoordPOI;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.GpxCreator;

public class WrongAngleFixer {
    private static final Logger log = Logger.getLogger(WrongAngleFixer.class);
    private static final double MAX_BEARING_ERROR = 15.0;
    private static final double MAX_BEARING_ERROR_HALF = 7.5;
    private static final double MAX_DIFF_ANGLE_STRAIGHT_LINE = 3.0;
    private final Area bbox;
    private final String gpxPath;
    static final int MODE_ROADS = 0;
    static final int MODE_LINES = 1;
    private int mode = 0;

    public WrongAngleFixer(Area bbox) {
        this.gpxPath = null;
        this.bbox = bbox;
        if (this.gpxPath != null && bbox != null && bbox.getWidth() * bbox.getHeight() < 100000) {
            ArrayList<Coord> grid = new ArrayList<Coord>();
            for (int lat = bbox.getMinLat(); lat < bbox.getMaxLat(); ++lat) {
                for (int lon = bbox.getMinLong(); lon < bbox.getMaxLong(); ++lon) {
                    grid.add(new Coord(lat, lon));
                }
            }
            GpxCreator.createGpx("e:/ld/grid", bbox.toCoords(), grid);
        }
    }

    public void optimizeWays(List<ConvertedWay> roads, List<ConvertedWay> lines, HashMap<Long, ConvertedWay> modifiedRoads, HashSet<Long> deletedRoads, List<RestrictionRelation> restrictions) {
        this.printBadAngles("bad_angles_start", roads);
        this.writeOSM("roads_orig", roads);
        this.writeOSM("lines_orig", lines);
        this.removeWrongAngles(roads, lines, modifiedRoads, deletedRoads, restrictions);
        this.writeOSM("roads_post_rem_wrong_angles", roads);
        this.removeObsoletePoints(roads, modifiedRoads);
        this.writeOSM("roads_post_rem_obsolete_points", roads);
        this.printBadAngles("bad_angles_finish", roads);
        this.mode = 1;
        this.writeOSM("lines_after_roads", lines);
        this.removeWrongAngles(null, lines, modifiedRoads, null, restrictions);
        this.writeOSM("lines_post_rem_wrong_angles", lines);
        this.removeObsoletePoints(lines, modifiedRoads);
        this.writeOSM("lines_final", lines);
    }

    private void replaceCoord(Coord toRepl, Coord replacement, Map<Coord, Coord> replacements) {
        CoordPOI cp;
        assert (toRepl != replacement);
        if (toRepl.getOnBoundary()) {
            if (!replacement.equals(toRepl)) {
                log.error("boundary node is replaced by node with non-equal coordinates at", toRepl.toOSMURL());
                assert (false) : "boundary node is replaced";
            }
            replacement.setOnBoundary(true);
        }
        toRepl.setReplaced(true);
        if (toRepl instanceof CoordPOI && (cp = (CoordPOI)toRepl).isUsed()) {
            replacement = new CoordPOI(replacement);
            ((CoordPOI)replacement).setNode(cp.getNode());
            ((CoordPOI)replacement).setUsed(true);
            ((CoordPOI)replacement).setConvertToViaInRouteRestriction(cp.getConvertToViaInRouteRestriction());
            if (!replacement.highPrecEquals(cp.getNode().getLocation())) {
                log.error("CoordPOI node is replaced with non-equal coordinates at", toRepl.toOSMURL());
            }
        }
        if (toRepl.isViaNodeOfRestriction()) {
            replacement.setViaNodeOfRestriction(true);
        }
        replacements.put(toRepl, replacement);
        while (toRepl.getHighwayCount() > replacement.getHighwayCount()) {
            replacement.incHighwayCount();
        }
        if (this.mode == 1 && toRepl.isEndOfWay()) {
            replacement.setEndOfWay(true);
        }
    }

    private static Coord getReplacement(Coord p, Way way, Map<Coord, Coord> replacements) {
        if (p.isReplaced()) {
            Coord replacement = null;
            Coord r = p;
            while ((r = replacements.get(r)) != null) {
                replacement = r;
            }
            if (replacement != null) {
                if (p instanceof CoordPOI) {
                    String wayPOI;
                    CoordPOI cp = (CoordPOI)p;
                    Node node = cp.getNode();
                    if (cp.isUsed() && way != null && way.getId() != 0L && (wayPOI = way.getTag("mkgmap:way-poi-node-ids")) != null && wayPOI.contains("[" + node.getId() + "]")) {
                        if (replacement instanceof CoordPOI) {
                            Node rNode = ((CoordPOI)replacement).getNode();
                            if (rNode.getId() != node.getId()) {
                                if (wayPOI.contains("[" + rNode.getId() + "]")) {
                                    log.warn("CoordPOI", node.getId(), "replaced by CoordPOI", rNode.getId(), "in way", way.toBrowseURL());
                                } else {
                                    log.warn("CoordPOI", node.getId(), "replaced by ignored CoordPOI", rNode.getId(), "in way", way.toBrowseURL());
                                }
                            }
                        } else {
                            log.warn("CoordPOI", node.getId(), "replaced by simple coord in way", way.toBrowseURL());
                        }
                    }
                }
                return replacement;
            }
            log.error((Object)("replacement not found for point " + p.toOSMURL()));
        }
        return p;
    }

    private void removeWrongAngles(List<ConvertedWay> roads, List<ConvertedWay> lines, HashMap<Long, ConvertedWay> modifiedRoads, HashSet<Long> deletedRoads, List<RestrictionRelation> restrictions) {
        List<Coord> points;
        Coord p;
        IdentityHashMap<Coord, Coord> replacements = new IdentityHashMap<Coord, Coord>();
        HashSet<Coord> changedPlaces = new HashSet<Coord>();
        int numNodesMerged = 0;
        HashSet<Way> waysWithBearingErrors = new HashSet<Way>();
        HashSet<Long> waysThatMapToOnePoint = new HashSet<Long>();
        int pass = 0;
        Way lastWay = null;
        List<ConvertedWay> convertedWays = roads != null ? roads : lines;
        boolean anotherPassRequired = true;
        while (anotherPassRequired && pass < 20) {
            anotherPassRequired = false;
            log.info((Object)("Removing wrong angles - PASS " + ++pass));
            this.writeOSM(this.mode == 1 ? "lines_pass_" + pass : "roads_pass_" + pass, convertedWays);
            lastWay = null;
            for (ConvertedWay cw : convertedWays) {
                Way way;
                if (!cw.isValid() || cw.isOverlay() || (way = cw.getWay()).equals(lastWay) || pass != 1 && !waysWithBearingErrors.contains(way)) continue;
                lastWay = way;
                List<Coord> points2 = way.getPoints();
                Coord prev = null;
                if (points2.get(0) == points2.get(points2.size() - 1) && points2.size() >= 2) {
                    prev = points2.get(points2.size() - 2);
                }
                boolean hasNonEqualPoints = false;
                for (int i = 0; i < points2.size(); ++i) {
                    Coord p2 = points2.get(i);
                    if (pass == 1) {
                        p2.setRemove(false);
                    }
                    p2 = WrongAngleFixer.getReplacement(p2, way, replacements);
                    if (i == 0 || i == points2.size() - 1) {
                        p2.setEndOfWay(true);
                    }
                    if (prev != null) {
                        double err;
                        if (pass == 1 && !p2.equals(prev)) {
                            hasNonEqualPoints = true;
                        }
                        if ((err = WrongAngleFixer.calcBearingError(p2, prev)) >= 15.0) {
                            p2.setPartOfBadAngle(true);
                            prev.setPartOfBadAngle(true);
                        }
                    }
                    prev = p2;
                }
                if (pass != 1 || hasNonEqualPoints) continue;
                waysThatMapToOnePoint.add(way.getId());
                log.info("all points of way", way.toBrowseURL(), "are rounded to equal map units");
            }
            IdentityHashMap<Coord, CenterOfAngle> centerMap = new IdentityHashMap<Coord, CenterOfAngle>();
            ArrayList<CenterOfAngle> centers = new ArrayList<CenterOfAngle>();
            int centerId = 0;
            lastWay = null;
            for (ConvertedWay cw : convertedWays) {
                Way way;
                if (!cw.isValid() || cw.isOverlay() || (way = cw.getWay()).equals(lastWay) || pass != 1 && !waysWithBearingErrors.contains(way)) continue;
                lastWay = way;
                boolean wayHasSpecialPoints = false;
                List<Coord> points3 = way.getPoints();
                Coord prev = null;
                if (points3.get(0) == points3.get(points3.size() - 1) && points3.size() >= 2) {
                    prev = points3.get(points3.size() - 2);
                }
                for (int i = 0; i < points3.size(); ++i) {
                    p = points3.get(i);
                    if (prev != null) {
                        if (p == prev) {
                            points3.remove(i);
                            --i;
                            if (this.mode != 0) continue;
                            modifiedRoads.put(way.getId(), cw);
                            continue;
                        }
                        if (p.isPartOfBadAngle() || prev.isPartOfBadAngle()) {
                            CenterOfAngle coa2;
                            wayHasSpecialPoints = true;
                            Coord p1 = prev;
                            Coord p2 = p;
                            CenterOfAngle coa1 = (CenterOfAngle)centerMap.get(p);
                            if (coa1 == null) {
                                coa1 = new CenterOfAngle(p, centerId++);
                                centerMap.put(p, coa1);
                                centers.add(coa1);
                            }
                            if ((coa2 = (CenterOfAngle)centerMap.get(prev)) == null) {
                                coa2 = new CenterOfAngle(prev, centerId++);
                                centerMap.put(prev, coa2);
                                centers.add(coa2);
                            }
                            coa1.addNeighbour(coa2);
                            coa2.addNeighbour(coa1);
                            if (points3.size() == 2) {
                                coa1.addBadMergeCandidate(coa2);
                            }
                            if (this.mode == 0 && p1.getHighwayCount() >= 2 && p2.getHighwayCount() >= 2 && cw.isRoundabout()) {
                                coa1.addBadMergeCandidate(coa2);
                            }
                        }
                    }
                    prev = p;
                }
                if (pass != 1 || !wayHasSpecialPoints) continue;
                waysWithBearingErrors.add(way);
            }
            lastWay = null;
            block5: for (ConvertedWay cw : convertedWays) {
                Way way;
                if (!cw.isValid() || cw.isOverlay() || (way = cw.getWay()).equals(lastWay)) continue;
                lastWay = way;
                if (waysWithBearingErrors.contains(way)) continue;
                List<Coord> points4 = way.getPoints();
                for (Coord p3 : points4) {
                    if (p3.getHighwayCount() < 2 || !centerMap.containsKey(p3)) continue;
                    waysWithBearingErrors.add(way);
                    continue block5;
                }
            }
            log.info((Object)("pass " + pass + ": analysing " + centers.size() + " points with bearing problems."));
            centerMap = null;
            ArrayList<CenterOfAngle> checkAgainList = null;
            boolean tryMerge = false;
            while (true) {
                checkAgainList = new ArrayList<CenterOfAngle>();
                for (CenterOfAngle coa : centers) {
                    coa.center.setPartOfBadAngle(false);
                    if (coa.getCurrentLocation(replacements) == null || coa.isOK(replacements)) continue;
                    boolean changed = coa.tryChange(replacements, tryMerge);
                    if (changed) {
                        if (this.gpxPath == null) continue;
                        changedPlaces.add(coa.center);
                        continue;
                    }
                    checkAgainList.add(coa);
                }
                if (tryMerge) break;
                tryMerge = true;
                centers = checkAgainList;
            }
            lastWay = null;
            boolean lastWayModified = false;
            ConvertedWay lastConvertedWay = null;
            for (ConvertedWay cw : convertedWays) {
                Way way;
                if (!cw.isValid() || cw.isOverlay() || !waysWithBearingErrors.contains(way = cw.getWay())) continue;
                List<Coord> points5 = way.getPoints();
                if (way.equals(lastWay)) {
                    if (!lastWayModified) continue;
                    points5.clear();
                    points5.addAll(lastWay.getPoints());
                    if (cw.isReversed() == lastConvertedWay.isReversed()) continue;
                    Collections.reverse(points5);
                    continue;
                }
                lastWay = way;
                lastConvertedWay = cw;
                lastWayModified = false;
                for (int i = points5.size() - 1; i >= 0; --i) {
                    Coord p4 = points5.get(i);
                    if (p4.isToRemove()) {
                        points5.remove(i);
                        anotherPassRequired = true;
                        lastWayModified = true;
                        if (i <= 0 || i >= points5.size() || points5.get(i - 1) != points5.get(i)) continue;
                        points5.remove(i);
                        continue;
                    }
                    Coord replacement = WrongAngleFixer.getReplacement(p4, way, replacements);
                    if (p4 == replacement) continue;
                    if (p4.isViaNodeOfRestriction()) {
                        replacement.setViaNodeOfRestriction(true);
                        p4.setViaNodeOfRestriction(false);
                    }
                    p4 = replacement;
                    points5.set(i, p4);
                    if (p4.getHighwayCount() >= 2) {
                        ++numNodesMerged;
                    }
                    lastWayModified = true;
                    if (i + 1 < points5.size() && points5.get(i + 1) == p4) {
                        points5.remove(i);
                        anotherPassRequired = true;
                    }
                    if (i - 1 < 0 || points5.get(i - 1) != p4) continue;
                    points5.remove(i);
                    anotherPassRequired = true;
                }
                if (!lastWayModified || this.mode != 0) continue;
                modifiedRoads.put(way.getId(), cw);
            }
        }
        int numWaysDeleted = 0;
        lastWay = null;
        boolean lastWayModified = false;
        ConvertedWay lastConvertedWay = null;
        for (ConvertedWay cw : convertedWays) {
            if (cw.isOverlay()) continue;
            Way way = cw.getWay();
            points = way.getPoints();
            if (points.size() < 2) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("  Way " + way.getTag("name") + " (" + way.toBrowseURL() + ") has less than 2 points - deleting it"));
                }
                if (this.mode == 1 && !waysThatMapToOnePoint.contains(way.getId())) {
                    log.warn("non-routable way ", way.getId(), "was removed");
                }
                if (this.mode == 0) {
                    deletedRoads.add(way.getId());
                }
                ++numWaysDeleted;
                continue;
            }
            if (way.equals(lastWay)) {
                if (!lastWayModified) continue;
                points.clear();
                points.addAll(lastWay.getPoints());
                if (cw.isReversed() == lastConvertedWay.isReversed()) continue;
                Collections.reverse(points);
                continue;
            }
            lastWay = way;
            lastConvertedWay = cw;
            lastWayModified = false;
            Coord prev = points.get(points.size() - 1);
            for (int i = points.size() - 2; i >= 0; --i) {
                Coord p5 = points.get(i);
                if (p5 == prev) {
                    points.remove(i);
                    lastWayModified = true;
                }
                prev = p5;
            }
        }
        if (this.mode == 0) {
            for (ConvertedWay cw : lines) {
                if (!cw.isValid() || cw.isOverlay()) continue;
                Way way = cw.getWay();
                points = way.getPoints();
                int n = points.size();
                boolean hasReplacedPoints = false;
                for (int i = 0; i < n; ++i) {
                    p = points.get(i);
                    if (!p.isReplaced()) continue;
                    hasReplacedPoints = true;
                    points.set(i, WrongAngleFixer.getReplacement(p, null, replacements));
                }
                if (!hasReplacedPoints || this.gpxPath == null) continue;
                GpxCreator.createGpx(this.gpxPath + way.getId() + "_mod_non_routable", points);
            }
            for (RestrictionRelation rr : restrictions) {
                for (Coord p6 : rr.getViaCoords()) {
                    Coord replacement;
                    if (p6 == (replacement = WrongAngleFixer.getReplacement(p6, null, replacements))) continue;
                    rr.replaceViaCoord(p6, replacement);
                }
            }
        }
        if (this.gpxPath != null) {
            GpxCreator.createGpx(this.gpxPath + "solved_badAngles", this.bbox.toCoords(), new ArrayList<Coord>(changedPlaces));
        }
        if (anotherPassRequired) {
            log.error((Object)("Removing wrong angles - didn't finish in " + pass + " passes, giving up!"));
        } else {
            log.info("Removing wrong angles - finished in", pass, "passes (", numNodesMerged, "nodes merged,", numWaysDeleted, "ways deleted)");
        }
    }

    private void removeObsoletePoints(List<ConvertedWay> convertedWays, HashMap<Long, ConvertedWay> modifiedRoads) {
        ConvertedWay lastConvertedWay = null;
        int numPointsRemoved = 0;
        boolean lastWasModified = false;
        ArrayList<Coord> removedInWay = new ArrayList<Coord>();
        ArrayList<Coord> obsoletePoints = new ArrayList<Coord>();
        ArrayList<Coord> modifiedPoints = new ArrayList<Coord>();
        for (ConvertedWay cw : convertedWays) {
            List<Coord> points;
            if (!cw.isValid() || cw.isOverlay()) continue;
            Way way = cw.getWay();
            if (lastConvertedWay != null && way.equals(lastConvertedWay.getWay())) {
                if (!lastWasModified) continue;
                points = way.getPoints();
                points.clear();
                points.addAll(lastConvertedWay.getPoints());
                if (cw.isReversed() == lastConvertedWay.isReversed()) continue;
                Collections.reverse(points);
                continue;
            }
            lastConvertedWay = cw;
            lastWasModified = false;
            points = way.getPoints();
            modifiedPoints.clear();
            double maxErrorDistance = WrongAngleFixer.calcMaxErrorDistance(points.get(0));
            boolean draw = false;
            removedInWay.clear();
            modifiedPoints.add(points.get(0));
            int i = 1;
            while (i + 1 < points.size()) {
                block16: {
                    boolean keepThis;
                    Coord cm;
                    block20: {
                        double realAngle;
                        Coord c2;
                        Coord c1;
                        block18: {
                            block19: {
                                block17: {
                                    block15: {
                                        cm = points.get(i);
                                        if (this.allowedToRemove(cm)) break block15;
                                        modifiedPoints.add(cm);
                                        break block16;
                                    }
                                    c1 = (Coord)modifiedPoints.get(modifiedPoints.size() - 1);
                                    if (c1 != (c2 = points.get(i + 1))) break block17;
                                    modifiedPoints.add(cm);
                                    break block16;
                                }
                                keepThis = true;
                                realAngle = Utils.getAngle(c1, cm, c2);
                                if (!(Math.abs(realAngle) < 3.0)) break block18;
                                double distance = cm.distToLineSegment(c1, c2);
                                if (!(distance >= maxErrorDistance)) break block19;
                                modifiedPoints.add(cm);
                                break block16;
                            }
                            keepThis = false;
                            break block20;
                        }
                        double displayedAngle = Utils.getDisplayedAngle(c1, cm, c2);
                        if (displayedAngle < 0.0 && realAngle > 0.0 || displayedAngle > 0.0 && realAngle < 0.0) {
                            keepThis = false;
                        } else if (Math.abs(displayedAngle) < 1.0) {
                            if (c1.getHighwayCount() < 2 && c2.getHighwayCount() < 2) {
                                keepThis = false;
                            }
                        } else if (Math.abs(realAngle - displayedAngle) > 2.0 * Math.abs(realAngle) && Math.abs(realAngle) < 7.5) {
                            keepThis = false;
                        }
                    }
                    if (keepThis) {
                        modifiedPoints.add(cm);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("removing obsolete point on almost straight segment in way ", way.toBrowseURL(), "at", cm.toOSMURL());
                        }
                        if (this.gpxPath != null) {
                            obsoletePoints.add(cm);
                            removedInWay.add(cm);
                        }
                        ++numPointsRemoved;
                        lastWasModified = true;
                    }
                }
                ++i;
            }
            if (!lastWasModified) continue;
            modifiedPoints.add(points.get(points.size() - 1));
            points.clear();
            points.addAll(modifiedPoints);
            if (this.mode == 0) {
                modifiedRoads.put(way.getId(), cw);
            }
            if (this.gpxPath == null || !draw && !cw.isRoundabout()) continue;
            GpxCreator.createGpx(this.gpxPath + way.getId() + "_dpmod", points, removedInWay);
        }
        if (this.gpxPath != null) {
            GpxCreator.createGpx(this.gpxPath + "obsolete", this.bbox.toCoords(), new ArrayList<Coord>(obsoletePoints));
        }
        log.info("Removed", numPointsRemoved, "obsolete points in lines");
    }

    private void printBadAngles(String name, List<ConvertedWay> roads) {
        if (this.gpxPath == null) {
            return;
        }
        ArrayList<ConvertedWay> badWays = new ArrayList<ConvertedWay>();
        Way lastWay = null;
        ArrayList<Coord> badAngles = new ArrayList<Coord>();
        for (int w = 0; w < roads.size(); ++w) {
            Coord plast;
            Coord p0;
            Way way;
            ConvertedWay cw = roads.get(w);
            if (!cw.isValid() || (way = cw.getWay()).equals(lastWay)) continue;
            boolean hasBadAngles = false;
            lastWay = way;
            List<Coord> points = way.getPoints();
            for (int i = points.size() - 2; i >= 1; --i) {
                Coord c2;
                Coord cm = points.get(i);
                Coord c1 = points.get(i - 1);
                if (c1 == (c2 = points.get(i + 1))) continue;
                double realAngle = Utils.getAngle(c1, cm, c2);
                double displayedAngle = Utils.getDisplayedAngle(c1, cm, c2);
                if (!(Math.abs(displayedAngle - realAngle) > 30.0)) continue;
                badAngles.add(cm);
                hasBadAngles = true;
            }
            if (points.size() > 2 && (p0 = points.get(0)) == (plast = points.get(points.size() - 1))) {
                Coord c2;
                Coord cm = points.get(0);
                Coord c1 = points.get(points.size() - 2);
                if (c1 == (c2 = points.get(1))) continue;
                double realAngle = Utils.getAngle(c1, cm, c2);
                double displayedAngle = Utils.getDisplayedAngle(c1, cm, c2);
                if (Math.abs(displayedAngle - realAngle) > 30.0) {
                    badAngles.add(cm);
                    hasBadAngles = true;
                }
            }
            if (!hasBadAngles) continue;
            badWays.add(cw);
        }
        GpxCreator.createGpx(this.gpxPath + name, this.bbox.toCoords(), new ArrayList<Coord>(badAngles));
        this.writeOSM(name, badWays);
    }

    private boolean allowedToRemove(Coord p) {
        if (p.getOnBoundary()) {
            return false;
        }
        if (this.mode == 1 && p.isEndOfWay()) {
            return false;
        }
        if (p instanceof CoordPOI && ((CoordPOI)p).isUsed()) {
            return false;
        }
        return p.getHighwayCount() < 2 && !p.isViaNodeOfRestriction();
    }

    private void writeOSM(String name, List<ConvertedWay> convertedWays) {
    }

    private static double calcBearingError(Coord p1, Coord p2) {
        double err;
        if (p1.equals(p2) || p1.highPrecEquals(p2)) {
            return Double.MAX_VALUE;
        }
        double realBearing = p1.bearingTo(p2);
        double displayedBearing = p1.getDisplayedCoord().bearingTo(p2.getDisplayedCoord());
        for (err = displayedBearing - realBearing; err > 180.0; err -= 360.0) {
        }
        while (err < -180.0) {
            err += 360.0;
        }
        return Math.abs(err);
    }

    private static double calcMaxErrorDistance(Coord p0) {
        Coord test = new Coord(p0.getLatitude(), p0.getLongitude() + 1);
        double lonErr = p0.getDisplayedCoord().distance(test) / 2.0;
        return lonErr;
    }

    public static List<Coord> fixAnglesInShape(List<Coord> points) {
        ArrayList<Coord> modifiedPoints = new ArrayList<Coord>(points.size());
        double maxErrorDistance = WrongAngleFixer.calcMaxErrorDistance(points.get(0));
        int n = points.size();
        int i = 0;
        while (i + 1 < points.size()) {
            block7: {
                double distance;
                double realAngle;
                Coord c2;
                int straightTest;
                Coord cm;
                Coord c1;
                block6: {
                    c1 = modifiedPoints.size() > 0 ? (Coord)modifiedPoints.get(modifiedPoints.size() - 1) : (i > 0 ? points.get(i - 1) : points.get(n - 2));
                    cm = points.get(i);
                    if (!cm.highPrecEquals(c1)) break block6;
                    if (modifiedPoints.size() <= 1) break block7;
                    modifiedPoints.remove(modifiedPoints.size() - 1);
                    c1 = (Coord)modifiedPoints.get(modifiedPoints.size() - 1);
                }
                if (!((straightTest = Utils.isHighPrecStraight(c1, cm, c2 = points.get(i + 1))) == 2 || straightTest == 1 || Math.abs(realAngle = Utils.getAngle(c1, cm, c2)) < 3.0 && (distance = cm.distToLineSegment(c1, c2)) < maxErrorDistance)) {
                    modifiedPoints.add(cm);
                }
            }
            ++i;
        }
        if (modifiedPoints.size() > 1 && modifiedPoints.get(0) != modifiedPoints.get(modifiedPoints.size() - 1)) {
            modifiedPoints.add((Coord)modifiedPoints.get(0));
        }
        return modifiedPoints;
    }

    private class CenterOfAngle {
        final Coord center;
        final List<CenterOfAngle> neighbours;
        final int id;
        boolean wasMerged;
        List<CenterOfAngle> badMergeCandidates;

        public CenterOfAngle(Coord center, int id) {
            this.center = center;
            assert (!center.isReplaced());
            this.id = id;
            this.neighbours = new ArrayList<CenterOfAngle>();
        }

        public String toString() {
            return "CenterOfAngle [id=" + this.id + ", wasMerged=" + this.wasMerged + ", num Neighbours=" + this.neighbours.size() + "]";
        }

        public int hashCode() {
            return this.center.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.center == ((CenterOfAngle)obj).center;
        }

        public Coord getCurrentLocation(Map<Coord, Coord> replacements) {
            Coord c = WrongAngleFixer.getReplacement(this.center, null, replacements);
            if (c.isToRemove()) {
                return null;
            }
            return c;
        }

        public void addBadMergeCandidate(CenterOfAngle other) {
            if (this.badMergeCandidates == null) {
                this.badMergeCandidates = new ArrayList<CenterOfAngle>();
            }
            this.badMergeCandidates.add(other);
        }

        public void addNeighbour(CenterOfAngle other) {
            if (this == other) {
                log.error((Object)"neighbour is equal");
            }
            boolean isNew = true;
            for (CenterOfAngle neighbour : this.neighbours) {
                if (neighbour != other) continue;
                isNew = false;
                break;
            }
            if (isNew) {
                this.neighbours.add(other);
            }
        }

        public boolean isOK(Map<Coord, Coord> replacements) {
            Coord c = this.getCurrentLocation(replacements);
            if (c == null) {
                return true;
            }
            for (CenterOfAngle neighbour : this.neighbours) {
                double err;
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null || !((err = WrongAngleFixer.calcBearingError(c, n)) >= 15.0)) continue;
                return false;
            }
            return true;
        }

        public boolean tryChange(Map<Coord, Coord> replacements, boolean tryAlsoMerge) {
            double maxDist;
            boolean forceMerge;
            if (this.wasMerged) {
                return false;
            }
            Coord currentCenter = this.getCurrentLocation(replacements);
            if (currentCenter == null) {
                return false;
            }
            CenterOfAngle worstNeighbour = null;
            Coord worstNP = null;
            double initialMaxError = 0.0;
            double initialSumErr = 0.0;
            for (CenterOfAngle neighbour : this.neighbours) {
                double err;
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) {
                    return false;
                }
                if (currentCenter.highPrecEquals(n)) {
                    if (currentCenter == n) {
                        log.error((Object)(this.id + ": bad neighbour " + neighbour.id + " zero distance"));
                    }
                    if (!(this.badMergeCandidates != null && this.badMergeCandidates.contains(neighbour) || neighbour.badMergeCandidates != null && neighbour.badMergeCandidates.contains(this))) {
                        WrongAngleFixer.this.replaceCoord(currentCenter, n, replacements);
                        this.wasMerged = true;
                        neighbour.wasMerged = true;
                        return true;
                    }
                }
                if ((err = WrongAngleFixer.calcBearingError(currentCenter, n)) != Double.MAX_VALUE) {
                    initialSumErr += err;
                }
                if (!(err > initialMaxError)) continue;
                initialMaxError = err;
                worstNeighbour = neighbour;
                worstNP = n;
            }
            if (initialMaxError < 15.0) {
                return false;
            }
            double removeErr = this.calcRemoveError(replacements);
            if (removeErr == 0.0) {
                currentCenter.setRemove(true);
                return true;
            }
            if (initialMaxError == Double.MAX_VALUE) {
                initialSumErr = initialMaxError;
            }
            double bestReplErr = initialMaxError;
            Coord bestCenterReplacement = null;
            List<Coord> altPositions = currentCenter.getAlternativePositions();
            for (Coord altCenter : altPositions) {
                double errMax;
                double err = WrongAngleFixer.calcBearingError(altCenter, worstNP);
                if (err >= bestReplErr || (errMax = this.calcMaxError(replacements, currentCenter, altCenter)) >= initialMaxError) continue;
                bestReplErr = err;
                bestCenterReplacement = altCenter;
            }
            Coord bestNeighbourReplacement = null;
            if (worstNP.hasAlternativePos()) {
                for (Coord altCenter : altPositions) {
                    WrongAngleFixer.this.replaceCoord(currentCenter, altCenter, replacements);
                    for (Coord altN : worstNP.getAlternativePositions()) {
                        double errNeighbour;
                        double err = WrongAngleFixer.calcBearingError(altCenter, altN);
                        if (err >= bestReplErr || (errNeighbour = worstNeighbour.calcMaxError(replacements, worstNP, altN)) >= bestReplErr) continue;
                        bestReplErr = err;
                        bestCenterReplacement = altCenter;
                        bestNeighbourReplacement = altN;
                    }
                    replacements.remove(currentCenter);
                    currentCenter.setReplaced(false);
                }
            }
            if (bestReplErr < 15.0) {
                if (removeErr < bestReplErr && initialMaxError - removeErr >= 7.5 && removeErr < 7.5) {
                    bestCenterReplacement = null;
                } else if (initialMaxError - bestReplErr < 7.5 || bestReplErr > 7.5) {
                    // empty if block
                }
                if (bestCenterReplacement != null) {
                    double modifiedSumErr;
                    WrongAngleFixer.this.replaceCoord(currentCenter, bestCenterReplacement, replacements);
                    if (bestNeighbourReplacement != null) {
                        WrongAngleFixer.this.replaceCoord(worstNP, bestNeighbourReplacement, replacements);
                    }
                    if ((modifiedSumErr = this.calcSumOfErrors(replacements)) < initialSumErr) {
                        if (bestNeighbourReplacement != null) {
                            // empty if block
                        }
                        return true;
                    }
                    replacements.remove(currentCenter);
                    currentCenter.setReplaced(false);
                    replacements.remove(worstNP);
                    worstNP.setReplaced(false);
                    bestCenterReplacement = null;
                }
            }
            if (removeErr < 15.0) {
                currentCenter.setRemove(true);
                return true;
            }
            if (!tryAlsoMerge) {
                return false;
            }
            double dist = currentCenter.distance(worstNP);
            boolean bl = forceMerge = dist < (maxDist = WrongAngleFixer.calcMaxErrorDistance(currentCenter) * 2.0) || currentCenter.equals(worstNP);
            if (forceMerge || this.neighbours.size() == 3 && worstNeighbour.neighbours.size() == 3) {
                return this.tryMerge(forceMerge, initialMaxError, worstNeighbour, replacements);
            }
            if (bestCenterReplacement != null) {
                double modifiedSumErr;
                double replImprovement = initialMaxError - bestReplErr;
                if (replImprovement < 15.0) {
                    return false;
                }
                WrongAngleFixer.this.replaceCoord(currentCenter, bestCenterReplacement, replacements);
                if (bestNeighbourReplacement != null) {
                    WrongAngleFixer.this.replaceCoord(worstNP, bestNeighbourReplacement, replacements);
                }
                if ((modifiedSumErr = this.calcSumOfErrors(replacements)) < initialSumErr) {
                    // empty if block
                }
                replacements.remove(currentCenter);
                currentCenter.setReplaced(false);
                if (bestNeighbourReplacement != null) {
                    replacements.remove(worstNP);
                    worstNP.setReplaced(false);
                }
                if (modifiedSumErr < initialSumErr) {
                    // empty if block
                }
            }
            return false;
        }

        private boolean tryMerge(boolean forceMerge, double initialMaxError, CenterOfAngle neighbour, Map<Coord, Coord> replacements) {
            if (this.badMergeCandidates != null && this.badMergeCandidates.contains(neighbour) || neighbour.badMergeCandidates != null && neighbour.badMergeCandidates.contains(this)) {
                return false;
            }
            Coord c = this.getCurrentLocation(replacements);
            Coord n = neighbour.getCurrentLocation(replacements);
            if (c.getOnBoundary() && (n.isViaNodeOfRestriction() || n.getOnBoundary() && !c.equals(n))) {
                return false;
            }
            if (c.isViaNodeOfRestriction() && (n.isViaNodeOfRestriction() || n.getOnBoundary())) {
                return false;
            }
            if (c instanceof CoordPOI && (n instanceof CoordPOI || n.getOnBoundary())) {
                return false;
            }
            if (n instanceof CoordPOI && (c instanceof CoordPOI || c.getOnBoundary())) {
                return false;
            }
            Coord mergePoint = c.getOnBoundary() || c instanceof CoordPOI ? c : (n.getOnBoundary() || n instanceof CoordPOI ? n : (c.equals(n) ? c : c.makeBetweenPoint(n, 0.5)));
            double err = 0.0;
            if (!c.equals(n)) {
                err = this.calcMergeErr(neighbour, mergePoint, replacements);
                if (err == Double.MAX_VALUE && initialMaxError == Double.MAX_VALUE) {
                    log.warn("still equal neighbour after merge", c.toOSMURL());
                } else {
                    if (err >= 15.0) {
                        return false;
                    }
                    if (initialMaxError - err < 7.5 && err > 7.5) {
                        return false;
                    }
                }
            }
            if (!(forceMerge || this.checkNearlyStraight(c.bearingTo(n), neighbour, replacements) && neighbour.checkNearlyStraight(n.bearingTo(c), this, replacements))) {
                return false;
            }
            int hwc = c.getHighwayCount() + n.getHighwayCount() - 1;
            for (int i = 0; i < hwc; ++i) {
                mergePoint.incHighwayCount();
            }
            if (c != mergePoint) {
                WrongAngleFixer.this.replaceCoord(c, mergePoint, replacements);
            }
            if (n != mergePoint) {
                WrongAngleFixer.this.replaceCoord(n, mergePoint, replacements);
            }
            this.wasMerged = true;
            neighbour.wasMerged = true;
            return true;
        }

        private boolean checkNearlyStraight(double bearing, CenterOfAngle other, Map<Coord, Coord> replacements) {
            Coord c = this.getCurrentLocation(replacements);
            for (CenterOfAngle neighbour : this.neighbours) {
                double angle;
                Coord n;
                if (neighbour == other || (n = neighbour.getCurrentLocation(replacements)) == null) continue;
                double bearing2 = c.bearingTo(n);
                for (angle = bearing2 - (bearing - 180.0); angle > 180.0; angle -= 360.0) {
                }
                while (angle < -180.0) {
                    angle += 360.0;
                }
                if (!(Math.abs(angle) < 10.0)) continue;
                return true;
            }
            return false;
        }

        private double calcMergeErr(CenterOfAngle other, Coord mergePoint, Map<Coord, Coord> replacements) {
            double err;
            Coord n;
            double maxErr = 0.0;
            for (CenterOfAngle neighbour : this.neighbours) {
                if (neighbour == other || (n = neighbour.getCurrentLocation(replacements)) == null || !((err = WrongAngleFixer.calcBearingError(mergePoint, n)) > maxErr)) continue;
                maxErr = err;
            }
            for (CenterOfAngle othersNeighbour : other.neighbours) {
                if (othersNeighbour == this || (n = othersNeighbour.getCurrentLocation(replacements)) == null || !((err = WrongAngleFixer.calcBearingError(mergePoint, n)) > maxErr)) continue;
                maxErr = err;
            }
            return maxErr;
        }

        private double calcMaxError(Map<Coord, Coord> replacements, Coord toRepl, Coord replacement) {
            double maxErr = 0.0;
            Coord c = this.getCurrentLocation(replacements);
            for (CenterOfAngle neighbour : this.neighbours) {
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) continue;
                double err = c == toRepl ? WrongAngleFixer.calcBearingError(replacement, n) : (n == toRepl ? WrongAngleFixer.calcBearingError(c, replacement) : WrongAngleFixer.calcBearingError(c, n));
                if (err == Double.MAX_VALUE) {
                    return err;
                }
                if (!(err > maxErr)) continue;
                maxErr = err;
            }
            return maxErr;
        }

        private double calcSumOfErrors(Map<Coord, Coord> replacements) {
            double SumErr = 0.0;
            Coord c = this.getCurrentLocation(replacements);
            for (CenterOfAngle neighbour : this.neighbours) {
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) continue;
                double err = WrongAngleFixer.calcBearingError(c, n);
                if (err == Double.MAX_VALUE) {
                    return err;
                }
                SumErr += err;
            }
            return SumErr;
        }

        private double calcRemoveError(Map<Coord, Coord> replacements) {
            if (!WrongAngleFixer.this.allowedToRemove(this.center)) {
                return Double.MAX_VALUE;
            }
            Coord c = this.getCurrentLocation(replacements);
            if (this.neighbours.size() > 2) {
                return Double.MAX_VALUE;
            }
            Coord[] outerPoints = new Coord[this.neighbours.size()];
            for (int i = 0; i < this.neighbours.size(); ++i) {
                CenterOfAngle neighbour = this.neighbours.get(i);
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) {
                    return Double.MAX_VALUE;
                }
                if (c.equals(n) && c.getDistToDisplayedPoint() < n.getDistToDisplayedPoint()) {
                    return 0.0;
                }
                outerPoints[i] = n;
            }
            if (this.neighbours.size() < 2) {
                return Double.MAX_VALUE;
            }
            if (c.getDistToDisplayedPoint() < Math.max(outerPoints[0].getDistToDisplayedPoint(), outerPoints[1].getDistToDisplayedPoint())) {
                return Double.MAX_VALUE;
            }
            double dsplAngle = Utils.getDisplayedAngle(outerPoints[0], c, outerPoints[1]);
            if (Math.abs(dsplAngle) < 3.0) {
                return Double.MAX_VALUE;
            }
            double realAngle = Utils.getAngle(outerPoints[0], c, outerPoints[1]);
            double err = Math.abs(realAngle) / 2.0;
            return err;
        }

        private void createGPX(String gpxName, Map<Coord, Coord> replacements) {
            if (gpxName == null || WrongAngleFixer.this.gpxPath == null) {
                return;
            }
            if (gpxName.isEmpty()) {
                gpxName = WrongAngleFixer.this.gpxPath + this.id + "_no_info";
            }
            Coord c = WrongAngleFixer.getReplacement(this.center, null, replacements);
            List<Coord> alternatives = c.getAlternativePositions();
            for (int i = 0; i < this.neighbours.size(); ++i) {
                CenterOfAngle n = this.neighbours.get(i);
                Coord nc = WrongAngleFixer.getReplacement(n.center, null, replacements);
                if (nc == null) continue;
                if (i == 0 && !alternatives.isEmpty()) {
                    GpxCreator.createGpx(gpxName + "_" + i, Arrays.asList(c, nc), alternatives);
                    continue;
                }
                GpxCreator.createGpx(gpxName + "_" + i, Arrays.asList(c, nc));
            }
            if (this.neighbours.isEmpty()) {
                GpxCreator.createGpx(gpxName + "_empty", Arrays.asList(c, c), alternatives);
            }
        }
    }
}

