/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.List;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueBuildedAction;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueBuilder;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class AddTagAction
extends ValueBuildedAction {
    private final boolean modify;
    private final String tag;
    private final short tagKey;
    private Element valueTags;

    public AddTagAction(String tag, String value, boolean modify) {
        this.modify = modify;
        this.tag = tag;
        this.tagKey = TagDict.getInstance().xlate(tag);
        this.add(value);
    }

    @Override
    public boolean perform(Element el) {
        String tv;
        if (!this.modify && (tv = el.getTag(this.tagKey)) != null) {
            return false;
        }
        Element tags = this.valueTags != null ? this.valueTags : el;
        for (ValueBuilder value : this.getValueBuilder()) {
            String newval = value.build(tags, el);
            if (newval == null) continue;
            el.addTag(this.tagKey, newval);
            return true;
        }
        return false;
    }

    public void setValueTags(Element valueTags) {
        this.valueTags = valueTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.modify ? "set " : "add ");
        sb.append(this.tag);
        sb.append("=");
        List<ValueBuilder> values = this.getValueBuilder();
        for (int i = 0; i < values.size(); ++i) {
            sb.append(values.get(i));
            if (i >= values.size() - 1) continue;
            sb.append(" | ");
        }
        sb.append(';');
        return sb.toString();
    }
}

