/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.me.parabola.mkgmap.osmstyle.actions.Action;
import uk.me.parabola.mkgmap.osmstyle.actions.AddAccessAction;
import uk.me.parabola.mkgmap.osmstyle.actions.AddTagAction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Relation;

public class SubAction
implements Action {
    private final List<Action> actionList = new ArrayList<Action>();
    private final String role;
    private final boolean once;

    public SubAction(String role, boolean once) {
        this.role = role;
        this.once = once;
    }

    @Override
    public boolean perform(Element el) {
        if (el instanceof Relation) {
            this.performOnSubElements((Relation)el);
        }
        return true;
    }

    private void performOnSubElements(Relation rel) {
        List<Map.Entry<String, Element>> elements = rel.getElements();
        for (Action a : this.actionList) {
            if (a instanceof AddTagAction) {
                ((AddTagAction)a).setValueTags(rel);
                continue;
            }
            if (!(a instanceof AddAccessAction)) continue;
            ((AddAccessAction)a).setValueTags(rel);
        }
        HashSet<Element> elems = this.once ? new HashSet<Element>() : null;
        for (Map.Entry<String, Element> r_el : elements) {
            if (this.role != null && !this.role.equals(r_el.getKey()) || this.once && !elems.add(r_el.getValue())) continue;
            for (Action a : this.actionList) {
                a.perform(r_el.getValue());
            }
        }
    }

    public void add(Action act) {
        this.actionList.add(act);
    }

    public String toString() {
        Formatter fmt = new Formatter();
        fmt.format(this.once ? "apply_once" : "apply", new Object[0]);
        if (this.role != null) {
            fmt.format(" role=%s ", this.role);
        }
        fmt.format(" {", new Object[0]);
        Iterator<Action> it = this.actionList.iterator();
        while (it.hasNext()) {
            Action a = it.next();
            fmt.format(a.toString(), new Object[0]);
            if (!it.hasNext()) continue;
            fmt.format(" ", new Object[0]);
        }
        fmt.format("}", new Object[0]);
        return fmt.toString();
    }
}

