/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.function.CachedFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;

public class MaxSpeedFunction
extends CachedFunction {
    private static final Pattern ENDS_IN_MPH_PATTERN = Pattern.compile(".*mph");
    private static final Pattern REMOVE_MPH_PATTERN = Pattern.compile("[ \t]*mph");
    private static final Pattern REMOVE_KMH_PATTERN = Pattern.compile("[ \t]*km/?h");
    private final DecimalFormat nf = new DecimalFormat("0.0#", DecimalFormatSymbols.getInstance(Locale.US));
    private final SpeedUnit unit;

    public MaxSpeedFunction(SpeedUnit unit) {
        super("maxspeed");
        this.unit = unit;
    }

    @Override
    protected String calcImpl(Element el) {
        String tagValue = el.getTag("maxspeed");
        if (tagValue == null) {
            return null;
        }
        String speedTag = tagValue.toLowerCase().trim();
        SpeedUnit speedTagUnit = SpeedUnit.KMH;
        if (ENDS_IN_MPH_PATTERN.matcher(speedTag).matches()) {
            speedTag = REMOVE_MPH_PATTERN.matcher(speedTag).replaceFirst("");
            speedTagUnit = SpeedUnit.MPH;
        } else {
            speedTag = REMOVE_KMH_PATTERN.matcher(speedTag).replaceFirst("");
        }
        try {
            double speed = this.unit.convert(Integer.parseInt(speedTag), speedTagUnit);
            return this.nf.format(speed);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        switch (this.unit) {
            case MPH: {
                return "maxspeedmph";
            }
        }
        return "maxspeedkmh";
    }

    @Override
    public boolean supportsWay() {
        return true;
    }

    public static enum SpeedUnit {
        KMH,
        MPH;


        public double convert(double value, SpeedUnit valueUnit) {
            if (this == valueUnit) {
                return value;
            }
            if (valueUnit == MPH) {
                return value * 1.61;
            }
            return value / 1.61;
        }
    }
}

