/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class HousenumberMatch {
    private final Element element;
    private MapRoad road;
    private double distance = Double.POSITIVE_INFINITY;
    private int segment = -1;
    private boolean left;
    private double segmentFrac;
    private int housenumber;
    private static final short housenumberTagKey1 = TagDict.getInstance().xlate("mkgmap:housenumber");
    private static final short housenumberTagKey2 = TagDict.getInstance().xlate("addr:housenumber");

    public HousenumberMatch(Element element) {
        this.element = element;
        this.parseHousenumber();
    }

    public Coord getLocation() {
        return this.element instanceof Node ? ((Node)this.element).getLocation() : ((Way)this.element).getCofG();
    }

    public static String getHousenumber(Element e) {
        String res = e.getTag(housenumberTagKey1);
        if (res != null) {
            return res;
        }
        return e.getTag(housenumberTagKey2);
    }

    private void parseHousenumber() {
        String housenumberString = HousenumberMatch.getHousenumber(this.element);
        if (housenumberString == null) {
            throw new IllegalArgumentException("No housenumber found in " + this.element.toBrowseURL());
        }
        Pattern p = Pattern.compile("\\D*(\\d+)\\D?.*");
        Matcher m = p.matcher(housenumberString);
        if (!m.matches()) {
            throw new IllegalArgumentException("No housenumber (" + this.element.toBrowseURL() + "): " + housenumberString);
        }
        try {
            this.housenumber = Integer.parseInt(m.group(1));
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("No housenumber (" + this.element.toBrowseURL() + "): " + housenumberString);
        }
        if (this.housenumber <= 0) {
            throw new IllegalArgumentException("No housenumber (" + this.element.toBrowseURL() + "): " + housenumberString);
        }
    }

    public MapRoad getRoad() {
        return this.road;
    }

    public void setRoad(MapRoad road) {
        this.road = road;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public int getSegment() {
        return this.segment;
    }

    public void setSegment(int segment) {
        this.segment = segment;
    }

    public boolean isLeft() {
        return this.left;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public double getSegmentFrac() {
        return this.segmentFrac;
    }

    public void setSegmentFrac(double segmentFrac) {
        this.segmentFrac = segmentFrac;
    }

    public int getHousenumber() {
        return this.housenumber;
    }

    public void setHousenumber(int housenumber) {
        this.housenumber = housenumber;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return String.valueOf(this.housenumber) + "(" + this.segment + ")";
    }
}

