/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Tags;

public abstract class Element {
    private Tags tags;
    private long id;
    private long originalId;

    public int getTagCount() {
        return this.tags == null ? 0 : this.tags.size();
    }

    public void addTag(String key, String val) {
        if (this.tags == null) {
            this.tags = new Tags();
        }
        this.tags.put(key, val);
    }

    public void addTag(short tagKey, String val) {
        if (this.tags == null) {
            this.tags = new Tags();
        }
        this.tags.put(tagKey, val);
    }

    public String getTag(String key) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(key);
    }

    public String getTag(short tagKey) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(tagKey);
    }

    public String deleteTag(String tagname) {
        String old = null;
        if (this.tags != null) {
            old = this.tags.remove(tagname);
            if (this.tags.size() == 0) {
                this.tags = null;
            }
        }
        return old;
    }

    public String deleteTag(short tagKey) {
        String old = null;
        if (this.tags != null) {
            old = this.tags.remove(tagKey);
            if (this.tags.size() == 0) {
                this.tags = null;
            }
        }
        return old;
    }

    public boolean tagIsLikeYes(String s) {
        return this.tagIsLikeYes(TagDict.getInstance().xlate(s));
    }

    public boolean tagIsLikeYes(short tagKey) {
        String val = this.getTag(tagKey);
        if (val == null) {
            return false;
        }
        return val.equals("yes") || val.equals("true") || val.equals("1");
    }

    public boolean tagIsLikeNo(String s) {
        return this.tagIsLikeNo(TagDict.getInstance().xlate(s));
    }

    public boolean tagIsLikeNo(short tagKey) {
        String val = this.getTag(tagKey);
        if (val == null) {
            return false;
        }
        return val.equals("no") || val.equals("false") || val.equals("0");
    }

    public long getId() {
        return this.id;
    }

    public long getOriginalId() {
        return this.originalId;
    }

    protected void setId(long id) {
        this.id = id;
        this.originalId = id;
    }

    public void setFakeId() {
        this.id = FakeIdGenerator.makeFakeId();
    }

    public String toTagString() {
        if (this.tags == null) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (String nameval : this.tags) {
            sb.append(nameval);
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public void copyTags(Element other) {
        this.tags = other.tags == null ? null : other.tags.copy();
    }

    public String getName() {
        return this.getTag("mkgmap:label:1");
    }

    public Map<String, String> getTagsWithPrefix(String prefix, boolean removePrefix) {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        return this.tags.getTagsWithPrefix(prefix, removePrefix);
    }

    protected void removeAllTags() {
        this.tags = null;
    }

    public Iterable<Map.Entry<String, String>> getTagEntryIterator() {
        return new Iterable<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                if (Element.this.tags == null) {
                    return Collections.emptyIterator();
                }
                return Element.this.tags.entryIterator();
            }
        };
    }

    public Iterable<Map.Entry<Short, String>> getFastTagEntryIterator() {
        return new Iterable<Map.Entry<Short, String>>(){

            @Override
            public Iterator<Map.Entry<Short, String>> iterator() {
                if (Element.this.tags == null) {
                    return Collections.emptyIterator();
                }
                return Element.this.tags.entryShortIterator();
            }
        };
    }

    protected String kind() {
        return "unknown";
    }

    public String toBrowseURL() {
        return "http://www.openstreetmap.org/" + this.kind() + "/" + this.id;
    }

    public Element copy() {
        throw new UnsupportedOperationException("unsupported element copy");
    }

    public String getDebugName() {
        String name = this.getName();
        if (name == null) {
            name = this.getTag("ref");
        }
        name = name == null ? "" : name + " ";
        return name + "(OSM id " + this.getId() + ")";
    }
}

