/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.Formatter;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;

public class GType {
    private static final Logger log = Logger.getLogger(GType.class);
    private final FeatureKind featureKind;
    private final int type;
    private int minResolution = 24;
    private int maxResolution = 24;
    private int maxLevel = -1;
    private int minLevel;
    private String defaultName;
    private int roadClass;
    private int roadSpeed;
    private boolean hasRoadAttribute;
    private boolean levelsWereFixed = false;
    private boolean continueSearch;
    private boolean propogateActionsOnContinue;

    public static boolean checkType(FeatureKind featureKind, int type) {
        if (type >= 65536) {
            if ((type & 0xFF) > 31) {
                return false;
            }
        } else {
            if (featureKind == FeatureKind.POLYLINE && type > 63) {
                return false;
            }
            if (featureKind == FeatureKind.POLYGON && (type > 127 || type == 74)) {
                return false;
            }
            if (featureKind == FeatureKind.POINT && (type < 256 || (type & 0xFF) > 31)) {
                return false;
            }
        }
        return true;
    }

    public GType(FeatureKind featureKind, String type) {
        this.featureKind = featureKind;
        try {
            int t = Integer.decode(type);
            if (featureKind == FeatureKind.POLYGON && t >= 256 && t < 65536 && (t & 0xFF) == 0) {
                t >>= 8;
            }
            this.type = t;
        }
        catch (NumberFormatException e) {
            log.error((Object)("not numeric " + type));
            throw new ExitException("non-numeric type in style file");
        }
    }

    public FeatureKind getFeatureKind() {
        return this.featureKind;
    }

    public int getType() {
        return this.type;
    }

    public int getMinResolution() {
        return this.minResolution;
    }

    public void setMinResolution(int minResolution) {
        this.minResolution = minResolution;
    }

    public int getMaxResolution() {
        return this.maxResolution;
    }

    public void setMaxResolution(int maxResolution) {
        this.maxResolution = maxResolution;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    public void fixLevels(LevelInfo[] levels) {
        for (LevelInfo info : levels) {
            if (info.getBits() <= this.minResolution) {
                this.maxLevel = info.getLevel();
            }
            if (info.getBits() > this.maxResolution) continue;
            this.minLevel = info.getLevel();
        }
        this.levelsWereFixed = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        sb.append('[');
        fmt.format("%#x", this.type);
        if (this.maxLevel == -1) {
            if (this.maxResolution == 24) {
                fmt.format(" resolution %d", this.minResolution);
            } else {
                fmt.format(" resolution %d-%d", this.maxResolution, this.minResolution);
            }
        } else if (this.minLevel == 0) {
            fmt.format(" level %d", this.maxLevel);
        } else {
            fmt.format(" level %d-%d", this.minLevel, this.maxLevel);
        }
        if (this.hasRoadAttribute) {
            fmt.format(" road_class=%d road_speed=%d", this.roadClass, this.roadSpeed);
        }
        if (this.continueSearch) {
            fmt.format(" continue", new Object[0]);
        }
        if (this.propogateActionsOnContinue) {
            fmt.format(" propagate", new Object[0]);
        }
        sb.append(']');
        String res = sb.toString();
        fmt.close();
        return res;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getRoadClass() {
        return this.roadClass;
    }

    public void setRoadClass(int roadClass) {
        if (this.getFeatureKind() == FeatureKind.POLYLINE) {
            this.hasRoadAttribute = true;
        }
        this.roadClass = roadClass;
    }

    public int getRoadSpeed() {
        return this.roadSpeed;
    }

    public void setRoadSpeed(int roadSpeed) {
        if (this.getFeatureKind() == FeatureKind.POLYLINE) {
            this.hasRoadAttribute = true;
        }
        this.roadSpeed = roadSpeed;
    }

    public boolean hasRoadAttribute() {
        return this.hasRoadAttribute;
    }

    public boolean isRoad() {
        if (!this.levelsWereFixed) {
            log.error((Object)"internal: isRoad() called before fixLevels()");
        }
        return this.hasRoadAttribute && this.minLevel == 0;
    }

    public boolean isContinueSearch() {
        return this.continueSearch;
    }

    public void propagateActions(boolean propagate) {
        this.propogateActionsOnContinue = propagate;
    }

    public boolean isPropogateActions() {
        return !this.continueSearch || this.propogateActionsOnContinue;
    }

    public void setContinueSearch(boolean continueSearch) {
        this.continueSearch = continueSearch;
    }

    public static boolean isRoutableLineType(int type) {
        return type >= 1 && type <= 63;
    }

    public static boolean isSpecialRoutableLineType(int type) {
        return type >= 1 && type <= 19 || type == 22 || type == 27;
    }

    public static String formatType(int type) {
        String s = String.format("%x", type);
        return (s.length() % 2 != 0 ? "0x0" : "0x") + s;
    }
}

