/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.CoordPOI;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class HighwayHooks
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(HighwayHooks.class);
    private final List<Way> motorways = new ArrayList<Way>();
    private final List<Node> exits = new ArrayList<Node>();
    private boolean makeOppositeCycleways;
    private ElementSaver saver;
    private boolean linkPOIsToWays;
    private Node currentNodeInWay;
    private final Set<String> usedTags = new HashSet<String>(){
        {
            this.add("highway");
            this.add("access");
            this.add("barrier");
            this.add("FIXME");
            this.add("fixme");
            this.add("route");
            this.add("oneway");
            this.add("junction");
            this.add("name");
            this.add("exit:road_ref");
            this.add("ref");
        }
    };

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.saver = saver;
        if (props.getProperty("make-all-cycleways", false)) {
            log.error((Object)"option make-all-cycleways is deprecated, please use make-opposite-cycleways");
            this.makeOppositeCycleways = true;
        } else {
            this.makeOppositeCycleways = props.getProperty("make-opposite-cycleways", false);
        }
        this.linkPOIsToWays = props.getProperty("link-pois-to-ways", false);
        this.currentNodeInWay = null;
        if (this.makeOppositeCycleways) {
            this.usedTags.add("cycleway");
            this.usedTags.add("bicycle");
            this.usedTags.add("oneway:bicycle");
            this.usedTags.add("bicycle:oneway");
            this.usedTags.add("cycleway:left");
            this.usedTags.add("cycleway:right");
        }
        if (props.getProperty("housenumbers", false)) {
            this.usedTags.add("addr:street");
            this.usedTags.add("addr:housenumber");
        }
        return true;
    }

    @Override
    public Set<String> getUsedTags() {
        return this.usedTags;
    }

    @Override
    public void onAddNode(Node node) {
        String val = node.getTag("highway");
        if (val != null && (val.equals("motorway_junction") || val.equals("services"))) {
            this.exits.add(node);
            node.addTag("mkgmap:osmid", String.valueOf(node.getId()));
        }
    }

    @Override
    public void onCoordAddedToWay(Way way, long id, Coord co) {
        if (!this.linkPOIsToWays) {
            return;
        }
        this.currentNodeInWay = this.saver.getNode(id);
        if (!(co instanceof CoordPOI) && this.currentNodeInWay != null) {
            String[] coordPOITags;
            for (String cpt : coordPOITags = new String[]{"barrier", "highway"}) {
                if (this.currentNodeInWay.getTag(cpt) == null) continue;
                CoordPOI cp = new CoordPOI(co);
                this.saver.addPoint(id, cp);
                Node newNode = new Node(id, cp);
                newNode.copyTags(this.currentNodeInWay);
                this.saver.addNode(newNode);
                cp.setNode(newNode);
                co = cp;
                if (this.exits.remove(this.currentNodeInWay)) {
                    this.exits.add(newNode);
                }
                this.currentNodeInWay = newNode;
                break;
            }
        }
        if (co instanceof CoordPOI) {
            way.addTag("mkgmap:way-has-pois", "true");
            if (log.isInfoEnabled()) {
                log.info("Linking POI", this.currentNodeInWay.toBrowseURL(), "to way at", co.toOSMURL());
            }
        }
    }

    @Override
    public void onAddWay(Way way) {
        String highway = way.getTag("highway");
        if (highway != null || "ferry".equals(way.getTag("route"))) {
            if ("roundabout".equals(way.getTag("junction")) && way.getTag("oneway") == null) {
                way.addTag("oneway", "yes");
            }
            if (this.makeOppositeCycleways && !"cycleway".equals(highway)) {
                String onewayTag = way.getTag("oneway");
                boolean oneway = way.tagIsLikeYes("oneway");
                if (!oneway & onewayTag != null && ("-1".equals(onewayTag) || "reverse".equals(onewayTag))) {
                    oneway = true;
                }
                if (oneway) {
                    String cycleway = way.getTag("cycleway");
                    boolean addCycleWay = false;
                    if ("no".equals(way.getTag("oneway:bicycle")) || "no".equals(way.getTag("bicycle:oneway"))) {
                        addCycleWay = true;
                    } else if (cycleway != null && ("opposite".equals(cycleway) || "opposite_lane".equals(cycleway) || "opposite_track".equals(cycleway))) {
                        addCycleWay = true;
                    } else if ("opposite_lane".equals(way.getTag("cycleway:left")) || "opposite_lane".equals(way.getTag("cycleway:right"))) {
                        addCycleWay = true;
                    } else if ("opposite_track".equals(way.getTag("cycleway:left")) || "opposite_track".equals(way.getTag("cycleway:right"))) {
                        addCycleWay = true;
                    }
                    if (addCycleWay) {
                        way.addTag("mkgmap:make-cycle-way", "yes");
                    }
                }
            }
        }
        if ("motorway".equals(highway) || "trunk".equals(highway)) {
            this.motorways.add(way);
        }
    }

    @Override
    public void end() {
        this.finishExits();
        this.exits.clear();
        this.motorways.clear();
    }

    private void finishExits() {
        for (Node e : this.exits) {
            String refTag;
            if (e.getTag(refTag = "exit:road_ref") != null) continue;
            String exitName = e.getTag("name");
            if (exitName == null) {
                exitName = e.getTag("ref");
            }
            String ref = null;
            Way motorway = null;
            for (Way w : this.motorways) {
                if (!w.getPoints().contains(e.getLocation())) continue;
                motorway = w;
                ref = w.getTag("ref");
                if (ref == null) continue;
                break;
            }
            if (ref != null) {
                log.info("Adding", refTag + "=" + ref, "to exit", exitName);
                e.addTag(refTag, ref);
                continue;
            }
            if (motorway == null) continue;
            log.warn("Motorway exit", exitName, "is positioned on a motorway that doesn't have a 'ref' tag (" + e.getLocation().toOSMURL() + ")");
        }
    }
}

