/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class OsmHandler {
    protected ElementSaver saver;
    protected OsmReadingHooks hooks;
    private final Map<String, Long> fakeIdMap = new HashMap<String, Long>();
    private Map<String, Set<String>> deletedTags;
    private Map<String, String> usedTags;
    protected long firstNodeRef;
    protected long lastNodeRef;
    protected boolean missingNodeRef;
    public static final String TAGS_INCOMPLETE_TAG = "mkgmap:tagsincomplete";

    public void setTagsToDelete(Map<String, Set<String>> deletedTags) {
        this.deletedTags = deletedTags;
    }

    public void setUsedTags(Set<String> used) {
        if (used == null || used.isEmpty()) {
            this.usedTags = null;
            return;
        }
        this.usedTags = new HashMap<String, String>();
        for (String s : used) {
            if (s == null) continue;
            s = s.intern();
            this.usedTags.put(s, s);
        }
    }

    protected String keepTag(String key, String val) {
        Set<String> vals;
        if (this.deletedTags != null && (vals = this.deletedTags.get(key)) != null && (vals.isEmpty() || vals.contains(val))) {
            return null;
        }
        if (this.usedTags != null) {
            return this.usedTags.get(key);
        }
        return key;
    }

    protected void setBBox(double minlat, double minlong, double maxlat, double maxlong) {
        Area bbox = new Area(minlat, minlong, maxlat, maxlong);
        this.saver.setBoundingBox(bbox);
    }

    protected long idVal(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            Long fakeIdVal = this.fakeIdMap.get(id);
            if (fakeIdVal == null) {
                fakeIdVal = FakeIdGenerator.makeFakeId();
                this.fakeIdMap.put(id, fakeIdVal);
            }
            return fakeIdVal;
        }
    }

    public void setElementSaver(ElementSaver elementSaver) {
        this.saver = elementSaver;
    }

    public void setHooks(OsmReadingHooks plugin) {
        this.hooks = plugin;
    }

    protected Way startWay(long id) {
        this.firstNodeRef = 0L;
        this.lastNodeRef = 0L;
        this.missingNodeRef = false;
        return new Way(id);
    }

    protected void endWay(Way way) {
        way.setClosedInOSM(this.firstNodeRef == this.lastNodeRef);
        way.setComplete(!this.missingNodeRef);
        this.saver.addWay(way);
        this.hooks.onAddWay(way);
    }

    protected void addCoordToWay(Way way, long id) {
        Coord co;
        this.lastNodeRef = id;
        if (this.firstNodeRef == 0L) {
            this.firstNodeRef = id;
        }
        if ((co = this.saver.getCoord(id)) != null) {
            this.hooks.onCoordAddedToWay(way, id, co);
            co = this.saver.getCoord(id);
            way.addPoint(co);
        } else {
            this.missingNodeRef = true;
        }
    }
}

