/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.osmstyle.StyledConverter;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.HighwayHooks;
import uk.me.parabola.mkgmap.reader.osm.LinkDestinationHook;
import uk.me.parabola.mkgmap.reader.osm.LoadableOsmDataSource;
import uk.me.parabola.mkgmap.reader.osm.LocationHook;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonFinishHook;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.OsmHandler;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksChain;
import uk.me.parabola.mkgmap.reader.osm.POIGeneratorHook;
import uk.me.parabola.mkgmap.reader.osm.RelationStyleHook;
import uk.me.parabola.mkgmap.reader.osm.RoutingHook;
import uk.me.parabola.mkgmap.reader.osm.SeaGenerator;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.UnusedElementsRemoverHook;
import uk.me.parabola.util.EnhancedProperties;

public abstract class OsmMapDataSource
extends MapperBasedMapDataSource
implements LoadableMapDataSource,
LoadableOsmDataSource {
    private static final Logger log = Logger.getLogger(OsmMapDataSource.class);
    private Style style;
    private final OsmReadingHooks[] POSSIBLE_HOOKS = new OsmReadingHooks[]{new SeaGenerator(), new MultiPolygonFinishHook(), new RelationStyleHook(), new LinkDestinationHook(), new UnusedElementsRemoverHook(), new RoutingHook(), new HighwayHooks(), new LocationHook(), new POIGeneratorHook()};
    protected OsmConverter converter;
    private final Set<String> usedTags = new HashSet<String>();
    protected ElementSaver elementSaver;
    protected OsmReadingHooks osmReadingHooks;

    @Override
    public LevelInfo[] mapLevels() {
        String levelSpec = this.getLevelSpec("levels");
        if (levelSpec == null) {
            levelSpec = "0:24, 1:22, 2:20, 3:18, 4:16";
        }
        return LevelInfo.createFromString(levelSpec);
    }

    @Override
    public LevelInfo[] overviewMapLevels() {
        String levelSpec = this.getLevelSpec("overview-levels");
        if (levelSpec == null) {
            return null;
        }
        LevelInfo[] levels = LevelInfo.createFromString(levelSpec);
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = new LevelInfo(levels.length - i - 1, levels[i].getBits());
        }
        return levels;
    }

    private String getLevelSpec(String optionName) {
        String levelSpec = this.getConfig().getProperty(optionName);
        log.debug(optionName, levelSpec, ", ", levelSpec != null ? Integer.valueOf(levelSpec.length()) : "");
        if ((levelSpec == null || levelSpec.length() < 2) && this.style != null) {
            levelSpec = this.style.getOption(optionName);
            log.debug("getting " + optionName + " from style:", levelSpec);
        }
        return levelSpec;
    }

    @Override
    public void load(String name) throws FileNotFoundException, FormatException {
        InputStream is = Utils.openFile(name);
        this.load(is);
    }

    @Override
    public String[] copyrightMessages() {
        String copyrightFileName = this.getConfig().getProperty("copyright-file", null);
        if (copyrightFileName != null) {
            File file = new File(copyrightFileName);
            ArrayList<String> copyrightArray = new ArrayList<String>();
            try {
                String text;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((text = reader.readLine()) != null) {
                    copyrightArray.add(text);
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                throw new ExitException("Could not open copyright file " + copyrightFileName);
            }
            catch (IOException e) {
                throw new ExitException("Error reading copyright file " + copyrightFileName);
            }
            String[] copyright = new String[copyrightArray.size()];
            copyrightArray.toArray(copyright);
            return copyright;
        }
        String note = this.getConfig().getProperty("copyright-message", "OpenStreetMap.org contributors. See: http://wiki.openstreetmap.org/index.php/Attribution");
        return new String[]{note};
    }

    protected void setStyle(Style style) {
        this.style = style;
    }

    protected void setupHandler(OsmHandler handler) {
        this.createElementSaver();
        this.createConverter();
        this.osmReadingHooks = this.pluginChain(this.elementSaver, this.getConfig());
        handler.setElementSaver(this.elementSaver);
        handler.setHooks(this.osmReadingHooks);
        handler.setUsedTags(this.getUsedTags());
        String deleteTagsFileName = this.getConfig().getProperty("delete-tags-file");
        if (deleteTagsFileName != null) {
            Map<String, Set<String>> deltags = this.readDeleteTagsFile(deleteTagsFileName);
            handler.setTagsToDelete(deltags);
        }
    }

    protected void createElementSaver() {
        this.elementSaver = new ElementSaver(this.getConfig());
    }

    public ElementSaver getElementSaver() {
        return this.elementSaver;
    }

    protected OsmReadingHooks[] getPossibleHooks() {
        return this.POSSIBLE_HOOKS;
    }

    protected OsmReadingHooks pluginChain(ElementSaver saver, EnhancedProperties props) {
        OsmReadingHooks hooks;
        ArrayList<OsmReadingHooks> plugins = new ArrayList<OsmReadingHooks>();
        for (OsmReadingHooks p : this.getPossibleHooks()) {
            if (!p.init(saver, props)) continue;
            plugins.add(p);
            if (!(p instanceof RelationStyleHook)) continue;
            ((RelationStyleHook)p).setStyle(this.style);
        }
        switch (plugins.size()) {
            case 0: {
                hooks = new OsmReadingHooksAdaptor();
                break;
            }
            case 1: {
                hooks = (OsmReadingHooks)plugins.get(0);
                break;
            }
            default: {
                OsmReadingHooksChain chain = new OsmReadingHooksChain();
                for (OsmReadingHooks p : plugins) {
                    chain.add(p);
                }
                hooks = chain;
            }
        }
        this.usedTags.addAll(hooks.getUsedTags());
        return hooks;
    }

    private Map<String, Set<String>> readDeleteTagsFile(String fileName) {
        HashMap<String, Set<String>> deletedTags = new HashMap<String, Set<String>>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(";")) continue;
                String[] parts = line.split("=");
                if (parts.length == 2) {
                    parts[0] = parts[0].trim();
                    parts[1] = parts[1].trim();
                    if ("*".equals(parts[1])) {
                        deletedTags.put(parts[0], new HashSet());
                        continue;
                    }
                    HashSet<String> vals = (HashSet<String>)deletedTags.get(parts[0]);
                    if (vals == null) {
                        vals = new HashSet<String>();
                    }
                    vals.add(parts[1]);
                    deletedTags.put(parts[0], vals);
                    continue;
                }
                log.error((Object)("Ignoring bad line in deleted tags file: " + line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Could not open delete tags file " + fileName));
        }
        catch (IOException e) {
            log.error((Object)("Error reading delete tags file " + fileName));
        }
        if (deletedTags.isEmpty()) {
            deletedTags = null;
        }
        return deletedTags;
    }

    protected void createConverter() {
        EnhancedProperties props = this.getConfig();
        Style style = StyleImpl.readStyle(props);
        this.setStyle(style);
        this.usedTags.addAll(style.getUsedTags());
        this.converter = new StyledConverter(style, this.mapper, props);
    }

    public OsmConverter getConverter() {
        return this.converter;
    }

    public Set<String> getUsedTags() {
        return this.usedTags;
    }

    @Override
    public Boolean getDriveOnLeft() {
        return this.converter.getDriveOnLeft();
    }
}

