/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class RestrictionRelation
extends Relation {
    private static final Logger log = Logger.getLogger(RestrictionRelation.class);
    private List<Long> fromWayIds = new ArrayList<Long>(2);
    private List<Long> toWayIds = new ArrayList<Long>(2);
    private List<Long> viaWayIds = new ArrayList<Long>(2);
    private List<Coord> viaPoints = new ArrayList<Coord>(2);
    private Coord viaCoord;
    private String restriction;
    private byte exceptMask;
    private char dirIndicator;
    private String messagePrefix;
    private boolean valid;
    private boolean evalWasCalled;
    private static final String[] unsupportedTags = new String[]{"day_on", "day_off", "hour_on", "hour_off"};
    private static final byte DEFAULT_EXCEPT_MASK = -127;
    private static final List<String> supportedRestrictions = Arrays.asList("no_right_turn", "no_left_turn", "no_u_turn", "no_straight_on", "only_right_turn", "only_left_turn", "only_straight_on", "no_entry", "no_exit");

    public RestrictionRelation(Relation other) {
        this.setId(other.getId());
        this.messagePrefix = "Turn restriction " + this.toBrowseURL();
        this.copyTags(other);
        for (Map.Entry<String, Element> pair : other.getElements()) {
            this.addElement(pair.getKey(), pair.getValue());
        }
    }

    public void eval(Area bbox) {
        String except;
        String vehicle;
        if (this.evalWasCalled) {
            log.error(this.messagePrefix, "internal error: eval() was already called");
            this.fromWayIds.clear();
            this.toWayIds.clear();
            this.viaWayIds.clear();
        }
        this.evalWasCalled = true;
        if (this.getTag("type") == null) {
            log.info(this.messagePrefix, "type tag was removed, relation is ignored");
            this.valid = false;
            return;
        }
        ArrayList<Way> fromWays = new ArrayList<Way>();
        ArrayList<Way> toWays = new ArrayList<Way>();
        ArrayList<Way> viaWays = new ArrayList<Way>();
        String browseURL = this.toBrowseURL();
        this.valid = true;
        this.exceptMask = (byte)-127;
        String specifc_type = this.getTag("restriction");
        int count_unknown = 0;
        Map<String, String> vehicles = this.getTagsWithPrefix("restriction:", true);
        if (!vehicles.isEmpty()) {
            this.exceptMask = (byte)-1;
            for (Map.Entry<String, String> entry : vehicles.entrySet()) {
                vehicle = entry.getKey();
                if (!this.setExceptMask(vehicle, false)) {
                    ++count_unknown;
                }
                if (specifc_type == null) {
                    specifc_type = entry.getValue();
                    continue;
                }
                if (specifc_type.equals(entry.getValue())) continue;
                log.warn(this.messagePrefix, "is invalid, it specifies different kinds of turns");
                this.valid = false;
                break;
            }
            if (this.valid && vehicles.size() == count_unknown) {
                log.warn(this.messagePrefix, "no supported vehicle in turn restriction");
                this.valid = false;
                return;
            }
        }
        if (specifc_type == null) {
            log.info(this.messagePrefix, "no valid restriction tag found");
            this.valid = false;
            return;
        }
        this.restriction = specifc_type.trim();
        this.messagePrefix = "Turn restriction (" + this.restriction + ") " + browseURL;
        if (!supportedRestrictions.contains(this.restriction)) {
            log.warn(this.messagePrefix, "ignoring unsupported restriction type '" + this.restriction + "'");
            this.valid = false;
            return;
        }
        String dirInfo = "";
        if (this.restriction.contains("left")) {
            dirInfo = dirInfo + "l";
        }
        if (this.restriction.contains("right")) {
            dirInfo = dirInfo + "r";
        }
        if (this.restriction.contains("straight")) {
            dirInfo = dirInfo + "s";
        }
        if (this.restriction.endsWith("u_turn")) {
            dirInfo = dirInfo + "u";
        }
        if (dirInfo.length() > 1) {
            log.warn(this.messagePrefix, "ignoring unsupported restriction type '" + this.restriction + "'");
            this.valid = false;
            return;
        }
        this.dirIndicator = dirInfo.length() == 1 ? dirInfo.charAt(0) : (char)63;
        String type = this.getTag("type");
        if (type.startsWith("restriction:")) {
            this.exceptMask = (byte)-1;
            vehicle = type.substring("restriction:".length());
            if (!this.setExceptMask(vehicle, false)) {
                log.warn(this.messagePrefix, "ignoring unsupported '" + vehicle + "' in turn restriction");
                this.valid = false;
                return;
            }
        }
        if ((except = this.getTag("except")) != null) {
            for (String vehicle2 : except.split("[,;]")) {
                vehicle2 = vehicle2.trim();
                this.setExceptMask(vehicle2, true);
            }
        }
        for (String unsupportedTag : unsupportedTags) {
            if (this.getTag(unsupportedTag) == null) continue;
            log.warn(this.messagePrefix, "ignoring unsupported '" + unsupportedTag + "' tag");
        }
        for (Map.Entry<String, Element> pair : this.getElements()) {
            String role = pair.getKey();
            Element el = pair.getValue();
            Coord location = null;
            if (this.viaCoord != null) {
                location = this.viaCoord;
            } else if (!fromWays.isEmpty() && !((Way)fromWays.get(0)).getPoints().isEmpty()) {
                location = ((Way)fromWays.get(0)).getPoints().get(0);
            } else if (!toWays.isEmpty() && !((Way)toWays.get(0)).getPoints().isEmpty()) {
                location = ((Way)toWays.get(0)).getPoints().get(0);
            } else if (!viaWays.isEmpty() && !((Way)viaWays.get(0)).getPoints().isEmpty()) {
                location = ((Way)viaWays.get(0)).getPoints().get(0);
            }
            if (location != null) {
                this.messagePrefix = "Turn restriction (" + this.restriction + ") " + browseURL + " (at " + location.toOSMURL() + ")";
            }
            if ("to".equals(role)) {
                if (!(el instanceof Way)) {
                    log.warn(this.messagePrefix, "'to' member", el.toBrowseURL(), "is not a way but it should be");
                    continue;
                }
                if (((Way)el).getPoints().isEmpty()) {
                    log.warn(this.messagePrefix, "ignoring empty 'to' way", el.toBrowseURL());
                    continue;
                }
                toWays.add((Way)el);
                continue;
            }
            if ("from".equals(role)) {
                if (!(el instanceof Way)) {
                    log.warn(this.messagePrefix, "'from' member", el.toBrowseURL(), "is not a way but it should be");
                    continue;
                }
                if (((Way)el).getPoints().isEmpty()) {
                    log.warn(this.messagePrefix, "ignoring empty 'from' way", el.toBrowseURL());
                    continue;
                }
                fromWays.add((Way)el);
                continue;
            }
            if ("via".equals(role)) {
                if (el instanceof Node) {
                    if (this.viaCoord != null) {
                        log.warn(this.messagePrefix, "has extra 'via' node", el.toBrowseURL());
                        this.valid = false;
                        continue;
                    }
                    this.viaCoord = ((Node)el).getLocation();
                    continue;
                }
                if (el instanceof Way) {
                    if (this.viaCoord != null) {
                        log.warn(this.messagePrefix, "has extra 'via' way", el.toBrowseURL());
                        this.valid = false;
                        continue;
                    }
                    viaWays.add((Way)el);
                    continue;
                }
                log.warn(this.messagePrefix, "'via' member", el.toBrowseURL(), "is not a node or way");
                continue;
            }
            if ("location_hint".equals(role)) continue;
            log.warn(this.messagePrefix, "unknown member role '" + role + "'");
        }
        if (!this.valid) {
            return;
        }
        if (!"no_entry".equals(this.restriction) && fromWays.size() > 1) {
            log.warn(this.messagePrefix, "multiple 'from' members are only accepted for no_entry restrictions");
            this.valid = false;
            return;
        }
        if (!"no_exit".equals(this.restriction) && toWays.size() > 1) {
            log.warn(this.messagePrefix, "multiple 'to' members are only accepted for no_exit restrictions");
            this.valid = false;
            return;
        }
        if (viaWays.isEmpty() && this.viaCoord == null && fromWays.size() == 1 && toWays.size() == 1) {
            Way fromWay = (Way)fromWays.get(0);
            Way toWay = (Way)toWays.get(0);
            List<Coord> fromPoints = fromWay.getPoints();
            List<Coord> toPoints = toWay.getPoints();
            int countSame = 0;
            for (Coord fp : fromPoints) {
                for (Coord tp : toPoints) {
                    if (fp != tp) continue;
                    ++countSame;
                    this.viaCoord = fp;
                }
            }
            if (countSame > 1) {
                log.warn(this.messagePrefix, "lacks 'via' node and way and the 'from' (", fromWay.toBrowseURL(), ") and 'to' (", toWay.toBrowseURL(), ") ways connect in more than one place");
                this.valid = false;
            } else if (this.viaCoord == null) {
                log.warn(this.messagePrefix, "lacks 'via' node and the 'from' (" + fromWay.toBrowseURL() + ") and 'to' (" + toWay.toBrowseURL() + ") ways don't connect");
                this.valid = false;
            } else if (fromPoints.get(0) != this.viaCoord && fromPoints.get(fromPoints.size() - 1) != this.viaCoord || toPoints.get(0) != this.viaCoord && toPoints.get(toPoints.size() - 1) != this.viaCoord) {
                log.warn(this.messagePrefix, "lacks 'via' node and the 'from' (" + fromWay.toBrowseURL() + ") and 'to' (" + toWay.toBrowseURL() + ") ways don't connect at an end point");
                this.valid = false;
            } else {
                log.warn(this.messagePrefix, "lacks 'via' node (guessing it should be at", this.viaCoord.toOSMURL() + ", why don't you add it to the OSM data?)");
            }
        }
        if (fromWays.isEmpty()) {
            log.warn(this.messagePrefix, "lacks 'from' way");
            this.valid = false;
        }
        if (toWays.isEmpty()) {
            log.warn(this.messagePrefix, "lacks 'to' way");
            this.valid = false;
        }
        if (!(fromWays.size() <= 1 && toWays.size() <= 1 || viaWays.isEmpty())) {
            log.warn(this.messagePrefix, "'via' way(s) are not supported with multiple 'from' or 'to' ways");
            this.valid = false;
        }
        if (toWays.size() == 1 && fromWays.size() == 1 && viaWays.isEmpty() && "no_u_turn".equals(this.restriction) && ((Way)fromWays.get(0)).equals(toWays.get(0))) {
            log.warn(this.messagePrefix, "no_u_turn with equal 'from' and 'to' way and via node is ignored");
            this.valid = false;
        }
        if (!this.valid) {
            return;
        }
        for (List ways : Arrays.asList(fromWays, viaWays, toWays)) {
            for (Way way : ways) {
                if (way.getPoints().size() < 2) {
                    log.warn(this.messagePrefix, "way", way.toBrowseURL(), "has less than 2 points, restriction is ignored");
                    this.valid = false;
                    continue;
                }
                if (way.getPoints().get(0) != way.getPoints().get(way.getPoints().size() - 1) || ways == toWays && this.dirIndicator != '?') continue;
                log.warn(this.messagePrefix, "way", way.toBrowseURL(), "starts and ends at same node, don't know which one to use");
                this.valid = false;
            }
        }
        if (!this.valid) {
            return;
        }
        if (!this.viaPoints.isEmpty()) {
            this.viaCoord = this.viaPoints.get(0);
        }
        if (this.viaCoord == null && viaWays.isEmpty()) {
            this.valid = false;
            return;
        }
        this.viaPoints.clear();
        Coord v1 = this.viaCoord;
        Coord v2 = this.viaCoord;
        if (!viaWays.isEmpty()) {
            v1 = ((Way)viaWays.get(0)).getPoints().get(0);
            v2 = ((Way)viaWays.get(0)).getPoints().get(((Way)viaWays.get(0)).getPoints().size() - 1);
        }
        for (Way fromWay : fromWays) {
            Coord e1 = fromWay.getPoints().get(0);
            Coord e2 = fromWay.getPoints().get(fromWay.getPoints().size() - 1);
            if (e1 == v1 || e2 == v1) {
                this.viaCoord = v1;
                continue;
            }
            if (e1 == v2 || e2 == v2) {
                this.viaCoord = v2;
                continue;
            }
            log.warn(this.messagePrefix, "'from' way", fromWay.toBrowseURL(), "doesn't start or end at 'via' node or way");
            this.valid = false;
        }
        if (!this.valid) {
            return;
        }
        this.viaPoints.add(this.viaCoord);
        for (int i = 0; i < viaWays.size(); ++i) {
            Way way;
            way = (Way)viaWays.get(i);
            Coord v = this.viaPoints.get(this.viaPoints.size() - 1);
            if (way.getPoints().get(0) == v) {
                v2 = way.getPoints().get(way.getPoints().size() - 1);
            } else if (way.getPoints().get(way.getPoints().size() - 1) == v) {
                v2 = way.getPoints().get(0);
            } else {
                log.warn(this.messagePrefix, "'via' way", way.toBrowseURL(), "doesn't start or end at", v.toDegreeString());
                this.valid = false;
            }
            this.viaPoints.add(v2);
        }
        int countInside = 0;
        for (Coord via : this.viaPoints) {
            if (!bbox.contains(via)) continue;
            ++countInside;
        }
        if (countInside == 0) {
            this.valid = false;
        } else if (countInside > 0 && countInside < this.viaPoints.size()) {
            log.warn(this.messagePrefix, "via way crosses tile boundary. Don't know how to save that, ignoring it");
            this.valid = false;
        }
        if (!this.valid) {
            return;
        }
        Coord lastVia = this.viaPoints.get(this.viaPoints.size() - 1);
        for (Way toWay : toWays) {
            Coord e1 = toWay.getPoints().get(0);
            Coord e2 = toWay.getPoints().get(toWay.getPoints().size() - 1);
            if (e1 == lastVia || e2 == lastVia) continue;
            log.warn(this.messagePrefix, "'to' way", toWay.toBrowseURL(), "doesn't start or end at 'via' node or way");
            this.valid = false;
        }
        if (this.valid && !viaWays.isEmpty() && this.restriction.startsWith("only")) {
            log.warn(this.messagePrefix, "check: 'via' way(s) are used in", this.restriction, "restriction");
        }
        if (this.valid) {
            for (Way w : viaWays) {
                if (fromWays.contains(w)) {
                    log.warn(this.messagePrefix, "'via' way", w.toBrowseURL(), "appears also as 'from' way");
                    this.valid = false;
                }
                if (!toWays.contains(w)) continue;
                log.warn(this.messagePrefix, "'via' way", w.toBrowseURL(), "appears also as 'to' way");
                this.valid = false;
            }
        }
        if (this.valid) {
            for (Way w : fromWays) {
                this.fromWayIds.add(w.getId());
            }
            for (Way w : toWays) {
                this.toWayIds.add(w.getId());
            }
            for (Way w : viaWays) {
                w.setViaWay(true);
                this.viaWayIds.add(w.getId());
            }
            for (Coord v : this.viaPoints) {
                v.setViaNodeOfRestriction(true);
            }
        }
    }

    private boolean setExceptMask(String vehicle, boolean b) {
        int flag = 0;
        if (vehicle == null) {
            return false;
        }
        if (vehicle.equals("vehicle")) {
            flag = 126;
        } else if (vehicle.equals("motor_vehicle")) {
            flag = 124;
        } else if (vehicle.equals("psv")) {
            flag = 96;
        } else if (vehicle.equals("bicycle")) {
            flag = 2;
        } else if (vehicle.equals("motorcar")) {
            flag = 4;
        } else if (vehicle.equals("bus")) {
            flag = 32;
        } else if (vehicle.equals("taxi")) {
            flag = 64;
        } else if (vehicle.equals("goods")) {
            flag = 8;
        } else if (vehicle.equals("hgv") || vehicle.equals("truck")) {
            flag = 16;
        } else if (vehicle.equals("emergency")) {
            flag = -128;
        } else if (vehicle.equals("foot")) {
            flag = 1;
        }
        if (flag == 0) {
            log.warn(this.messagePrefix, "ignoring unsupported vehicle class '" + vehicle + "' in turn restriction");
            return false;
        }
        this.exceptMask = b ? (byte)(this.exceptMask | flag) : (byte)(this.exceptMask & ~flag);
        return true;
    }

    public boolean isFromWay(long wayId) {
        return this.fromWayIds.contains(wayId);
    }

    public boolean isToWay(long wayId) {
        return this.toWayIds.contains(wayId);
    }

    public void replaceViaCoord(Coord oldP, Coord newP) {
        for (int i = 0; i < this.viaPoints.size(); ++i) {
            if (this.viaPoints.get(i) != oldP) continue;
            this.viaPoints.set(i, newP);
            if (log.isDebugEnabled()) {
                log.debug(this.messagePrefix, this.restriction, "'via' coord redefined from", oldP.toOSMURL(), "to", newP.toOSMURL());
            }
            return;
        }
    }

    public void addRestriction(MapCollector collector, IdentityHashMap<Coord, CoordNode> nodeIdMap) {
        GeneralRouteRestriction grr;
        if (!this.valid) {
            return;
        }
        ArrayList<CoordNode> viaNodes = new ArrayList<CoordNode>();
        for (Coord v : this.viaPoints) {
            CoordNode vn = nodeIdMap.get(v);
            if (vn == null) {
                log.error(this.messagePrefix, "via node is not a routing node");
                return;
            }
            viaNodes.add(vn);
        }
        if (viaNodes.size() > 6) {
            log.warn(this.messagePrefix, "has more than 6 via nodes, this is not supported");
            return;
        }
        if (this.restriction == null) {
            log.error("internal error: can't add valid restriction relation", this.getId(), "type", this.restriction);
            return;
        }
        int addedRestrictions = 0;
        if (this.restriction.startsWith("no_")) {
            for (long fromWayId : this.fromWayIds) {
                for (long toWayId : this.toWayIds) {
                    grr = new GeneralRouteRestriction("not", this.exceptMask, this.messagePrefix);
                    grr.setFromWayId(fromWayId);
                    grr.setToWayId(toWayId);
                    grr.setViaNodes(viaNodes);
                    grr.setViaWayIds(this.viaWayIds);
                    grr.setDirIndicator(this.dirIndicator);
                    addedRestrictions += collector.addRestriction(grr);
                }
            }
            if (log.isInfoEnabled()) {
                log.info(this.messagePrefix, this.restriction, "translated to", addedRestrictions, "img file restrictions");
            }
        } else if (this.restriction.startsWith("only_")) {
            grr = new GeneralRouteRestriction("only", this.exceptMask, this.messagePrefix);
            grr.setFromWayId(this.fromWayIds.get(0));
            grr.setToWayId(this.toWayIds.get(0));
            grr.setViaNodes(viaNodes);
            grr.setViaWayIds(this.viaWayIds);
            grr.setDirIndicator(this.dirIndicator);
            int numAdded = collector.addRestriction(grr);
            if (numAdded > 0) {
                log.info(this.messagePrefix, this.restriction, "added - allows routing to way", this.toWayIds.get(0));
            }
        } else {
            log.error("mkgmap internal error: unknown restriction", this.restriction);
        }
    }

    @Override
    public void processElements() {
    }

    public String toString() {
        String s = "[restriction id = " + this.getId() + "(" + this.restriction + ")";
        s = !this.fromWayIds.isEmpty() && !this.toWayIds.isEmpty() && this.viaCoord != null ? s + ", from = " + this.fromWayIds.get(0) + ", to = " + this.toWayIds.get(0) + ", via = " + this.viaCoord.toOSMURL() + "]" : s + "]";
        return s;
    }

    public boolean isValid() {
        assert (this.evalWasCalled);
        return this.valid;
    }

    public List<Coord> getViaCoords() {
        assert (this.evalWasCalled);
        return this.viaPoints;
    }

    public Set<Long> getWayIds() {
        assert (this.evalWasCalled);
        HashSet<Long> wayIds = new HashSet<Long>();
        wayIds.addAll(this.fromWayIds);
        wayIds.addAll(this.viaWayIds);
        wayIds.addAll(this.toWayIds);
        return wayIds;
    }

    public byte getExceptMask() {
        assert (this.evalWasCalled);
        return this.exceptMask;
    }

    public boolean replaceWay(long oldWayId, long newWayId) {
        assert (this.evalWasCalled);
        boolean matched = false;
        for (List ways : Arrays.asList(this.fromWayIds, this.viaWayIds, this.toWayIds)) {
            for (int i = 0; i < ways.size(); ++i) {
                if ((Long)ways.get(i) != oldWayId) continue;
                ways.set(i, newWayId);
                matched = true;
            }
        }
        return matched;
    }

    public boolean isValidWithoputWay(long wayId) {
        assert (this.evalWasCalled);
        if (this.viaWayIds.contains(wayId)) {
            return false;
        }
        this.fromWayIds.remove(wayId);
        if (this.fromWayIds.isEmpty()) {
            return false;
        }
        this.toWayIds.remove(wayId);
        return !this.toWayIds.isEmpty();
    }

    public void updateViaWay(Way way, List<Integer> nodeIndices) {
        if (!this.valid) {
            return;
        }
        if (!this.viaWayIds.contains(way.getId())) {
            return;
        }
        Coord first = way.getPoints().get(nodeIndices.get(0));
        Coord last = way.getPoints().get(nodeIndices.get(nodeIndices.size() - 1));
        int posFirst = -1;
        for (int i = 0; i < this.viaPoints.size(); ++i) {
            if (first != this.viaPoints.get(i)) continue;
            posFirst = i;
            break;
        }
        int posLast = -1;
        for (int i = 0; i < this.viaPoints.size(); ++i) {
            if (last != this.viaPoints.get(i)) continue;
            posLast = i;
            break;
        }
        if (posFirst < 0 || posLast < 0) {
            log.error(this.messagePrefix, "internal error: via way doesn't contain expected points");
            this.valid = false;
            return;
        }
        ArrayList<Coord> midPoints = new ArrayList<Coord>();
        int i = 1;
        while (i + 1 < nodeIndices.size()) {
            midPoints.add(way.getPoints().get(nodeIndices.get(i)));
            ++i;
        }
        if (posFirst < posLast) {
            if (posLast - posFirst > 1) {
                this.viaPoints.subList(posFirst + 1, posLast).clear();
            }
            this.viaPoints.addAll(posFirst + 1, midPoints);
        } else {
            if (posFirst - posLast > 1) {
                this.viaPoints.subList(posLast + 1, posFirst).clear();
            }
            Collections.reverse(midPoints);
            this.viaPoints.addAll(posLast + 1, midPoints);
        }
        int wayPos = this.viaWayIds.indexOf(way.getId());
        while (this.viaWayIds.size() > wayPos + 1 && this.viaWayIds.get(wayPos + 1).longValue() == way.getId()) {
            this.viaWayIds.remove(wayPos);
        }
        for (int i2 = 0; i2 < midPoints.size(); ++i2) {
            this.viaWayIds.add(wayPos + 1, way.getId());
        }
        if (this.viaPoints.size() != this.viaWayIds.size() + 1) {
            log.error((Object)"internal error: number of via points and via ways no longer fits");
            this.valid = false;
        } else if (this.viaPoints.size() > 6) {
            log.warn(this.messagePrefix, "has more than 6 via nodes, this is not supported");
            this.valid = false;
        }
    }
}

