/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.GpxCreator;
import uk.me.parabola.util.QuadTree;

public class SeaPolygonRelation
extends MultiPolygonRelation {
    private static final Logger log = Logger.getLogger(SeaPolygonRelation.class);
    private final QuadTree landCoords;
    private final QuadTree seaCoords;
    private boolean floodBlocker = true;
    private int floodBlockerGap = 40;
    private double floodBlockerRatio = 0.5;
    private int floodBlockerThreshold = 20;
    private boolean debug;
    private final DecimalFormat format = new DecimalFormat("0.0000");
    private Rule floodBlockerRules;
    private final String[] landTag = new String[]{"natural", "land"};

    public SeaPolygonRelation(Relation other, Map<Long, Way> wayMap, Area bbox) {
        super(other, wayMap, bbox);
        this.landCoords = new QuadTree(bbox);
        this.seaCoords = new QuadTree(bbox);
        this.addTag("type", "mkgmap:seapolygon");
    }

    @Override
    protected boolean isAreaSizeCalculated() {
        return false;
    }

    @Override
    protected void postProcessing() {
        if (this.isFloodBlocker()) {
            this.removeFloodedAreas();
        }
        super.postProcessing();
    }

    private void fillQuadTrees() {
        final AtomicBoolean isLand = new AtomicBoolean(false);
        final AtomicBoolean isSea = new AtomicBoolean(false);
        TypeResult fakedType = new TypeResult(){

            @Override
            public void add(Element el, GType type) {
                if (log.isDebugEnabled()) {
                    log.debug(el.getId(), type);
                }
                if (type.getType() == 1) {
                    isLand.set(true);
                } else if (type.getType() == 2) {
                    isSea.set(true);
                }
            }
        };
        for (Way way : this.getTileWayMap().values()) {
            if (log.isDebugEnabled()) {
                log.debug("Check usage of way for floodblocker:", way.getId(), way.toTagString());
            }
            this.floodBlockerRules.resolveType(way, fakedType);
            if (isLand.get()) {
                log.debug("Way", way.getId(), "identified as land");
                this.landCoords.addAll(way.getPoints());
                isLand.set(false);
                continue;
            }
            if (!isSea.get()) continue;
            log.debug("Way", way.getId(), "identified as sea");
            this.seaCoords.addAll(way.getPoints());
            isSea.set(false);
        }
    }

    private void removeFloodedAreas() {
        this.fillQuadTrees();
        ArrayList<Way> polygons = new ArrayList<Way>(this.getMpPolygons().values());
        log.info("Starting flood blocker. Polygons to check:", this.getMpPolygons().size());
        String baseName = GpxCreator.getGpxBaseName();
        if (this.debug) {
            GpxCreator.createAreaGpx(baseName + "bbox", this.getBbox());
        }
        for (Way p : polygons) {
            boolean sea = "sea".equals(p.getTag("natural"));
            QuadTree goodCoords = sea ? this.seaCoords : this.landCoords;
            QuadTree badCoords = sea ? this.landCoords : this.seaCoords;
            String polyType = sea ? "sea" : "land";
            String otherType = sea ? "land" : "sea";
            List<Coord> minusCoords = badCoords.get(p.getPoints(), this.getFloodBlockerGap());
            List<Coord> positiveCoords = goodCoords.get(p.getPoints());
            log.info(polyType, "polygon", p.getId(), "contains", minusCoords.size(), otherType, "coords and", positiveCoords.size(), polyType, "coords.");
            if (minusCoords.size() <= 0) continue;
            double area = MultiPolygonRelation.calcAreaSize(p.getPoints());
            double ratio = (double)(minusCoords.size() - positiveCoords.size()) * 100000.0 / area;
            String areaFMT = this.format.format(area);
            String ratioFMT = this.format.format(ratio);
            log.info("Flood blocker for", polyType, "polygon", p.getId());
            log.info("area", areaFMT);
            log.info(polyType, positiveCoords.size());
            log.info(otherType, minusCoords.size());
            log.info("ratio", ratioFMT);
            if (this.debug) {
                GpxCreator.createGpx(baseName + p.getId() + "_" + polyType + "_" + minusCoords.size() + "_" + positiveCoords.size() + "_" + ratioFMT, p.getPoints());
                GpxCreator.createGpx(baseName + p.getId() + "_con_" + minusCoords.size() + "_" + positiveCoords.size() + "_" + ratioFMT, null, minusCoords);
                if (!positiveCoords.isEmpty()) {
                    GpxCreator.createGpx(baseName + p.getId() + "_pro_" + minusCoords.size() + "_" + positiveCoords.size() + "_" + ratioFMT, null, positiveCoords);
                }
            }
            if (minusCoords.size() - positiveCoords.size() >= this.getFloodBlockerThreshold() && ratio > this.getFloodBlockerRatio()) {
                log.warn("Polygon", p.getId(), "type", polyType, "seems to be wrong. Changing it to", otherType);
                if (sea) {
                    p.deleteTag("natural");
                    p.addTag(this.landTag[0], this.landTag[1]);
                    continue;
                }
                p.deleteTag(this.landTag[0]);
                p.addTag("natural", "sea");
                continue;
            }
            log.info("Polygon", p.getId(), "is not blocked");
        }
        log.info("Flood blocker finished. Resulting polygons:", this.getMpPolygons().size());
        this.landCoords.clear();
        this.seaCoords.clear();
    }

    public boolean isFloodBlocker() {
        return this.floodBlocker;
    }

    public void setFloodBlocker(boolean floodBlocker) {
        this.floodBlocker = floodBlocker;
    }

    public int getFloodBlockerGap() {
        return this.floodBlockerGap;
    }

    public void setFloodBlockerGap(int floodBlockerGap) {
        this.floodBlockerGap = floodBlockerGap;
    }

    public double getFloodBlockerRatio() {
        return this.floodBlockerRatio;
    }

    public void setFloodBlockerRatio(double floodBlockerRatio) {
        this.floodBlockerRatio = floodBlockerRatio;
    }

    public int getFloodBlockerThreshold() {
        return this.floodBlockerThreshold;
    }

    public void setFloodBlockerThreshold(int floodBlockerThreshold) {
        this.floodBlockerThreshold = floodBlockerThreshold;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Rule getFloodBlockerRules() {
        return this.floodBlockerRules;
    }

    public void setFloodBlockerRules(Rule floodBlockerRules) {
        this.floodBlockerRules = floodBlockerRules;
    }

    public void setLandTag(String landTag, String landValue) {
        this.landTag[0] = landTag;
        this.landTag[1] = landValue;
    }
}

