/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;
import uk.me.parabola.util.EnhancedProperties;

public class BoundaryGrid {
    private static final Logger log = Logger.getLogger(BoundaryGrid.class);
    private final Area searchBbox;
    private final BoundaryQuadTree[][] grid;
    private final boolean[][] emptyMessagePrinted;
    private final int minLat;
    private final int minLon;
    private final EnhancedProperties props;

    public BoundaryGrid(String boundaryDirName, Area bbox, EnhancedProperties props) {
        this.minLat = BoundaryUtil.getSplitBegin(bbox.getMinLat());
        this.minLon = BoundaryUtil.getSplitBegin(bbox.getMinLong());
        int gridMaxLat = BoundaryUtil.getSplitBegin(bbox.getMaxLat());
        int gridMaxLon = BoundaryUtil.getSplitBegin(bbox.getMaxLong());
        int dimLat = (gridMaxLat - this.minLat) / 50000 + 1;
        int dimLon = (gridMaxLon - this.minLon) / 50000 + 1;
        this.grid = new BoundaryQuadTree[dimLat][dimLon];
        this.emptyMessagePrinted = new boolean[dimLat][dimLon];
        this.searchBbox = bbox;
        this.props = props;
        this.init(boundaryDirName);
    }

    public Tags get(Coord co) {
        int gridLon;
        if (!this.searchBbox.contains(co)) {
            return null;
        }
        int gridLat = (co.getLatitude() - this.minLat) / 50000;
        if (this.grid[gridLat][gridLon = (co.getLongitude() - this.minLon) / 50000] == null) {
            if (!this.emptyMessagePrinted[gridLat][gridLon]) {
                this.emptyMessagePrinted[gridLat][gridLon] = true;
                int keyLat = BoundaryUtil.getSplitBegin(co.getLatitude());
                int keyLon = BoundaryUtil.getSplitBegin(co.getLongitude());
                log.warn("no precompiled boundary information available for raster tile", BoundaryUtil.getKey(keyLat, keyLon));
            }
            return null;
        }
        return this.grid[gridLat][gridLon].get(co);
    }

    private void init(String boundaryDirName) {
        List<String> requiredFileNames = BoundaryUtil.getRequiredBoundaryFileNames(this.searchBbox);
        Map<String, BoundaryQuadTree> trees = BoundaryUtil.loadQuadTrees(boundaryDirName, requiredFileNames, this.searchBbox, this.props);
        for (Map.Entry<String, BoundaryQuadTree> entry : trees.entrySet()) {
            Area fileBbox = BoundaryUtil.getBbox(entry.getKey());
            int gridLat = (fileBbox.getMinLat() - this.minLat) / 50000;
            int gridLon = (fileBbox.getMinLong() - this.minLon) / 50000;
            this.grid[gridLat][gridLon] = entry.getValue();
        }
    }
}

