/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryElement;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.Java2DConverter;
import uk.me.parabola.util.MultiHashMap;
import uk.me.parabola.util.ShapeSplitter;

public class BoundaryUtil {
    private static final Logger log = Logger.getLogger(BoundaryUtil.class);
    private static final int UNKNOWN_DATA_FORMAT = 0;
    private static final int RAW_DATA_FORMAT_V1 = 2;
    private static final int QUADTREE_DATA_FORMAT_V1 = 3;
    public static final double MIN_DIMENSION = 1.0E-7;
    public static final int RASTER = 50000;

    public static List<BoundaryElement> splitToElements(java.awt.geom.Area area, String id) {
        if (area.isEmpty()) {
            return Collections.emptyList();
        }
        java.awt.geom.Area testArea = area;
        boolean tryAgain = true;
        while (true) {
            List<List<Coord>> areaElements;
            if ((areaElements = Java2DConverter.areaToShapes(testArea)).isEmpty()) {
                log.debug("Area has no dimension. Area:", area.getBounds());
                return Collections.emptyList();
            }
            ArrayList<BoundaryElement> bElements = new ArrayList<BoundaryElement>();
            for (List<Coord> singleElement : areaElements) {
                if (singleElement.size() <= 3) continue;
                boolean outer = Way.clockwise(singleElement);
                bElements.add(new BoundaryElement(outer, singleElement));
            }
            if (bElements.isEmpty()) {
                log.error((Object)("Empty boundary elements list after conversion. Area: " + area.getBounds()));
                return Collections.emptyList();
            }
            Collections.reverse(bElements);
            if (((BoundaryElement)bElements.get(0)).isOuter()) {
                return bElements;
            }
            if (!tryAgain) {
                log.error((Object)(" first element is not outer. " + bElements.get(0)));
                return Collections.emptyList();
            }
            Path2D.Float path = new Path2D.Float(area);
            testArea = new java.awt.geom.Area(path);
            tryAgain = false;
        }
    }

    public static BoundaryQuadTree loadQuadTree(String boundaryDirName, String boundaryFileName) {
        Map<String, BoundaryQuadTree> trees = BoundaryUtil.loadQuadTrees(boundaryDirName, Collections.singletonList(boundaryFileName), null, null);
        return trees.get(boundaryFileName);
    }

    public static Map<String, BoundaryQuadTree> loadQuadTrees(String boundaryDirName, List<String> boundaryFileNames, Area searchBbox, EnhancedProperties props) {
        HashMap<String, BoundaryQuadTree> trees = new HashMap<String, BoundaryQuadTree>();
        File boundaryDir = new File(boundaryDirName);
        if (boundaryDir.isDirectory()) {
            for (String boundaryFileName : boundaryFileNames) {
                log.info("loading boundary file:", boundaryFileName);
                File boundaryFile = new File(boundaryDir, boundaryFileName);
                if (!boundaryFile.exists()) continue;
                try {
                    FileInputStream stream = new FileInputStream(boundaryFile);
                    Throwable throwable = null;
                    try {
                        BoundaryQuadTree bqt = BoundaryUtil.loadQuadTreeFromStream(stream, boundaryFileName, searchBbox, props);
                        if (bqt == null) continue;
                        trees.put(boundaryFileName, bqt);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException exp) {
                    log.error((Object)("Cannot load boundary file " + boundaryFileName + "." + exp));
                }
            }
        } else if (boundaryDirName.endsWith(".zip")) {
            String currentFileName = "";
            try (ZipFile zipFile = new ZipFile(boundaryDir);){
                for (String boundaryFileName : boundaryFileNames) {
                    log.info("loading boundary file:", boundaryFileName);
                    currentFileName = boundaryFileName;
                    ZipEntry entry = zipFile.getEntry(boundaryFileName);
                    if (entry == null) continue;
                    InputStream stream = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        BoundaryQuadTree bqt = BoundaryUtil.loadQuadTreeFromStream(stream, boundaryFileName, searchBbox, props);
                        if (bqt == null) continue;
                        trees.put(boundaryFileName, bqt);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            catch (IOException exp) {
                log.error((Object)("Cannot load boundary file " + currentFileName + "." + exp));
            }
        } else {
            log.error((Object)("Cannot read " + boundaryDirName));
        }
        return trees;
    }

    public static java.awt.geom.Area readAreaAsPath(DataInputStream inpStream) throws IOException {
        double[] res = new double[2];
        Path2D.Double path = new Path2D.Double(1, 1024);
        int windingRule = inpStream.readInt();
        path.setWindingRule(windingRule);
        int type = inpStream.readInt();
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        while (type >= 0) {
            switch (type) {
                case 1: {
                    double delta;
                    int ii;
                    for (int len = inpStream.readInt(); len > 0; --len) {
                        for (ii = 0; ii < 2; ++ii) {
                            delta = BoundaryUtil.readVarDouble(inpStream);
                            res[ii] = delta == Double.POSITIVE_INFINITY ? BoundaryUtil.readVarDouble(inpStream) : res[ii] + delta;
                        }
                        if (res[0] < minX) {
                            minX = res[0];
                        }
                        if (res[0] > maxX) {
                            maxX = res[0];
                        }
                        if (res[1] < minY) {
                            minY = res[1];
                        }
                        if (res[1] > maxY) {
                            maxY = res[1];
                        }
                        path.lineTo(res[0], res[1]);
                    }
                    break;
                }
                case 0: {
                    double delta;
                    int ii;
                    for (ii = 0; ii < 2; ++ii) {
                        delta = BoundaryUtil.readVarDouble(inpStream);
                        res[ii] = delta == Double.POSITIVE_INFINITY ? BoundaryUtil.readVarDouble(inpStream) : res[ii] + delta;
                    }
                    if (res[0] < minX) {
                        minX = res[0];
                    }
                    if (res[0] > maxX) {
                        maxX = res[0];
                    }
                    if (res[1] < minY) {
                        minY = res[1];
                    }
                    if (res[1] > maxY) {
                        maxY = res[1];
                    }
                    path.moveTo(res[0], res[1]);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                    return null;
                }
            }
            type = inpStream.readInt();
        }
        if (type != -1) {
            log.error((Object)("Final type value != -1: " + type));
        } else if (maxX - minX >= 1.0E-7 || maxY - minY >= 1.0E-7) {
            return new java.awt.geom.Area(path);
        }
        return null;
    }

    private static List<Boundary> readStreamRawFormat(DataInputStream inpStream, String fname, Area bbox) throws IOException {
        ArrayList<Boundary> boundaryList = new ArrayList<Boundary>();
        try {
            while (true) {
                int minLat = inpStream.readInt();
                int minLong = inpStream.readInt();
                int maxLat = inpStream.readInt();
                int maxLong = inpStream.readInt();
                if (log.isDebugEnabled()) {
                    log.debug("Next boundary. Lat min:", minLat, "max:", maxLat, "Long min:", minLong, "max:", maxLong);
                }
                Area rBbox = new Area(minLat, minLong, maxLat, maxLong);
                int bSize = inpStream.readInt();
                log.debug("Size:", bSize);
                if (bbox == null || bbox.intersects(rBbox)) {
                    log.debug((Object)"Bbox intersects. Load the boundary");
                    String id = inpStream.readUTF();
                    Tags tags = new Tags();
                    int noOfTags = inpStream.readInt();
                    for (int i = 0; i < noOfTags; ++i) {
                        String name = inpStream.readUTF();
                        String value = inpStream.readUTF();
                        tags.put(name, value.intern());
                    }
                    java.awt.geom.Area area = BoundaryUtil.readAreaAsPath(inpStream);
                    if (area != null) {
                        Boundary boundary = new Boundary(area, tags, id);
                        boundaryList.add(boundary);
                        continue;
                    }
                    log.warn((Object)("Boundary " + tags + " does not contain any valid area in file " + fname));
                    continue;
                }
                log.debug("Bbox does not intersect. Skip", bSize);
                inpStream.skipBytes(bSize);
            }
        }
        catch (EOFException exp) {
            return boundaryList;
        }
    }

    public static List<String> getRequiredBoundaryFileNames(Area bbox) {
        ArrayList<String> names = new ArrayList<String>();
        for (int latSplit = BoundaryUtil.getSplitBegin(bbox.getMinLat()); latSplit <= BoundaryUtil.getSplitBegin(bbox.getMaxLat()); latSplit += 50000) {
            for (int lonSplit = BoundaryUtil.getSplitBegin(bbox.getMinLong()); lonSplit <= BoundaryUtil.getSplitBegin(bbox.getMaxLong()); lonSplit += 50000) {
                names.add("bounds_" + BoundaryUtil.getKey(latSplit, lonSplit) + ".bnd");
            }
        }
        return names;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getBoundaryDirContent(String dirName) {
        ArrayList<String> names = new ArrayList<String>();
        File boundaryDir = new File(dirName);
        if (!boundaryDir.exists()) {
            log.error((Object)("boundary directory/zip does not exist: " + dirName));
            return names;
        } else if (boundaryDir.isDirectory()) {
            String[] allNames;
            for (String name : allNames = boundaryDir.list()) {
                if (!name.endsWith(".bnd")) continue;
                names.add(name);
            }
            return names;
        } else {
            if (!boundaryDir.getName().endsWith(".zip")) return names;
            try (ZipFile zipFile = new ZipFile(boundaryDir);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                boolean isFlat = true;
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) {
                        isFlat = false;
                    }
                    if (!entry.getName().endsWith(".bnd")) continue;
                    names.add(entry.getName());
                }
                if (isFlat) return names;
                log.error((Object)("boundary zip file contains directories. Files in directories will be ignored." + dirName));
                return names;
            }
            catch (IOException ioe) {
                System.err.println("Unhandled exception:");
                ioe.printStackTrace();
            }
        }
        return names;
    }

    public static int getSplitBegin(int value) {
        int rem = value % 50000;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value - rem;
        }
        return value - 50000 - rem;
    }

    public static int getSplitEnd(int value) {
        int rem = value % 50000;
        if (rem == 0) {
            return value;
        }
        if (value >= 0) {
            return value + 50000 - rem;
        }
        return value - rem;
    }

    public static String getKey(int lat, int lon) {
        return lat + "_" + lon;
    }

    public static Area getBbox(String boundaryFileName) {
        String filename = new String(boundaryFileName);
        filename = filename.substring(0, filename.length() - 4);
        String[] fParts = filename.split(Pattern.quote("_"));
        int lat = Integer.parseInt(fParts[1]);
        int lon = Integer.parseInt(fParts[2]);
        return new Area(lat, lon, lat + 50000, lon + 50000);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BoundaryQuadTree loadQuadTreeFromStream(InputStream stream, String fname, Area searchBbox, EnhancedProperties props) throws IOException {
        block26: {
            bqt = null;
            qtBbox = BoundaryUtil.getBbox(fname);
            inpStream = new DataInputStream(new BufferedInputStream(stream, 0x100000));
            var7_7 = null;
            try {
                mkgmapRel = "?";
                firstId = inpStream.readUTF();
                if (!"BND".equals(firstId)) {
                    throw new FormatException("Unsupported boundary data type " + firstId);
                }
                format = 0;
                createTime = inpStream.readLong();
                headerLength = inpStream.readInt();
                header = new byte[headerLength];
                for (bytesRead = 0; bytesRead < headerLength; bytesRead += nBytes) {
                    nBytes = inpStream.read(header, bytesRead, headerLength - bytesRead);
                    if (nBytes >= 0) continue;
                    throw new IOException("Cannot read header with size " + headerLength);
                }
                rawHeaderStream = new ByteArrayInputStream(header);
                headerStream = new DataInputStream(rawHeaderStream);
                dataFormat = rawHeaderStream.available() > 0 ? headerStream.readUTF() : "RAW";
                recordVersion = rawHeaderStream.available() > 0 ? headerStream.readInt() : 2;
                v0 = mkgmapRel = rawHeaderStream.available() > 0 ? headerStream.readUTF() : "unknown";
                if ("RAW".equals(dataFormat) && recordVersion == 1) {
                    format = 2;
                } else if ("QUADTREE".equals(dataFormat) && recordVersion == 1) {
                    format = 3;
                }
                if (BoundaryUtil.log.isDebugEnabled()) {
                    BoundaryUtil.log.debug(new Object[]{"File created by mkgmap release", mkgmapRel, "at", new Date(createTime)});
                }
                switch (format) {
                    case 3: {
                        return new BoundaryQuadTree(inpStream, qtBbox, searchBbox, props);
                    }
                    case 2: {
                        boundaryList = BoundaryUtil.readStreamRawFormat(inpStream, fname, searchBbox);
                        if (boundaryList == null || boundaryList.isEmpty()) {
                            var21_25 = null;
                            if (inpStream == null) return var21_25;
                            if (var7_7 == null) break block26;
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                    default: {
                        throw new FormatException("Unsupported boundary file format: " + format);
                    }
                }
            }
            catch (EOFException exp) {
                return bqt;
            }
            catch (FormatException exp) {
                BoundaryUtil.log.error((Object)("Failed to read boundary file " + fname + " " + exp.getMessage()));
                return bqt;
            }
            catch (Throwable var8_12) {
                var7_7 = var8_12;
                throw var8_12;
            }
            catch (Throwable var23_27) {
                throw var23_27;
            }
            try {
                inpStream.close();
                return var21_25;
            }
            catch (Throwable x2) {
                var7_7.addSuppressed(x2);
                return var21_25;
            }
        }
        inpStream.close();
        return var21_25;
lbl-1000:
        // 1 sources

        {
            boundaryList = BoundaryUtil.mergePostalCodes(boundaryList);
            return new BoundaryQuadTree(qtBbox, boundaryList, props);
        }
    }

    private static List<Boundary> mergePostalCodes(List<Boundary> boundaries) {
        ArrayList<Boundary> mergedList = new ArrayList<Boundary>(boundaries.size());
        MultiHashMap<String, Boundary> equalPostalCodes = new MultiHashMap<String, Boundary>();
        for (Boundary boundary : boundaries) {
            String postalCode = BoundaryUtil.getPostalCode(boundary.getTags());
            if (postalCode == null) {
                mergedList.add(boundary);
                continue;
            }
            equalPostalCodes.add(postalCode, boundary);
        }
        for (Map.Entry entry : equalPostalCodes.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                mergedList.addAll((Collection)entry.getValue());
                continue;
            }
            java.awt.geom.Area newPostCodeArea = new java.awt.geom.Area();
            for (Boundary b : (List)entry.getValue()) {
                newPostCodeArea.add(b.getArea());
                if (b.getTags().get("postal_code") != null) {
                    b.getTags().remove("postal_code");
                } else if ("postal_code".equals(b.getTags().get("boundary"))) {
                    b.getTags().remove("boundary");
                    b.getTags().remove("name");
                }
                if (BoundaryUtil.isAdministrativeBoundary(b)) {
                    mergedList.add(b);
                    continue;
                }
                log.info("Boundary", b.getId(), b.getTags(), "contains no more boundary tags. Skipping it.");
            }
            Tags postalCodeTags = new Tags();
            postalCodeTags.put("postal_code", (String)entry.getKey());
            Boundary postalCodeBoundary = new Boundary(newPostCodeArea, postalCodeTags, "p" + (String)entry.getKey());
            log.info("Merged", ((List)entry.getValue()).size(), "postal code boundaries for postal code", entry.getKey());
            mergedList.add(postalCodeBoundary);
        }
        return mergedList;
    }

    public static boolean isAdministrativeBoundary(Boundary b) {
        block7: {
            String boundaryVal;
            block6: {
                if (!b.getId().startsWith("r")) break block6;
                String type = b.getTags().get("type");
                if (!"boundary".equals(type) && !"multipolygon".equals(type)) break block7;
                String boundaryVal2 = b.getTags().get("boundary");
                if (!"administrative".equals(boundaryVal2)) {
                    return false;
                }
                if (b.getTags().get("admin_level") == null) {
                    return false;
                }
                Iterator<Map.Entry<String, String>> tagIterator = b.getTags().entryIterator();
                while (tagIterator.hasNext()) {
                    Map.Entry<String, String> tag = tagIterator.next();
                    if (!tag.getKey().contains("name")) continue;
                    return true;
                }
                break block7;
            }
            if (b.getId().startsWith("w") && "administrative".equals(boundaryVal = b.getTags().get("boundary"))) {
                if (b.getTags().get("admin_level") == null) {
                    return false;
                }
                Iterator<Map.Entry<String, String>> tagIterator = b.getTags().entryIterator();
                while (tagIterator.hasNext()) {
                    Map.Entry<String, String> tag = tagIterator.next();
                    if (!tag.getKey().contains("name")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String getPostalCode(Tags tags) {
        String[] nameParts;
        String name;
        String zip = tags.get("postal_code");
        if (zip == null && "postal_code".equals(tags.get("boundary")) && (name = tags.get("name")) != null && (nameParts = name.split(Pattern.quote(" "))).length > 0) {
            zip = nameParts[0].trim();
        }
        return zip;
    }

    public static void createJavaCodeSnippet(java.awt.geom.Area area) {
        double[] res = new double[6];
        PathIterator pit = area.getPathIterator(null);
        System.out.println("Path2D.Double path = new Path2D.Double();");
        System.out.println("path.setWindingRule(" + pit.getWindingRule() + ");");
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            switch (type) {
                case 1: {
                    System.out.println("path.lineTo(" + res[0] + "d, " + res[1] + "d);");
                    break;
                }
                case 0: {
                    System.out.println("path.moveTo(" + res[0] + "d, " + res[1] + "d);");
                    break;
                }
                case 4: {
                    System.out.println("path.closePath();");
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        System.out.println("Area area = new Area(path);");
    }

    static double readVarDouble(DataInputStream inp) throws IOException {
        byte b;
        long res = 0L;
        long toShift = 57L;
        while (((b = inp.readByte()) & 0x80) != 0) {
            res |= (long)(b & 0x7F);
            if ((toShift -= 7L) <= 0L) continue;
            res <<= 7;
        }
        if (toShift > 0L) {
            res |= (long)b;
            res <<= (int)toShift;
        } else {
            res <<= 1;
            res |= 1L;
        }
        return Double.longBitsToDouble(res);
    }

    public static Map<String, Shape> rasterArea(java.awt.geom.Area areaToSplit) {
        return BoundaryUtil.rasterShape(areaToSplit, new HashMap<String, Shape>());
    }

    private static Map<String, Shape> rasterShape(Shape shapeToSplit, Map<String, Shape> splits) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        PathIterator pit = shapeToSplit.getPathIterator(null);
        double[] points = new double[512];
        double[] res = new double[6];
        int num = 0;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            double x = res[0];
            double y = res[1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            switch (type) {
                case 0: 
                case 1: {
                    if (num + 2 >= points.length) {
                        points = Arrays.copyOf(points, points.length * 2);
                    }
                    points[num++] = x;
                    points[num++] = y;
                    break;
                }
                case 4: {
                    int sMinLong = BoundaryUtil.getSplitBegin((int)Math.round(minX));
                    int sMinLat = BoundaryUtil.getSplitBegin((int)Math.round(minY));
                    int sMaxLong = BoundaryUtil.getSplitEnd((int)Math.round(maxX));
                    int sMaxLat = BoundaryUtil.getSplitEnd((int)Math.round(maxY));
                    int dLon = sMaxLong - sMinLong;
                    int dLat = sMaxLat - sMinLat;
                    Rectangle2D.Double bbox = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
                    if (dLon > 50000 || dLat > 50000) {
                        Rectangle clip2;
                        Rectangle clip1;
                        if (dLon > dLat) {
                            int midLon = BoundaryUtil.getSplitEnd(sMinLong + dLon / 2);
                            clip1 = new Rectangle(sMinLong, sMinLat, midLon - sMinLong, dLat);
                            clip2 = new Rectangle(midLon, sMinLat, sMaxLong - midLon, dLat);
                        } else {
                            int midLat = BoundaryUtil.getSplitEnd(sMinLat + dLat / 2);
                            clip1 = new Rectangle(sMinLong, sMinLat, dLon, midLat - sMinLat);
                            clip2 = new Rectangle(sMinLong, midLat, dLon, sMaxLat - midLat);
                        }
                        Path2D.Double clippedPath = ShapeSplitter.clipSinglePathWithSutherlandHodgman(points, num, clip1, bbox);
                        if (clippedPath != null) {
                            BoundaryUtil.rasterShape(clippedPath, splits);
                        }
                        if ((clippedPath = ShapeSplitter.clipSinglePathWithSutherlandHodgman(points, num, clip2, bbox)) != null) {
                            BoundaryUtil.rasterShape(clippedPath, splits);
                        }
                    } else {
                        String key = BoundaryUtil.getKey(sMinLat, sMinLong);
                        Path2D.Double segment = ShapeSplitter.pointsToPath2D(points, num);
                        if (segment != null) {
                            Path2D.Double path = (Path2D.Double)splits.get(key);
                            if (path == null) {
                                splits.put(key, segment);
                            } else {
                                path.append(segment, false);
                            }
                        }
                    }
                    num = 0;
                    minY = Double.POSITIVE_INFINITY;
                    minX = Double.POSITIVE_INFINITY;
                    maxY = Double.NEGATIVE_INFINITY;
                    maxX = Double.NEGATIVE_INFINITY;
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        return splits;
    }
}

