/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.o5m;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmHandler;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class O5mBinHandler
extends OsmHandler {
    private static final int NODE_DATASET = 16;
    private static final int WAY_DATASET = 17;
    private static final int REL_DATASET = 18;
    private static final int BBOX_DATASET = 219;
    private static final int TIMESTAMP_DATASET = 220;
    private static final int HEADER_DATASET = 224;
    private static final int EOD_FLAG = 254;
    private static final int RESET_FLAG = 255;
    private static final int EOF_FLAG = -1;
    private static final int STRING_TABLE_SIZE = 15000;
    private static final int MAX_STRING_PAIR_SIZE = 252;
    private static final String[] REL_REF_TYPES = new String[]{"node", "way", "relation", "?"};
    private static final double FACTOR = 1.0E-9;
    private final BufferedInputStream fis;
    private InputStream is;
    private ByteArrayInputStream bis;
    private byte[] cnvBuffer;
    private byte[] ioBuf;
    private int ioPos;
    private String[][] stringTable;
    private String[] stringPair;
    private int currStringTablePos;
    private int bytesToRead;
    long countBytes;
    private long lastNodeId;
    private long lastWayId;
    private long lastRelId;
    private long[] lastRef;
    private long lastTs;
    private long lastChangeSet;
    private int lastLon;
    private int lastLat;

    O5mBinHandler(InputStream stream) {
        this.fis = new BufferedInputStream(stream);
        this.is = this.fis;
        this.cnvBuffer = new byte[4000];
        this.ioBuf = new byte[8192];
        this.ioPos = 0;
        this.stringPair = new String[2];
        this.lastRef = new long[3];
        this.reset();
    }

    public void parse() {
        try {
            int start = this.is.read();
            ++this.countBytes;
            if (start != 255) {
                throw new IOException("wrong header byte " + start);
            }
            this.readFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readFile() throws IOException {
        boolean done = false;
        while (!done) {
            this.is = this.fis;
            long size = 0L;
            int fileType = this.is.read();
            ++this.countBytes;
            if (fileType >= 0 && fileType < 240) {
                this.bytesToRead = 0;
                size = this.readUnsignedNum64FromStream();
                this.countBytes += size - (long)this.bytesToRead;
                this.bytesToRead = (int)size;
                switch (fileType) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 219: 
                    case 220: 
                    case 224: {
                        if (this.bytesToRead > this.ioBuf.length) {
                            this.ioBuf = new byte[this.bytesToRead + 100];
                        }
                        int bytesRead = 0;
                        for (int neededBytes = this.bytesToRead; neededBytes > 0; neededBytes -= bytesRead) {
                            bytesRead += this.is.read(this.ioBuf, bytesRead, neededBytes);
                        }
                        this.ioPos = 0;
                        this.bis = new ByteArrayInputStream(this.ioBuf, 0, this.bytesToRead);
                        this.is = this.bis;
                        break;
                    }
                }
            }
            if (fileType == -1) {
                done = true;
                continue;
            }
            if (fileType == 16) {
                this.readNode();
                continue;
            }
            if (fileType == 17) {
                this.readWay();
                continue;
            }
            if (fileType == 18) {
                this.readRel();
                continue;
            }
            if (fileType == 219) {
                this.readBBox();
                continue;
            }
            if (fileType == 220) {
                this.readFileTimestamp();
                continue;
            }
            if (fileType == 224) {
                this.readHeader();
                continue;
            }
            if (fileType == 254) {
                done = true;
                continue;
            }
            if (fileType == 255) {
                this.reset();
                continue;
            }
            if (fileType >= 240) continue;
            this.skip(size);
        }
    }

    private void readFileTimestamp() {
        this.readSignedNum64();
    }

    private void skip(long bytes) throws IOException {
        for (long toSkip = bytes; toSkip > 0L; toSkip -= this.is.skip(toSkip)) {
        }
    }

    private void readBBox() {
        double leftf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        double bottomf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        double rightf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        double topf = (double)(100L * (long)this.readSignedNum32()) * 1.0E-9;
        assert (this.bytesToRead == 0);
        this.setBBox(bottomf, leftf, topf, rightf);
    }

    private void readNode() throws IOException {
        int lat;
        int lon;
        this.lastNodeId += this.readSignedNum64();
        if (this.bytesToRead == 0) {
            return;
        }
        this.readVersionTsAuthor();
        if (this.bytesToRead == 0) {
            return;
        }
        this.lastLon = lon = this.readSignedNum32() + this.lastLon;
        this.lastLat = lat = this.readSignedNum32() + this.lastLat;
        double flon = (double)(100L * (long)lon) * 1.0E-9;
        double flat = (double)(100L * (long)lat) * 1.0E-9;
        assert (flat >= -90.0 && flat <= 90.0);
        assert (flon >= -180.0 && flon <= 180.0);
        Coord co = new Coord(flat, flon);
        this.saver.addPoint(this.lastNodeId, co);
        if (this.bytesToRead > 0) {
            Node node = new Node(this.lastNodeId, co);
            this.readTags(node);
            if (node.getTagCount() > 0) {
                this.saver.addNode(node);
                this.hooks.onAddNode(node);
            }
        }
    }

    private void readWay() throws IOException {
        this.lastWayId += this.readSignedNum64();
        if (this.bytesToRead == 0) {
            return;
        }
        this.readVersionTsAuthor();
        if (this.bytesToRead == 0) {
            return;
        }
        Way way = this.startWay(this.lastWayId);
        long refSize = this.readUnsignedNum32();
        long stop = (long)this.bytesToRead - refSize;
        while ((long)this.bytesToRead > stop) {
            this.lastRef[0] = this.lastRef[0] + this.readSignedNum64();
            this.addCoordToWay(way, this.lastRef[0]);
        }
        this.readTags(way);
        this.endWay(way);
    }

    private void readRel() throws IOException {
        String relType;
        this.lastRelId += this.readSignedNum64();
        if (this.bytesToRead == 0) {
            return;
        }
        this.readVersionTsAuthor();
        if (this.bytesToRead == 0) {
            return;
        }
        GeneralRelation rel = new GeneralRelation(this.lastRelId);
        long refSize = this.readUnsignedNum32();
        long stop = (long)this.bytesToRead - refSize;
        while ((long)this.bytesToRead > stop) {
            Element el = null;
            long deltaRef = this.readSignedNum64();
            int refType = this.readRelRef();
            String role = this.stringPair[1];
            int n = refType;
            this.lastRef[n] = this.lastRef[n] + deltaRef;
            long memId = this.lastRef[refType];
            if (refType == 0) {
                Coord co;
                el = this.saver.getNode(memId);
                if (el == null && (co = this.saver.getCoord(memId)) != null) {
                    el = new Node(memId, co);
                    this.saver.addNode((Node)el);
                }
            } else if (refType == 1) {
                el = this.saver.getWay(memId);
            } else if (refType == 2) {
                el = this.saver.getRelation(memId);
                if (el == null) {
                    this.saver.deferRelation(memId, rel, role);
                }
            } else assert (false);
            if (el == null) continue;
            rel.addElement(role, el);
        }
        boolean tagsIncomplete = this.readTags(rel);
        if (tagsIncomplete && ("multipolygon".equals(relType = rel.getTag("type")) || "boundary".equals(relType))) {
            rel.addTag("mkgmap:tagsincomplete", "true");
        }
        this.saver.addRelation(rel);
    }

    private boolean readTags(Element elem) throws IOException {
        boolean tagsIncomplete = false;
        while (this.bytesToRead > 0) {
            this.readStringPair();
            String key = this.stringPair[0];
            String val = this.stringPair[1].trim();
            key = elem instanceof Relation && "type".equals(key) ? "type" : this.keepTag(key, val);
            if (key != null) {
                elem.addTag(key, val.intern());
                continue;
            }
            tagsIncomplete = true;
        }
        assert (this.bytesToRead == 0);
        return tagsIncomplete;
    }

    private void storeStringPair() {
        this.stringTable[0][this.currStringTablePos] = this.stringPair[0];
        this.stringTable[1][this.currStringTablePos] = this.stringPair[1];
        ++this.currStringTablePos;
        if (this.currStringTablePos >= 15000) {
            this.currStringTablePos = 0;
        }
    }

    private void setStringRefPair(int ref) {
        int pos = this.currStringTablePos - ref;
        if (pos < 0) {
            pos += 15000;
        }
        this.stringPair[0] = this.stringTable[0][pos];
        this.stringPair[1] = this.stringTable[1][pos];
    }

    private void readVersionTsAuthor() throws IOException {
        int version = this.readUnsignedNum32();
        if (version != 0) {
            long ts;
            this.lastTs = ts = this.readSignedNum64() + this.lastTs;
            if (ts != 0L) {
                long changeSet;
                this.lastChangeSet = changeSet = (long)this.readSignedNum32() + this.lastChangeSet;
                this.readAuthor();
            }
        }
    }

    private void readAuthor() throws IOException {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.bytesToRead;
            long uidNum = this.readUnsignedNum64();
            if (uidNum == 0L) {
                this.stringPair[0] = "";
            } else {
                this.stringPair[0] = Long.toString(uidNum);
                ++this.ioPos;
                --this.bytesToRead;
            }
            int start = 0;
            int buffPos = 0;
            this.stringPair[1] = null;
            while (this.stringPair[1] == null) {
                byte b = this.ioBuf[this.ioPos++];
                --this.bytesToRead;
                this.cnvBuffer[buffPos++] = b;
                if (b != 0) continue;
                this.stringPair[1] = new String(this.cnvBuffer, start, buffPos - 1, "UTF-8");
            }
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
    }

    private int readRelRef() throws IOException {
        int refType = -1;
        long toReadStart = this.bytesToRead;
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            refType = this.ioBuf[this.ioPos++] - 48;
            --this.bytesToRead;
            if (refType < 0 || refType > 2) {
                refType = 3;
            }
            this.stringPair[0] = REL_REF_TYPES[refType];
            int start = 0;
            int buffPos = 0;
            this.stringPair[1] = null;
            while (this.stringPair[1] == null) {
                byte b = this.ioBuf[this.ioPos++];
                --this.bytesToRead;
                this.cnvBuffer[buffPos++] = b;
                if (b != 0) continue;
                this.stringPair[1] = new String(this.cnvBuffer, start, buffPos - 1, "UTF-8");
            }
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
            char c = this.stringPair[0].charAt(0);
            switch (c) {
                case 'n': {
                    refType = 0;
                    break;
                }
                case 'w': {
                    refType = 1;
                    break;
                }
                case 'r': {
                    refType = 2;
                    break;
                }
                default: {
                    refType = 3;
                }
            }
        }
        return refType;
    }

    private void readStringPair() throws IOException {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.bytesToRead;
            int cnt = 0;
            int buffPos = 0;
            int start = 0;
            while (cnt < 2) {
                byte b = this.ioBuf[this.ioPos++];
                --this.bytesToRead;
                this.cnvBuffer[buffPos++] = b;
                if (b != 0) continue;
                this.stringPair[cnt] = new String(this.cnvBuffer, start, buffPos - start - 1, "UTF-8");
                ++cnt;
                start = buffPos;
            }
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
    }

    private void reset() {
        this.lastNodeId = 0L;
        this.lastWayId = 0L;
        this.lastRelId = 0L;
        this.lastRef[0] = 0L;
        this.lastRef[1] = 0L;
        this.lastRef[2] = 0L;
        this.lastTs = 0L;
        this.lastChangeSet = 0L;
        this.lastLon = 0;
        this.lastLat = 0;
        this.stringTable = new String[2][15000];
        this.currStringTablePos = 0;
    }

    private void readHeader() throws IOException {
        if (this.ioBuf[0] != 111 || this.ioBuf[1] != 53 || this.ioBuf[2] != 99 && this.ioBuf[2] != 109 || this.ioBuf[3] != 50) {
            throw new IOException("unsupported header");
        }
    }

    private int readSignedNum32() {
        int b = this.ioBuf[this.ioPos++];
        --this.bytesToRead;
        int result = b;
        if ((b & 0x80) == 0) {
            if ((b & 1) == 1) {
                return -1 - (result >> 1);
            }
            return result >> 1;
        }
        int sign = b & 1;
        result = (result & 0x7E) >> 1;
        int fac = 64;
        while (((b = this.ioBuf[this.ioPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result += fac * (b & 0x7F);
            fac <<= 7;
        }
        --this.bytesToRead;
        result += fac * b;
        if (sign == 1) {
            return -1 - result;
        }
        return result;
    }

    private long readSignedNum64() {
        byte b = this.ioBuf[this.ioPos++];
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            if ((b & 1) == 1) {
                return -1L - (result >> 1);
            }
            return result >> 1;
        }
        int sign = b & 1;
        result = (result & 0x7EL) >> 1;
        long fac = 64L;
        while (((b = this.ioBuf[this.ioPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result += fac * (long)(b & 0x7F);
            fac <<= 7;
        }
        --this.bytesToRead;
        result += fac * (long)b;
        if (sign == 1) {
            return -1L - result;
        }
        return result;
    }

    private long readUnsignedNum64FromStream() throws IOException {
        int b = this.is.read();
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7FL;
        long fac = 128L;
        while (((b = this.is.read()) & 0x80) != 0) {
            --this.bytesToRead;
            result += fac * (long)(b & 0x7F);
            fac <<= 7;
        }
        --this.bytesToRead;
        return result += fac * (long)b;
    }

    private long readUnsignedNum64() {
        byte b = this.ioBuf[this.ioPos++];
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7FL;
        long fac = 128L;
        while (((b = this.ioBuf[this.ioPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result += fac * (long)(b & 0x7F);
            fac <<= 7;
        }
        --this.bytesToRead;
        return result += fac * (long)b;
    }

    private int readUnsignedNum32() {
        int b = this.ioBuf[this.ioPos++];
        --this.bytesToRead;
        int result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7F;
        long fac = 128L;
        while (((b = this.ioBuf[this.ioPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result = (int)((long)result + fac * (long)(b & 0x7F));
            fac <<= 7;
        }
        --this.bytesToRead;
        result = (int)((long)result + fac * (long)b);
        return result;
    }
}

