/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.xml;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmHandler;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class Osm5XmlHandler
extends OsmHandler {
    private static final Logger log = Logger.getLogger(Osm5XmlHandler.class);
    private int mode;
    private static final int MODE_NODE = 1;
    private static final int MODE_WAY = 2;
    private static final int MODE_BOUND = 3;
    private static final int MODE_RELATION = 4;
    private static final int MODE_BOUNDS = 5;
    private final boolean ignoreBounds;
    protected Node currentNode;
    protected Way currentWay;
    protected Relation currentRelation;
    protected long currentElementId;

    public Osm5XmlHandler(EnhancedProperties props) {
        this.ignoreBounds = props.getProperty("ignore-osm-bounds", false);
    }

    private void startInNode(String qName, Attributes attributes) {
        if (qName.equals("tag")) {
            String key = attributes.getValue("k");
            String val = attributes.getValue("v").trim();
            if ((key = this.keepTag(key, val)) != null) {
                if (this.currentNode == null) {
                    Coord co = this.saver.getCoord(this.currentElementId);
                    this.currentNode = new Node(this.currentElementId, co);
                }
                this.currentNode.addTag(key, val.intern());
            }
        }
    }

    private void startInWay(String qName, Attributes attributes) {
        if (qName.equals("nd")) {
            long id = this.idVal(attributes.getValue("ref"));
            this.addCoordToWay(this.currentWay, id);
        } else if (qName.equals("tag")) {
            String key = attributes.getValue("k");
            String val = attributes.getValue("v").trim();
            if ((key = this.keepTag(key, val)) != null) {
                this.currentWay.addTag(key, val.intern());
            }
        }
    }

    private void startInRelation(String qName, Attributes attributes) {
        if (qName.equals("member")) {
            Element el;
            long id = this.idVal(attributes.getValue("ref"));
            String type = attributes.getValue("type");
            if ("way".equals(type)) {
                el = this.saver.getWay(id);
            } else if ("node".equals(type)) {
                Coord co;
                el = this.saver.getNode(id);
                if (el == null && (co = this.saver.getCoord(id)) != null) {
                    el = new Node(id, co);
                    this.saver.addNode((Node)el);
                }
            } else if ("relation".equals(type)) {
                el = this.saver.getRelation(id);
                if (el == null) {
                    this.saver.deferRelation(id, this.currentRelation, attributes.getValue("role"));
                }
            } else {
                el = null;
            }
            if (el != null) {
                this.currentRelation.addElement(attributes.getValue("role"), el);
            }
        } else if (qName.equals("tag")) {
            String key = attributes.getValue("k");
            String val = attributes.getValue("v").trim();
            if ((key = "type".equals(key) ? "type" : this.keepTag(key, val)) == null) {
                this.currentRelation.addTag("mkgmap:tagsincomplete", "true");
            } else {
                this.currentRelation.addTag(key, val.intern());
            }
        }
    }

    private void setupBBoxFromBounds(Attributes xmlattr) {
        try {
            this.setBBox(Double.parseDouble(xmlattr.getValue("minlat")), Double.parseDouble(xmlattr.getValue("minlon")), Double.parseDouble(xmlattr.getValue("maxlat")), Double.parseDouble(xmlattr.getValue("maxlon")));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"NumberformatException: Cannot read bbox");
        }
    }

    private void setupBBoxFromBound(String box) {
        String[] f = box.split(",");
        try {
            this.setBBox(Double.parseDouble(f[0]), Double.parseDouble(f[1]), Double.parseDouble(f[2]), Double.parseDouble(f[3]));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"NumberformatException: Cannot read bbox");
        }
    }

    private void startNode(String sid, String slat, String slon) {
        if (sid == null || slat == null || slon == null) {
            return;
        }
        try {
            long id = this.idVal(sid);
            Coord co = new Coord(Double.parseDouble(slat), Double.parseDouble(slon));
            this.saver.addPoint(id, co);
            this.currentElementId = id;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private void startWay(String sid) {
        try {
            long id = this.idVal(sid);
            this.currentWay = this.startWay(id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public class SaxHandler
    extends DefaultHandler {
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (Osm5XmlHandler.this.mode == 0) {
                if (qName.equals("node")) {
                    Osm5XmlHandler.this.mode = 1;
                    Osm5XmlHandler.this.startNode(attributes.getValue("id"), attributes.getValue("lat"), attributes.getValue("lon"));
                } else if (qName.equals("way")) {
                    Osm5XmlHandler.this.mode = 2;
                    Osm5XmlHandler.this.startWay(attributes.getValue("id"));
                } else if (qName.equals("relation")) {
                    Osm5XmlHandler.this.mode = 4;
                    Osm5XmlHandler.this.currentRelation = new GeneralRelation(Osm5XmlHandler.this.idVal(attributes.getValue("id")));
                } else if (qName.equals("bound")) {
                    Osm5XmlHandler.this.mode = 3;
                    if (!Osm5XmlHandler.this.ignoreBounds) {
                        String box = attributes.getValue("box");
                        Osm5XmlHandler.this.setupBBoxFromBound(box);
                    }
                } else if (qName.equals("bounds")) {
                    Osm5XmlHandler.this.mode = 5;
                    if (!Osm5XmlHandler.this.ignoreBounds) {
                        Osm5XmlHandler.this.setupBBoxFromBounds(attributes);
                    }
                }
            } else if (Osm5XmlHandler.this.mode == 1) {
                Osm5XmlHandler.this.startInNode(qName, attributes);
            } else if (Osm5XmlHandler.this.mode == 2) {
                Osm5XmlHandler.this.startInWay(qName, attributes);
            } else if (Osm5XmlHandler.this.mode == 4) {
                Osm5XmlHandler.this.startInRelation(qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (Osm5XmlHandler.this.mode == 1) {
                if (qName.equals("node")) {
                    Osm5XmlHandler.this.mode = 0;
                    if (Osm5XmlHandler.this.currentNode != null) {
                        Osm5XmlHandler.this.saver.addNode(Osm5XmlHandler.this.currentNode);
                        Osm5XmlHandler.this.hooks.onAddNode(Osm5XmlHandler.this.currentNode);
                    }
                    Osm5XmlHandler.this.currentElementId = 0L;
                    Osm5XmlHandler.this.currentNode = null;
                }
            } else if (Osm5XmlHandler.this.mode == 2) {
                if (qName.equals("way")) {
                    Osm5XmlHandler.this.mode = 0;
                    Osm5XmlHandler.this.endWay(Osm5XmlHandler.this.currentWay);
                    Osm5XmlHandler.this.currentWay = null;
                }
            } else if (Osm5XmlHandler.this.mode == 3) {
                if (qName.equals("bound")) {
                    Osm5XmlHandler.this.mode = 0;
                }
            } else if (Osm5XmlHandler.this.mode == 5) {
                if (qName.equals("bounds")) {
                    Osm5XmlHandler.this.mode = 0;
                }
            } else if (Osm5XmlHandler.this.mode == 4 && qName.equals("relation")) {
                String type;
                Osm5XmlHandler.this.mode = 0;
                if (Osm5XmlHandler.this.currentRelation.getTag("mkgmap:tagsincomplete") != null && !"multipolygon".equals(type = Osm5XmlHandler.this.currentRelation.getTag("type")) && !"boundary".equals(type)) {
                    Osm5XmlHandler.this.currentRelation.deleteTag("mkgmap:tagsincomplete");
                }
                Osm5XmlHandler.this.saver.addRelation(Osm5XmlHandler.this.currentRelation);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            System.err.println("Error at line " + e.getLineNumber() + ", col " + e.getColumnNumber());
            super.fatalError(e);
        }
    }
}

