/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.plugin;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.xml.Osm5MapDataSource;

public class MapReader {
    private static final List<Class<? extends LoadableMapDataSource>> loaders;

    public static LoadableMapDataSource createMapReader(String name) {
        for (Class<? extends LoadableMapDataSource> loader : loaders) {
            try {
                LoadableMapDataSource src = loader.newInstance();
                if (name == null || !src.isFileSupported(name)) continue;
                return src;
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return new Osm5MapDataSource();
    }

    static {
        String[] sources = new String[]{"uk.me.parabola.mkgmap.reader.osm.bin.OsmBinMapDataSource", "uk.me.parabola.mkgmap.reader.osm.o5m.O5mBinMapDataSource", "uk.me.parabola.mkgmap.reader.polish.PolishMapDataSource", "uk.me.parabola.mkgmap.reader.test.ElementTestDataSource", "uk.me.parabola.mkgmap.reader.osm.xml.Osm5MapDataSource"};
        loaders = new ArrayList<Class<? extends LoadableMapDataSource>>();
        for (String source : sources) {
            try {
                Class<?> c = Class.forName(source);
                loaders.add(c);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
    }
}

