/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.IOException;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.io.StructuredOutputStream;
import uk.me.parabola.tdbfmt.Block;
import uk.me.parabola.tdbfmt.OverviewMapBlock;

public class DetailMapBlock
extends OverviewMapBlock {
    private int tdbVersion;
    private String innername;
    private int rgnDataSize;
    private int treDataSize;
    private int lblDataSize;
    private int netDataSize;
    private int nodDataSize;

    public DetailMapBlock(int tdbVersion) {
        assert (tdbVersion > 0);
        this.tdbVersion = tdbVersion;
    }

    public DetailMapBlock(Block block) throws IOException {
        super(block);
        StructuredInputStream ds = block.getInputStream();
        int junk = ds.read2();
        assert (junk == 4);
        junk = ds.read2();
        assert (junk == 3);
        this.rgnDataSize = ds.read4();
        this.treDataSize = ds.read4();
        this.lblDataSize = ds.read4();
        junk = ds.read();
        assert (junk == 1);
    }

    @Override
    public void write(Block block) throws IOException {
        super.write(block);
        StructuredOutputStream os = block.getOutputStream();
        int n = 3;
        if (this.tdbVersion >= 407) {
            if (this.netDataSize > 0) {
                ++n;
            }
            if (this.nodDataSize > 0) {
                ++n;
            }
        }
        os.write2(n + 1);
        os.write2(n);
        os.write4(this.treDataSize);
        os.write4(this.rgnDataSize);
        os.write4(this.lblDataSize);
        if (this.tdbVersion >= 407) {
            if (n > 3) {
                os.write4(this.netDataSize);
            }
            if (n > 4) {
                os.write4(this.nodDataSize);
            }
            os.write4(-16727295);
            os.write(0);
            os.write(0);
            os.write(0);
            String mn = this.getInnername();
            os.writeString(mn + ".TRE");
            os.writeString(mn + ".RGN");
            os.writeString(mn + ".LBL");
            if (n > 3) {
                os.writeString(mn + ".NET");
            }
            if (n > 4) {
                os.writeString(mn + ".NOD");
            }
        } else {
            os.write(1);
        }
    }

    public String getInnername() {
        return this.innername;
    }

    public void setInnername(String innername) {
        this.innername = innername;
    }

    public void setRgnDataSize(int rgnDataSize) {
        this.rgnDataSize = rgnDataSize;
    }

    public void setTreDataSize(int treDataSize) {
        this.treDataSize = treDataSize;
    }

    public void setLblDataSize(int lblDataSize) {
        this.lblDataSize = lblDataSize;
    }

    public void setNetDataSize(int netDataSize) {
        this.netDataSize = netDataSize;
    }

    public void setNodDataSize(int nodDataSize) {
        this.nodDataSize = nodDataSize;
    }

    @Override
    public String toString() {
        return super.toString() + ", rgn size=" + this.rgnDataSize + ", tre size=" + this.treDataSize + ", lbl size" + this.lblDataSize;
    }
}

