/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.Java2DConverter;

public final class ElementQuadTreeNode {
    private static final Logger log = Logger.getLogger(ElementQuadTreeNode.class);
    private static final List<Coord> EMPTY_LIST = Collections.emptyList();
    private static final int MAX_POINTS = 1000;
    private Map<Element, List<Coord>> elementMap;
    private final Area bounds;
    private final Rectangle boundsRect;
    private Boolean empty;
    private ElementQuadTreeNode[] children;

    public boolean isEmpty() {
        if (this.empty == null) {
            if (this.isLeaf()) {
                this.empty = this.elementMap.isEmpty();
            } else {
                this.empty = true;
                for (ElementQuadTreeNode child : this.children) {
                    if (child.isEmpty()) continue;
                    this.empty = false;
                    break;
                }
            }
        }
        return this.empty;
    }

    public long getSize() {
        if (this.isLeaf()) {
            int items = 0;
            for (List<Coord> points : this.elementMap.values()) {
                if (points == EMPTY_LIST) {
                    ++items;
                    continue;
                }
                items += points.size();
            }
            return items;
        }
        int items = 0;
        for (ElementQuadTreeNode child : this.children) {
            items = (int)((long)items + child.getSize());
        }
        return items;
    }

    public int getDepth() {
        if (this.isLeaf()) {
            return 1;
        }
        int maxDepth = 0;
        for (ElementQuadTreeNode node : this.children) {
            maxDepth = Math.max(node.getDepth(), maxDepth);
        }
        return maxDepth + 1;
    }

    private ElementQuadTreeNode(Area bounds, Map<Element, List<Coord>> elements) {
        this.bounds = bounds;
        this.boundsRect = new Rectangle(bounds.getMinLong(), bounds.getMinLat(), bounds.getWidth(), bounds.getHeight());
        this.children = null;
        this.elementMap = elements;
        this.empty = this.elementMap.isEmpty();
        this.checkSplit();
    }

    public ElementQuadTreeNode(Area bounds, Collection<Element> elements) {
        this.bounds = bounds;
        this.boundsRect = new Rectangle(bounds.getMinLong(), bounds.getMinLat(), bounds.getWidth(), bounds.getHeight());
        this.children = null;
        this.elementMap = new HashMap<Element, List<Coord>>(elements.size() * 4 / 3 + 10);
        for (Element el : elements) {
            if (el instanceof Way) {
                List<Coord> points = ((Way)el).getPoints();
                this.elementMap.put(el, points);
                continue;
            }
            if (!(el instanceof Node)) continue;
            this.elementMap.put(el, EMPTY_LIST);
        }
        this.empty = this.elementMap.isEmpty();
        this.checkSplit();
    }

    public Area getBounds() {
        return this.bounds;
    }

    public Rectangle getBoundsAsRectangle() {
        return this.boundsRect;
    }

    private void checkSplit() {
        if (this.getSize() > 1000L) {
            this.split();
        }
    }

    private void remove(Element elem, Area bbox) {
        if (bbox == null || this.isEmpty()) {
            return;
        }
        if (this.isLeaf()) {
            this.elementMap.remove(elem);
            this.empty = this.elementMap.isEmpty();
        } else {
            for (ElementQuadTreeNode child : this.children) {
                if (!child.getBounds().intersects(bbox)) continue;
                child.remove(elem, bbox);
                if (!child.isEmpty()) continue;
                this.empty = null;
            }
        }
    }

    private Area getBbox(Element elem) {
        if (elem instanceof Node) {
            Coord c = ((Node)elem).getLocation();
            return new Area(c.getLatitude(), c.getLongitude(), c.getLatitude(), c.getLongitude());
        }
        if (elem instanceof Way) {
            List<Coord> points = ((Way)elem).getPoints();
            if (points.isEmpty()) {
                return null;
            }
            Coord c = points.get(0);
            int minLat = c.getLatitude();
            int maxLat = c.getLatitude();
            int minLong = c.getLongitude();
            int maxLong = c.getLongitude();
            for (Coord co : points) {
                if (co.getLatitude() < minLat) {
                    minLat = co.getLatitude();
                } else if (co.getLatitude() > maxLat) {
                    maxLat = co.getLatitude();
                }
                if (co.getLongitude() < minLong) {
                    minLong = co.getLongitude();
                    continue;
                }
                if (co.getLongitude() <= maxLong) continue;
                maxLong = co.getLongitude();
            }
            return new Area(minLat, minLong, maxLat, maxLong);
        }
        return null;
    }

    public void remove(Element elem) {
        this.remove(elem, this.getBbox(elem));
    }

    public Set<Element> get(Area bbox, Set<Element> resultList) {
        if (this.isEmpty()) {
            return resultList;
        }
        if (this.isLeaf()) {
            if (bbox.getMinLat() <= this.bounds.getMinLat() && bbox.getMaxLat() >= this.bounds.getMaxLat() && bbox.getMinLong() <= this.bounds.getMinLong() && bbox.getMaxLong() >= this.bounds.getMaxLong()) {
                resultList.addAll(this.elementMap.keySet());
            } else {
                block0: for (Map.Entry<Element, List<Coord>> elem : this.elementMap.entrySet()) {
                    if (elem.getKey() instanceof Node) {
                        Node n = (Node)elem.getKey();
                        if (!bbox.contains(n.getLocation())) continue;
                        resultList.add(n);
                        continue;
                    }
                    if (!(elem.getKey() instanceof Way) || resultList.contains(elem.getKey())) continue;
                    for (Coord c : elem.getValue()) {
                        if (!bbox.contains(c)) continue;
                        resultList.add(elem.getKey());
                        continue block0;
                    }
                }
            }
        } else {
            for (ElementQuadTreeNode child : this.children) {
                if (child.isEmpty() || !bbox.intersects(child.getBounds())) continue;
                resultList = child.get(bbox, resultList);
            }
        }
        return resultList;
    }

    public Set<Element> get(ElementQuadTreePolygon polygon, Set<Element> resultList) {
        block7: {
            if (this.isEmpty()) {
                return resultList;
            }
            if (!polygon.getBbox().intersects(this.getBounds())) break block7;
            if (this.isLeaf()) {
                block0: for (Map.Entry<Element, List<Coord>> elem : this.elementMap.entrySet()) {
                    if (resultList.contains(elem.getKey())) continue;
                    if (elem.getKey() instanceof Node) {
                        Node n = (Node)elem.getKey();
                        Coord c = n.getLocation();
                        if (!polygon.getArea().contains(c.getLongitude(), c.getLatitude())) continue;
                        resultList.add(n);
                        continue;
                    }
                    if (!(elem.getKey() instanceof Way)) continue;
                    for (Coord c : elem.getValue()) {
                        if (!polygon.getArea().contains(c.getLongitude(), c.getLatitude())) continue;
                        resultList.add(elem.getKey());
                        continue block0;
                    }
                }
            } else {
                for (ElementQuadTreeNode child : this.children) {
                    if (child.isEmpty() || !polygon.getArea().intersects(child.getBoundsAsRectangle())) continue;
                    java.awt.geom.Area subArea = (java.awt.geom.Area)polygon.getArea().clone();
                    subArea.intersect(Java2DConverter.createBoundsArea(new Area(child.getBounds().getMinLat() - 1, child.getBounds().getMinLong() - 1, child.getBounds().getMaxLat() + 1, child.getBounds().getMaxLong() + 1)));
                    child.get(new ElementQuadTreePolygon(subArea), resultList);
                }
            }
        }
        return resultList;
    }

    public boolean isLeaf() {
        return this.elementMap != null;
    }

    private void split() {
        if (this.bounds.getHeight() <= 5 || this.bounds.getWidth() <= 5) {
            log.error((Object)("Do not split more due to too small bounds: " + this.bounds));
            return;
        }
        int halfLat = (this.bounds.getMinLat() + this.bounds.getMaxLat()) / 2;
        int halfLong = (this.bounds.getMinLong() + this.bounds.getMaxLong()) / 2;
        this.children = new ElementQuadTreeNode[4];
        Area[] childBounds = new Area[]{new Area(this.bounds.getMinLat(), this.bounds.getMinLong(), halfLat, halfLong), new Area(halfLat, this.bounds.getMinLong(), this.bounds.getMaxLat(), halfLong), new Area(this.bounds.getMinLat(), halfLong, halfLat, this.bounds.getMaxLong()), new Area(halfLat, halfLong, this.bounds.getMaxLat(), this.bounds.getMaxLong())};
        ArrayList childElems = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            childElems.add(new HashMap());
        }
        block1: for (Map.Entry<Element, List<Coord>> elem : this.elementMap.entrySet()) {
            int i;
            if (elem.getKey() instanceof Node) {
                Node node = (Node)elem.getKey();
                for (i = 0; i < childBounds.length; ++i) {
                    if (!childBounds[i].contains(node.getLocation())) continue;
                    ((Map)childElems.get(i)).put(node, EMPTY_LIST);
                    continue block1;
                }
                continue;
            }
            if (!(elem.getKey() instanceof Way)) continue;
            ArrayList points = new ArrayList(4);
            for (i = 0; i < 4; ++i) {
                points.add(new ArrayList(elem.getValue().size()));
            }
            block4: for (Coord c : elem.getValue()) {
                for (int i2 = 0; i2 < childBounds.length; ++i2) {
                    if (!childBounds[i2].contains(c)) continue;
                    ((List)points.get(i2)).add(c);
                    continue block4;
                }
            }
            for (i = 0; i < 4; ++i) {
                if (((List)points.get(i)).isEmpty()) continue;
                ((Map)childElems.get(i)).put(elem.getKey(), points.get(i));
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.children[i] = new ElementQuadTreeNode(childBounds[i], (Map)childElems.get(i));
        }
        this.elementMap = null;
    }

    public void clear() {
        this.children = null;
        this.elementMap = new HashMap<Element, List<Coord>>();
    }

    public static final class ElementQuadTreePolygon {
        private final java.awt.geom.Area javaArea;
        private final Area bbox;

        public ElementQuadTreePolygon(java.awt.geom.Area javaArea) {
            this.javaArea = javaArea;
            Rectangle bboxRect = javaArea.getBounds();
            this.bbox = new Area(bboxRect.y, bboxRect.x, bboxRect.y + bboxRect.height, bboxRect.x + bboxRect.width);
        }

        public ElementQuadTreePolygon(List<Coord> points) {
            this(Java2DConverter.createArea(points));
        }

        public ElementQuadTreePolygon(Collection<List<Coord>> polygonList) {
            this.javaArea = new java.awt.geom.Area();
            for (List<Coord> polygon : polygonList) {
                this.javaArea.add(Java2DConverter.createArea(polygon));
            }
            Rectangle bboxRect = this.javaArea.getBounds();
            this.bbox = new Area(bboxRect.y, bboxRect.x, bboxRect.y + bboxRect.height, bboxRect.x + bboxRect.width);
        }

        public Area getBbox() {
            return this.bbox;
        }

        public java.awt.geom.Area getArea() {
            return this.javaArea;
        }
    }
}

