/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;

public class Java2DConverter {
    private static final Logger log = Logger.getLogger(Java2DConverter.class);

    public static java.awt.geom.Area createBoundsArea(Area bbox) {
        return Java2DConverter.createArea(bbox.toCoords());
    }

    public static Area createBbox(Shape shape) {
        Rectangle areaBounds = shape.getBounds();
        return new Area(areaBounds.y, areaBounds.x, (int)areaBounds.getMaxY(), (int)areaBounds.getMaxX());
    }

    public static java.awt.geom.Area createArea(List<Coord> polygonPoints) {
        return new java.awt.geom.Area(Java2DConverter.createPath2D(polygonPoints));
    }

    public static Path2D createPath2D(List<Coord> polygonPoints) {
        int n = polygonPoints.size();
        if (n < 3) {
            return new Path2D.Double();
        }
        Path2D.Double path = new Path2D.Double(1, n);
        if (polygonPoints.get(0).highPrecEquals(polygonPoints.get(n - 1))) {
            --n;
        }
        double lastLat = 2.147483647E9;
        double lastLon = 2.147483647E9;
        for (int i = 0; i < n; ++i) {
            Coord co = polygonPoints.get(i);
            int lat30 = co.getHighPrecLat();
            int lon30 = co.getHighPrecLon();
            double x = (double)lon30 / 64.0;
            double y = (double)lat30 / 64.0;
            if (i == 0) {
                ((Path2D)path).moveTo(x, y);
            } else if (lastLon != (double)lon30 || lastLat != (double)lat30) {
                ((Path2D)path).lineTo(x, y);
            }
            lastLon = lon30;
            lastLat = lat30;
        }
        path.closePath();
        return path;
    }

    public static Polygon createHighPrecPolygon(List<Coord> points) {
        Polygon polygon = new Polygon();
        for (Coord co : points) {
            polygon.addPoint(co.getHighPrecLon(), co.getHighPrecLat());
        }
        return polygon;
    }

    public static List<java.awt.geom.Area> areaToSingularAreas(java.awt.geom.Area area) {
        return Java2DConverter.areaToSingularAreas(0, area);
    }

    private static List<java.awt.geom.Area> areaToSingularAreas(int depth, java.awt.geom.Area area) {
        if (area.isEmpty()) {
            return Collections.emptyList();
        }
        if (area.isSingular()) {
            return Collections.singletonList(area);
        }
        ArrayList<java.awt.geom.Area> singularAreas = new ArrayList<java.awt.geom.Area>();
        double[] res = new double[6];
        PathIterator pit = area.getPathIterator(null);
        Path2D path = null;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            double lat = res[1];
            double lon = res[0];
            switch (type) {
                case 1: {
                    path.lineTo(lon, lat);
                    break;
                }
                case 4: {
                    path.closePath();
                    java.awt.geom.Area a = new java.awt.geom.Area(path);
                    if (!a.isEmpty()) {
                        if (depth < 10 && !a.isSingular()) {
                            singularAreas.addAll(Java2DConverter.areaToSingularAreas(depth + 1, a));
                        } else {
                            singularAreas.add(a);
                        }
                    }
                    path = null;
                    break;
                }
                case 0: {
                    path = new Path2D.Double();
                    path.moveTo(lon, lat);
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        return singularAreas;
    }

    public static List<Coord> singularAreaToPoints(java.awt.geom.Area area) {
        if (area.isEmpty()) {
            return null;
        }
        ArrayList<Coord> points = null;
        double[] res = new double[6];
        PathIterator pit = area.getPathIterator(null);
        int prevLat30 = Integer.MIN_VALUE;
        int prevLong30 = Integer.MIN_VALUE;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            int lat30 = (int)Math.round(res[1] * 64.0);
            int lon30 = (int)Math.round(res[0] * 64.0);
            switch (type) {
                case 0: {
                    if (points != null) {
                        log.error((Object)"area not singular");
                    }
                    points = new ArrayList<Coord>();
                    points.add(Coord.makeHighPrecCoord(lat30, lon30));
                    break;
                }
                case 1: {
                    assert (points != null);
                    if (prevLat30 == lat30 && prevLong30 == lon30) break;
                    points.add(Coord.makeHighPrecCoord(lat30, lon30));
                    break;
                }
                case 4: {
                    assert (points != null);
                    if (points.size() < 3) {
                        points = null;
                        break;
                    }
                    if (((Coord)points.get(0)).highPrecEquals((Coord)points.get(points.size() - 1))) {
                        points.set(points.size() - 1, (Coord)points.get(0));
                    } else {
                        points.add((Coord)points.get(0));
                    }
                    if (points.size() < 4) {
                        points = null;
                        break;
                    }
                    return points;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            prevLat30 = lat30;
            prevLong30 = lon30;
            pit.next();
        }
        return points;
    }

    public static List<List<Coord>> areaToShapes(java.awt.geom.Area area) {
        ArrayList<List<Coord>> outputs = new ArrayList<List<Coord>>(4);
        double[] res = new double[6];
        PathIterator pit = area.getPathIterator(null);
        ArrayList<Coord> coords = null;
        int prevLat30 = Integer.MIN_VALUE;
        int prevLong30 = Integer.MIN_VALUE;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            int lat30 = (int)Math.round(res[1] * 64.0);
            int lon30 = (int)Math.round(res[0] * 64.0);
            switch (type) {
                case 1: {
                    if (prevLat30 != lat30 || prevLong30 != lon30) {
                        coords.add(Coord.makeHighPrecCoord(lat30, lon30));
                    }
                    prevLat30 = lat30;
                    prevLong30 = lon30;
                    break;
                }
                case 0: 
                case 4: {
                    if (type == 0 && coords != null || type == 4) {
                        if (coords.size() > 2) {
                            if (((Coord)coords.get(0)).highPrecEquals((Coord)coords.get(coords.size() - 1))) {
                                coords.set(coords.size() - 1, (Coord)coords.get(0));
                            } else {
                                coords.add((Coord)coords.get(0));
                            }
                        }
                        if (coords.size() > 3) {
                            outputs.add(coords);
                        }
                    }
                    if (type == 0) {
                        coords = new ArrayList<Coord>();
                        coords.add(Coord.makeHighPrecCoord(lat30, lon30));
                        prevLat30 = lat30;
                        prevLong30 = lon30;
                        break;
                    }
                    coords = null;
                    prevLat30 = Integer.MIN_VALUE;
                    prevLong30 = Integer.MIN_VALUE;
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        return outputs;
    }
}

