/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import uk.me.parabola.log.Logger;

public class ShapeSplitter {
    private static final Logger log = Logger.getLogger(ShapeSplitter.class);
    private static final int LEFT = 0;
    private static final int TOP = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;

    public static Path2D.Double clipShape(Shape shape, Rectangle2D clippingRect) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        PathIterator pit = shape.getPathIterator(null);
        double[] points = new double[512];
        int num = 0;
        Path2D.Double result = null;
        double[] res = new double[6];
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            double x = res[0];
            double y = res[1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            switch (type) {
                case 0: 
                case 1: {
                    if (num + 2 >= points.length) {
                        points = Arrays.copyOf(points, points.length * 2);
                    }
                    points[num++] = x;
                    points[num++] = y;
                    break;
                }
                case 4: {
                    Path2D.Double segment = null;
                    if (!clippingRect.contains(minX, minY) || !clippingRect.contains(maxX, maxY)) {
                        Rectangle2D.Double bbox = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
                        segment = ShapeSplitter.clipSinglePathWithSutherlandHodgman(points, num, clippingRect, bbox);
                    } else {
                        segment = ShapeSplitter.pointsToPath2D(points, num);
                    }
                    if (segment != null) {
                        if (result == null) {
                            result = segment;
                        } else {
                            result.append(segment, false);
                        }
                    }
                    num = 0;
                    minY = Double.POSITIVE_INFINITY;
                    minX = Double.POSITIVE_INFINITY;
                    maxY = Double.NEGATIVE_INFINITY;
                    maxX = Double.NEGATIVE_INFINITY;
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        return result;
    }

    public static Path2D.Double pointsToPath2D(double[] points, int num) {
        if (num < 2) {
            return null;
        }
        if (points[0] == points[num - 2] && points[1] == points[num - 1]) {
            num -= 2;
        }
        if (num < 6) {
            return null;
        }
        Path2D.Double path = new Path2D.Double(1, num / 2 + 2);
        double lastX = points[0];
        double lastY = points[1];
        path.moveTo(lastX, lastY);
        int numOut = 1;
        int i = 2;
        while (i < num) {
            double x = points[i++];
            double y = points[i++];
            if (x == lastX && y == lastY) continue;
            path.lineTo(x, y);
            lastX = x;
            lastY = y;
            ++numOut;
        }
        if (numOut < 3) {
            return null;
        }
        path.closePath();
        return path;
    }

    public static Path2D.Double clipSinglePathWithSutherlandHodgman(double[] points, int num, Rectangle2D clippingRect, Rectangle2D.Double bbox) {
        if (num <= 2 || !bbox.intersects(clippingRect)) {
            return null;
        }
        int countVals = num;
        if (points[0] == points[num - 2] && points[1] == points[num - 1]) {
            countVals -= 2;
        }
        double[] outputList = points;
        double leftX = clippingRect.getMinX();
        double rightX = clippingRect.getMaxX();
        double lowerY = clippingRect.getMinY();
        double upperY = clippingRect.getMaxY();
        boolean eIsIn = false;
        boolean sIsIn = false;
        for (int side = 0; side <= 3; ++side) {
            boolean skipTestForThisSide;
            if (countVals < 6) {
                return null;
            }
            switch (side) {
                case 0: {
                    skipTestForThisSide = bbox.getMinX() >= leftX;
                    break;
                }
                case 1: {
                    skipTestForThisSide = bbox.getMaxY() < upperY;
                    break;
                }
                case 2: {
                    skipTestForThisSide = bbox.getMaxX() < rightX;
                    break;
                }
                default: {
                    boolean bl = skipTestForThisSide = bbox.getMinY() >= lowerY;
                }
            }
            if (skipTestForThisSide) continue;
            double[] input = outputList;
            outputList = new double[countVals + 16];
            double sLon = 0.0;
            double sLat = 0.0;
            double pLon = 0.0;
            double pLat = 0.0;
            int posIn = countVals - 2;
            int posOut = 0;
            for (int i = 0; i < countVals + 2; i += 2) {
                if (posIn >= countVals) {
                    posIn = 0;
                }
                double eLon = input[posIn++];
                double eLat = input[posIn++];
                switch (side) {
                    case 0: {
                        eIsIn = eLon >= leftX;
                        break;
                    }
                    case 1: {
                        eIsIn = eLat < upperY;
                        break;
                    }
                    case 2: {
                        eIsIn = eLon < rightX;
                        break;
                    }
                    default: {
                        boolean bl = eIsIn = eLat >= lowerY;
                    }
                }
                if (i > 0) {
                    if (eIsIn != sIsIn) {
                        double slope = eLon != sLon ? (eLat - sLat) / (eLon - sLon) : 1.0;
                        switch (side) {
                            case 0: {
                                pLon = leftX;
                                pLat = slope * (leftX - sLon) + sLat;
                                break;
                            }
                            case 2: {
                                pLon = rightX;
                                pLat = slope * (rightX - sLon) + sLat;
                                break;
                            }
                            case 1: {
                                pLon = eLon != sLon ? sLon + (upperY - sLat) / slope : sLon;
                                pLat = upperY;
                                break;
                            }
                            default: {
                                pLon = eLon != sLon ? sLon + (lowerY - sLat) / slope : sLon;
                                pLat = lowerY;
                            }
                        }
                    }
                    int toAdd = 0;
                    if (eIsIn) {
                        if (!sIsIn) {
                            toAdd += 2;
                        }
                        toAdd += 2;
                    } else if (sIsIn) {
                        toAdd += 2;
                    }
                    if (posOut + toAdd >= outputList.length) {
                        outputList = Arrays.copyOf(outputList, outputList.length * 2);
                    }
                    if (eIsIn) {
                        if (!sIsIn) {
                            outputList[posOut++] = pLon;
                            outputList[posOut++] = pLat;
                        }
                        outputList[posOut++] = eLon;
                        outputList[posOut++] = eLat;
                    } else if (sIsIn) {
                        outputList[posOut++] = pLon;
                        outputList[posOut++] = pLat;
                    }
                }
                sLon = eLon;
                sLat = eLat;
                sIsIn = eIsIn;
            }
            countVals = posOut;
        }
        return ShapeSplitter.pointsToPath2D(outputList, countVals);
    }
}

