#tag Module
Protected Module Module1
	#tag Method, Flags = &h0
		Function CleanFileName(s As String) As String
		  s = ReplaceAll(s, "\", "-")
		  s = ReplaceAll(s, "/", "-")
		  s = ReplaceAll(s, ":", "_")
		  s = ReplaceAll(s, "*", "_")
		  s = ReplaceAll(s, "?", "_")
		  s = ReplaceAll(s, """", "'")
		  s = ReplaceAll(s, "<", "{")
		  s = ReplaceAll(s, ">", "}")
		  s = ReplaceAll(s, "|", "_")
		  
		  Return Trim(s)
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Function
	#tag EndMethod

	#tag Method, Flags = &h0
		Function ReturnMsg(Msg As String, ParamArray args As String) As String
		  Dim i As Integer
		  
		  For i = 0 To UBound(args)
		    Msg = ReplaceAll(Msg, "#P" + Str(i) + "#", args(i))
		  Next
		  Return Msg
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Function
	#tag EndMethod

	#tag Method, Flags = &h0
		Sub ShowErr(err As RuntimeException, ErrLoc As String)
		  Dim msg As String
		  
		  If NoErr Then Exit Sub
		  App.MouseCursor = Nil
		  
		  msg = str_error
		  
		  If err IsA FunctionNotFoundException Then
		    msg = msg + "FunctionNotFoundException"
		  ElseIf err IsA IllegalCastException Then
		    msg = msg + "IllegalCastException"
		  ElseIf err IsA InvalidParentException Then
		    msg = msg + "InvalidParentException"
		  ElseIf err IsA NilObjectException Then
		    msg = msg + "NilObjectException"
		  ElseIf err IsA OutOfBoundsException Then
		    msg = msg + "OutOfBoundsException"
		  ElseIf err IsA OutOfMemoryException Then
		    msg = msg + "OutOfMemoryException"
		  ElseIf err IsA RegistryAccessErrorException Then
		    msg = msg + "RegistryAccessErrorException"
		  ElseIf err IsA ServiceNotAvailableException Then
		    msg = msg + "ServiceNotAvailableException"
		  ElseIf err IsA ShellNotRunningException Then
		    msg = msg + "ShellNotRunningException"
		  ElseIf err IsA StackOverflowException Then
		    msg = msg + "StackOverflowException"
		  ElseIf err IsA ThreadAlreadyRunningException Then
		    msg = msg + "ThreadAlreadyRunningException"
		  ElseIf err IsA TypeMismatchException Then
		    msg = msg + "TypeMismatchException"
		  ElseIf err IsA UnsupportedFormatException Then
		    msg = msg + "UnsupportedFormatException"
		  Else
		    msg = str_unknown_error
		  End If
		  MsgBox msg + " in module " + ErrLoc
		  
		  NoErr = False
		End Sub
	#tag EndMethod


	#tag Note, Name = LICENCE
		Copyright (C) 2014 JaVaWa
		
		This program is free software; you can redistribute it and/or modify
		it under the terms of the GNU General Public License version 2 as
		published by the Free Software Foundation.
		
		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.
	#tag EndNote


	#tag Property, Flags = &h0
		AppTitle As String
	#tag EndProperty

	#tag Property, Flags = &h0
		DropFiles() As FolderItem
	#tag EndProperty

	#tag Property, Flags = &h0
		IMGs() As clsImg
	#tag EndProperty

	#tag Property, Flags = &h0
		JavaBin As String
	#tag EndProperty

	#tag Property, Flags = &h0
		JavaHeap As Integer
	#tag EndProperty

	#tag Property, Flags = &h0
		JavaInfo As String
	#tag EndProperty

	#tag Property, Flags = &h0
		NoErr As Boolean
	#tag EndProperty

	#tag Property, Flags = &h0
		ResourcesFolder As FolderItem
	#tag EndProperty

	#tag Property, Flags = &h0
		WorkingFolder As FolderItem
	#tag EndProperty


	#tag Constant, Name = str_adding, Type = String, Dynamic = True, Default = \"Adding #P0#", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Adding #P0#"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"#P0# toevoegen"
	#tag EndConstant

	#tag Constant, Name = str_ask_install, Type = String, Dynamic = True, Default = \"Do you want to install the map now\?", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Do you want to install the map now\?"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Wil je de kaart nu installeren\?"
	#tag EndConstant

	#tag Constant, Name = str_cancel, Type = String, Dynamic = True, Default = \"Cancel", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Cancel"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Annuleren"
	#tag EndConstant

	#tag Constant, Name = str_comb_osm, Type = String, Dynamic = True, Default = \"Combined OSM", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Combined OSM"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Gecombineerde OSM"
	#tag EndConstant

	#tag Constant, Name = str_create_error, Type = String, Dynamic = True, Default = \"An error has occurred. Check the log below.", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"An error has occurred. Check the log below."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Er is een fout opgetreden. Controleer onderstaande log."
	#tag EndConstant

	#tag Constant, Name = str_create_gmap, Type = String, Dynamic = True, Default = \"Creating .gmap...", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Creating .gmap..."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \".gmap maken..."
	#tag EndConstant

	#tag Constant, Name = str_drop_files, Type = String, Dynamic = True, Default = \"Drop files here:", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Drop files here:"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Sleep bestanden hier naartoe:"
	#tag EndConstant

	#tag Constant, Name = str_error, Type = String, Dynamic = True, Default = \"An error has occurred: ", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"An error has occurred: "
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Er is een fout opgetreden: "
	#tag EndConstant

	#tag Constant, Name = str_extracting, Type = String, Dynamic = True, Default = \"Extracting #P0#...", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Extracting #P0#..."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"#P0# uitpakken..."
	#tag EndConstant

	#tag Constant, Name = str_finished, Type = String, Dynamic = True, Default = \"Finished combining maps.", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Finished combining maps."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Kaarten zijn samengevoegd."
	#tag EndConstant

	#tag Constant, Name = str_folder_exists, Type = String, Dynamic = True, Default = \"The folder #P0# already exists. The process will be aborted.", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"The folder #P0# already exists. The process will be aborted."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"De map #P0# bestaat al. De bewerking wordt afgebroken."
	#tag EndConstant

	#tag Constant, Name = str_gmapsupp, Type = String, Dynamic = True, Default = \"Create gmapsupp.img", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Create gmapsupp.img"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Gmapsupp.img aanmaken"
	#tag EndConstant

	#tag Constant, Name = str_help, Type = String, Dynamic = True, Default = \"Help", Scope = Public
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Help"
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Help"
	#tag EndConstant

	#tag Constant, Name = str_illegal_id, Type = String, Dynamic = True, Default = \"The chosen Familiy ID is invalid.", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"The chosen Familiy ID is invalid.\rEnter a value between 1 and 65535; excluding 2041."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Het ingevulde Family ID is ongeldig.\rGeef een waarde op tussen 1 en 65535; met uitzondering van 2041."
	#tag EndConstant

	#tag Constant, Name = str_java, Type = String, Dynamic = True, Default = \"Java memory", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Java memory"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Java geheugen"
	#tag EndConstant

	#tag Constant, Name = str_java_err_missing, Type = String, Dynamic = True, Default = \"It appears that Java isn\'t installed on your system. This application requires Java version 6 (1.6) or higher.", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"It appears that Java isn\'t installed on your system. This application requires Java version 6 (1.6) or higher."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Het lijkt erop dat Java niet op je computer is ge\xC3\xAFnstalleerd. Deze applicatie vereist Java verse 6 (1.6) of hoger."
	#tag EndConstant

	#tag Constant, Name = str_java_err_version, Type = String, Dynamic = True, Default = \"The version of Java on your system is too old. This application requires Java version 6 (1.6) or higher.", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"The version of Java on your system is too old. This application requires Java version 6 (1.6) or higher."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"De versie van Java op je computer is te oud. Deze applicatie vereist Java verse 6 (1.6) of hoger."
	#tag EndConstant

	#tag Constant, Name = str_java_heap, Type = String, Dynamic = True, Default = \"Memory allocation for Java.\rRead the manual first before changing this value!", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Memory allocation for Java.\rRead the manual first before changing this value!"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Geheugenreservering voor Java.\rLees eerst de handleiding voordat je deze waarde wijzigt!"
	#tag EndConstant

	#tag Constant, Name = str_java_info, Type = String, Dynamic = True, Default = \"About Java:", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"About Java:"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Over Java:"
	#tag EndConstant

	#tag Constant, Name = str_java_missing, Type = String, Dynamic = True, Default = \"Java not found", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Java not found"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Java niet gevonden"
	#tag EndConstant

	#tag Constant, Name = str_lang, Type = String, Dynamic = True, Default = \"en", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"en"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"nl"
	#tag EndConstant

	#tag Constant, Name = str_name_on_computer, Type = String, Dynamic = True, Default = \"Name on computer:", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Name on computer:"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Naam op computer:"
	#tag EndConstant

	#tag Constant, Name = str_name_on_device, Type = String, Dynamic = True, Default = \"Name on device:", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Name on device:"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Naam in toestel:"
	#tag EndConstant

	#tag Constant, Name = str_new_style, Type = String, Dynamic = True, Default = \"New style (.gmap)", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"New style (.gmap)"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Nieuwe stijl (.gmap)"
	#tag EndConstant

	#tag Constant, Name = str_next, Type = String, Dynamic = True, Default = \"Next >", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Next >"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Volgende >"
	#tag EndConstant

	#tag Constant, Name = str_no, Type = String, Dynamic = True, Default = \"No", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"No"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Nee"
	#tag EndConstant

	#tag Constant, Name = str_none, Type = String, Dynamic = True, Default = \"{none}", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"{none}"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"{geen}"
	#tag EndConstant

	#tag Constant, Name = str_num_files, Type = String, Dynamic = True, Default = \"Number of files:", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Number of files:"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Aantal bestanden:"
	#tag EndConstant

	#tag Constant, Name = str_ok, Type = String, Dynamic = True, Default = \"OK", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"OK"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"OK"
	#tag EndConstant

	#tag Constant, Name = str_old_style, Type = String, Dynamic = True, Default = \"Old style (registry)", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Old style (registry)"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Oude stijl (register)"
	#tag EndConstant

	#tag Constant, Name = str_prev, Type = String, Dynamic = True, Default = \"< Previous", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"< Previous"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"< Vorige"
	#tag EndConstant

	#tag Constant, Name = str_processed, Type = String, Dynamic = True, Default = \"Files are processed.", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Files are processed."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Bestanden zijn verwerkt."
	#tag EndConstant

	#tag Constant, Name = str_processing, Type = String, Dynamic = True, Default = \"Processing...", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Processing..."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Verwerken..."
	#tag EndConstant

	#tag Constant, Name = str_quit, Type = String, Dynamic = True, Default = \"Quit", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Quit"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Afsluiten"
	#tag EndConstant

	#tag Constant, Name = str_read_help, Type = String, Dynamic = True, Default = \"Read the manual!", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Read the manual!"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Lees de handleiding!"
	#tag EndConstant

	#tag Constant, Name = str_remove_selection, Type = String, Dynamic = True, Default = \"Remove selection", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Remove selection"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Selectie verwijderen"
	#tag EndConstant

	#tag Constant, Name = str_retry, Type = String, Dynamic = True, Default = \"Retry", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Retry"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Opnieuw"
	#tag EndConstant

	#tag Constant, Name = str_select_folder, Type = String, Dynamic = True, Default = \"Select export folder", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Select export folder"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Kies uitvoermap"
	#tag EndConstant

	#tag Constant, Name = str_splitting, Type = String, Dynamic = True, Default = \"Splitting #P0#...", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Splitting #P0#..."
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"#P0# splitsen..."
	#tag EndConstant

	#tag Constant, Name = str_start, Type = String, Dynamic = True, Default = \"Start", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Start"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Start"
	#tag EndConstant

	#tag Constant, Name = str_typ, Type = String, Dynamic = True, Default = \"TYP file:", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"TYP file:"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"TYP-bestand:"
	#tag EndConstant

	#tag Constant, Name = str_unknown_error, Type = String, Dynamic = True, Default = \"An unknown error has occurred", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"An unknown error has occurred"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Er is een onbekende fout opgetreden"
	#tag EndConstant

	#tag Constant, Name = str_yes, Type = String, Dynamic = True, Default = \"Yes", Scope = Public
		#Tag Instance, Platform = Any, Language = en, Definition  = \"Yes"
		#Tag Instance, Platform = Any, Language = nl, Definition  = \"Ja"
	#tag EndConstant


	#tag ViewBehavior
		#tag ViewProperty
			Name="AppTitle"
			Group="Behavior"
			Type="String"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
		#tag ViewProperty
			Name="Index"
			Visible=true
			Group="ID"
			InitialValue="-2147483648"
			InheritedFrom="Object"
		#tag EndViewProperty
		#tag ViewProperty
			Name="JavaBin"
			Group="Behavior"
			Type="String"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
		#tag ViewProperty
			Name="JavaHeap"
			Group="Behavior"
			InitialValue="512M"
			Type="Integer"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
		#tag ViewProperty
			Name="JavaInfo"
			Group="Behavior"
			Type="String"
			EditorType="MultiLineEditor"
		#tag EndViewProperty
		#tag ViewProperty
			Name="Left"
			Visible=true
			Group="Position"
			InitialValue="0"
			InheritedFrom="Object"
		#tag EndViewProperty
		#tag ViewProperty
			Name="Name"
			Visible=true
			Group="ID"
			InheritedFrom="Object"
		#tag EndViewProperty
		#tag ViewProperty
			Name="NoErr"
			Group="Behavior"
			Type="Boolean"
		#tag EndViewProperty
		#tag ViewProperty
			Name="Super"
			Visible=true
			Group="ID"
			InheritedFrom="Object"
		#tag EndViewProperty
		#tag ViewProperty
			Name="Top"
			Visible=true
			Group="Position"
			InitialValue="0"
			InheritedFrom="Object"
		#tag EndViewProperty
	#tag EndViewBehavior
End Module
#tag EndModule
