#tag Window
Begin Window wProgress
   BackColor       =   16777215
   Backdrop        =   ""
   CloseButton     =   False
   Composite       =   False
   Frame           =   7
   FullScreen      =   False
   HasBackColor    =   False
   Height          =   338
   ImplicitInstance=   True
   LiveResize      =   True
   MacProcID       =   0
   MaxHeight       =   32000
   MaximizeButton  =   False
   MaxWidth        =   32000
   MenuBar         =   ""
   MenuBarVisible  =   True
   MinHeight       =   64
   MinimizeButton  =   False
   MinWidth        =   64
   Placement       =   0
   Resizeable      =   True
   Title           =   "Untitled"
   Visible         =   True
   Width           =   451
   Begin Thread thrAction
      Height          =   32
      Index           =   -2147483648
      Left            =   124
      LockedInPosition=   False
      Priority        =   5
      Scope           =   0
      StackSize       =   0
      TabPanelIndex   =   0
      Top             =   -53
      Width           =   32
   End
   Begin Label lblProcess
      AutoDeactivate  =   True
      Bold            =   True
      DataField       =   ""
      DataSource      =   ""
      Enabled         =   True
      Height          =   20
      HelpTag         =   ""
      Index           =   -2147483648
      InitialParent   =   ""
      Italic          =   ""
      Left            =   10
      LockBottom      =   ""
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   ""
      LockTop         =   True
      Multiline       =   ""
      Scope           =   0
      Selectable      =   False
      TabIndex        =   0
      TabPanelIndex   =   0
      Text            =   "#str_processing"
      TextAlign       =   0
      TextColor       =   0
      TextFont        =   "System"
      TextSize        =   0
      TextUnit        =   0
      Top             =   10
      Transparent     =   False
      Underline       =   ""
      Visible         =   True
      Width           =   411
   End
   Begin Shell shTask
      Arguments       =   ""
      Backend         =   ""
      Height          =   32
      Index           =   -2147483648
      Left            =   36
      LockedInPosition=   False
      Mode            =   1
      Scope           =   0
      TabPanelIndex   =   0
      TimeOut         =   -1
      Top             =   -53
      Width           =   32
   End
   Begin PushButton pbOK
      AutoDeactivate  =   True
      Bold            =   ""
      ButtonStyle     =   0
      Cancel          =   ""
      Caption         =   "#str_cancel"
      Default         =   False
      Enabled         =   True
      Height          =   20
      HelpTag         =   ""
      Index           =   -2147483648
      InitialParent   =   ""
      Italic          =   ""
      Left            =   179
      LockBottom      =   True
      LockedInPosition=   False
      LockLeft        =   False
      LockRight       =   ""
      LockTop         =   False
      Scope           =   0
      TabIndex        =   2
      TabPanelIndex   =   0
      TabStop         =   True
      TextFont        =   "System"
      TextSize        =   0
      TextUnit        =   0
      Top             =   308
      Underline       =   ""
      Visible         =   True
      Width           =   95
   End
   Begin TextArea taInfo
      AcceptTabs      =   ""
      Alignment       =   0
      AutoDeactivate  =   True
      AutomaticallyCheckSpelling=   True
      BackColor       =   16777215
      Bold            =   ""
      Border          =   True
      DataField       =   ""
      DataSource      =   ""
      Enabled         =   True
      Format          =   ""
      Height          =   260
      HelpTag         =   ""
      HideSelection   =   True
      Index           =   -2147483648
      Italic          =   ""
      Left            =   10
      LimitText       =   0
      LockBottom      =   True
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   True
      LockTop         =   True
      Mask            =   ""
      Multiline       =   True
      ReadOnly        =   ""
      Scope           =   0
      ScrollbarHorizontal=   ""
      ScrollbarVertical=   True
      Styled          =   True
      TabIndex        =   1
      TabPanelIndex   =   0
      TabStop         =   True
      Text            =   ""
      TextColor       =   0
      TextFont        =   "System"
      TextSize        =   0
      TextUnit        =   0
      Top             =   35
      Underline       =   ""
      UseFocusRing    =   True
      Visible         =   True
      Width           =   431
   End
   Begin Timer tmStart
      Height          =   32
      Index           =   -2147483648
      Left            =   80
      LockedInPosition=   False
      Mode            =   0
      Period          =   100
      Scope           =   0
      TabPanelIndex   =   0
      Top             =   -53
      Width           =   32
   End
   Begin Thread thrFinishCreate
      Height          =   32
      Index           =   -2147483648
      Left            =   168
      LockedInPosition=   False
      Priority        =   5
      Scope           =   0
      StackSize       =   0
      TabPanelIndex   =   0
      Top             =   -53
      Width           =   32
   End
End
#tag EndWindow

#tag WindowCode
	#tag Event
		Sub Activate()
		  If Not Loaded Then
		    tmStart.Mode = Timer.ModeSingle
		    Loaded = True
		  End If
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent

	#tag Event
		Sub Close()
		  If thrAction.State <> 4 Then thrAction.Kill
		  If shTask.IsRunning Then shTask.Close
		  NoErr = True
		End Sub
	#tag EndEvent

	#tag Event
		Sub Open()
		  Title = AppTitle
		  Left = (Screen(0).AvailableWidth - Width) \ 2
		  Top = (Screen(0).AvailableHeight - Height) \ 2
		End Sub
	#tag EndEvent

	#tag Event
		Sub Resizing()
		  pbOK.Left = (Width - pbOK.Width) / 2
		End Sub
	#tag EndEvent


	#tag Method, Flags = &h1
		Protected Sub CleanupFolder(f As FolderItem)
		  Dim i As Integer
		  Dim files() As FolderItem
		  
		  For i = 1 To f.Count
		    files.Append f.Item(i)
		  Next
		  
		  For i = 0 To UBound(files)
		    files(i).Delete
		  Next
		  
		Exception err
		  ShowErr err, CurrentMethodName
		  
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Sub ExtractImg(f As FolderItem, fDest As FolderItem)
		  Dim b, bOut as BinaryStream
		  Dim i, j, s As Integer
		  Dim file_name As String
		  Dim bs, file_size, fat_start, fat_len As UInt32
		  Dim sector_no As UInt16
		  Dim found As Boolean
		  Dim files() As clsSubFile
		  Dim part_no As UInt8
		  
		  If f.Length < 100 Then Exit Sub
		  
		  b = BinaryStream.Open(f)
		  b.LittleEndian = True
		  
		  If b.ReadUInt8 <> 0 Then
		    b.Close
		    Exit Sub
		  End If
		  
		  b.Position = 16
		  
		  If b.Read(6) <> "DSKIMG" Then
		    b.Close
		    Exit Sub
		  End If
		  
		  b.Position = 65
		  
		  If b.Read(6) <> "GARMIN" Then
		    b.Close
		    Exit Sub
		  End If
		  b.Position = 97
		  bs = 2 ^ (b.ReadUInt8 + b.ReadUInt8)
		  fat_start = 512
		  
		  Do
		    b.Position = fat_start
		    If b.ReadUInt8 = 1 Then
		      b.Position = b.Position + 11
		      fat_len = b.ReadUInt32 - fat_start
		      Exit Do
		    End If
		    fat_start = fat_start + 512
		  Loop
		  fat_start = fat_start + 512
		  
		  For i = 0 To (fat_len / 512) - 1
		    b.Position = fat_start + i * 512
		    If b.ReadUInt8 = 1 Then
		      file_name = Trim(b.Read(8)) + "." + b.Read(3)
		      file_size = b.ReadUInt32
		      b.Position = b.Position + 1
		      part_no = b.ReadUInt8
		      
		      found = False
		      For j = 0 To UBound(files)
		        If files(j).file_name = file_name Then
		          found = True
		          Exit For
		        End If
		      Next
		      If Not found Then
		        j = UBound(files) + 1
		        ReDim files(j)
		        files(j) = New clsSubFile
		        files(j).file_name = file_name
		      End If
		      If part_no = 0 Then files(j).file_size = file_size
		      
		      b.Position = b.Position + 14
		      For s = 1 To 240
		        sector_no = b.ReadUInt16
		        If sector_no <> -1 Then files(j).sectors.Append sector_no
		      Next
		    End If
		  Next
		  
		  If Not fDest.Exists Then fDest.CreateAsFolder
		  For i = 0 To UBound(files)
		    bOut = BinaryStream.Create(fDest.Child(files(i).file_name), True)
		    For j = 0 To UBound(files(i).sectors)
		      b.Position = files(i).sectors(j) * bs
		      bOut.Write b.Read(bs)
		    Next
		    bOut.Length = files(i).file_size
		    bOut.Close
		  Next
		  b.Close
		  
		Exception err
		  ShowErr err, CurrentMethodName
		  
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Function GetImgCoord(b As BinaryStream) As Double
		  Dim r As Double
		  Dim v(2) As UInt8
		  Dim i As Integer
		  
		  For i = 0 To 2
		    v(i) = b.ReadUInt8
		  Next
		  
		  r = v(0) + ShiftLeft(v(1), 8) + ShiftLeft(v(2), 16)
		  
		  If r > 8388607 Then
		    r = BitAnd(r, 8388607) - 8388608
		  End If
		  
		  Return r * 360 / 2 ^ 24
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Function
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Sub ProcessFiles()
		  Dim r As String
		  Dim i, k, n As Integer
		  Dim ovm As FolderItem
		  
		  For i = 0 To UBound(DropFiles)
		    If Right(DropFiles(i).Name, 4) = ".zip" Or Right(DropFiles(i).Name, 3) = ".7z" Then
		      UnzipHeap.Append DropFiles(i)
		    ElseIf DropFiles(i).Name = "gmapsupp.img" Then
		      SplitHeap.Append(DropFiles(i))
		    ElseIf Right(DropFiles(i).Name, 4) = ".img" Then
		      r = ReadIMG(DropFiles(i))
		      If r = "split" Then
		        SplitHeap.Append(DropFiles(i))
		      ElseIf Left(r, 3) = "img" Then
		        n = -1
		        If WorkingFolder.Child("Tiles").Child(DropFiles(i).Name).Exists Then
		          For k = 0 To UBound(IMGs)
		            If IMGs(k).Name = DropFiles(i).Name Then n = k
		          Next
		          WorkingFolder.Child("Tiles").Child(DropFiles(i).Name).Delete
		        End If
		        If n = -1 Then
		          n = UBound(IMGs) + 1
		          ReDim IMGs(n)
		          IMGs(n) = New clsImg
		        End If
		        IMGs(n).Bounds = Mid(r, 4)
		        IMGs(n).Name = DropFiles(i).Name
		        IMGs(n).Path = WorkingFolder.Child("Tiles").Child(DropFiles(i).Name)
		        IMGs(n).Size = IMGs(n).Path.Length
		        taInfo.SelText = ReturnMsg(str_adding, DropFiles(i).Name) + EndOfLine
		        DropFiles(i).CopyFileTo WorkingFolder.Child("Tiles")
		        ovm = DropFiles(i).Parent.Child("ovm_" + DropFiles(i).Name)
		        If ovm.Exists Then ovm.CopyFileTo WorkingFolder.Child("Tiles")
		      End If
		    End If
		  Next
		  
		  ReDim DropFiles(-1)
		  
		  If UBound(UnzipHeap) > -1 Or UBound(SplitHeap) > -1 Then
		    If UBound(SplitHeap) > -1 Then
		      tmpCnt = tmpCnt + 1
		      SplitImg SplitHeap.Pop, WorkingFolder.Child(Str(tmpCnt))
		    ElseIf UBound(UnzipHeap) > -1 Then
		      tmpCnt = tmpCnt + 1
		      UnZip UnzipHeap.Pop, WorkingFolder.Child(Str(tmpCnt))
		    End If
		  Else
		    For i = 1 To tmpCnt
		      Try
		        CleanupFolder WorkingFolder.Child(Str(i))
		        WorkingFolder.Child(Str(i)).Delete
		      Catch
		      End Try
		    Next
		    App.MouseCursor = Nil
		    lblProcess.Caption = str_processed
		    pbOK.Caption = "OK"
		  End If
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Function ReadIMG(f As FolderItem) As String
		  Dim b As BinaryStream
		  Dim i, j As Integer
		  Dim file_name, file_title, file_ext As String
		  Dim files() As String
		  Dim bounds As String
		  Dim firstTRE As String
		  Dim bs, file_size, fat_start, fat_len, sector_no As UInt64
		  
		  If f.Name = "63240000.img" Or f.Name = "63440000.img" Or f.Name = "10010000.img" Or f.Name = "49000000.img" Then Return "overview"
		  
		  If f.Length < 100 Then Return "err"
		  
		  b = BinaryStream.Open(f)
		  b.LittleEndian = True
		  
		  b.Position = 16
		  If b.Read(6) <> "DSKIMG" Then
		    b = Nil
		    Return "err"
		  End If
		  
		  b.Position = 65
		  If b.Read(6) <> "GARMIN" Then
		    b = Nil
		    Return "err"
		  End If
		  
		  b.Position = 73
		  If Left(b.Read(20), 12) = "Overview map" Then
		    b = Nil
		    Return "overview"
		  End If
		  
		  b.Position = 97
		  bs = 2 ^ (b.ReadUInt8 + b.ReadUInt8)
		  
		  fat_start = 512
		  Do
		    b.Position = fat_start
		    If b.readUInt8 = 1 Then
		      b.Position = b.Position + 11
		      fat_len = b.ReadUInt32 - fat_start
		      Exit Do
		    End If
		    fat_start = fat_start + 512
		  Loop
		  fat_start = fat_start + 512
		  
		  For j = 0 To (fat_len / 512) - 1
		    b.Position = fat_start + j * 512
		    If b.ReadUInt8 = 1 Then
		      file_title = Trim(b.Read(8))
		      file_ext =  b.Read(3)
		      file_name = file_title + "." + file_ext
		      If files.IndexOf(file_name) = -1 Then
		        files.Append file_name
		        file_size = b.ReadUInt32
		        b.Position = b.Position + 16
		        sector_no = b.ReadUInt16
		        If bs * sector_no + file_size > b.Length Then
		          b = Nil
		          Return "err"
		        End If
		        b.Position = bs * sector_no + 14
		        i = b.ReadUInt16
		        If file_ext = "tre" Then
		          b.Position = bs * sector_no + 21
		          bounds = Str(GetImgCoord(b)) + "|" + Str(GetImgCoord(b)) + "|" + Str(GetImgCoord(b)) + "|" + Str(GetImgCoord(b))
		          If firstTRE <> "" And file_name <> firstTRE Then
		            b = Nil
		            Return "split"
		          End If
		          firstTRE = file_name
		        End If
		      End If
		    End If
		  Next
		  b = Nil
		  
		  If firstTRE = "" Then Return "nomap"
		  
		  file_title = Left(f.Name, Len(f.Name) - 4)
		  If Len(file_title) = 8 And Val(file_title) > 0 And bounds <> "" Then Return "img" + bounds
		  
		Exception err
		  ShowErr err, CurrentMethodName
		  
		End Function
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Sub SplitImg(f As FolderItem, p As FolderItem)
		  If p.Exists Then
		    CleanupFolder(p)
		  Else
		    p.CreateAsFolder
		  End If
		  taInfo.SelText = ReturnMsg(str_splitting, f.Name) + EndOfLine
		  #if TargetWin32
		    Dim c As String
		    
		    c = ResourcesFolder.Child("gmt.exe").ShellPath + " -s -o "  + p.ShellPath + " " + f.ShellPath
		    c = c.Replace("^", "^^")
		    c = c.Replace("&", "^&")
		    shTask.Execute c
		  #else
		    shTask.Execute ResourcesFolder.Child("gmt").ShellPath, " -s -o "  + p.ShellPath + " " + f.ShellPath
		  #endif
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Sub StartCreate()
		  Dim tos As TextOutputStream
		  Dim i As Integer
		  Dim Names() As String
		  
		  If wMain.pmTyp.ListIndex > 0 Then
		    ResourcesFolder.Child("typ" + wMain.pmTyp.Text + ".txt").CopyFileTo WorkingFolder
		    WorkingFolder.Child("typ" + wMain.pmTyp.Text + ".txt").Name = wMain.pmTyp.Text + ".txt"
		  End If
		  tos = TextOutputStream.Create(WorkingFolder.Child("options.txt"))
		  tos.Write "output-dir: Tiles" + EndOfLine.Windows
		  tos.Write "area-name: " + wMain.tfPcName.Text + EndOfLine.Windows
		  tos.Write "draw-priority: 20" + EndOfLine.Windows
		  tos.Write "latin1" + EndOfLine.Windows
		  tos.Write "code-page: 1252" + EndOfLine.Windows
		  tos.Write "show-profiles: 1" + EndOfLine.Windows
		  tos.Write "net" + EndOfLine.Windows
		  tos.Write "route" + EndOfLine.Windows
		  tos.Write "product-id: 1" + EndOfLine.Windows
		  tos.Write "index" + EndOfLine.Windows
		  tos.Write "tdbfile" + EndOfLine.Windows
		  tos.Write "family-name: " + wMain.tfDeviceName.Text + EndOfLine.Windows
		  tos.Write "family-id: " + wMain.tfFamID.Text + EndOfLine.Windows
		  tos.Write "series-name: " + wMain.tfPcName.Text + EndOfLine.Windows
		  tos.Write "description: " + wMain.tfPcName.Text + EndOfLine.Windows
		  tos.Write "overview-mapname: mapset" + EndOfLine.Windows
		  If wMain.chkGmapsupp.Value Then tos.Write "gmapsupp" + EndOfLine.Windows
		  If wMain.pmTyp.ListIndex > 0 Then tos.Write "input-file: " + wMain.pmTyp.Text + ".txt" + EndOfLine.Windows
		  For i = 0 To UBound(IMGs)
		    
		    #if TargetWin32
		      Names.Append "input-file: Tiles\" + IMGs(i).Name
		    #else
		      Names.Append "input-file: Tiles/" + IMGs(i).Name
		    #endif
		  Next
		  
		  Names.Sort
		  tos.Write Join(Names, EndOfLine.Windows)
		  tos.Write EndOfLine.Windows + EndOfLine.Windows
		  tos.Close
		  
		  #if TargetWin32
		    Dim nsis, hexid As String
		    Dim tis As TextInputStream
		    Dim c As String
		    
		    tis = TextInputStream.Open(ResourcesFolder.Child("installer_template.nsi"))
		    nsis = tis.ReadAll
		    tis.Close
		    tis = Nil
		    tos = TextOutputStream.Create(WorkingFolder.Child("Tiles").Child("mapset.nsi"))
		    If wMain.pmTyp.ListIndex > 0 Then tos.Write "!define TYPNAME """ + wMain.pmTyp.Text + ".typ""" + EndOfLine.Windows
		    
		    hexid = Hex(Val(wMain.tfFamID.Text))
		    Select Case Len(hexid)
		    Case 1
		      hexid = "0" + hexid + "00"
		    Case 2
		      hexid = hexid + "00"
		    Case 3
		      hexid = Right(hexid, 2) + "0" + Left(hexid, 1)
		    Case 4
		      hexid = Right(hexid, 2) + Left(hexid, 2)
		    End Select
		    
		    tos.Write Replace(ReplaceAll(nsis, "OSM_Combi", CleanFileName(wMain.tfPcName.Text)), "hexfamilyid", hexid).ConvertEncoding(Encodings.WindowsANSI)
		    tos.Close
		    tos = Nil
		    tos = TextOutputStream.Create(WorkingFolder.Child("createmap.cmd"))
		    tos.Write "@echo off" + EndOfLine.Windows
		    tos.Write Left(WorkingFolder.AbsolutePath, 2) + EndOfLine.Windows
		    
		    c = "cd """ + Mid(WorkingFolder.AbsolutePath, 3) + """" + EndOfLine.Windows
		    tos.Write c.ConvertEncoding(Encodings.WindowsANSI)
		    
		    c = JavaBin + " -jar -Xmx" + Str(JavaHeap) + "M """ + ResourcesFolder.Child("mkgmap.jar").AbsolutePath + """ --read-config=options.txt" + EndOfLine.Windows
		    tos.Write c.ConvertEncoding(Encodings.WindowsANSI)
		    c = """" + ResourcesFolder.Child("makensis.exe").AbsolutePath + """ Tiles\mapset.nsi >nul" + EndOfLine.Windows
		    tos.Write c.ConvertEncoding(Encodings.WindowsANSI)
		    tos.Close
		    tos = Nil
		    c = """" + WorkingFolder.Child("createmap.cmd").AbsolutePath + """"
		    shTask.Execute c.ConvertEncoding(Encodings.WindowsANSI)
		  #else
		    tos = TextOutputStream.Create(WorkingFolder.Child("createmap.sh"))
		    tos.Write "#!/bin/bash" + EndOfLine.UNIX
		    tos.Write "cd " + WorkingFolder.ShellPath + EndOfLine.UNIX
		    tos.Write JavaBin + " -jar -Xmx" + Str(JavaHeap) + "M " + ResourcesFolder.Child("mkgmap.jar").ShellPath + " --read-config=options.txt"
		    tos.Close
		    tos = Nil
		    WorkingFolder.Child("createmap.sh").Permissions = &o777
		    shTask.Execute WorkingFolder.Child("createmap.sh").ShellPath
		  #endif
		  
		Exception err
		  ShowErr err, CurrentMethodName
		  
		End Sub
	#tag EndMethod

	#tag Method, Flags = &h1
		Protected Sub UnZip(f As FolderItem, p As FolderItem)
		  If p.Exists Then
		    CleanupFolder(p)
		  Else
		    p.CreateAsFolder
		  End If
		  taInfo.SelText = ReturnMsg(str_extracting, f.Name) + EndOfLine
		  #if TargetWin32
		    Dim c As String
		    c = """" + ResourcesFolder.Child("7za.exe").AbsolutePath +  """ e """ + f.AbsolutePath  + """ -o""" + p.AbsolutePath + """ -aoa"
		    shTask.Execute c.ConvertEncoding(Encodings.WindowsANSI)
		  #else
		    shTask.Execute ResourcesFolder.Child("unar").ShellPath, " -D -f -o "  + p.ShellPath + " " + f.ShellPath
		  #endif
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndMethod


	#tag Note, Name = LICENCE
		Copyright (C) 2014 JaVaWa
		
		This program is free software; you can redistribute it and/or modify
		it under the terms of the GNU General Public License version 2 as
		published by the Free Software Foundation.
		
		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.
	#tag EndNote


	#tag Property, Flags = &h1
		Protected Loaded As Boolean
	#tag EndProperty

	#tag Property, Flags = &h0
		Mode As String
	#tag EndProperty

	#tag Property, Flags = &h1
		Protected SplitHeap() As FolderItem
	#tag EndProperty

	#tag Property, Flags = &h1
		Protected tmpCnt As Integer
	#tag EndProperty

	#tag Property, Flags = &h1
		Protected UnzipHeap() As FolderItem
	#tag EndProperty


#tag EndWindowCode

#tag Events thrAction
	#tag Event
		Sub Run()
		  If Mode = "proc" Then
		    ProcessFiles
		  ElseIf Mode = "create" Then
		    StartCreate
		  End If
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events shTask
	#tag Event
		Sub Completed()
		  Dim i As Integer
		  
		  If Mode = "create" Then
		    thrFinishCreate.Run
		  Else
		    For i = 1 To WorkingFolder.Child(Str(tmpCnt)).Count
		      DropFiles.Append WorkingFolder.Child(Str(tmpCnt)).Item(i)
		    Next
		    ProcessFiles
		  End If
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
	#tag Event
		Sub DataAvailable()
		  taInfo.SelText = shTask.ReadAll
		  
		Exception err
		  ShowErr err, CurrentMethodName
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events pbOK
	#tag Event
		Sub Action()
		  wProgress.Close
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events tmStart
	#tag Event
		Sub Action()
		  thrAction.Run
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events thrFinishCreate
	#tag Event
		Sub Run()
		  Dim tos As TextOutputStream
		  Dim b As BinaryStream
		  Dim Success As Boolean
		  Dim fMap, ovm As FolderItem
		  Dim i As Integer
		  Dim msn As String
		  
		  Success = True
		  If Not WorkingFolder.Child("Tiles").Child("mapset.img").Exists Then Success = False
		  If Not WorkingFolder.Child("Tiles").Child("mapset_mdr.img").Exists Then Success = False
		  If Not WorkingFolder.Child("Tiles").Child("mapset.mdx").Exists Then Success = False
		  If Not WorkingFolder.Child("Tiles").Child("mapset.tdb").Exists Then Success = False
		  If wMain.pmTyp.ListIndex > 0 Then
		    If Not WorkingFolder.Child("Tiles").Child(wMain.pmTyp.Text + ".typ").Exists Then Success = False
		  End If
		  If wMain.chkGmapsupp.Value Then
		    If Not WorkingFolder.Child("Tiles").Child("gmapsupp.img").Exists Then Success = False
		  End If
		  If Not Success Then
		    App.MouseCursor = Nil
		    taInfo.SelText = str_create_error
		    lblProcess.Caption = str_create_error
		    pbOK.Caption = "OK"
		    Exit Sub
		  End If
		  
		  #if TargetWin32
		    fMap = WorkingFolder.Child(CleanFileName(wMain.tfPcName.Text))
		    If Not fMap.Exists Then fMap.CreateAsFolder
		    WorkingFolder.Child("Tiles").Child("install.exe").MoveFileTo fMap
		    WorkingFolder.Child("Tiles").Child("mapset_mdr.img").MoveFileTo fMap
		    WorkingFolder.Child("Tiles").Child("mapset.img").MoveFileTo fMap
		    For i = 0 To UBound(IMGs)
		      ovm = IMGs(i).Path.Parent.Child("ovm_" + IMGs(i).Path.Name)
		      If ovm.Exists Then ovm.Delete
		      IMGs(i).Path.MoveFileTo fMap
		    Next
		    WorkingFolder.Child("Tiles").Child("mapset.mdx").MoveFileTo fMap
		    WorkingFolder.Child("Tiles").Child("mapset.tdb").MoveFileTo fMap
		    If wMain.pmTyp.ListIndex > 0 Then WorkingFolder.Child("Tiles").Child(wMain.pmTyp.Text + ".typ").MoveFileTo fMap
		  #else
		    taInfo.SelText = str_create_gmap + EndOfLine
		    fMap = WorkingFolder.Child(CleanFileName(wMain.tfPcName.Text) + ".gmap")
		    If Not fMap.Exists Then fMap.CreateAsFolder
		    If Not fMap.Child("Product1").Exists Then fMap.Child("Product1").CreateAsFolder
		    
		    taInfo.SelText = ReturnMsg(str_extracting, "mapset_mdr.img") + EndOfLine
		    ExtractImg WorkingFolder.Child("Tiles").Child("mapset_mdr.img"), fMap.Child("mapset_mdr")
		    WorkingFolder.Child("Tiles").Child("mapset_mdr.img").Delete
		    
		    taInfo.SelText = ReturnMsg(str_extracting, "mapset.img") + EndOfLine
		    ExtractImg WorkingFolder.Child("Tiles").Child("mapset.img"), fMap.Child("Product1").Child("mapset")
		    WorkingFolder.Child("Tiles").Child("mapset.img").Delete
		    
		    For i = 0 To UBound(IMGs)
		      taInfo.SelText = ReturnMsg(str_extracting, IMGs(i).Name) + EndOfLine
		      ExtractImg IMGs(i).Path, fMap.Child("Product1").Child(Left(IMGs(i).Name, Len(IMGs(i).Name) - 4))
		      ovm = IMGs(i).Path.Parent.Child("ovm_" + IMGs(i).Path.Name)
		      If ovm.Exists Then ovm.Delete
		      IMGs(i).Path.Delete
		    Next
		    
		    tos = TextOutputStream.Create(fMap.Child("Info.xml"))
		    tos.WriteLine "<?xml version=""1.0"" encoding=""UTF-8"" standalone=""no"" ?>"
		    tos.WriteLine "<MapProduct xmlns=""http://www.garmin.com/xmlschemas/MapProduct/v1"">"
		    tos.WriteLine "<Name>" + wMain.tfDeviceName.Text + "</Name>"
		    tos.WriteLine "<InstallationID>1</InstallationID>"
		    tos.WriteLine "<DataVersion>100</DataVersion>"
		    tos.WriteLine "<DataFormat>Original</DataFormat>"
		    tos.WriteLine "<ID>" + wMain.tfFamID.Text + "</ID>"
		    tos.WriteLine "<IDX>mapset.mdx</IDX>"
		    tos.WriteLine "<MDR>mapset_mdr</MDR>"
		    If wMain.pmTyp.ListIndex > 0 Then tos.WriteLine "<TYP>" + wMain.pmTyp.Text + ".typ</TYP>"
		    tos.WriteLine "<SubProduct>"
		    tos.WriteLine "<Name>" + wMain.tfPcName.Text + "</Name>"
		    tos.WriteLine "<ID>1</ID>"
		    tos.WriteLine "<BaseMap>mapset</BaseMap>"
		    tos.WriteLine "<TDB>mapset.tdb</TDB>"
		    tos.WriteLine "<Directory>Product1</Directory>"
		    tos.WriteLine "</SubProduct>"
		    tos.WriteLine "</MapProduct>"
		    tos.Close
		    WorkingFolder.Child("Tiles").Child("mapset.mdx").MoveFileTo fMap
		    WorkingFolder.Child("Tiles").Child("mapset.tdb").MoveFileTo fMap.Child("Product1")
		    If wMain.pmTyp.ListIndex > 0 Then WorkingFolder.Child("Tiles").Child(wMain.pmTyp.Text + ".typ").MoveFileTo fMap
		  #endif
		  
		  If wMain.chkGmapsupp.Value Then
		    If WorkingFolder.Child("gmapsupp.img").Exists Then WorkingFolder.Child("gmapsupp.img").Delete
		    WorkingFolder.Child("Tiles").Child("gmapsupp.img").MoveFileTo WorkingFolder
		    b = BinaryStream.Open(WorkingFolder.Child("gmapsupp.img"), True)
		    msn = wMain.tfDeviceName.Text.ConvertEncoding(Encodings.WindowsANSI)
		    msn = LeftB(msn, 50)
		    While LenB(msn) < 50
		      msn = msn + " "
		    Wend
		    b.Position = 14
		    b.Write ChrB(1)
		    b.Position = 73
		    b.Write LeftB(msn, 20)
		    b.Position= 101
		    b.Write MidB(msn, 21)
		    b = Nil
		  End If
		  
		  ReDim IMGs(-1)
		  If wMain.pmTyp.ListIndex > 0 Then WorkingFolder.Child(wMain.pmTyp.Text + ".txt").Delete
		  WorkingFolder.Child("options.txt").Delete
		  
		  #if TargetWin32
		    WorkingFolder.Child("createmap.cmd").Delete
		  #else
		    WorkingFolder.Child("createmap.sh").Delete
		  #endif
		  Try
		    CleanupFolder WorkingFolder.Child("Tiles")
		    WorkingFolder.Child("Tiles").Delete
		  Catch
		  End Try
		  App.MouseCursor = Nil
		  
		  taInfo.SelText = str_finished
		  lblProcess.Caption = str_finished
		  pbOK.Caption = "OK"
		  wMain.Success = True
		  
		Exception err
		  ShowErr err, CurrentMethodName
		  
		End Sub
	#tag EndEvent
#tag EndEvents
