#include "../librpc/gen_ndr/ndr_atsvc.h"
#ifndef __CLI_ATSVC__
#define __CLI_ATSVC__
struct tevent_req *rpccli_atsvc_JobAdd_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli,
					    const char *_servername /* [in] [unique,charset(UTF16)] */,
					    struct atsvc_JobInfo *_job_info /* [in] [ref] */,
					    uint32_t *_job_id /* [out] [ref] */);
NTSTATUS rpccli_atsvc_JobAdd_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result);
NTSTATUS rpccli_atsvc_JobAdd(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     struct atsvc_JobInfo *job_info /* [in] [ref] */,
			     uint32_t *job_id /* [out] [ref] */);
struct tevent_req *rpccli_atsvc_JobDel_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli,
					    const char *_servername /* [in] [unique,charset(UTF16)] */,
					    uint32_t _min_job_id /* [in]  */,
					    uint32_t _max_job_id /* [in]  */);
NTSTATUS rpccli_atsvc_JobDel_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result);
NTSTATUS rpccli_atsvc_JobDel(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     uint32_t min_job_id /* [in]  */,
			     uint32_t max_job_id /* [in]  */);
struct tevent_req *rpccli_atsvc_JobEnum_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     const char *_servername /* [in] [unique,charset(UTF16)] */,
					     struct atsvc_enum_ctr *_ctr /* [in,out] [ref] */,
					     uint32_t _preferred_max_len /* [in]  */,
					     uint32_t *_total_entries /* [out] [ref] */,
					     uint32_t *_resume_handle /* [in,out] [unique] */);
NTSTATUS rpccli_atsvc_JobEnum_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result);
NTSTATUS rpccli_atsvc_JobEnum(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *servername /* [in] [unique,charset(UTF16)] */,
			      struct atsvc_enum_ctr *ctr /* [in,out] [ref] */,
			      uint32_t preferred_max_len /* [in]  */,
			      uint32_t *total_entries /* [out] [ref] */,
			      uint32_t *resume_handle /* [in,out] [unique] */);
struct tevent_req *rpccli_atsvc_JobGetInfo_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_servername /* [in] [unique,charset(UTF16)] */,
						uint32_t _job_id /* [in]  */,
						struct atsvc_JobInfo **_job_info /* [out] [ref] */);
NTSTATUS rpccli_atsvc_JobGetInfo_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result);
NTSTATUS rpccli_atsvc_JobGetInfo(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [unique,charset(UTF16)] */,
				 uint32_t job_id /* [in]  */,
				 struct atsvc_JobInfo **job_info /* [out] [ref] */);
#endif /* __CLI_ATSVC__ */
