/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_frsapi.h"

struct rpccli_FRSAPI_VERIFY_PROMOTION_state {
	struct FRSAPI_VERIFY_PROMOTION orig;
	struct FRSAPI_VERIFY_PROMOTION tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSAPI_VERIFY_PROMOTION_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSAPI_VERIFY_PROMOTION_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSAPI_VERIFY_PROMOTION_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSAPI_VERIFY_PROMOTION_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_VERIFY_PROMOTION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSAPI_VERIFY_PROMOTION_done, req);
	return req;
}

static void rpccli_FRSAPI_VERIFY_PROMOTION_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSAPI_VERIFY_PROMOTION_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_VERIFY_PROMOTION_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSAPI_VERIFY_PROMOTION_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_VERIFY_PROMOTION_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_VERIFY_PROMOTION r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_VERIFY_PROMOTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSAPI_PROMOTION_STATUS_state {
	struct FRSAPI_PROMOTION_STATUS orig;
	struct FRSAPI_PROMOTION_STATUS tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSAPI_PROMOTION_STATUS_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSAPI_PROMOTION_STATUS_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSAPI_PROMOTION_STATUS_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSAPI_PROMOTION_STATUS_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_PROMOTION_STATUS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSAPI_PROMOTION_STATUS_done, req);
	return req;
}

static void rpccli_FRSAPI_PROMOTION_STATUS_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSAPI_PROMOTION_STATUS_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_PROMOTION_STATUS_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSAPI_PROMOTION_STATUS_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSAPI_PROMOTION_STATUS_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_PROMOTION_STATUS_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_PROMOTION_STATUS(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_PROMOTION_STATUS r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_PROMOTION_STATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSAPI_START_DEMOTION_state {
	struct FRSAPI_START_DEMOTION orig;
	struct FRSAPI_START_DEMOTION tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSAPI_START_DEMOTION_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSAPI_START_DEMOTION_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSAPI_START_DEMOTION_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSAPI_START_DEMOTION_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_START_DEMOTION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSAPI_START_DEMOTION_done, req);
	return req;
}

static void rpccli_FRSAPI_START_DEMOTION_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSAPI_START_DEMOTION_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_START_DEMOTION_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSAPI_START_DEMOTION_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSAPI_START_DEMOTION_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_START_DEMOTION_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_START_DEMOTION(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_START_DEMOTION r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_START_DEMOTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_FRSAPI_COMMIT_DEMOTION_state {
	struct FRSAPI_COMMIT_DEMOTION orig;
	struct FRSAPI_COMMIT_DEMOTION tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSAPI_COMMIT_DEMOTION_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSAPI_COMMIT_DEMOTION_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSAPI_COMMIT_DEMOTION_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSAPI_COMMIT_DEMOTION_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_COMMIT_DEMOTION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSAPI_COMMIT_DEMOTION_done, req);
	return req;
}

static void rpccli_FRSAPI_COMMIT_DEMOTION_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSAPI_COMMIT_DEMOTION_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_COMMIT_DEMOTION_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSAPI_COMMIT_DEMOTION_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSAPI_COMMIT_DEMOTION_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_COMMIT_DEMOTION_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_COMMIT_DEMOTION(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_COMMIT_DEMOTION r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_COMMIT_DEMOTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_frsapi_SetDsPollingIntervalW_state {
	struct frsapi_SetDsPollingIntervalW orig;
	struct frsapi_SetDsPollingIntervalW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frsapi_SetDsPollingIntervalW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frsapi_SetDsPollingIntervalW_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    uint32_t _CurrentInterval /* [in]  */,
							    uint32_t _DsPollingLongInterval /* [in]  */,
							    uint32_t _DsPollingShortInterval /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_frsapi_SetDsPollingIntervalW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frsapi_SetDsPollingIntervalW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.CurrentInterval = _CurrentInterval;
	state->orig.in.DsPollingLongInterval = _DsPollingLongInterval;
	state->orig.in.DsPollingShortInterval = _DsPollingShortInterval;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_SETDSPOLLINGINTERVALW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frsapi_SetDsPollingIntervalW_done, req);
	return req;
}

static void rpccli_frsapi_SetDsPollingIntervalW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frsapi_SetDsPollingIntervalW_state *state = tevent_req_data(
		req, struct rpccli_frsapi_SetDsPollingIntervalW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frsapi_SetDsPollingIntervalW_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct rpccli_frsapi_SetDsPollingIntervalW_state *state = tevent_req_data(
		req, struct rpccli_frsapi_SetDsPollingIntervalW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_SetDsPollingIntervalW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     uint32_t CurrentInterval /* [in]  */,
					     uint32_t DsPollingLongInterval /* [in]  */,
					     uint32_t DsPollingShortInterval /* [in]  */,
					     WERROR *werror)
{
	struct frsapi_SetDsPollingIntervalW r;
	NTSTATUS status;

	/* In parameters */
	r.in.CurrentInterval = CurrentInterval;
	r.in.DsPollingLongInterval = DsPollingLongInterval;
	r.in.DsPollingShortInterval = DsPollingShortInterval;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_SETDSPOLLINGINTERVALW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frsapi_GetDsPollingIntervalW_state {
	struct frsapi_GetDsPollingIntervalW orig;
	struct frsapi_GetDsPollingIntervalW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frsapi_GetDsPollingIntervalW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frsapi_GetDsPollingIntervalW_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    uint32_t *_CurrentInterval /* [out] [ref] */,
							    uint32_t *_DsPollingLongInterval /* [out] [ref] */,
							    uint32_t *_DsPollingShortInterval /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_frsapi_GetDsPollingIntervalW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frsapi_GetDsPollingIntervalW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */
	state->orig.out.CurrentInterval = _CurrentInterval;
	state->orig.out.DsPollingLongInterval = _DsPollingLongInterval;
	state->orig.out.DsPollingShortInterval = _DsPollingShortInterval;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_frsapi_GetDsPollingIntervalW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_GETDSPOLLINGINTERVALW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frsapi_GetDsPollingIntervalW_done, req);
	return req;
}

static void rpccli_frsapi_GetDsPollingIntervalW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frsapi_GetDsPollingIntervalW_state *state = tevent_req_data(
		req, struct rpccli_frsapi_GetDsPollingIntervalW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.CurrentInterval = *state->tmp.out.CurrentInterval;
	*state->orig.out.DsPollingLongInterval = *state->tmp.out.DsPollingLongInterval;
	*state->orig.out.DsPollingShortInterval = *state->tmp.out.DsPollingShortInterval;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frsapi_GetDsPollingIntervalW_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct rpccli_frsapi_GetDsPollingIntervalW_state *state = tevent_req_data(
		req, struct rpccli_frsapi_GetDsPollingIntervalW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_GetDsPollingIntervalW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     uint32_t *CurrentInterval /* [out] [ref] */,
					     uint32_t *DsPollingLongInterval /* [out] [ref] */,
					     uint32_t *DsPollingShortInterval /* [out] [ref] */,
					     WERROR *werror)
{
	struct frsapi_GetDsPollingIntervalW r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_GETDSPOLLINGINTERVALW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*CurrentInterval = *r.out.CurrentInterval;
	*DsPollingLongInterval = *r.out.DsPollingLongInterval;
	*DsPollingShortInterval = *r.out.DsPollingShortInterval;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_FRSAPI_VERIFY_PROMOTION_W_state {
	struct FRSAPI_VERIFY_PROMOTION_W orig;
	struct FRSAPI_VERIFY_PROMOTION_W tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_FRSAPI_VERIFY_PROMOTION_W_done(struct tevent_req *subreq);

struct tevent_req *rpccli_FRSAPI_VERIFY_PROMOTION_W_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_FRSAPI_VERIFY_PROMOTION_W_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_FRSAPI_VERIFY_PROMOTION_W_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_VERIFY_PROMOTION_W,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_FRSAPI_VERIFY_PROMOTION_W_done, req);
	return req;
}

static void rpccli_FRSAPI_VERIFY_PROMOTION_W_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_FRSAPI_VERIFY_PROMOTION_W_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_VERIFY_PROMOTION_W_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION_W_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx)
{
	struct rpccli_FRSAPI_VERIFY_PROMOTION_W_state *state = tevent_req_data(
		req, struct rpccli_FRSAPI_VERIFY_PROMOTION_W_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION_W(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx)
{
	struct FRSAPI_VERIFY_PROMOTION_W r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_VERIFY_PROMOTION_W,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_frsapi_InfoW_state {
	struct frsapi_InfoW orig;
	struct frsapi_InfoW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frsapi_InfoW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frsapi_InfoW_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli,
					    uint32_t _length /* [in] [range(0,0x10000)] */,
					    struct frsapi_Info *_info /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_frsapi_InfoW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frsapi_InfoW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.length = _length;
	state->orig.in.info = _info;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_frsapi_InfoW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_INFOW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frsapi_InfoW_done, req);
	return req;
}

static void rpccli_frsapi_InfoW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frsapi_InfoW_state *state = tevent_req_data(
		req, struct rpccli_frsapi_InfoW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frsapi_InfoW_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  WERROR *result)
{
	struct rpccli_frsapi_InfoW_state *state = tevent_req_data(
		req, struct rpccli_frsapi_InfoW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_InfoW(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     uint32_t length /* [in] [range(0,0x10000)] */,
			     struct frsapi_Info *info /* [in,out] [unique] */,
			     WERROR *werror)
{
	struct frsapi_InfoW r;
	NTSTATUS status;

	/* In parameters */
	r.in.length = length;
	r.in.info = info;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_INFOW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frsapi_IsPathReplicated_state {
	struct frsapi_IsPathReplicated orig;
	struct frsapi_IsPathReplicated tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frsapi_IsPathReplicated_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frsapi_IsPathReplicated_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       const char *_path /* [in] [unique,charset(UTF16)] */,
						       enum frsapi_ReplicaSetType _replica_set_type /* [in]  */,
						       uint32_t *_replicated /* [out] [ref] */,
						       uint32_t *_primary /* [out] [ref] */,
						       uint32_t *_root /* [out] [ref] */,
						       struct GUID *_replica_set_guid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_frsapi_IsPathReplicated_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frsapi_IsPathReplicated_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.path = _path;
	state->orig.in.replica_set_type = _replica_set_type;

	/* Out parameters */
	state->orig.out.replicated = _replicated;
	state->orig.out.primary = _primary;
	state->orig.out.root = _root;
	state->orig.out.replica_set_guid = _replica_set_guid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_frsapi_IsPathReplicated_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_ISPATHREPLICATED,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frsapi_IsPathReplicated_done, req);
	return req;
}

static void rpccli_frsapi_IsPathReplicated_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frsapi_IsPathReplicated_state *state = tevent_req_data(
		req, struct rpccli_frsapi_IsPathReplicated_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.replicated = *state->tmp.out.replicated;
	*state->orig.out.primary = *state->tmp.out.primary;
	*state->orig.out.root = *state->tmp.out.root;
	*state->orig.out.replica_set_guid = *state->tmp.out.replica_set_guid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frsapi_IsPathReplicated_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct rpccli_frsapi_IsPathReplicated_state *state = tevent_req_data(
		req, struct rpccli_frsapi_IsPathReplicated_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_IsPathReplicated(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *path /* [in] [unique,charset(UTF16)] */,
					enum frsapi_ReplicaSetType replica_set_type /* [in]  */,
					uint32_t *replicated /* [out] [ref] */,
					uint32_t *primary /* [out] [ref] */,
					uint32_t *root /* [out] [ref] */,
					struct GUID *replica_set_guid /* [out] [ref] */,
					WERROR *werror)
{
	struct frsapi_IsPathReplicated r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = path;
	r.in.replica_set_type = replica_set_type;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_ISPATHREPLICATED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*replicated = *r.out.replicated;
	*primary = *r.out.primary;
	*root = *r.out.root;
	*replica_set_guid = *r.out.replica_set_guid;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frsapi_WriterCommand_state {
	struct frsapi_WriterCommand orig;
	struct frsapi_WriterCommand tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frsapi_WriterCommand_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frsapi_WriterCommand_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    enum frsapi_WriterCommandsValues _command /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_frsapi_WriterCommand_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frsapi_WriterCommand_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.command = _command;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_WRITERCOMMAND,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frsapi_WriterCommand_done, req);
	return req;
}

static void rpccli_frsapi_WriterCommand_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frsapi_WriterCommand_state *state = tevent_req_data(
		req, struct rpccli_frsapi_WriterCommand_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frsapi_WriterCommand_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_frsapi_WriterCommand_state *state = tevent_req_data(
		req, struct rpccli_frsapi_WriterCommand_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_WriterCommand(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     enum frsapi_WriterCommandsValues command /* [in]  */,
				     WERROR *werror)
{
	struct frsapi_WriterCommand r;
	NTSTATUS status;

	/* In parameters */
	r.in.command = command;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_WRITERCOMMAND,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_frsapi_ForceReplication_state {
	struct frsapi_ForceReplication orig;
	struct frsapi_ForceReplication tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_frsapi_ForceReplication_done(struct tevent_req *subreq);

struct tevent_req *rpccli_frsapi_ForceReplication_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct GUID *_replica_set_guid /* [in] [unique] */,
						       struct GUID *_connection_guid /* [in] [unique] */,
						       const char *_replica_set_name /* [in] [unique,charset(UTF16)] */,
						       const char *_partner_dns_name /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_frsapi_ForceReplication_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_frsapi_ForceReplication_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.replica_set_guid = _replica_set_guid;
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.replica_set_name = _replica_set_name;
	state->orig.in.partner_dns_name = _partner_dns_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_frsapi,
				    NDR_FRSAPI_FORCEREPLICATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_frsapi_ForceReplication_done, req);
	return req;
}

static void rpccli_frsapi_ForceReplication_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_frsapi_ForceReplication_state *state = tevent_req_data(
		req, struct rpccli_frsapi_ForceReplication_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_frsapi_ForceReplication_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct rpccli_frsapi_ForceReplication_state *state = tevent_req_data(
		req, struct rpccli_frsapi_ForceReplication_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_frsapi_ForceReplication(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct GUID *replica_set_guid /* [in] [unique] */,
					struct GUID *connection_guid /* [in] [unique] */,
					const char *replica_set_name /* [in] [unique,charset(UTF16)] */,
					const char *partner_dns_name /* [in] [unique,charset(UTF16)] */,
					WERROR *werror)
{
	struct frsapi_ForceReplication r;
	NTSTATUS status;

	/* In parameters */
	r.in.replica_set_guid = replica_set_guid;
	r.in.connection_guid = connection_guid;
	r.in.replica_set_name = replica_set_name;
	r.in.partner_dns_name = partner_dns_name;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_frsapi,
				NDR_FRSAPI_FORCEREPLICATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

