#include "../librpc/gen_ndr/ndr_frstrans.h"
#ifndef __CLI_FRSTRANS__
#define __CLI_FRSTRANS__
struct tevent_req *rpccli_frstrans_CheckConnectivity_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct GUID _replica_set_guid /* [in]  */,
							  struct GUID _connection_guid /* [in]  */);
NTSTATUS rpccli_frstrans_CheckConnectivity_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result);
NTSTATUS rpccli_frstrans_CheckConnectivity(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct GUID replica_set_guid /* [in]  */,
					   struct GUID connection_guid /* [in]  */,
					   WERROR *werror);
struct tevent_req *rpccli_frstrans_EstablishConnection_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    struct GUID _replica_set_guid /* [in]  */,
							    struct GUID _connection_guid /* [in]  */,
							    enum frstrans_ProtocolVersion _downstream_protocol_version /* [in]  */,
							    uint32_t _downstream_flags /* [in]  */,
							    enum frstrans_ProtocolVersion *_upstream_protocol_version /* [out] [ref] */,
							    uint32_t *_upstream_flags /* [out] [ref] */);
NTSTATUS rpccli_frstrans_EstablishConnection_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result);
NTSTATUS rpccli_frstrans_EstablishConnection(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct GUID replica_set_guid /* [in]  */,
					     struct GUID connection_guid /* [in]  */,
					     enum frstrans_ProtocolVersion downstream_protocol_version /* [in]  */,
					     uint32_t downstream_flags /* [in]  */,
					     enum frstrans_ProtocolVersion *upstream_protocol_version /* [out] [ref] */,
					     uint32_t *upstream_flags /* [out] [ref] */,
					     WERROR *werror);
struct tevent_req *rpccli_frstrans_EstablishSession_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 struct GUID _connection_guid /* [in]  */,
							 struct GUID _content_set_guid /* [in]  */);
NTSTATUS rpccli_frstrans_EstablishSession_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result);
NTSTATUS rpccli_frstrans_EstablishSession(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct GUID connection_guid /* [in]  */,
					  struct GUID content_set_guid /* [in]  */,
					  WERROR *werror);
struct tevent_req *rpccli_frstrans_RequestUpdates_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct GUID _connection_guid /* [in]  */,
						       struct GUID _content_set_guid /* [in]  */,
						       uint32_t _credits_available /* [in] [range(0,256)] */,
						       uint32_t _hash_requested /* [in] [range(0,1)] */,
						       enum frstrans_UpdateRequestType _update_request_type /* [in] [range(0,2)] */,
						       uint32_t _version_vector_diff_count /* [in]  */,
						       struct frstrans_VersionVector *_version_vector_diff /* [in] [ref,size_is(version_vector_diff_count)] */,
						       struct frstrans_Update *_frs_update /* [out] [ref,length_is(*update_count),size_is(credits_available)] */,
						       uint32_t *_update_count /* [out] [ref] */,
						       enum frstrans_UpdateStatus *_update_status /* [out] [ref] */,
						       struct GUID *_gvsn_db_guid /* [out] [ref] */,
						       uint64_t *_gvsn_version /* [out] [ref] */);
NTSTATUS rpccli_frstrans_RequestUpdates_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result);
NTSTATUS rpccli_frstrans_RequestUpdates(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct GUID connection_guid /* [in]  */,
					struct GUID content_set_guid /* [in]  */,
					uint32_t credits_available /* [in] [range(0,256)] */,
					uint32_t hash_requested /* [in] [range(0,1)] */,
					enum frstrans_UpdateRequestType update_request_type /* [in] [range(0,2)] */,
					uint32_t version_vector_diff_count /* [in]  */,
					struct frstrans_VersionVector *version_vector_diff /* [in] [ref,size_is(version_vector_diff_count)] */,
					struct frstrans_Update *frs_update /* [out] [ref,length_is(*update_count),size_is(credits_available)] */,
					uint32_t *update_count /* [out] [ref] */,
					enum frstrans_UpdateStatus *update_status /* [out] [ref] */,
					struct GUID *gvsn_db_guid /* [out] [ref] */,
					uint64_t *gvsn_version /* [out] [ref] */,
					WERROR *werror);
struct tevent_req *rpccli_frstrans_RequestVersionVector_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     uint32_t _sequence_number /* [in]  */,
							     struct GUID _connection_guid /* [in]  */,
							     struct GUID _content_set_guid /* [in]  */,
							     enum frstrans_VersionRequestType _request_type /* [in] [range(0,2)] */,
							     enum frstrans_VersionChangeType _change_type /* [in] [range(0,2)] */,
							     uint64_t _vv_generation /* [in]  */);
NTSTATUS rpccli_frstrans_RequestVersionVector_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result);
NTSTATUS rpccli_frstrans_RequestVersionVector(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      uint32_t sequence_number /* [in]  */,
					      struct GUID connection_guid /* [in]  */,
					      struct GUID content_set_guid /* [in]  */,
					      enum frstrans_VersionRequestType request_type /* [in] [range(0,2)] */,
					      enum frstrans_VersionChangeType change_type /* [in] [range(0,2)] */,
					      uint64_t vv_generation /* [in]  */,
					      WERROR *werror);
struct tevent_req *rpccli_frstrans_AsyncPoll_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli,
						  struct GUID _connection_guid /* [in]  */,
						  struct frstrans_AsyncResponseContext *_response /* [out] [ref] */);
NTSTATUS rpccli_frstrans_AsyncPoll_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result);
NTSTATUS rpccli_frstrans_AsyncPoll(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct GUID connection_guid /* [in]  */,
				   struct frstrans_AsyncResponseContext *response /* [out] [ref] */,
				   WERROR *werror);
struct tevent_req *rpccli_FRSTRANS_REQUEST_RECORDS_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_REQUEST_RECORDS_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_REQUEST_RECORDS(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_UPDATE_CANCEL_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_UPDATE_CANCEL_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_UPDATE_CANCEL(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_RAW_GET_FILE_DATA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_RDC_GET_SIGNATURES_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_RDC_GET_SIGNATURES_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_RDC_GET_SIGNATURES(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_RDC_GET_FILE_DATA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_RDC_CLOSE_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_RDC_CLOSE_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_RDC_CLOSE(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_frstrans_InitializeFileTransferAsync_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct rpc_pipe_client *cli,
								    struct GUID _connection_guid /* [in]  */,
								    struct frstrans_Update *_frs_update /* [in,out] [ref] */,
								    uint32_t _rdc_desired /* [in] [range(0,1)] */,
								    enum frstrans_RequestedStagingPolicy *_staging_policy /* [in,out] [ref] */,
								    struct policy_handle *_server_context /* [out] [ref] */,
								    struct frstrans_RdcFileInfo **_rdc_file_info /* [out] [ref] */,
								    uint8_t *_data_buffer /* [out] [ref,length_is(*size_read),size_is(buffer_size)] */,
								    uint32_t _buffer_size /* [in] [range(0,262144)] */,
								    uint32_t *_size_read /* [out] [ref] */,
								    uint32_t *_is_end_of_file /* [out] [ref] */);
NTSTATUS rpccli_frstrans_InitializeFileTransferAsync_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result);
NTSTATUS rpccli_frstrans_InitializeFileTransferAsync(struct rpc_pipe_client *cli,
						     TALLOC_CTX *mem_ctx,
						     struct GUID connection_guid /* [in]  */,
						     struct frstrans_Update *frs_update /* [in,out] [ref] */,
						     uint32_t rdc_desired /* [in] [range(0,1)] */,
						     enum frstrans_RequestedStagingPolicy *staging_policy /* [in,out] [ref] */,
						     struct policy_handle *server_context /* [out] [ref] */,
						     struct frstrans_RdcFileInfo **rdc_file_info /* [out] [ref] */,
						     uint8_t *data_buffer /* [out] [ref,length_is(*size_read),size_is(buffer_size)] */,
						     uint32_t buffer_size /* [in] [range(0,262144)] */,
						     uint32_t *size_read /* [out] [ref] */,
						     uint32_t *is_end_of_file /* [out] [ref] */,
						     WERROR *werror);
struct tevent_req *rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(struct rpc_pipe_client *cli,
						       TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_RAW_GET_FILE_DATA_ASYNC(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx);
struct tevent_req *rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct rpc_pipe_client *cli);
NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSTRANS_RDC_GET_FILE_DATA_ASYNC(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx);
#endif /* __CLI_FRSTRANS__ */
