
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_ntlmssp.h"
#include "../librpc/gen_ndr/ndr_ntlmssp_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

staticforward PyTypeObject VERSION_Type;
staticforward PyTypeObject NEGOTIATE_MESSAGE_Type;
staticforward PyTypeObject Restriction_Encoding_Type;
staticforward PyTypeObject AV_PAIR_Type;
staticforward PyTypeObject AV_PAIR_LIST_Type;
staticforward PyTypeObject CHALLENGE_MESSAGE_Type;
staticforward PyTypeObject LM_RESPONSE_Type;
staticforward PyTypeObject LMv2_RESPONSE_Type;
staticforward PyTypeObject NTLM_RESPONSE_Type;
staticforward PyTypeObject NTLMv2_CLIENT_CHALLENGE_Type;
staticforward PyTypeObject NTLMv2_RESPONSE_Type;
staticforward PyTypeObject MIC_Type;
staticforward PyTypeObject AUTHENTICATE_MESSAGE_Type;
staticforward PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_Type;
staticforward PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type;
staticforward PyTypeObject ntlmssp_InterfaceType;


static PyObject *py_VERSION_get_ProductMajorVersion(PyObject *obj, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(obj);
	PyObject *py_ProductMajorVersion;
	py_ProductMajorVersion = PyInt_FromLong(object->ProductMajorVersion);
	return py_ProductMajorVersion;
}

static int py_VERSION_set_ProductMajorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ProductMajorVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_VERSION_get_ProductMinorVersion(PyObject *obj, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(obj);
	PyObject *py_ProductMinorVersion;
	py_ProductMinorVersion = PyInt_FromLong(object->ProductMinorVersion);
	return py_ProductMinorVersion;
}

static int py_VERSION_set_ProductMinorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ProductMinorVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_VERSION_get_ProductBuild(PyObject *obj, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(obj);
	PyObject *py_ProductBuild;
	py_ProductBuild = PyInt_FromLong(object->ProductBuild);
	return py_ProductBuild;
}

static int py_VERSION_set_ProductBuild(PyObject *py_obj, PyObject *value, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ProductBuild = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_VERSION_get_Reserved(PyObject *obj, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyList_New(3);
	if (py_Reserved == NULL) {
		return NULL;
	}
	{
		int Reserved_cntr_0;
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < 3; Reserved_cntr_0++) {
			PyObject *py_Reserved_0;
			py_Reserved_0 = PyInt_FromLong(object->Reserved[Reserved_cntr_0]);
			PyList_SetItem(py_Reserved, Reserved_cntr_0, py_Reserved_0);
		}
	}
	return py_Reserved;
}

static int py_VERSION_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Reserved_cntr_0;
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < PyList_Size(value); Reserved_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, Reserved_cntr_0), return -1;);
			object->Reserved[Reserved_cntr_0] = PyInt_AsLong(PyList_GetItem(value, Reserved_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_VERSION_get_NTLMRevisionCurrent(PyObject *obj, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(obj);
	PyObject *py_NTLMRevisionCurrent;
	py_NTLMRevisionCurrent = PyInt_FromLong(object->NTLMRevisionCurrent);
	return py_NTLMRevisionCurrent;
}

static int py_VERSION_set_NTLMRevisionCurrent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct VERSION *object = (struct VERSION *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NTLMRevisionCurrent = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_VERSION_getsetters[] = {
	{ discard_const_p(char, "ProductMajorVersion"), py_VERSION_get_ProductMajorVersion, py_VERSION_set_ProductMajorVersion },
	{ discard_const_p(char, "ProductMinorVersion"), py_VERSION_get_ProductMinorVersion, py_VERSION_set_ProductMinorVersion },
	{ discard_const_p(char, "ProductBuild"), py_VERSION_get_ProductBuild, py_VERSION_set_ProductBuild },
	{ discard_const_p(char, "Reserved"), py_VERSION_get_Reserved, py_VERSION_set_Reserved },
	{ discard_const_p(char, "NTLMRevisionCurrent"), py_VERSION_get_NTLMRevisionCurrent, py_VERSION_set_NTLMRevisionCurrent },
	{ NULL }
};

static PyObject *py_VERSION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct VERSION, type);
}


static PyTypeObject VERSION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.VERSION",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_VERSION_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_VERSION_new,
};

PyObject *py_import_ntlmssp_Version(TALLOC_CTX *mem_ctx, int level, union ntlmssp_Version *in)
{
	PyObject *ret;

	switch (level) {
		case NTLMSSP_NEGOTIATE_VERSION:
			ret = py_talloc_reference_ex(&VERSION_Type, mem_ctx, &in->version);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union ntlmssp_Version *py_export_ntlmssp_Version(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_Version *ret = talloc_zero(mem_ctx, union ntlmssp_Version);
	switch (level) {
		case NTLMSSP_NEGOTIATE_VERSION:
			PY_CHECK_TYPE(&VERSION_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->version, py_talloc_get_ptr(in), sizeof(ret->version));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_NEGOTIATE_MESSAGE_get_Signature(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Signature;
	py_Signature = PyUnicode_Decode(object->Signature, strlen(object->Signature), "utf-8", "ignore");
	return py_Signature;
}

static int py_NEGOTIATE_MESSAGE_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->Signature = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyInt_FromLong(object->MessageType);
	return py_MessageType;
}

static int py_NEGOTIATE_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MessageType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_NegotiateFlags(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_NegotiateFlags;
	py_NegotiateFlags = PyInt_FromLong(object->NegotiateFlags);
	return py_NegotiateFlags;
}

static int py_NEGOTIATE_MESSAGE_set_NegotiateFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NegotiateFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_DomainNameLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_DomainNameLen;
	py_DomainNameLen = PyInt_FromLong(object->DomainNameLen);
	return py_DomainNameLen;
}

static int py_NEGOTIATE_MESSAGE_set_DomainNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DomainNameLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_DomainNameMaxLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_DomainNameMaxLen;
	py_DomainNameMaxLen = PyInt_FromLong(object->DomainNameMaxLen);
	return py_DomainNameMaxLen;
}

static int py_NEGOTIATE_MESSAGE_set_DomainNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DomainNameMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_DomainName(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_DomainName;
	if (object->DomainName == NULL) {
		py_DomainName = Py_None;
	} else {
		py_DomainName = PyString_FromString(*object->DomainName);
	}
	return py_DomainName;
}

static int py_NEGOTIATE_MESSAGE_set_DomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->DomainName);
	if (value == Py_None) {
		object->DomainName = NULL;
	} else {
		object->DomainName = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->DomainName);
		*object->DomainName = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_WorkstationLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_WorkstationLen;
	py_WorkstationLen = PyInt_FromLong(object->WorkstationLen);
	return py_WorkstationLen;
}

static int py_NEGOTIATE_MESSAGE_set_WorkstationLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->WorkstationLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_WorkstationMaxLen(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_WorkstationMaxLen;
	py_WorkstationMaxLen = PyInt_FromLong(object->WorkstationMaxLen);
	return py_WorkstationMaxLen;
}

static int py_NEGOTIATE_MESSAGE_set_WorkstationMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->WorkstationMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_Workstation(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Workstation;
	if (object->Workstation == NULL) {
		py_Workstation = Py_None;
	} else {
		py_Workstation = PyString_FromString(*object->Workstation);
	}
	return py_Workstation;
}

static int py_NEGOTIATE_MESSAGE_set_Workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->Workstation);
	if (value == Py_None) {
		object->Workstation = NULL;
	} else {
		object->Workstation = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->Workstation);
		*object->Workstation = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	}
	return 0;
}

static PyObject *py_NEGOTIATE_MESSAGE_get_Version(PyObject *obj, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = py_import_ntlmssp_Version(py_talloc_get_mem_ctx(obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, &object->Version);
	if (py_Version == NULL) {
		return NULL;
	}
	return py_Version;
}

static int py_NEGOTIATE_MESSAGE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	memcpy(&object->Version, py_export_ntlmssp_Version(py_talloc_get_mem_ctx(py_obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, value), sizeof(object->Version));
	return 0;
}

static PyGetSetDef py_NEGOTIATE_MESSAGE_getsetters[] = {
	{ discard_const_p(char, "Signature"), py_NEGOTIATE_MESSAGE_get_Signature, py_NEGOTIATE_MESSAGE_set_Signature },
	{ discard_const_p(char, "MessageType"), py_NEGOTIATE_MESSAGE_get_MessageType, py_NEGOTIATE_MESSAGE_set_MessageType },
	{ discard_const_p(char, "NegotiateFlags"), py_NEGOTIATE_MESSAGE_get_NegotiateFlags, py_NEGOTIATE_MESSAGE_set_NegotiateFlags },
	{ discard_const_p(char, "DomainNameLen"), py_NEGOTIATE_MESSAGE_get_DomainNameLen, py_NEGOTIATE_MESSAGE_set_DomainNameLen },
	{ discard_const_p(char, "DomainNameMaxLen"), py_NEGOTIATE_MESSAGE_get_DomainNameMaxLen, py_NEGOTIATE_MESSAGE_set_DomainNameMaxLen },
	{ discard_const_p(char, "DomainName"), py_NEGOTIATE_MESSAGE_get_DomainName, py_NEGOTIATE_MESSAGE_set_DomainName },
	{ discard_const_p(char, "WorkstationLen"), py_NEGOTIATE_MESSAGE_get_WorkstationLen, py_NEGOTIATE_MESSAGE_set_WorkstationLen },
	{ discard_const_p(char, "WorkstationMaxLen"), py_NEGOTIATE_MESSAGE_get_WorkstationMaxLen, py_NEGOTIATE_MESSAGE_set_WorkstationMaxLen },
	{ discard_const_p(char, "Workstation"), py_NEGOTIATE_MESSAGE_get_Workstation, py_NEGOTIATE_MESSAGE_set_Workstation },
	{ discard_const_p(char, "Version"), py_NEGOTIATE_MESSAGE_get_Version, py_NEGOTIATE_MESSAGE_set_Version },
	{ NULL }
};

static PyObject *py_NEGOTIATE_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct NEGOTIATE_MESSAGE, type);
}

static PyObject *py_NEGOTIATE_MESSAGE_ndr_pack(PyObject *py_obj)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_NEGOTIATE_MESSAGE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NEGOTIATE_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct NEGOTIATE_MESSAGE *object = (struct NEGOTIATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_NEGOTIATE_MESSAGE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_NEGOTIATE_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NEGOTIATE_MESSAGE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NEGOTIATE_MESSAGE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NEGOTIATE_MESSAGE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.NEGOTIATE_MESSAGE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_NEGOTIATE_MESSAGE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_NEGOTIATE_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NEGOTIATE_MESSAGE_new,
};


static PyObject *py_Restriction_Encoding_get_Size(PyObject *obj, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(obj);
	PyObject *py_Size;
	py_Size = PyInt_FromLong(object->Size);
	return py_Size;
}

static int py_Restriction_Encoding_set_Size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_Restriction_Encoding_get_Z4(PyObject *obj, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(obj);
	PyObject *py_Z4;
	py_Z4 = PyInt_FromLong(object->Z4);
	return py_Z4;
}

static int py_Restriction_Encoding_set_Z4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Z4 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_Restriction_Encoding_get_IntegrityLevel(PyObject *obj, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(obj);
	PyObject *py_IntegrityLevel;
	py_IntegrityLevel = PyInt_FromLong(object->IntegrityLevel);
	return py_IntegrityLevel;
}

static int py_Restriction_Encoding_set_IntegrityLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->IntegrityLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_Restriction_Encoding_get_SubjectIntegrityLevel(PyObject *obj, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(obj);
	PyObject *py_SubjectIntegrityLevel;
	py_SubjectIntegrityLevel = PyInt_FromLong(object->SubjectIntegrityLevel);
	return py_SubjectIntegrityLevel;
}

static int py_Restriction_Encoding_set_SubjectIntegrityLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SubjectIntegrityLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_Restriction_Encoding_get_MachineId(PyObject *obj, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(obj);
	PyObject *py_MachineId;
	py_MachineId = PyList_New(32);
	if (py_MachineId == NULL) {
		return NULL;
	}
	{
		int MachineId_cntr_0;
		for (MachineId_cntr_0 = 0; MachineId_cntr_0 < 32; MachineId_cntr_0++) {
			PyObject *py_MachineId_0;
			py_MachineId_0 = PyInt_FromLong(object->MachineId[MachineId_cntr_0]);
			PyList_SetItem(py_MachineId, MachineId_cntr_0, py_MachineId_0);
		}
	}
	return py_MachineId;
}

static int py_Restriction_Encoding_set_MachineId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct Restriction_Encoding *object = (struct Restriction_Encoding *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int MachineId_cntr_0;
		for (MachineId_cntr_0 = 0; MachineId_cntr_0 < PyList_Size(value); MachineId_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, MachineId_cntr_0), return -1;);
			object->MachineId[MachineId_cntr_0] = PyInt_AsLong(PyList_GetItem(value, MachineId_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_Restriction_Encoding_getsetters[] = {
	{ discard_const_p(char, "Size"), py_Restriction_Encoding_get_Size, py_Restriction_Encoding_set_Size },
	{ discard_const_p(char, "Z4"), py_Restriction_Encoding_get_Z4, py_Restriction_Encoding_set_Z4 },
	{ discard_const_p(char, "IntegrityLevel"), py_Restriction_Encoding_get_IntegrityLevel, py_Restriction_Encoding_set_IntegrityLevel },
	{ discard_const_p(char, "SubjectIntegrityLevel"), py_Restriction_Encoding_get_SubjectIntegrityLevel, py_Restriction_Encoding_set_SubjectIntegrityLevel },
	{ discard_const_p(char, "MachineId"), py_Restriction_Encoding_get_MachineId, py_Restriction_Encoding_set_MachineId },
	{ NULL }
};

static PyObject *py_Restriction_Encoding_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct Restriction_Encoding, type);
}


static PyTypeObject Restriction_Encoding_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.Restriction_Encoding",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_Restriction_Encoding_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_Restriction_Encoding_new,
};

PyObject *py_import_ntlmssp_AvValue(TALLOC_CTX *mem_ctx, int level, union ntlmssp_AvValue *in)
{
	PyObject *ret;

	switch (level) {
		case MsvAvEOL:
			ret = Py_None;
			return ret;

		case MsvAvNbComputerName:
			ret = PyString_FromString(in->AvNbComputerName);
			return ret;

		case MsvAvNbDomainName:
			ret = PyString_FromString(in->AvNbDomainName);
			return ret;

		case MsvAvDnsComputerName:
			ret = PyString_FromString(in->AvDnsComputerName);
			return ret;

		case MsvAvDnsDomainName:
			ret = PyString_FromString(in->AvDnsDomainName);
			return ret;

		case MsvAvDnsTreeName:
			ret = PyString_FromString(in->AvDnsTreeName);
			return ret;

		case MsvAvFlags:
			ret = PyInt_FromLong(in->AvFlags);
			return ret;

		case MsvAvTimestamp:
			ret = PyInt_FromLong(in->AvTimestamp);
			return ret;

		case MsAvRestrictions:
			ret = py_talloc_reference_ex(&Restriction_Encoding_Type, mem_ctx, &in->AvRestrictions);
			return ret;

		case MsvAvTargetName:
			ret = PyString_FromString(in->AvTargetName);
			return ret;

		case MsvChannelBindings:
			ret = PyList_New(16);
			if (ret == NULL) {
				return NULL;
			}
			{
				int ChannelBindings_cntr_0;
				for (ChannelBindings_cntr_0 = 0; ChannelBindings_cntr_0 < 16; ChannelBindings_cntr_0++) {
					PyObject *py_ChannelBindings_0;
					py_ChannelBindings_0 = PyInt_FromLong(in->ChannelBindings[ChannelBindings_cntr_0]);
					PyList_SetItem(ret, ChannelBindings_cntr_0, py_ChannelBindings_0);
				}
			}
			return ret;

		default:
			ret = PyString_FromStringAndSize((char *)(in->blob).data, (in->blob).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union ntlmssp_AvValue *py_export_ntlmssp_AvValue(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_AvValue *ret = talloc_zero(mem_ctx, union ntlmssp_AvValue);
	switch (level) {
		case MsvAvEOL:
			break;

		case MsvAvNbComputerName:
			ret->AvNbComputerName = talloc_strdup(mem_ctx, PyString_AsString(in));
			break;

		case MsvAvNbDomainName:
			ret->AvNbDomainName = talloc_strdup(mem_ctx, PyString_AsString(in));
			break;

		case MsvAvDnsComputerName:
			ret->AvDnsComputerName = talloc_strdup(mem_ctx, PyString_AsString(in));
			break;

		case MsvAvDnsDomainName:
			ret->AvDnsDomainName = talloc_strdup(mem_ctx, PyString_AsString(in));
			break;

		case MsvAvDnsTreeName:
			ret->AvDnsTreeName = talloc_strdup(mem_ctx, PyString_AsString(in));
			break;

		case MsvAvFlags:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->AvFlags = PyInt_AsLong(in);
			break;

		case MsvAvTimestamp:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->AvTimestamp = PyInt_AsLong(in);
			break;

		case MsAvRestrictions:
			PY_CHECK_TYPE(&Restriction_Encoding_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->AvRestrictions, py_talloc_get_ptr(in), sizeof(ret->AvRestrictions));
			break;

		case MsvAvTargetName:
			ret->AvTargetName = talloc_strdup(mem_ctx, PyString_AsString(in));
			break;

		case MsvChannelBindings:
			PY_CHECK_TYPE(&PyList_Type, in, talloc_free(ret); return NULL;);
			{
				int ChannelBindings_cntr_0;
				for (ChannelBindings_cntr_0 = 0; ChannelBindings_cntr_0 < PyList_Size(in); ChannelBindings_cntr_0++) {
					PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(in, ChannelBindings_cntr_0), talloc_free(ret); return NULL;);
					ret->ChannelBindings[ChannelBindings_cntr_0] = PyInt_AsLong(PyList_GetItem(in, ChannelBindings_cntr_0));
				}
			}
			break;

		default:
			ret->blob = data_blob_talloc(mem_ctx, PyString_AsString(in), PyString_Size(in));
			break;

	}

	return ret;
}


static PyObject *py_AV_PAIR_get_AvId(PyObject *obj, void *closure)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(obj);
	PyObject *py_AvId;
	py_AvId = PyInt_FromLong(object->AvId);
	return py_AvId;
}

static int py_AV_PAIR_set_AvId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->AvId = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AV_PAIR_get_AvLen(PyObject *obj, void *closure)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(obj);
	PyObject *py_AvLen;
	py_AvLen = PyInt_FromLong(object->AvLen);
	return py_AvLen;
}

static int py_AV_PAIR_set_AvLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->AvLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AV_PAIR_get_Value(PyObject *obj, void *closure)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(obj);
	PyObject *py_Value;
	py_Value = py_import_ntlmssp_AvValue(py_talloc_get_mem_ctx(obj), object->AvId, &object->Value);
	if (py_Value == NULL) {
		return NULL;
	}
	return py_Value;
}

static int py_AV_PAIR_set_Value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(py_obj);
	memcpy(&object->Value, py_export_ntlmssp_AvValue(py_talloc_get_mem_ctx(py_obj), object->AvId, value), sizeof(object->Value));
	return 0;
}

static PyGetSetDef py_AV_PAIR_getsetters[] = {
	{ discard_const_p(char, "AvId"), py_AV_PAIR_get_AvId, py_AV_PAIR_set_AvId },
	{ discard_const_p(char, "AvLen"), py_AV_PAIR_get_AvLen, py_AV_PAIR_set_AvLen },
	{ discard_const_p(char, "Value"), py_AV_PAIR_get_Value, py_AV_PAIR_set_Value },
	{ NULL }
};

static PyObject *py_AV_PAIR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct AV_PAIR, type);
}

static PyObject *py_AV_PAIR_ndr_pack(PyObject *py_obj)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_AV_PAIR);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_AV_PAIR_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct AV_PAIR *object = (struct AV_PAIR *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_AV_PAIR);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_AV_PAIR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_AV_PAIR_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_AV_PAIR_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject AV_PAIR_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.AV_PAIR",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_AV_PAIR_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_AV_PAIR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AV_PAIR_new,
};


static PyObject *py_AV_PAIR_LIST_get_count(PyObject *obj, void *closure)
{
	struct AV_PAIR_LIST *object = (struct AV_PAIR_LIST *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_AV_PAIR_LIST_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR_LIST *object = (struct AV_PAIR_LIST *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AV_PAIR_LIST_get_pair(PyObject *obj, void *closure)
{
	struct AV_PAIR_LIST *object = (struct AV_PAIR_LIST *)py_talloc_get_ptr(obj);
	PyObject *py_pair;
	py_pair = PyList_New(object->count);
	if (py_pair == NULL) {
		return NULL;
	}
	{
		int pair_cntr_0;
		for (pair_cntr_0 = 0; pair_cntr_0 < object->count; pair_cntr_0++) {
			PyObject *py_pair_0;
			py_pair_0 = py_talloc_reference_ex(&AV_PAIR_Type, object->pair, &object->pair[pair_cntr_0]);
			PyList_SetItem(py_pair, pair_cntr_0, py_pair_0);
		}
	}
	return py_pair;
}

static int py_AV_PAIR_LIST_set_pair(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AV_PAIR_LIST *object = (struct AV_PAIR_LIST *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pair_cntr_0;
		object->pair = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->pair, PyList_Size(value));
		for (pair_cntr_0 = 0; pair_cntr_0 < PyList_Size(value); pair_cntr_0++) {
			PY_CHECK_TYPE(&AV_PAIR_Type, PyList_GetItem(value, pair_cntr_0), return -1;);
			memcpy(&object->pair[pair_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, pair_cntr_0)), sizeof(object->pair[pair_cntr_0]));
		}
	}
	return 0;
}

static PyGetSetDef py_AV_PAIR_LIST_getsetters[] = {
	{ discard_const_p(char, "count"), py_AV_PAIR_LIST_get_count, py_AV_PAIR_LIST_set_count },
	{ discard_const_p(char, "pair"), py_AV_PAIR_LIST_get_pair, py_AV_PAIR_LIST_set_pair },
	{ NULL }
};

static PyObject *py_AV_PAIR_LIST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct AV_PAIR_LIST, type);
}


static PyTypeObject AV_PAIR_LIST_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.AV_PAIR_LIST",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_AV_PAIR_LIST_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AV_PAIR_LIST_new,
};


static PyObject *py_CHALLENGE_MESSAGE_get_Signature(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Signature;
	py_Signature = PyUnicode_Decode(object->Signature, strlen(object->Signature), "utf-8", "ignore");
	return py_Signature;
}

static int py_CHALLENGE_MESSAGE_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->Signature = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyInt_FromLong(object->MessageType);
	return py_MessageType;
}

static int py_CHALLENGE_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MessageType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetNameLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_TargetNameLen;
	py_TargetNameLen = PyInt_FromLong(object->TargetNameLen);
	return py_TargetNameLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->TargetNameLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetNameMaxLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_TargetNameMaxLen;
	py_TargetNameMaxLen = PyInt_FromLong(object->TargetNameMaxLen);
	return py_TargetNameMaxLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->TargetNameMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetName(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_TargetName;
	if (object->TargetName == NULL) {
		py_TargetName = Py_None;
	} else {
		py_TargetName = PyString_FromString(*object->TargetName);
	}
	return py_TargetName;
}

static int py_CHALLENGE_MESSAGE_set_TargetName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->TargetName);
	if (value == Py_None) {
		object->TargetName = NULL;
	} else {
		object->TargetName = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->TargetName);
		*object->TargetName = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_NegotiateFlags(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_NegotiateFlags;
	py_NegotiateFlags = PyInt_FromLong(object->NegotiateFlags);
	return py_NegotiateFlags;
}

static int py_CHALLENGE_MESSAGE_set_NegotiateFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NegotiateFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_ServerChallenge(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_ServerChallenge;
	py_ServerChallenge = PyList_New(8);
	if (py_ServerChallenge == NULL) {
		return NULL;
	}
	{
		int ServerChallenge_cntr_0;
		for (ServerChallenge_cntr_0 = 0; ServerChallenge_cntr_0 < 8; ServerChallenge_cntr_0++) {
			PyObject *py_ServerChallenge_0;
			py_ServerChallenge_0 = PyInt_FromLong(object->ServerChallenge[ServerChallenge_cntr_0]);
			PyList_SetItem(py_ServerChallenge, ServerChallenge_cntr_0, py_ServerChallenge_0);
		}
	}
	return py_ServerChallenge;
}

static int py_CHALLENGE_MESSAGE_set_ServerChallenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ServerChallenge_cntr_0;
		for (ServerChallenge_cntr_0 = 0; ServerChallenge_cntr_0 < PyList_Size(value); ServerChallenge_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, ServerChallenge_cntr_0), return -1;);
			object->ServerChallenge[ServerChallenge_cntr_0] = PyInt_AsLong(PyList_GetItem(value, ServerChallenge_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_Reserved(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyList_New(8);
	if (py_Reserved == NULL) {
		return NULL;
	}
	{
		int Reserved_cntr_0;
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < 8; Reserved_cntr_0++) {
			PyObject *py_Reserved_0;
			py_Reserved_0 = PyInt_FromLong(object->Reserved[Reserved_cntr_0]);
			PyList_SetItem(py_Reserved, Reserved_cntr_0, py_Reserved_0);
		}
	}
	return py_Reserved;
}

static int py_CHALLENGE_MESSAGE_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Reserved_cntr_0;
		for (Reserved_cntr_0 = 0; Reserved_cntr_0 < PyList_Size(value); Reserved_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, Reserved_cntr_0), return -1;);
			object->Reserved[Reserved_cntr_0] = PyInt_AsLong(PyList_GetItem(value, Reserved_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetInfoLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_TargetInfoLen;
	py_TargetInfoLen = PyInt_FromLong(object->TargetInfoLen);
	return py_TargetInfoLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetInfoLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->TargetInfoLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetNameInfoMaxLen(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_TargetNameInfoMaxLen;
	py_TargetNameInfoMaxLen = PyInt_FromLong(object->TargetNameInfoMaxLen);
	return py_TargetNameInfoMaxLen;
}

static int py_CHALLENGE_MESSAGE_set_TargetNameInfoMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->TargetNameInfoMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_TargetInfo(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_TargetInfo;
	if (object->TargetInfo == NULL) {
		py_TargetInfo = Py_None;
	} else {
		py_TargetInfo = py_talloc_reference_ex(&AV_PAIR_LIST_Type, object->TargetInfo, object->TargetInfo);
	}
	return py_TargetInfo;
}

static int py_CHALLENGE_MESSAGE_set_TargetInfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->TargetInfo);
	if (value == Py_None) {
		object->TargetInfo = NULL;
	} else {
		object->TargetInfo = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->TargetInfo);
		PY_CHECK_TYPE(&AV_PAIR_LIST_Type, value, return -1;);
		object->TargetInfo = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_CHALLENGE_MESSAGE_get_Version(PyObject *obj, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = py_import_ntlmssp_Version(py_talloc_get_mem_ctx(obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, &object->Version);
	if (py_Version == NULL) {
		return NULL;
	}
	return py_Version;
}

static int py_CHALLENGE_MESSAGE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	memcpy(&object->Version, py_export_ntlmssp_Version(py_talloc_get_mem_ctx(py_obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, value), sizeof(object->Version));
	return 0;
}

static PyGetSetDef py_CHALLENGE_MESSAGE_getsetters[] = {
	{ discard_const_p(char, "Signature"), py_CHALLENGE_MESSAGE_get_Signature, py_CHALLENGE_MESSAGE_set_Signature },
	{ discard_const_p(char, "MessageType"), py_CHALLENGE_MESSAGE_get_MessageType, py_CHALLENGE_MESSAGE_set_MessageType },
	{ discard_const_p(char, "TargetNameLen"), py_CHALLENGE_MESSAGE_get_TargetNameLen, py_CHALLENGE_MESSAGE_set_TargetNameLen },
	{ discard_const_p(char, "TargetNameMaxLen"), py_CHALLENGE_MESSAGE_get_TargetNameMaxLen, py_CHALLENGE_MESSAGE_set_TargetNameMaxLen },
	{ discard_const_p(char, "TargetName"), py_CHALLENGE_MESSAGE_get_TargetName, py_CHALLENGE_MESSAGE_set_TargetName },
	{ discard_const_p(char, "NegotiateFlags"), py_CHALLENGE_MESSAGE_get_NegotiateFlags, py_CHALLENGE_MESSAGE_set_NegotiateFlags },
	{ discard_const_p(char, "ServerChallenge"), py_CHALLENGE_MESSAGE_get_ServerChallenge, py_CHALLENGE_MESSAGE_set_ServerChallenge },
	{ discard_const_p(char, "Reserved"), py_CHALLENGE_MESSAGE_get_Reserved, py_CHALLENGE_MESSAGE_set_Reserved },
	{ discard_const_p(char, "TargetInfoLen"), py_CHALLENGE_MESSAGE_get_TargetInfoLen, py_CHALLENGE_MESSAGE_set_TargetInfoLen },
	{ discard_const_p(char, "TargetNameInfoMaxLen"), py_CHALLENGE_MESSAGE_get_TargetNameInfoMaxLen, py_CHALLENGE_MESSAGE_set_TargetNameInfoMaxLen },
	{ discard_const_p(char, "TargetInfo"), py_CHALLENGE_MESSAGE_get_TargetInfo, py_CHALLENGE_MESSAGE_set_TargetInfo },
	{ discard_const_p(char, "Version"), py_CHALLENGE_MESSAGE_get_Version, py_CHALLENGE_MESSAGE_set_Version },
	{ NULL }
};

static PyObject *py_CHALLENGE_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct CHALLENGE_MESSAGE, type);
}

static PyObject *py_CHALLENGE_MESSAGE_ndr_pack(PyObject *py_obj)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_CHALLENGE_MESSAGE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_CHALLENGE_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct CHALLENGE_MESSAGE *object = (struct CHALLENGE_MESSAGE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_CHALLENGE_MESSAGE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_CHALLENGE_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CHALLENGE_MESSAGE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_CHALLENGE_MESSAGE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CHALLENGE_MESSAGE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.CHALLENGE_MESSAGE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_CHALLENGE_MESSAGE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_CHALLENGE_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CHALLENGE_MESSAGE_new,
};


static PyObject *py_LM_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct LM_RESPONSE *object = (struct LM_RESPONSE *)py_talloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(24);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < 24; Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyInt_FromLong(object->Response[Response_cntr_0]);
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_LM_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LM_RESPONSE *object = (struct LM_RESPONSE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_Size(value); Response_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, Response_cntr_0), return -1;);
			object->Response[Response_cntr_0] = PyInt_AsLong(PyList_GetItem(value, Response_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_LM_RESPONSE_getsetters[] = {
	{ discard_const_p(char, "Response"), py_LM_RESPONSE_get_Response, py_LM_RESPONSE_set_Response },
	{ NULL }
};

static PyObject *py_LM_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct LM_RESPONSE, type);
}

static PyObject *py_LM_RESPONSE_ndr_pack(PyObject *py_obj)
{
	struct LM_RESPONSE *object = (struct LM_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_LM_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_LM_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct LM_RESPONSE *object = (struct LM_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_LM_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_LM_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_LM_RESPONSE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_LM_RESPONSE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject LM_RESPONSE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.LM_RESPONSE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_LM_RESPONSE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_LM_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_LM_RESPONSE_new,
};


static PyObject *py_LMv2_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct LMv2_RESPONSE *object = (struct LMv2_RESPONSE *)py_talloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(16);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < 16; Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyInt_FromLong(object->Response[Response_cntr_0]);
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_LMv2_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LMv2_RESPONSE *object = (struct LMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_Size(value); Response_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, Response_cntr_0), return -1;);
			object->Response[Response_cntr_0] = PyInt_AsLong(PyList_GetItem(value, Response_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_LMv2_RESPONSE_get_ChallengeFromClient(PyObject *obj, void *closure)
{
	struct LMv2_RESPONSE *object = (struct LMv2_RESPONSE *)py_talloc_get_ptr(obj);
	PyObject *py_ChallengeFromClient;
	py_ChallengeFromClient = PyList_New(8);
	if (py_ChallengeFromClient == NULL) {
		return NULL;
	}
	{
		int ChallengeFromClient_cntr_0;
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < 8; ChallengeFromClient_cntr_0++) {
			PyObject *py_ChallengeFromClient_0;
			py_ChallengeFromClient_0 = PyInt_FromLong(object->ChallengeFromClient[ChallengeFromClient_cntr_0]);
			PyList_SetItem(py_ChallengeFromClient, ChallengeFromClient_cntr_0, py_ChallengeFromClient_0);
		}
	}
	return py_ChallengeFromClient;
}

static int py_LMv2_RESPONSE_set_ChallengeFromClient(PyObject *py_obj, PyObject *value, void *closure)
{
	struct LMv2_RESPONSE *object = (struct LMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ChallengeFromClient_cntr_0;
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < PyList_Size(value); ChallengeFromClient_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, ChallengeFromClient_cntr_0), return -1;);
			object->ChallengeFromClient[ChallengeFromClient_cntr_0] = PyInt_AsLong(PyList_GetItem(value, ChallengeFromClient_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_LMv2_RESPONSE_getsetters[] = {
	{ discard_const_p(char, "Response"), py_LMv2_RESPONSE_get_Response, py_LMv2_RESPONSE_set_Response },
	{ discard_const_p(char, "ChallengeFromClient"), py_LMv2_RESPONSE_get_ChallengeFromClient, py_LMv2_RESPONSE_set_ChallengeFromClient },
	{ NULL }
};

static PyObject *py_LMv2_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct LMv2_RESPONSE, type);
}

static PyObject *py_LMv2_RESPONSE_ndr_pack(PyObject *py_obj)
{
	struct LMv2_RESPONSE *object = (struct LMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_LMv2_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_LMv2_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct LMv2_RESPONSE *object = (struct LMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_LMv2_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_LMv2_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_LMv2_RESPONSE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_LMv2_RESPONSE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject LMv2_RESPONSE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.LMv2_RESPONSE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_LMv2_RESPONSE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_LMv2_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_LMv2_RESPONSE_new,
};

PyObject *py_import_ntlmssp_LM_RESPONSE(TALLOC_CTX *mem_ctx, int level, union ntlmssp_LM_RESPONSE *in)
{
	PyObject *ret;

	switch (level) {
		case 24:
			ret = py_talloc_reference_ex(&LM_RESPONSE_Type, mem_ctx, &in->v1);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union ntlmssp_LM_RESPONSE *py_export_ntlmssp_LM_RESPONSE(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_LM_RESPONSE *ret = talloc_zero(mem_ctx, union ntlmssp_LM_RESPONSE);
	switch (level) {
		case 24:
			PY_CHECK_TYPE(&LM_RESPONSE_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v1, py_talloc_get_ptr(in), sizeof(ret->v1));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_NTLM_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct NTLM_RESPONSE *object = (struct NTLM_RESPONSE *)py_talloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(24);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < 24; Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyInt_FromLong(object->Response[Response_cntr_0]);
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_NTLM_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLM_RESPONSE *object = (struct NTLM_RESPONSE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_Size(value); Response_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, Response_cntr_0), return -1;);
			object->Response[Response_cntr_0] = PyInt_AsLong(PyList_GetItem(value, Response_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_NTLM_RESPONSE_getsetters[] = {
	{ discard_const_p(char, "Response"), py_NTLM_RESPONSE_get_Response, py_NTLM_RESPONSE_set_Response },
	{ NULL }
};

static PyObject *py_NTLM_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct NTLM_RESPONSE, type);
}

static PyObject *py_NTLM_RESPONSE_ndr_pack(PyObject *py_obj)
{
	struct NTLM_RESPONSE *object = (struct NTLM_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_NTLM_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NTLM_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct NTLM_RESPONSE *object = (struct NTLM_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_NTLM_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_NTLM_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLM_RESPONSE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NTLM_RESPONSE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLM_RESPONSE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.NTLM_RESPONSE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_NTLM_RESPONSE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_NTLM_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLM_RESPONSE_new,
};


static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_RespType(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_RespType;
	py_RespType = PyInt_FromLong(object->RespType);
	return py_RespType;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_RespType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->RespType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_HiRespType(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_HiRespType;
	py_HiRespType = PyInt_FromLong(object->HiRespType);
	return py_HiRespType;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_HiRespType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->HiRespType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_Reserved1(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_Reserved1;
	py_Reserved1 = PyInt_FromLong(object->Reserved1);
	return py_Reserved1;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_Reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Reserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_Reserved2(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_Reserved2;
	py_Reserved2 = PyInt_FromLong(object->Reserved2);
	return py_Reserved2;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_Reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Reserved2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_TimeStamp(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_TimeStamp;
	py_TimeStamp = PyInt_FromLong(object->TimeStamp);
	return py_TimeStamp;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_TimeStamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->TimeStamp = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_ChallengeFromClient(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_ChallengeFromClient;
	py_ChallengeFromClient = PyList_New(8);
	if (py_ChallengeFromClient == NULL) {
		return NULL;
	}
	{
		int ChallengeFromClient_cntr_0;
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < 8; ChallengeFromClient_cntr_0++) {
			PyObject *py_ChallengeFromClient_0;
			py_ChallengeFromClient_0 = PyInt_FromLong(object->ChallengeFromClient[ChallengeFromClient_cntr_0]);
			PyList_SetItem(py_ChallengeFromClient, ChallengeFromClient_cntr_0, py_ChallengeFromClient_0);
		}
	}
	return py_ChallengeFromClient;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_ChallengeFromClient(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ChallengeFromClient_cntr_0;
		for (ChallengeFromClient_cntr_0 = 0; ChallengeFromClient_cntr_0 < PyList_Size(value); ChallengeFromClient_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, ChallengeFromClient_cntr_0), return -1;);
			object->ChallengeFromClient[ChallengeFromClient_cntr_0] = PyInt_AsLong(PyList_GetItem(value, ChallengeFromClient_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_Reserved3(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_Reserved3;
	py_Reserved3 = PyInt_FromLong(object->Reserved3);
	return py_Reserved3;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_Reserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Reserved3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_get_AvPairs(PyObject *obj, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(obj);
	PyObject *py_AvPairs;
	py_AvPairs = py_talloc_reference_ex(&AV_PAIR_LIST_Type, py_talloc_get_mem_ctx(obj), &object->AvPairs);
	return py_AvPairs;
}

static int py_NTLMv2_CLIENT_CHALLENGE_set_AvPairs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_CLIENT_CHALLENGE *object = (struct NTLMv2_CLIENT_CHALLENGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&AV_PAIR_LIST_Type, value, return -1;);
	memcpy(&object->AvPairs, py_talloc_get_ptr(value), sizeof(object->AvPairs));
	return 0;
}

static PyGetSetDef py_NTLMv2_CLIENT_CHALLENGE_getsetters[] = {
	{ discard_const_p(char, "RespType"), py_NTLMv2_CLIENT_CHALLENGE_get_RespType, py_NTLMv2_CLIENT_CHALLENGE_set_RespType },
	{ discard_const_p(char, "HiRespType"), py_NTLMv2_CLIENT_CHALLENGE_get_HiRespType, py_NTLMv2_CLIENT_CHALLENGE_set_HiRespType },
	{ discard_const_p(char, "Reserved1"), py_NTLMv2_CLIENT_CHALLENGE_get_Reserved1, py_NTLMv2_CLIENT_CHALLENGE_set_Reserved1 },
	{ discard_const_p(char, "Reserved2"), py_NTLMv2_CLIENT_CHALLENGE_get_Reserved2, py_NTLMv2_CLIENT_CHALLENGE_set_Reserved2 },
	{ discard_const_p(char, "TimeStamp"), py_NTLMv2_CLIENT_CHALLENGE_get_TimeStamp, py_NTLMv2_CLIENT_CHALLENGE_set_TimeStamp },
	{ discard_const_p(char, "ChallengeFromClient"), py_NTLMv2_CLIENT_CHALLENGE_get_ChallengeFromClient, py_NTLMv2_CLIENT_CHALLENGE_set_ChallengeFromClient },
	{ discard_const_p(char, "Reserved3"), py_NTLMv2_CLIENT_CHALLENGE_get_Reserved3, py_NTLMv2_CLIENT_CHALLENGE_set_Reserved3 },
	{ discard_const_p(char, "AvPairs"), py_NTLMv2_CLIENT_CHALLENGE_get_AvPairs, py_NTLMv2_CLIENT_CHALLENGE_set_AvPairs },
	{ NULL }
};

static PyObject *py_NTLMv2_CLIENT_CHALLENGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct NTLMv2_CLIENT_CHALLENGE, type);
}


static PyTypeObject NTLMv2_CLIENT_CHALLENGE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.NTLMv2_CLIENT_CHALLENGE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_NTLMv2_CLIENT_CHALLENGE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMv2_CLIENT_CHALLENGE_new,
};


static PyObject *py_NTLMv2_RESPONSE_get_Response(PyObject *obj, void *closure)
{
	struct NTLMv2_RESPONSE *object = (struct NTLMv2_RESPONSE *)py_talloc_get_ptr(obj);
	PyObject *py_Response;
	py_Response = PyList_New(16);
	if (py_Response == NULL) {
		return NULL;
	}
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < 16; Response_cntr_0++) {
			PyObject *py_Response_0;
			py_Response_0 = PyInt_FromLong(object->Response[Response_cntr_0]);
			PyList_SetItem(py_Response, Response_cntr_0, py_Response_0);
		}
	}
	return py_Response;
}

static int py_NTLMv2_RESPONSE_set_Response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_RESPONSE *object = (struct NTLMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Response_cntr_0;
		for (Response_cntr_0 = 0; Response_cntr_0 < PyList_Size(value); Response_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, Response_cntr_0), return -1;);
			object->Response[Response_cntr_0] = PyInt_AsLong(PyList_GetItem(value, Response_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NTLMv2_RESPONSE_get_Challenge(PyObject *obj, void *closure)
{
	struct NTLMv2_RESPONSE *object = (struct NTLMv2_RESPONSE *)py_talloc_get_ptr(obj);
	PyObject *py_Challenge;
	py_Challenge = py_talloc_reference_ex(&NTLMv2_CLIENT_CHALLENGE_Type, py_talloc_get_mem_ctx(obj), &object->Challenge);
	return py_Challenge;
}

static int py_NTLMv2_RESPONSE_set_Challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMv2_RESPONSE *object = (struct NTLMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&NTLMv2_CLIENT_CHALLENGE_Type, value, return -1;);
	memcpy(&object->Challenge, py_talloc_get_ptr(value), sizeof(object->Challenge));
	return 0;
}

static PyGetSetDef py_NTLMv2_RESPONSE_getsetters[] = {
	{ discard_const_p(char, "Response"), py_NTLMv2_RESPONSE_get_Response, py_NTLMv2_RESPONSE_set_Response },
	{ discard_const_p(char, "Challenge"), py_NTLMv2_RESPONSE_get_Challenge, py_NTLMv2_RESPONSE_set_Challenge },
	{ NULL }
};

static PyObject *py_NTLMv2_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct NTLMv2_RESPONSE, type);
}

static PyObject *py_NTLMv2_RESPONSE_ndr_pack(PyObject *py_obj)
{
	struct NTLMv2_RESPONSE *object = (struct NTLMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_NTLMv2_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NTLMv2_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct NTLMv2_RESPONSE *object = (struct NTLMv2_RESPONSE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_NTLMv2_RESPONSE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_NTLMv2_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLMv2_RESPONSE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NTLMv2_RESPONSE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLMv2_RESPONSE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.NTLMv2_RESPONSE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_NTLMv2_RESPONSE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_NTLMv2_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMv2_RESPONSE_new,
};

PyObject *py_import_ntlmssp_NTLM_RESPONSE(TALLOC_CTX *mem_ctx, int level, union ntlmssp_NTLM_RESPONSE *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = Py_None;
			return ret;

		case 0x18:
			ret = py_talloc_reference_ex(&NTLM_RESPONSE_Type, mem_ctx, &in->v1);
			return ret;

		default:
			ret = py_talloc_reference_ex(&NTLMv2_RESPONSE_Type, mem_ctx, &in->v2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union ntlmssp_NTLM_RESPONSE *py_export_ntlmssp_NTLM_RESPONSE(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ntlmssp_NTLM_RESPONSE *ret = talloc_zero(mem_ctx, union ntlmssp_NTLM_RESPONSE);
	switch (level) {
		case 0:
			break;

		case 0x18:
			PY_CHECK_TYPE(&NTLM_RESPONSE_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v1, py_talloc_get_ptr(in), sizeof(ret->v1));
			break;

		default:
			PY_CHECK_TYPE(&NTLMv2_RESPONSE_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v2, py_talloc_get_ptr(in), sizeof(ret->v2));
			break;

	}

	return ret;
}


static PyObject *py_MIC_get_MIC(PyObject *obj, void *closure)
{
	struct MIC *object = (struct MIC *)py_talloc_get_ptr(obj);
	PyObject *py_MIC;
	py_MIC = PyList_New(16);
	if (py_MIC == NULL) {
		return NULL;
	}
	{
		int MIC_cntr_0;
		for (MIC_cntr_0 = 0; MIC_cntr_0 < 16; MIC_cntr_0++) {
			PyObject *py_MIC_0;
			py_MIC_0 = PyInt_FromLong(object->MIC[MIC_cntr_0]);
			PyList_SetItem(py_MIC, MIC_cntr_0, py_MIC_0);
		}
	}
	return py_MIC;
}

static int py_MIC_set_MIC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct MIC *object = (struct MIC *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int MIC_cntr_0;
		for (MIC_cntr_0 = 0; MIC_cntr_0 < PyList_Size(value); MIC_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, MIC_cntr_0), return -1;);
			object->MIC[MIC_cntr_0] = PyInt_AsLong(PyList_GetItem(value, MIC_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_MIC_getsetters[] = {
	{ discard_const_p(char, "MIC"), py_MIC_get_MIC, py_MIC_set_MIC },
	{ NULL }
};

static PyObject *py_MIC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct MIC, type);
}


static PyTypeObject MIC_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.MIC",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_MIC_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_MIC_new,
};


static PyObject *py_AUTHENTICATE_MESSAGE_get_Signature(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Signature;
	py_Signature = PyUnicode_Decode(object->Signature, strlen(object->Signature), "utf-8", "ignore");
	return py_Signature;
}

static int py_AUTHENTICATE_MESSAGE_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->Signature = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_MessageType(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyInt_FromLong(object->MessageType);
	return py_MessageType;
}

static int py_AUTHENTICATE_MESSAGE_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MessageType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_LmChallengeResponseLen;
	py_LmChallengeResponseLen = PyInt_FromLong(object->LmChallengeResponseLen);
	return py_LmChallengeResponseLen;
}

static int py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->LmChallengeResponseLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_LmChallengeResponseMaxLen;
	py_LmChallengeResponseMaxLen = PyInt_FromLong(object->LmChallengeResponseMaxLen);
	return py_LmChallengeResponseMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->LmChallengeResponseMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_LmChallengeResponse(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_LmChallengeResponse;
	if (object->LmChallengeResponse == NULL) {
		py_LmChallengeResponse = Py_None;
	} else {
		py_LmChallengeResponse = py_import_ntlmssp_LM_RESPONSE(object->LmChallengeResponse, object->LmChallengeResponseLen, object->LmChallengeResponse);
		if (py_LmChallengeResponse == NULL) {
			return NULL;
		}
	}
	return py_LmChallengeResponse;
}

static int py_AUTHENTICATE_MESSAGE_set_LmChallengeResponse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->LmChallengeResponse);
	if (value == Py_None) {
		object->LmChallengeResponse = NULL;
	} else {
		object->LmChallengeResponse = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->LmChallengeResponse);
		object->LmChallengeResponse = py_export_ntlmssp_LM_RESPONSE(py_talloc_get_mem_ctx(py_obj), object->LmChallengeResponseLen, value);
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_NtChallengeResponseLen;
	py_NtChallengeResponseLen = PyInt_FromLong(object->NtChallengeResponseLen);
	return py_NtChallengeResponseLen;
}

static int py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NtChallengeResponseLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_NtChallengeResponseMaxLen;
	py_NtChallengeResponseMaxLen = PyInt_FromLong(object->NtChallengeResponseMaxLen);
	return py_NtChallengeResponseMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NtChallengeResponseMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NtChallengeResponse(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_NtChallengeResponse;
	if (object->NtChallengeResponse == NULL) {
		py_NtChallengeResponse = Py_None;
	} else {
		py_NtChallengeResponse = py_import_ntlmssp_NTLM_RESPONSE(object->NtChallengeResponse, object->NtChallengeResponseLen, object->NtChallengeResponse);
		if (py_NtChallengeResponse == NULL) {
			return NULL;
		}
	}
	return py_NtChallengeResponse;
}

static int py_AUTHENTICATE_MESSAGE_set_NtChallengeResponse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->NtChallengeResponse);
	if (value == Py_None) {
		object->NtChallengeResponse = NULL;
	} else {
		object->NtChallengeResponse = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->NtChallengeResponse);
		object->NtChallengeResponse = py_export_ntlmssp_NTLM_RESPONSE(py_talloc_get_mem_ctx(py_obj), object->NtChallengeResponseLen, value);
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_DomainNameLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_DomainNameLen;
	py_DomainNameLen = PyInt_FromLong(object->DomainNameLen);
	return py_DomainNameLen;
}

static int py_AUTHENTICATE_MESSAGE_set_DomainNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DomainNameLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_DomainNameMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_DomainNameMaxLen;
	py_DomainNameMaxLen = PyInt_FromLong(object->DomainNameMaxLen);
	return py_DomainNameMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_DomainNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DomainNameMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_DomainName(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_DomainName;
	if (object->DomainName == NULL) {
		py_DomainName = Py_None;
	} else {
		py_DomainName = PyString_FromString(*object->DomainName);
	}
	return py_DomainName;
}

static int py_AUTHENTICATE_MESSAGE_set_DomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->DomainName);
	if (value == Py_None) {
		object->DomainName = NULL;
	} else {
		object->DomainName = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->DomainName);
		*object->DomainName = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_UserNameLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_UserNameLen;
	py_UserNameLen = PyInt_FromLong(object->UserNameLen);
	return py_UserNameLen;
}

static int py_AUTHENTICATE_MESSAGE_set_UserNameLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UserNameLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_UserNameMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_UserNameMaxLen;
	py_UserNameMaxLen = PyInt_FromLong(object->UserNameMaxLen);
	return py_UserNameMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_UserNameMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->UserNameMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_UserName(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_UserName;
	if (object->UserName == NULL) {
		py_UserName = Py_None;
	} else {
		py_UserName = PyString_FromString(*object->UserName);
	}
	return py_UserName;
}

static int py_AUTHENTICATE_MESSAGE_set_UserName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->UserName);
	if (value == Py_None) {
		object->UserName = NULL;
	} else {
		object->UserName = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->UserName);
		*object->UserName = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_WorkstationLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_WorkstationLen;
	py_WorkstationLen = PyInt_FromLong(object->WorkstationLen);
	return py_WorkstationLen;
}

static int py_AUTHENTICATE_MESSAGE_set_WorkstationLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->WorkstationLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_WorkstationMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_WorkstationMaxLen;
	py_WorkstationMaxLen = PyInt_FromLong(object->WorkstationMaxLen);
	return py_WorkstationMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_WorkstationMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->WorkstationMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_Workstation(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Workstation;
	if (object->Workstation == NULL) {
		py_Workstation = Py_None;
	} else {
		py_Workstation = PyString_FromString(*object->Workstation);
	}
	return py_Workstation;
}

static int py_AUTHENTICATE_MESSAGE_set_Workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->Workstation);
	if (value == Py_None) {
		object->Workstation = NULL;
	} else {
		object->Workstation = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->Workstation);
		*object->Workstation = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_EncryptedRandomSessionKeyLen;
	py_EncryptedRandomSessionKeyLen = PyInt_FromLong(object->EncryptedRandomSessionKeyLen);
	return py_EncryptedRandomSessionKeyLen;
}

static int py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->EncryptedRandomSessionKeyLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyMaxLen(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_EncryptedRandomSessionKeyMaxLen;
	py_EncryptedRandomSessionKeyMaxLen = PyInt_FromLong(object->EncryptedRandomSessionKeyMaxLen);
	return py_EncryptedRandomSessionKeyMaxLen;
}

static int py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyMaxLen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->EncryptedRandomSessionKeyMaxLen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKey(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_EncryptedRandomSessionKey;
	if (object->EncryptedRandomSessionKey == NULL) {
		py_EncryptedRandomSessionKey = Py_None;
	} else {
		py_EncryptedRandomSessionKey = PyString_FromStringAndSize((char *)(*object->EncryptedRandomSessionKey).data, (*object->EncryptedRandomSessionKey).length);
	}
	return py_EncryptedRandomSessionKey;
}

static int py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	talloc_free(object->EncryptedRandomSessionKey);
	if (value == Py_None) {
		object->EncryptedRandomSessionKey = NULL;
	} else {
		object->EncryptedRandomSessionKey = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->EncryptedRandomSessionKey);
		*object->EncryptedRandomSessionKey = data_blob_talloc(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value), PyString_Size(value));
	}
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_NegotiateFlags(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_NegotiateFlags;
	py_NegotiateFlags = PyInt_FromLong(object->NegotiateFlags);
	return py_NegotiateFlags;
}

static int py_AUTHENTICATE_MESSAGE_set_NegotiateFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->NegotiateFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_AUTHENTICATE_MESSAGE_get_Version(PyObject *obj, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = py_import_ntlmssp_Version(py_talloc_get_mem_ctx(obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, &object->Version);
	if (py_Version == NULL) {
		return NULL;
	}
	return py_Version;
}

static int py_AUTHENTICATE_MESSAGE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	memcpy(&object->Version, py_export_ntlmssp_Version(py_talloc_get_mem_ctx(py_obj), object->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION, value), sizeof(object->Version));
	return 0;
}

static PyGetSetDef py_AUTHENTICATE_MESSAGE_getsetters[] = {
	{ discard_const_p(char, "Signature"), py_AUTHENTICATE_MESSAGE_get_Signature, py_AUTHENTICATE_MESSAGE_set_Signature },
	{ discard_const_p(char, "MessageType"), py_AUTHENTICATE_MESSAGE_get_MessageType, py_AUTHENTICATE_MESSAGE_set_MessageType },
	{ discard_const_p(char, "LmChallengeResponseLen"), py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseLen, py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseLen },
	{ discard_const_p(char, "LmChallengeResponseMaxLen"), py_AUTHENTICATE_MESSAGE_get_LmChallengeResponseMaxLen, py_AUTHENTICATE_MESSAGE_set_LmChallengeResponseMaxLen },
	{ discard_const_p(char, "LmChallengeResponse"), py_AUTHENTICATE_MESSAGE_get_LmChallengeResponse, py_AUTHENTICATE_MESSAGE_set_LmChallengeResponse },
	{ discard_const_p(char, "NtChallengeResponseLen"), py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseLen, py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseLen },
	{ discard_const_p(char, "NtChallengeResponseMaxLen"), py_AUTHENTICATE_MESSAGE_get_NtChallengeResponseMaxLen, py_AUTHENTICATE_MESSAGE_set_NtChallengeResponseMaxLen },
	{ discard_const_p(char, "NtChallengeResponse"), py_AUTHENTICATE_MESSAGE_get_NtChallengeResponse, py_AUTHENTICATE_MESSAGE_set_NtChallengeResponse },
	{ discard_const_p(char, "DomainNameLen"), py_AUTHENTICATE_MESSAGE_get_DomainNameLen, py_AUTHENTICATE_MESSAGE_set_DomainNameLen },
	{ discard_const_p(char, "DomainNameMaxLen"), py_AUTHENTICATE_MESSAGE_get_DomainNameMaxLen, py_AUTHENTICATE_MESSAGE_set_DomainNameMaxLen },
	{ discard_const_p(char, "DomainName"), py_AUTHENTICATE_MESSAGE_get_DomainName, py_AUTHENTICATE_MESSAGE_set_DomainName },
	{ discard_const_p(char, "UserNameLen"), py_AUTHENTICATE_MESSAGE_get_UserNameLen, py_AUTHENTICATE_MESSAGE_set_UserNameLen },
	{ discard_const_p(char, "UserNameMaxLen"), py_AUTHENTICATE_MESSAGE_get_UserNameMaxLen, py_AUTHENTICATE_MESSAGE_set_UserNameMaxLen },
	{ discard_const_p(char, "UserName"), py_AUTHENTICATE_MESSAGE_get_UserName, py_AUTHENTICATE_MESSAGE_set_UserName },
	{ discard_const_p(char, "WorkstationLen"), py_AUTHENTICATE_MESSAGE_get_WorkstationLen, py_AUTHENTICATE_MESSAGE_set_WorkstationLen },
	{ discard_const_p(char, "WorkstationMaxLen"), py_AUTHENTICATE_MESSAGE_get_WorkstationMaxLen, py_AUTHENTICATE_MESSAGE_set_WorkstationMaxLen },
	{ discard_const_p(char, "Workstation"), py_AUTHENTICATE_MESSAGE_get_Workstation, py_AUTHENTICATE_MESSAGE_set_Workstation },
	{ discard_const_p(char, "EncryptedRandomSessionKeyLen"), py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyLen, py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyLen },
	{ discard_const_p(char, "EncryptedRandomSessionKeyMaxLen"), py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKeyMaxLen, py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKeyMaxLen },
	{ discard_const_p(char, "EncryptedRandomSessionKey"), py_AUTHENTICATE_MESSAGE_get_EncryptedRandomSessionKey, py_AUTHENTICATE_MESSAGE_set_EncryptedRandomSessionKey },
	{ discard_const_p(char, "NegotiateFlags"), py_AUTHENTICATE_MESSAGE_get_NegotiateFlags, py_AUTHENTICATE_MESSAGE_set_NegotiateFlags },
	{ discard_const_p(char, "Version"), py_AUTHENTICATE_MESSAGE_get_Version, py_AUTHENTICATE_MESSAGE_set_Version },
	{ NULL }
};

static PyObject *py_AUTHENTICATE_MESSAGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct AUTHENTICATE_MESSAGE, type);
}

static PyObject *py_AUTHENTICATE_MESSAGE_ndr_pack(PyObject *py_obj)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_AUTHENTICATE_MESSAGE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_AUTHENTICATE_MESSAGE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct AUTHENTICATE_MESSAGE *object = (struct AUTHENTICATE_MESSAGE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_AUTHENTICATE_MESSAGE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_AUTHENTICATE_MESSAGE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_AUTHENTICATE_MESSAGE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_AUTHENTICATE_MESSAGE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject AUTHENTICATE_MESSAGE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.AUTHENTICATE_MESSAGE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_AUTHENTICATE_MESSAGE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_AUTHENTICATE_MESSAGE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_AUTHENTICATE_MESSAGE_new,
};


static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_Version(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyInt_FromLong(object->Version);
	return py_Version;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_RandomPad(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(obj);
	PyObject *py_RandomPad;
	py_RandomPad = PyInt_FromLong(object->RandomPad);
	return py_RandomPad;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_RandomPad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->RandomPad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_Checksum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyInt_FromLong(object->Checksum);
	return py_Checksum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Checksum = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_get_SeqNum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(obj);
	PyObject *py_SeqNum;
	py_SeqNum = PyInt_FromLong(object->SeqNum);
	return py_SeqNum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_set_SeqNum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SeqNum = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NTLMSSP_MESSAGE_SIGNATURE_getsetters[] = {
	{ discard_const_p(char, "Version"), py_NTLMSSP_MESSAGE_SIGNATURE_get_Version, py_NTLMSSP_MESSAGE_SIGNATURE_set_Version },
	{ discard_const_p(char, "RandomPad"), py_NTLMSSP_MESSAGE_SIGNATURE_get_RandomPad, py_NTLMSSP_MESSAGE_SIGNATURE_set_RandomPad },
	{ discard_const_p(char, "Checksum"), py_NTLMSSP_MESSAGE_SIGNATURE_get_Checksum, py_NTLMSSP_MESSAGE_SIGNATURE_set_Checksum },
	{ discard_const_p(char, "SeqNum"), py_NTLMSSP_MESSAGE_SIGNATURE_get_SeqNum, py_NTLMSSP_MESSAGE_SIGNATURE_set_SeqNum },
	{ NULL }
};

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct NTLMSSP_MESSAGE_SIGNATURE, type);
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_ndr_pack(PyObject *py_obj)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_NTLMSSP_MESSAGE_SIGNATURE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct NTLMSSP_MESSAGE_SIGNATURE *object = (struct NTLMSSP_MESSAGE_SIGNATURE *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_NTLMSSP_MESSAGE_SIGNATURE);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_NTLMSSP_MESSAGE_SIGNATURE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLMSSP_MESSAGE_SIGNATURE_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NTLMSSP_MESSAGE_SIGNATURE_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.NTLMSSP_MESSAGE_SIGNATURE",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_NTLMSSP_MESSAGE_SIGNATURE_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_NTLMSSP_MESSAGE_SIGNATURE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMSSP_MESSAGE_SIGNATURE_new,
};


static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Version(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyInt_FromLong(object->Version);
	return py_Version;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Checksum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(obj);
	PyObject *py_Checksum;
	py_Checksum = PyList_New(8);
	if (py_Checksum == NULL) {
		return NULL;
	}
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < 8; Checksum_cntr_0++) {
			PyObject *py_Checksum_0;
			py_Checksum_0 = PyInt_FromLong(object->Checksum[Checksum_cntr_0]);
			PyList_SetItem(py_Checksum, Checksum_cntr_0, py_Checksum_0);
		}
	}
	return py_Checksum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Checksum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Checksum_cntr_0;
		for (Checksum_cntr_0 = 0; Checksum_cntr_0 < PyList_Size(value); Checksum_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, Checksum_cntr_0), return -1;);
			object->Checksum[Checksum_cntr_0] = PyInt_AsLong(PyList_GetItem(value, Checksum_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_SeqNum(PyObject *obj, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(obj);
	PyObject *py_SeqNum;
	py_SeqNum = PyInt_FromLong(object->SeqNum);
	return py_SeqNum;
}

static int py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_SeqNum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SeqNum = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_getsetters[] = {
	{ discard_const_p(char, "Version"), py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Version, py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Version },
	{ discard_const_p(char, "Checksum"), py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_Checksum, py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_Checksum },
	{ discard_const_p(char, "SeqNum"), py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_get_SeqNum, py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_set_SeqNum },
	{ NULL }
};

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2, type);
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_pack(PyObject *py_obj)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *object = (struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.NTLMSSP_MESSAGE_SIGNATURE_NTLMv2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_new,
};


static bool pack_py_decode_NEGOTIATE_MESSAGE_args_in(PyObject *args, PyObject *kwargs, struct decode_NEGOTIATE_MESSAGE *r)
{
	PyObject *py_negotiate;
	const char *kwnames[] = {
		"negotiate", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:decode_NEGOTIATE_MESSAGE", discard_const_p(char *, kwnames), &py_negotiate)) {
		return false;
	}

	PY_CHECK_TYPE(&NEGOTIATE_MESSAGE_Type, py_negotiate, return false;);
	memcpy(&r->in.negotiate, py_talloc_get_ptr(py_negotiate), sizeof(r->in.negotiate));
	return true;
}

static PyObject *unpack_py_decode_NEGOTIATE_MESSAGE_args_out(struct decode_NEGOTIATE_MESSAGE *r)
{
	PyObject *result = Py_None;
	return result;
}

static bool pack_py_decode_CHALLENGE_MESSAGE_args_in(PyObject *args, PyObject *kwargs, struct decode_CHALLENGE_MESSAGE *r)
{
	PyObject *py_challenge;
	const char *kwnames[] = {
		"challenge", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:decode_CHALLENGE_MESSAGE", discard_const_p(char *, kwnames), &py_challenge)) {
		return false;
	}

	PY_CHECK_TYPE(&CHALLENGE_MESSAGE_Type, py_challenge, return false;);
	memcpy(&r->in.challenge, py_talloc_get_ptr(py_challenge), sizeof(r->in.challenge));
	return true;
}

static PyObject *unpack_py_decode_CHALLENGE_MESSAGE_args_out(struct decode_CHALLENGE_MESSAGE *r)
{
	PyObject *result = Py_None;
	return result;
}

static bool pack_py_decode_AUTHENTICATE_MESSAGE_args_in(PyObject *args, PyObject *kwargs, struct decode_AUTHENTICATE_MESSAGE *r)
{
	PyObject *py_authenticate;
	const char *kwnames[] = {
		"authenticate", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:decode_AUTHENTICATE_MESSAGE", discard_const_p(char *, kwnames), &py_authenticate)) {
		return false;
	}

	PY_CHECK_TYPE(&AUTHENTICATE_MESSAGE_Type, py_authenticate, return false;);
	memcpy(&r->in.authenticate, py_talloc_get_ptr(py_authenticate), sizeof(r->in.authenticate));
	return true;
}

static PyObject *unpack_py_decode_AUTHENTICATE_MESSAGE_args_out(struct decode_AUTHENTICATE_MESSAGE *r)
{
	PyObject *result = Py_None;
	return result;
}

static bool pack_py_decode_NTLMv2_CLIENT_CHALLENGE_args_in(PyObject *args, PyObject *kwargs, struct decode_NTLMv2_CLIENT_CHALLENGE *r)
{
	PyObject *py_challenge;
	const char *kwnames[] = {
		"challenge", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:decode_NTLMv2_CLIENT_CHALLENGE", discard_const_p(char *, kwnames), &py_challenge)) {
		return false;
	}

	PY_CHECK_TYPE(&NTLMv2_CLIENT_CHALLENGE_Type, py_challenge, return false;);
	memcpy(&r->in.challenge, py_talloc_get_ptr(py_challenge), sizeof(r->in.challenge));
	return true;
}

static PyObject *unpack_py_decode_NTLMv2_CLIENT_CHALLENGE_args_out(struct decode_NTLMv2_CLIENT_CHALLENGE *r)
{
	PyObject *result = Py_None;
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_ntlmssp_methods[] = {
	{ "decode_NEGOTIATE_MESSAGE", "S.decode_NEGOTIATE_MESSAGE(negotiate) -> None", (dcerpc_call_fn)dcerpc_decode_NEGOTIATE_MESSAGE, (py_data_pack_fn)pack_py_decode_NEGOTIATE_MESSAGE_args_in, (py_data_unpack_fn)unpack_py_decode_NEGOTIATE_MESSAGE_args_out, 0, &ndr_table_ntlmssp },
	{ "decode_CHALLENGE_MESSAGE", "S.decode_CHALLENGE_MESSAGE(challenge) -> None", (dcerpc_call_fn)dcerpc_decode_CHALLENGE_MESSAGE, (py_data_pack_fn)pack_py_decode_CHALLENGE_MESSAGE_args_in, (py_data_unpack_fn)unpack_py_decode_CHALLENGE_MESSAGE_args_out, 1, &ndr_table_ntlmssp },
	{ "decode_AUTHENTICATE_MESSAGE", "S.decode_AUTHENTICATE_MESSAGE(authenticate) -> None", (dcerpc_call_fn)dcerpc_decode_AUTHENTICATE_MESSAGE, (py_data_pack_fn)pack_py_decode_AUTHENTICATE_MESSAGE_args_in, (py_data_unpack_fn)unpack_py_decode_AUTHENTICATE_MESSAGE_args_out, 2, &ndr_table_ntlmssp },
	{ "decode_NTLMv2_CLIENT_CHALLENGE", "S.decode_NTLMv2_CLIENT_CHALLENGE(challenge) -> None", (dcerpc_call_fn)dcerpc_decode_NTLMv2_CLIENT_CHALLENGE, (py_data_pack_fn)pack_py_decode_NTLMv2_CLIENT_CHALLENGE_args_in, (py_data_unpack_fn)unpack_py_decode_NTLMv2_CLIENT_CHALLENGE_args_out, 3, &ndr_table_ntlmssp },
	{ NULL }
};

static PyObject *interface_ntlmssp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_ntlmssp);
}

#define PY_DOC_NTLMSSP "NTLM messages"
static PyTypeObject ntlmssp_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "ntlmssp.ntlmssp",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "ntlmssp(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_NTLMSSP,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_ntlmssp_new,
};

static PyMethodDef ntlmssp_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initntlmssp(void)
{
	PyObject *m;

	if (PyType_Ready(&VERSION_Type) < 0)
		return;
	if (PyType_Ready(&NEGOTIATE_MESSAGE_Type) < 0)
		return;
	if (PyType_Ready(&Restriction_Encoding_Type) < 0)
		return;
	if (PyType_Ready(&AV_PAIR_Type) < 0)
		return;
	if (PyType_Ready(&AV_PAIR_LIST_Type) < 0)
		return;
	if (PyType_Ready(&CHALLENGE_MESSAGE_Type) < 0)
		return;
	if (PyType_Ready(&LM_RESPONSE_Type) < 0)
		return;
	if (PyType_Ready(&LMv2_RESPONSE_Type) < 0)
		return;
	if (PyType_Ready(&NTLM_RESPONSE_Type) < 0)
		return;
	if (PyType_Ready(&NTLMv2_CLIENT_CHALLENGE_Type) < 0)
		return;
	if (PyType_Ready(&NTLMv2_RESPONSE_Type) < 0)
		return;
	if (PyType_Ready(&MIC_Type) < 0)
		return;
	if (PyType_Ready(&AUTHENTICATE_MESSAGE_Type) < 0)
		return;
	if (PyType_Ready(&NTLMSSP_MESSAGE_SIGNATURE_Type) < 0)
		return;
	if (PyType_Ready(&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type) < 0)
		return;
	if (PyType_Ready(&ntlmssp_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&ntlmssp_InterfaceType, py_ndr_ntlmssp_methods))
		return;

#ifdef PY_VERSION_PATCH
	PY_VERSION_PATCH(&VERSION_Type);
#endif
#ifdef PY_NEGOTIATE_MESSAGE_PATCH
	PY_NEGOTIATE_MESSAGE_PATCH(&NEGOTIATE_MESSAGE_Type);
#endif
#ifdef PY_RESTRICTION_ENCODING_PATCH
	PY_RESTRICTION_ENCODING_PATCH(&Restriction_Encoding_Type);
#endif
#ifdef PY_AV_PAIR_PATCH
	PY_AV_PAIR_PATCH(&AV_PAIR_Type);
#endif
#ifdef PY_AV_PAIR_LIST_PATCH
	PY_AV_PAIR_LIST_PATCH(&AV_PAIR_LIST_Type);
#endif
#ifdef PY_CHALLENGE_MESSAGE_PATCH
	PY_CHALLENGE_MESSAGE_PATCH(&CHALLENGE_MESSAGE_Type);
#endif
#ifdef PY_LM_RESPONSE_PATCH
	PY_LM_RESPONSE_PATCH(&LM_RESPONSE_Type);
#endif
#ifdef PY_LMV2_RESPONSE_PATCH
	PY_LMV2_RESPONSE_PATCH(&LMv2_RESPONSE_Type);
#endif
#ifdef PY_NTLM_RESPONSE_PATCH
	PY_NTLM_RESPONSE_PATCH(&NTLM_RESPONSE_Type);
#endif
#ifdef PY_NTLMV2_CLIENT_CHALLENGE_PATCH
	PY_NTLMV2_CLIENT_CHALLENGE_PATCH(&NTLMv2_CLIENT_CHALLENGE_Type);
#endif
#ifdef PY_NTLMV2_RESPONSE_PATCH
	PY_NTLMV2_RESPONSE_PATCH(&NTLMv2_RESPONSE_Type);
#endif
#ifdef PY_MIC_PATCH
	PY_MIC_PATCH(&MIC_Type);
#endif
#ifdef PY_AUTHENTICATE_MESSAGE_PATCH
	PY_AUTHENTICATE_MESSAGE_PATCH(&AUTHENTICATE_MESSAGE_Type);
#endif
#ifdef PY_NTLMSSP_MESSAGE_SIGNATURE_PATCH
	PY_NTLMSSP_MESSAGE_SIGNATURE_PATCH(&NTLMSSP_MESSAGE_SIGNATURE_Type);
#endif
#ifdef PY_NTLMSSP_MESSAGE_SIGNATURE_NTLMV2_PATCH
	PY_NTLMSSP_MESSAGE_SIGNATURE_NTLMV2_PATCH(&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type);
#endif
#ifdef PY_NTLMSSP_PATCH
	PY_NTLMSSP_PATCH(&ntlmssp_InterfaceType);
#endif

	m = Py_InitModule3("ntlmssp", ntlmssp_methods, "ntlmssp DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MINOR_VERSION_1", PyInt_FromLong(NTLMSSP_WINDOWS_MINOR_VERSION_1));
	PyModule_AddObject(m, "NtLmNegotiate", PyInt_FromLong(NtLmNegotiate));
	PyModule_AddObject(m, "NTLMSSP_REVISION_W2K3", PyInt_FromLong(NTLMSSP_REVISION_W2K3));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_DATAGRAM", PyInt_FromLong(NTLMSSP_NEGOTIATE_DATAGRAM));
	PyModule_AddObject(m, "MsvAvTargetName", PyInt_FromLong(MsvAvTargetName));
	PyModule_AddObject(m, "NTLMSSP_REVISION_W2K3_RC1", PyInt_FromLong(NTLMSSP_REVISION_W2K3_RC1));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_TARGET_INFO", PyInt_FromLong(NTLMSSP_NEGOTIATE_TARGET_INFO));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY", PyInt_FromLong(NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY));
	PyModule_AddObject(m, "NTLMSSP_ANONYMOUS", PyInt_FromLong(NTLMSSP_ANONYMOUS));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_SEAL", PyInt_FromLong(NTLMSSP_NEGOTIATE_SEAL));
	PyModule_AddObject(m, "NTLMSSP_AVFLAG_CONSTRAINTED_ACCOUNT", PyInt_FromLong(NTLMSSP_AVFLAG_CONSTRAINTED_ACCOUNT));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED", PyInt_FromLong(NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED));
	PyModule_AddObject(m, "NTLMSSP_TARGET_TYPE_SHARE", PyInt_FromLong(NTLMSSP_TARGET_TYPE_SHARE));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_UNICODE", PyInt_FromLong(NTLMSSP_NEGOTIATE_UNICODE));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_IDENTIFY", PyInt_FromLong(NTLMSSP_NEGOTIATE_IDENTIFY));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_SIGN", PyInt_FromLong(NTLMSSP_NEGOTIATE_SIGN));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MINOR_VERSION_2", PyInt_FromLong(NTLMSSP_WINDOWS_MINOR_VERSION_2));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_KEY_EXCH", PyInt_FromLong(NTLMSSP_NEGOTIATE_KEY_EXCH));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED", PyInt_FromLong(NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED));
	PyModule_AddObject(m, "NTLMSSP_SIGN_VERSION", PyInt_FromLong(0x01));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_56", PyInt_FromLong(NTLMSSP_NEGOTIATE_56));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_OEM", PyInt_FromLong(NTLMSSP_NEGOTIATE_OEM));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MINOR_VERSION_0", PyInt_FromLong(NTLMSSP_WINDOWS_MINOR_VERSION_0));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_LM_KEY", PyInt_FromLong(NTLMSSP_NEGOTIATE_LM_KEY));
	PyModule_AddObject(m, "MsvAvFlags", PyInt_FromLong(MsvAvFlags));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_ALWAYS_SIGN", PyInt_FromLong(NTLMSSP_NEGOTIATE_ALWAYS_SIGN));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MAJOR_VERSION_6", PyInt_FromLong(NTLMSSP_WINDOWS_MAJOR_VERSION_6));
	PyModule_AddObject(m, "NtLmChallenge", PyInt_FromLong(NtLmChallenge));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NT_ONLY", PyInt_FromLong(NTLMSSP_NEGOTIATE_NT_ONLY));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_VERSION", PyInt_FromLong(NTLMSSP_NEGOTIATE_VERSION));
	PyModule_AddObject(m, "MsvAvDnsDomainName", PyInt_FromLong(MsvAvDnsDomainName));
	PyModule_AddObject(m, "MsvAvNbDomainName", PyInt_FromLong(MsvAvNbDomainName));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_128", PyInt_FromLong(NTLMSSP_NEGOTIATE_128));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NETWARE", PyInt_FromLong(NTLMSSP_NEGOTIATE_NETWARE));
	PyModule_AddObject(m, "MsAvRestrictions", PyInt_FromLong(MsAvRestrictions));
	PyModule_AddObject(m, "MsvAvDnsTreeName", PyInt_FromLong(MsvAvDnsTreeName));
	PyModule_AddObject(m, "MsvAvTimestamp", PyInt_FromLong(MsvAvTimestamp));
	PyModule_AddObject(m, "NTLMSSP_TARGET_TYPE_DOMAIN", PyInt_FromLong(NTLMSSP_TARGET_TYPE_DOMAIN));
	PyModule_AddObject(m, "NTLMSSP_TARGET_TYPE_SERVER", PyInt_FromLong(NTLMSSP_TARGET_TYPE_SERVER));
	PyModule_AddObject(m, "NtLmAuthenticate", PyInt_FromLong(NtLmAuthenticate));
	PyModule_AddObject(m, "NTLMSSP_SIG_SIZE", PyInt_FromLong(16));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NTLM", PyInt_FromLong(NTLMSSP_NEGOTIATE_NTLM));
	PyModule_AddObject(m, "NTLMSSP_REQUEST_TARGET", PyInt_FromLong(NTLMSSP_REQUEST_TARGET));
	PyModule_AddObject(m, "NTLMSSP_AVFLAG_MIC_IN_AUTHENTICATE_MESSAGE", PyInt_FromLong(NTLMSSP_AVFLAG_MIC_IN_AUTHENTICATE_MESSAGE));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_NTLM2", PyInt_FromLong(NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY));
	PyModule_AddObject(m, "MsvAvNbComputerName", PyInt_FromLong(MsvAvNbComputerName));
	PyModule_AddObject(m, "NTLMSSP_NEGOTIATE_THIS_IS_LOCAL_CALL", PyInt_FromLong(NTLMSSP_NEGOTIATE_THIS_IS_LOCAL_CALL));
	PyModule_AddObject(m, "MsvAvDnsComputerName", PyInt_FromLong(MsvAvDnsComputerName));
	PyModule_AddObject(m, "NTLMSSP_REQUEST_NON_NT_SESSION_KEY", PyInt_FromLong(NTLMSSP_REQUEST_NON_NT_SESSION_KEY));
	PyModule_AddObject(m, "MsvAvEOL", PyInt_FromLong(MsvAvEOL));
	PyModule_AddObject(m, "MsvChannelBindings", PyInt_FromLong(MsvChannelBindings));
	PyModule_AddObject(m, "NTLMSSP_WINDOWS_MAJOR_VERSION_5", PyInt_FromLong(NTLMSSP_WINDOWS_MAJOR_VERSION_5));
	Py_INCREF((PyObject *)&VERSION_Type);
	PyModule_AddObject(m, "VERSION", (PyObject *)&VERSION_Type);
	Py_INCREF((PyObject *)&NEGOTIATE_MESSAGE_Type);
	PyModule_AddObject(m, "NEGOTIATE_MESSAGE", (PyObject *)&NEGOTIATE_MESSAGE_Type);
	Py_INCREF((PyObject *)&Restriction_Encoding_Type);
	PyModule_AddObject(m, "Restriction_Encoding", (PyObject *)&Restriction_Encoding_Type);
	Py_INCREF((PyObject *)&AV_PAIR_Type);
	PyModule_AddObject(m, "AV_PAIR", (PyObject *)&AV_PAIR_Type);
	Py_INCREF((PyObject *)&AV_PAIR_LIST_Type);
	PyModule_AddObject(m, "AV_PAIR_LIST", (PyObject *)&AV_PAIR_LIST_Type);
	Py_INCREF((PyObject *)&CHALLENGE_MESSAGE_Type);
	PyModule_AddObject(m, "CHALLENGE_MESSAGE", (PyObject *)&CHALLENGE_MESSAGE_Type);
	Py_INCREF((PyObject *)&LM_RESPONSE_Type);
	PyModule_AddObject(m, "LM_RESPONSE", (PyObject *)&LM_RESPONSE_Type);
	Py_INCREF((PyObject *)&LMv2_RESPONSE_Type);
	PyModule_AddObject(m, "LMv2_RESPONSE", (PyObject *)&LMv2_RESPONSE_Type);
	Py_INCREF((PyObject *)&NTLM_RESPONSE_Type);
	PyModule_AddObject(m, "NTLM_RESPONSE", (PyObject *)&NTLM_RESPONSE_Type);
	Py_INCREF((PyObject *)&NTLMv2_CLIENT_CHALLENGE_Type);
	PyModule_AddObject(m, "NTLMv2_CLIENT_CHALLENGE", (PyObject *)&NTLMv2_CLIENT_CHALLENGE_Type);
	Py_INCREF((PyObject *)&NTLMv2_RESPONSE_Type);
	PyModule_AddObject(m, "NTLMv2_RESPONSE", (PyObject *)&NTLMv2_RESPONSE_Type);
	Py_INCREF((PyObject *)&MIC_Type);
	PyModule_AddObject(m, "MIC", (PyObject *)&MIC_Type);
	Py_INCREF((PyObject *)&AUTHENTICATE_MESSAGE_Type);
	PyModule_AddObject(m, "AUTHENTICATE_MESSAGE", (PyObject *)&AUTHENTICATE_MESSAGE_Type);
	Py_INCREF((PyObject *)&NTLMSSP_MESSAGE_SIGNATURE_Type);
	PyModule_AddObject(m, "NTLMSSP_MESSAGE_SIGNATURE", (PyObject *)&NTLMSSP_MESSAGE_SIGNATURE_Type);
	Py_INCREF((PyObject *)&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type);
	PyModule_AddObject(m, "NTLMSSP_MESSAGE_SIGNATURE_NTLMv2", (PyObject *)&NTLMSSP_MESSAGE_SIGNATURE_NTLMv2_Type);
	Py_INCREF((PyObject *)&ntlmssp_InterfaceType);
	PyModule_AddObject(m, "ntlmssp", (PyObject *)&ntlmssp_InterfaceType);
#ifdef PY_MOD_NTLMSSP_PATCH
	PY_MOD_NTLMSSP_PATCH(m);
#endif

}
