/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_dsbackup.h"

static bool api_HrRBackupPrepare(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupPrepare *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPPREPARE];

	r = talloc(talloc_tos(), struct HrRBackupPrepare);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupPrepare, r);
	}

	_HrRBackupPrepare(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupPrepare, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupEnd(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupEnd *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPEND];

	r = talloc(talloc_tos(), struct HrRBackupEnd);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupEnd, r);
	}

	_HrRBackupEnd(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupEnd, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupGetAttachmentInformation(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupGetAttachmentInformation *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPGETATTACHMENTINFORMATION];

	r = talloc(talloc_tos(), struct HrRBackupGetAttachmentInformation);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupGetAttachmentInformation, r);
	}

	_HrRBackupGetAttachmentInformation(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupGetAttachmentInformation, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupOpenFile(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupOpenFile *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPOPENFILE];

	r = talloc(talloc_tos(), struct HrRBackupOpenFile);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupOpenFile, r);
	}

	_HrRBackupOpenFile(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupOpenFile, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupRead(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupRead *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPREAD];

	r = talloc(talloc_tos(), struct HrRBackupRead);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupRead, r);
	}

	_HrRBackupRead(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupRead, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupClose(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupClose *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPCLOSE];

	r = talloc(talloc_tos(), struct HrRBackupClose);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupClose, r);
	}

	_HrRBackupClose(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupClose, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupGetBackupLogs(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupGetBackupLogs *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPGETBACKUPLOGS];

	r = talloc(talloc_tos(), struct HrRBackupGetBackupLogs);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupGetBackupLogs, r);
	}

	_HrRBackupGetBackupLogs(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupGetBackupLogs, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupTruncateLogs(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupTruncateLogs *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPTRUNCATELOGS];

	r = talloc(talloc_tos(), struct HrRBackupTruncateLogs);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupTruncateLogs, r);
	}

	_HrRBackupTruncateLogs(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupTruncateLogs, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRBackupPing(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRBackupPing *r;

	call = &ndr_table_ad_backup.calls[NDR_HRRBACKUPPING];

	r = talloc(talloc_tos(), struct HrRBackupPing);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRBackupPing, r);
	}

	_HrRBackupPing(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRBackupPing, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ad_backup_cmds[] = 
{
	{"HRRBACKUPPREPARE", NDR_HRRBACKUPPREPARE, api_HrRBackupPrepare},
	{"HRRBACKUPEND", NDR_HRRBACKUPEND, api_HrRBackupEnd},
	{"HRRBACKUPGETATTACHMENTINFORMATION", NDR_HRRBACKUPGETATTACHMENTINFORMATION, api_HrRBackupGetAttachmentInformation},
	{"HRRBACKUPOPENFILE", NDR_HRRBACKUPOPENFILE, api_HrRBackupOpenFile},
	{"HRRBACKUPREAD", NDR_HRRBACKUPREAD, api_HrRBackupRead},
	{"HRRBACKUPCLOSE", NDR_HRRBACKUPCLOSE, api_HrRBackupClose},
	{"HRRBACKUPGETBACKUPLOGS", NDR_HRRBACKUPGETBACKUPLOGS, api_HrRBackupGetBackupLogs},
	{"HRRBACKUPTRUNCATELOGS", NDR_HRRBACKUPTRUNCATELOGS, api_HrRBackupTruncateLogs},
	{"HRRBACKUPPING", NDR_HRRBACKUPPING, api_HrRBackupPing},
};

void ad_backup_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ad_backup_cmds;
	*n_fns = sizeof(api_ad_backup_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ad_backup_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_HRRBACKUPPREPARE: {
			struct HrRBackupPrepare *r = (struct HrRBackupPrepare *)_r;
			_HrRBackupPrepare(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPEND: {
			struct HrRBackupEnd *r = (struct HrRBackupEnd *)_r;
			_HrRBackupEnd(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPGETATTACHMENTINFORMATION: {
			struct HrRBackupGetAttachmentInformation *r = (struct HrRBackupGetAttachmentInformation *)_r;
			_HrRBackupGetAttachmentInformation(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPOPENFILE: {
			struct HrRBackupOpenFile *r = (struct HrRBackupOpenFile *)_r;
			_HrRBackupOpenFile(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPREAD: {
			struct HrRBackupRead *r = (struct HrRBackupRead *)_r;
			_HrRBackupRead(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPCLOSE: {
			struct HrRBackupClose *r = (struct HrRBackupClose *)_r;
			_HrRBackupClose(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPGETBACKUPLOGS: {
			struct HrRBackupGetBackupLogs *r = (struct HrRBackupGetBackupLogs *)_r;
			_HrRBackupGetBackupLogs(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPTRUNCATELOGS: {
			struct HrRBackupTruncateLogs *r = (struct HrRBackupTruncateLogs *)_r;
			_HrRBackupTruncateLogs(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRBACKUPPING: {
			struct HrRBackupPing *r = (struct HrRBackupPing *)_r;
			_HrRBackupPing(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_ad_backup_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ad_backup", "ad_backup", &ndr_table_ad_backup, api_ad_backup_cmds, sizeof(api_ad_backup_cmds) / sizeof(struct api_struct));
}
static bool api_HrRIsNTDSOnline(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRIsNTDSOnline *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRISNTDSONLINE];

	r = talloc(talloc_tos(), struct HrRIsNTDSOnline);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRIsNTDSOnline, r);
	}

	_HrRIsNTDSOnline(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRIsNTDSOnline, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRRestorePrepare(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRRestorePrepare *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRRESTOREPREPARE];

	r = talloc(talloc_tos(), struct HrRRestorePrepare);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRRestorePrepare, r);
	}

	_HrRRestorePrepare(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRRestorePrepare, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRRestoreRegister(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRRestoreRegister *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRRESTOREREGISTER];

	r = talloc(talloc_tos(), struct HrRRestoreRegister);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRRestoreRegister, r);
	}

	_HrRRestoreRegister(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRRestoreRegister, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRRestoreRegisterComplete(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRRestoreRegisterComplete *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRRESTOREREGISTERCOMPLETE];

	r = talloc(talloc_tos(), struct HrRRestoreRegisterComplete);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRRestoreRegisterComplete, r);
	}

	_HrRRestoreRegisterComplete(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRRestoreRegisterComplete, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRRestoreGetDatabaseLocations(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRRestoreGetDatabaseLocations *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRRESTOREGETDATABASELOCATIONS];

	r = talloc(talloc_tos(), struct HrRRestoreGetDatabaseLocations);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRRestoreGetDatabaseLocations, r);
	}

	_HrRRestoreGetDatabaseLocations(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRRestoreGetDatabaseLocations, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRRestoreEnd(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRRestoreEnd *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRRESTOREEND];

	r = talloc(talloc_tos(), struct HrRRestoreEnd);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRRestoreEnd, r);
	}

	_HrRRestoreEnd(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRRestoreEnd, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRRestoreSetCurrentLogNumber(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRRestoreSetCurrentLogNumber *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRRESTORESETCURRENTLOGNUMBER];

	r = talloc(talloc_tos(), struct HrRRestoreSetCurrentLogNumber);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRRestoreSetCurrentLogNumber, r);
	}

	_HrRRestoreSetCurrentLogNumber(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRRestoreSetCurrentLogNumber, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_HrRRestoreCheckLogsForBackup(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct HrRRestoreCheckLogsForBackup *r;

	call = &ndr_table_ad_restore.calls[NDR_HRRRESTORECHECKLOGSFORBACKUP];

	r = talloc(talloc_tos(), struct HrRRestoreCheckLogsForBackup);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(HrRRestoreCheckLogsForBackup, r);
	}

	_HrRRestoreCheckLogsForBackup(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(HrRRestoreCheckLogsForBackup, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ad_restore_cmds[] = 
{
	{"HRRISNTDSONLINE", NDR_HRRISNTDSONLINE, api_HrRIsNTDSOnline},
	{"HRRRESTOREPREPARE", NDR_HRRRESTOREPREPARE, api_HrRRestorePrepare},
	{"HRRRESTOREREGISTER", NDR_HRRRESTOREREGISTER, api_HrRRestoreRegister},
	{"HRRRESTOREREGISTERCOMPLETE", NDR_HRRRESTOREREGISTERCOMPLETE, api_HrRRestoreRegisterComplete},
	{"HRRRESTOREGETDATABASELOCATIONS", NDR_HRRRESTOREGETDATABASELOCATIONS, api_HrRRestoreGetDatabaseLocations},
	{"HRRRESTOREEND", NDR_HRRRESTOREEND, api_HrRRestoreEnd},
	{"HRRRESTORESETCURRENTLOGNUMBER", NDR_HRRRESTORESETCURRENTLOGNUMBER, api_HrRRestoreSetCurrentLogNumber},
	{"HRRRESTORECHECKLOGSFORBACKUP", NDR_HRRRESTORECHECKLOGSFORBACKUP, api_HrRRestoreCheckLogsForBackup},
};

void ad_restore_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ad_restore_cmds;
	*n_fns = sizeof(api_ad_restore_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ad_restore_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_HRRISNTDSONLINE: {
			struct HrRIsNTDSOnline *r = (struct HrRIsNTDSOnline *)_r;
			_HrRIsNTDSOnline(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRRESTOREPREPARE: {
			struct HrRRestorePrepare *r = (struct HrRRestorePrepare *)_r;
			_HrRRestorePrepare(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRRESTOREREGISTER: {
			struct HrRRestoreRegister *r = (struct HrRRestoreRegister *)_r;
			_HrRRestoreRegister(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRRESTOREREGISTERCOMPLETE: {
			struct HrRRestoreRegisterComplete *r = (struct HrRRestoreRegisterComplete *)_r;
			_HrRRestoreRegisterComplete(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRRESTOREGETDATABASELOCATIONS: {
			struct HrRRestoreGetDatabaseLocations *r = (struct HrRRestoreGetDatabaseLocations *)_r;
			_HrRRestoreGetDatabaseLocations(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRRESTOREEND: {
			struct HrRRestoreEnd *r = (struct HrRRestoreEnd *)_r;
			_HrRRestoreEnd(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRRESTORESETCURRENTLOGNUMBER: {
			struct HrRRestoreSetCurrentLogNumber *r = (struct HrRRestoreSetCurrentLogNumber *)_r;
			_HrRRestoreSetCurrentLogNumber(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_HRRRESTORECHECKLOGSFORBACKUP: {
			struct HrRRestoreCheckLogsForBackup *r = (struct HrRRestoreCheckLogsForBackup *)_r;
			_HrRRestoreCheckLogsForBackup(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_ad_restore_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ad_restore", "ad_restore", &ndr_table_ad_restore, api_ad_restore_cmds, sizeof(api_ad_restore_cmds) / sizeof(struct api_struct));
}
