/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_frstrans.h"

static bool api_frstrans_CheckConnectivity(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct frstrans_CheckConnectivity *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_CHECKCONNECTIVITY];

	r = talloc(talloc_tos(), struct frstrans_CheckConnectivity);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frstrans_CheckConnectivity, r);
	}

	r->out.result = _frstrans_CheckConnectivity(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frstrans_CheckConnectivity, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_frstrans_EstablishConnection(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct frstrans_EstablishConnection *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_ESTABLISHCONNECTION];

	r = talloc(talloc_tos(), struct frstrans_EstablishConnection);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frstrans_EstablishConnection, r);
	}

	ZERO_STRUCT(r->out);
	r->out.upstream_protocol_version = talloc_zero(r, enum frstrans_ProtocolVersion);
	if (r->out.upstream_protocol_version == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.upstream_flags = talloc_zero(r, uint32_t);
	if (r->out.upstream_flags == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_EstablishConnection(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frstrans_EstablishConnection, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_frstrans_EstablishSession(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct frstrans_EstablishSession *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_ESTABLISHSESSION];

	r = talloc(talloc_tos(), struct frstrans_EstablishSession);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frstrans_EstablishSession, r);
	}

	r->out.result = _frstrans_EstablishSession(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frstrans_EstablishSession, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_frstrans_RequestUpdates(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct frstrans_RequestUpdates *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_REQUESTUPDATES];

	r = talloc(talloc_tos(), struct frstrans_RequestUpdates);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frstrans_RequestUpdates, r);
	}

	ZERO_STRUCT(r->out);
	r->out.frs_update = talloc_zero_array(r, struct frstrans_Update, r->in.credits_available);
	if (r->out.frs_update == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.update_count = talloc_zero(r, uint32_t);
	if (r->out.update_count == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.update_status = talloc_zero(r, enum frstrans_UpdateStatus);
	if (r->out.update_status == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.gvsn_db_guid = talloc_zero(r, struct GUID);
	if (r->out.gvsn_db_guid == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.gvsn_version = talloc_zero(r, uint64_t);
	if (r->out.gvsn_version == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_RequestUpdates(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frstrans_RequestUpdates, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_frstrans_RequestVersionVector(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct frstrans_RequestVersionVector *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_REQUESTVERSIONVECTOR];

	r = talloc(talloc_tos(), struct frstrans_RequestVersionVector);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frstrans_RequestVersionVector, r);
	}

	r->out.result = _frstrans_RequestVersionVector(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frstrans_RequestVersionVector, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_frstrans_AsyncPoll(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct frstrans_AsyncPoll *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_ASYNCPOLL];

	r = talloc(talloc_tos(), struct frstrans_AsyncPoll);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frstrans_AsyncPoll, r);
	}

	ZERO_STRUCT(r->out);
	r->out.response = talloc_zero(r, struct frstrans_AsyncResponseContext);
	if (r->out.response == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_AsyncPoll(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frstrans_AsyncPoll, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_REQUEST_RECORDS(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_REQUEST_RECORDS *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_REQUEST_RECORDS];

	r = talloc(talloc_tos(), struct FRSTRANS_REQUEST_RECORDS);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_REQUEST_RECORDS, r);
	}

	_FRSTRANS_REQUEST_RECORDS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_REQUEST_RECORDS, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_UPDATE_CANCEL(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_UPDATE_CANCEL *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_UPDATE_CANCEL];

	r = talloc(talloc_tos(), struct FRSTRANS_UPDATE_CANCEL);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_UPDATE_CANCEL, r);
	}

	_FRSTRANS_UPDATE_CANCEL(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_UPDATE_CANCEL, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RAW_GET_FILE_DATA(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_RAW_GET_FILE_DATA *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RAW_GET_FILE_DATA];

	r = talloc(talloc_tos(), struct FRSTRANS_RAW_GET_FILE_DATA);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_RAW_GET_FILE_DATA, r);
	}

	_FRSTRANS_RAW_GET_FILE_DATA(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_RAW_GET_FILE_DATA, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_GET_SIGNATURES(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_RDC_GET_SIGNATURES *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_GET_SIGNATURES];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_GET_SIGNATURES);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_RDC_GET_SIGNATURES, r);
	}

	_FRSTRANS_RDC_GET_SIGNATURES(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_RDC_GET_SIGNATURES, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_PUSH_SOURCE_NEEDS];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_RDC_PUSH_SOURCE_NEEDS, r);
	}

	_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_RDC_PUSH_SOURCE_NEEDS, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_GET_FILE_DATA(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_RDC_GET_FILE_DATA *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_GET_FILE_DATA];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_GET_FILE_DATA);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_RDC_GET_FILE_DATA, r);
	}

	_FRSTRANS_RDC_GET_FILE_DATA(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_RDC_GET_FILE_DATA, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_CLOSE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_RDC_CLOSE *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_CLOSE];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_CLOSE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_RDC_CLOSE, r);
	}

	_FRSTRANS_RDC_CLOSE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_RDC_CLOSE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_frstrans_InitializeFileTransferAsync(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct frstrans_InitializeFileTransferAsync *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC];

	r = talloc(talloc_tos(), struct frstrans_InitializeFileTransferAsync);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(frstrans_InitializeFileTransferAsync, r);
	}

	ZERO_STRUCT(r->out);
	r->out.frs_update = r->in.frs_update;
	r->out.staging_policy = r->in.staging_policy;
	r->out.server_context = talloc_zero(r, struct policy_handle);
	if (r->out.server_context == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rdc_file_info = talloc_zero(r, struct frstrans_RdcFileInfo *);
	if (r->out.rdc_file_info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data_buffer = talloc_zero_array(r, uint8_t, r->in.buffer_size);
	if (r->out.data_buffer == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.size_read = talloc_zero(r, uint32_t);
	if (r->out.size_read == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.is_end_of_file = talloc_zero(r, uint32_t);
	if (r->out.is_end_of_file == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _frstrans_InitializeFileTransferAsync(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(frstrans_InitializeFileTransferAsync, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE];

	r = talloc(talloc_tos(), struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE, r);
	}

	_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RAW_GET_FILE_DATA_ASYNC(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_RAW_GET_FILE_DATA_ASYNC *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RAW_GET_FILE_DATA_ASYNC];

	r = talloc(talloc_tos(), struct FRSTRANS_RAW_GET_FILE_DATA_ASYNC);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_RAW_GET_FILE_DATA_ASYNC, r);
	}

	_FRSTRANS_RAW_GET_FILE_DATA_ASYNC(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_RAW_GET_FILE_DATA_ASYNC, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_FRSTRANS_RDC_GET_FILE_DATA_ASYNC(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct FRSTRANS_RDC_GET_FILE_DATA_ASYNC *r;

	call = &ndr_table_frstrans.calls[NDR_FRSTRANS_RDC_GET_FILE_DATA_ASYNC];

	r = talloc(talloc_tos(), struct FRSTRANS_RDC_GET_FILE_DATA_ASYNC);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(FRSTRANS_RDC_GET_FILE_DATA_ASYNC, r);
	}

	_FRSTRANS_RDC_GET_FILE_DATA_ASYNC(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(FRSTRANS_RDC_GET_FILE_DATA_ASYNC, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_frstrans_cmds[] = 
{
	{"FRSTRANS_CHECKCONNECTIVITY", NDR_FRSTRANS_CHECKCONNECTIVITY, api_frstrans_CheckConnectivity},
	{"FRSTRANS_ESTABLISHCONNECTION", NDR_FRSTRANS_ESTABLISHCONNECTION, api_frstrans_EstablishConnection},
	{"FRSTRANS_ESTABLISHSESSION", NDR_FRSTRANS_ESTABLISHSESSION, api_frstrans_EstablishSession},
	{"FRSTRANS_REQUESTUPDATES", NDR_FRSTRANS_REQUESTUPDATES, api_frstrans_RequestUpdates},
	{"FRSTRANS_REQUESTVERSIONVECTOR", NDR_FRSTRANS_REQUESTVERSIONVECTOR, api_frstrans_RequestVersionVector},
	{"FRSTRANS_ASYNCPOLL", NDR_FRSTRANS_ASYNCPOLL, api_frstrans_AsyncPoll},
	{"FRSTRANS_REQUEST_RECORDS", NDR_FRSTRANS_REQUEST_RECORDS, api_FRSTRANS_REQUEST_RECORDS},
	{"FRSTRANS_UPDATE_CANCEL", NDR_FRSTRANS_UPDATE_CANCEL, api_FRSTRANS_UPDATE_CANCEL},
	{"FRSTRANS_RAW_GET_FILE_DATA", NDR_FRSTRANS_RAW_GET_FILE_DATA, api_FRSTRANS_RAW_GET_FILE_DATA},
	{"FRSTRANS_RDC_GET_SIGNATURES", NDR_FRSTRANS_RDC_GET_SIGNATURES, api_FRSTRANS_RDC_GET_SIGNATURES},
	{"FRSTRANS_RDC_PUSH_SOURCE_NEEDS", NDR_FRSTRANS_RDC_PUSH_SOURCE_NEEDS, api_FRSTRANS_RDC_PUSH_SOURCE_NEEDS},
	{"FRSTRANS_RDC_GET_FILE_DATA", NDR_FRSTRANS_RDC_GET_FILE_DATA, api_FRSTRANS_RDC_GET_FILE_DATA},
	{"FRSTRANS_RDC_CLOSE", NDR_FRSTRANS_RDC_CLOSE, api_FRSTRANS_RDC_CLOSE},
	{"FRSTRANS_INITIALIZEFILETRANSFERASYNC", NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC, api_frstrans_InitializeFileTransferAsync},
	{"FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE", NDR_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE, api_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE},
	{"FRSTRANS_RAW_GET_FILE_DATA_ASYNC", NDR_FRSTRANS_RAW_GET_FILE_DATA_ASYNC, api_FRSTRANS_RAW_GET_FILE_DATA_ASYNC},
	{"FRSTRANS_RDC_GET_FILE_DATA_ASYNC", NDR_FRSTRANS_RDC_GET_FILE_DATA_ASYNC, api_FRSTRANS_RDC_GET_FILE_DATA_ASYNC},
};

void frstrans_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_frstrans_cmds;
	*n_fns = sizeof(api_frstrans_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_frstrans_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_FRSTRANS_CHECKCONNECTIVITY: {
			struct frstrans_CheckConnectivity *r = (struct frstrans_CheckConnectivity *)_r;
			r->out.result = _frstrans_CheckConnectivity(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_ESTABLISHCONNECTION: {
			struct frstrans_EstablishConnection *r = (struct frstrans_EstablishConnection *)_r;
			ZERO_STRUCT(r->out);
			r->out.upstream_protocol_version = talloc_zero(mem_ctx, enum frstrans_ProtocolVersion);
			if (r->out.upstream_protocol_version == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.upstream_flags = talloc_zero(mem_ctx, uint32_t);
			if (r->out.upstream_flags == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _frstrans_EstablishConnection(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_ESTABLISHSESSION: {
			struct frstrans_EstablishSession *r = (struct frstrans_EstablishSession *)_r;
			r->out.result = _frstrans_EstablishSession(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_REQUESTUPDATES: {
			struct frstrans_RequestUpdates *r = (struct frstrans_RequestUpdates *)_r;
			ZERO_STRUCT(r->out);
			r->out.frs_update = talloc_zero_array(mem_ctx, struct frstrans_Update, r->in.credits_available);
			if (r->out.frs_update == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.update_count = talloc_zero(mem_ctx, uint32_t);
			if (r->out.update_count == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.update_status = talloc_zero(mem_ctx, enum frstrans_UpdateStatus);
			if (r->out.update_status == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.gvsn_db_guid = talloc_zero(mem_ctx, struct GUID);
			if (r->out.gvsn_db_guid == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.gvsn_version = talloc_zero(mem_ctx, uint64_t);
			if (r->out.gvsn_version == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _frstrans_RequestUpdates(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_REQUESTVERSIONVECTOR: {
			struct frstrans_RequestVersionVector *r = (struct frstrans_RequestVersionVector *)_r;
			r->out.result = _frstrans_RequestVersionVector(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_ASYNCPOLL: {
			struct frstrans_AsyncPoll *r = (struct frstrans_AsyncPoll *)_r;
			ZERO_STRUCT(r->out);
			r->out.response = talloc_zero(mem_ctx, struct frstrans_AsyncResponseContext);
			if (r->out.response == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _frstrans_AsyncPoll(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_REQUEST_RECORDS: {
			struct FRSTRANS_REQUEST_RECORDS *r = (struct FRSTRANS_REQUEST_RECORDS *)_r;
			_FRSTRANS_REQUEST_RECORDS(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_UPDATE_CANCEL: {
			struct FRSTRANS_UPDATE_CANCEL *r = (struct FRSTRANS_UPDATE_CANCEL *)_r;
			_FRSTRANS_UPDATE_CANCEL(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_RAW_GET_FILE_DATA: {
			struct FRSTRANS_RAW_GET_FILE_DATA *r = (struct FRSTRANS_RAW_GET_FILE_DATA *)_r;
			_FRSTRANS_RAW_GET_FILE_DATA(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_RDC_GET_SIGNATURES: {
			struct FRSTRANS_RDC_GET_SIGNATURES *r = (struct FRSTRANS_RDC_GET_SIGNATURES *)_r;
			_FRSTRANS_RDC_GET_SIGNATURES(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_RDC_PUSH_SOURCE_NEEDS: {
			struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS *r = (struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS *)_r;
			_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_RDC_GET_FILE_DATA: {
			struct FRSTRANS_RDC_GET_FILE_DATA *r = (struct FRSTRANS_RDC_GET_FILE_DATA *)_r;
			_FRSTRANS_RDC_GET_FILE_DATA(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_RDC_CLOSE: {
			struct FRSTRANS_RDC_CLOSE *r = (struct FRSTRANS_RDC_CLOSE *)_r;
			_FRSTRANS_RDC_CLOSE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC: {
			struct frstrans_InitializeFileTransferAsync *r = (struct frstrans_InitializeFileTransferAsync *)_r;
			ZERO_STRUCT(r->out);
			r->out.frs_update = r->in.frs_update;
			r->out.staging_policy = r->in.staging_policy;
			r->out.server_context = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.server_context == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.rdc_file_info = talloc_zero(mem_ctx, struct frstrans_RdcFileInfo *);
			if (r->out.rdc_file_info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.data_buffer = talloc_zero_array(mem_ctx, uint8_t, r->in.buffer_size);
			if (r->out.data_buffer == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.size_read = talloc_zero(mem_ctx, uint32_t);
			if (r->out.size_read == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.is_end_of_file = talloc_zero(mem_ctx, uint32_t);
			if (r->out.is_end_of_file == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _frstrans_InitializeFileTransferAsync(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE: {
			struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE *r = (struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE *)_r;
			_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_RAW_GET_FILE_DATA_ASYNC: {
			struct FRSTRANS_RAW_GET_FILE_DATA_ASYNC *r = (struct FRSTRANS_RAW_GET_FILE_DATA_ASYNC *)_r;
			_FRSTRANS_RAW_GET_FILE_DATA_ASYNC(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_FRSTRANS_RDC_GET_FILE_DATA_ASYNC: {
			struct FRSTRANS_RDC_GET_FILE_DATA_ASYNC *r = (struct FRSTRANS_RDC_GET_FILE_DATA_ASYNC *)_r;
			_FRSTRANS_RDC_GET_FILE_DATA_ASYNC(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_frstrans_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "frstrans", "frstrans", &ndr_table_frstrans, api_frstrans_cmds, sizeof(api_frstrans_cmds) / sizeof(struct api_struct));
}
