/* $NetBSD: meson_vpureg.h,v 1.1 2019/01/19 21:43:43 jmcneill Exp $ */

/*-
 * Copyright (c) 2015 Jared McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _MESON_VPUREG_H
#define _MESON_VPUREG_H

#define VPU_REG(n)	((n) << 2)

#define VIU_OSD2_CTRL_STAT_REG		VPU_REG(0x1a30)
#define VIU_OSD2_TCOLOR_AG0_REG		VPU_REG(0x1a37)
#define VIU_OSD2_TCOLOR_AG1_REG		VPU_REG(0x1a38)
#define VIU_OSD2_TCOLOR_AG2_REG		VPU_REG(0x1a39)
#define VIU_OSD2_TCOLOR_AG3_REG		VPU_REG(0x1a3a)
#define VIU_OSD2_BLK0_CFG_W0_REG	VPU_REG(0x1a3b)
#define VIU_OSD2_BLK0_CFG_W1_REG	VPU_REG(0x1a3c)
#define VIU_OSD2_BLK0_CFG_W2_REG	VPU_REG(0x1a3d)
#define VIU_OSD2_BLK0_CFG_W3_REG	VPU_REG(0x1a3e)
#define VIU_OSD2_BLK0_CFG_W4_REG	VPU_REG(0x1a64)
#define VPP_MISC_REG			VPU_REG(0x1d26)
#define VPP_OSD_VSC_PHASE_STEP_REG	VPU_REG(0x1dc0)
#define VPP_OSD_VSC_INI_PHASE_REG	VPU_REG(0x1dc1)
#define VPP_OSD_VSC_CTRL0_REG		VPU_REG(0x1dc2)
#define VPP_OSD_HSC_PHASE_STEP_REG	VPU_REG(0x1dc3)
#define VPP_OSD_HSC_INI_PHASE_REG	VPU_REG(0x1dc4)
#define VPP_OSD_HSC_CTRL0_REG		VPU_REG(0x1dc5)
#define VPP_OSD_SC_DUMMY_DATA_REG	VPU_REG(0x1dc7)
#define VPP_OSD_SC_CTRL0_REG		VPU_REG(0x1dc8)
#define VPP_OSD_SCI_WH_M1_REG		VPU_REG(0x1dc9)
#define VPP_OSD_SCO_H_REG		VPU_REG(0x1dca)
#define VPP_OSD_SCO_V_REG		VPU_REG(0x1dcb)

#define VIU_OSD_CTRL_STAT_ENABLE	__BIT(21)
#define VIU_OSD_CTRL_STAT_GLOBAL_ALPHA	__BITS(20,12)
#define VIU_OSD_CTRL_STAT_BLK3_ENABLE	__BIT(3)
#define VIU_OSD_CTRL_STAT_BLK2_ENABLE	__BIT(2)
#define VIU_OSD_CTRL_STAT_BLK1_ENABLE	__BIT(1)
#define VIU_OSD_CTRL_STAT_BLK0_ENABLE	__BIT(0)

#define VIU_OSD_TCOLOR_R		__BITS(31,24)
#define VIU_OSD_TCOLOR_G		__BITS(23,16)
#define VIU_OSD_TCOLOR_B		__BITS(15,8)
#define VIU_OSD_TCOLOR_A		__BITS(7,0)

#define VIU_OSD_BLK_CFG_W0_TBL_ADDR	__BITS(23,16)
#define VIU_OSD_BLK_CFG_W0_LITTLE_ENDIAN __BIT(15)
#define VIU_OSD_BLK_CFG_W0_RPT_Y	__BIT(14)
#define VIU_OSD_BLK_CFG_W0_INTERP_CTRL	__BITS(13,12)
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE	__BITS(11,8)
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE_PAL4	0
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE_PAL16	1
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE_PAL256	2
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE_YUV	3
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE_16BPP	4
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE_32BPP	5
#define VIU_OSD_BLK_CFG_W0_OSD_BLK_MODE_24BPP	7
#define VIU_OSD_BLK_CFG_W0_RGB_EN	__BIT(7)
#define VIU_OSD_BLK_CFG_W0_TC_ALPHA_EN	__BIT(6)
#define VIU_OSD_BLK_CFG_W0_COLOR_MATRIX	__BITS(5,2)
#define VIU_OSD_BLK_CFG_W0_COLOR_MATRIX_RGB	0
#define VIU_OSD_BLK_CFG_W0_COLOR_MATRIX_RGBA	0
#define VIU_OSD_BLK_CFG_W0_COLOR_MATRIX_ARGB	1
#define VIU_OSD_BLK_CFG_W0_COLOR_MATRIX_ABGR	2
#define VIU_OSD_BLK_CFG_W0_COLOR_MATRIX_BGRA	3
#define VIU_OSD_BLK_CFG_W0_COLOR_MATRIX_RGB565	4
#define VIU_OSD_BLK_CFG_W0_INTERLACE_EN	__BIT(1)
#define VIU_OSD_BLK_CFG_W0_INTERLACE_SEL_ODD __BIT(0)

#define VIU_OSD_BLK_CFG_W1_X_END	__BITS(28,16)
#define VIU_OSD_BLK_CFG_W1_X_START	__BITS(12,0)

#define VIU_OSD_BLK_CFG_W2_Y_END	__BITS(28,16)
#define VIU_OSD_BLK_CFG_W2_Y_START	__BITS(12,0)

#define VIU_OSD_BLK_CFG_W3_H_END	__BITS(27,16)
#define VIU_OSD_BLK_CFG_W3_H_START	__BITS(11,0)

#define VIU_OSD_BLK_CFG_W4_V_END	__BITS(27,16)
#define VIU_OSD_BLK_CFG_W4_V_START	__BITS(11,0)

#define VPP_MISC_OSD2_PREBLEND		__BIT(17)
#define VPP_MISC_OSD1_PREBLEND		__BIT(16)
#define VPP_MISC_OSD2_POSTBLEND		__BIT(13)
#define VPP_MISC_OSD1_POSTBLEND		__BIT(12)
#define VPP_MISC_POSTBLEND		__BIT(7)
#define VPP_MISC_PREBLEND		__BIT(6)

#define VPP_OSD_VSC_PHASE_STEP_FORMAT	__BITS(27,0)

#define VPP_OSD_VSC_INI_PHASE_0		__BITS(31,16)
#define VPP_OSD_VSC_INI_PHASE_1		__BITS(15,0)

#define VPP_OSD_VSC_CTRL0_VSCALE_EN	__BIT(24)
#define VPP_OSC_VSC_CTRL0_INTERLACE	__BIT(23)
#define VPP_OSD_VSC_CTRL0_BOT_RPT_P0_NUM0	__BITS(17,16)
#define VPP_OSD_VSC_CTRL0_BOT_INI_RCV_NUM0	__BITS(14,11)
#define VPP_OSD_VSC_CTRL0_TOP_RPT_P0_NUM0	__BITS(9,8)
#define VPP_OSD_VSC_CTRL0_TOP_INI_RCV_NUM0	__BITS(6,3)
#define VPP_OSD_VSC_CTRL0_BANK_LENGTH	__BITS(2,0)

#define VPP_OSD_HSC_PHASE_STEP_FORMAT	__BITS(27,0)

#define VPP_OSD_HSC_INI_PHASE_0		__BITS(31,16)
#define VPP_OSD_HSC_INI_PHASE_1		__BITS(15,0)

#define VPP_OSD_HSC_CTRL0_HSCALE_EN	__BIT(22)
#define VPP_OSD_HSC_CTRL0_RPT_P0_NUM0	__BITS(9,8)
#define VPP_OSD_HSC_CTRL0_INI_RCV_NUM0	__BITS(6,3)
#define VPP_OSD_HSC_CTRL0_BANK_LENGTH	__BITS(2,0)

#define VPP_OSD_SC_CTRL0_OSC_SC_DIN_OSD1_ALPHA_MODE	__BIT(14)
#define VPP_OSD_SC_CTRL0_OSC_SC_DIN_OSD2_ALPHA_MODE	__BIT(13)
#define VPP_OSD_SC_CTRL0_OSC_SC_ALPHA_MODE		__BIT(12)
#define VPP_OSD_SC_CTRL0_DEFAULT_ALPHA	__BITS(11,4)
#define VPP_OSD_SC_CTRL0_OSD_SC_PATH_EN	__BIT(3)
#define VPP_OSD_SC_CTRL0_OSD_SC_SEL	__BITS(1,0)

#define VPP_OSD_SCI_WH_M1_WIDTH		__BITS(28,16)
#define VPP_OSD_SCI_WH_M1_HEIGHT	__BITS(12,0)

#define VPP_OSD_SCO_H_START		__BITS(28,16)
#define VPP_OSD_SCO_H_END		__BITS(12,0)

#define VPP_OSD_SCO_V_START		__BITS(28,16)
#define VPP_OSD_SCO_V_END		__BITS(12,0)

#endif /* _MESON_VPUREG_H */
