/*
 * Copyright (C) 2020 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated file, do not edit */

#include "bi_opcodes.h"

struct bi_op_props bi_opcode_props[BI_NUM_OPCODES] = {
    
    [BI_OPCODE_ACMPSTORE_I32] = {
        "ACMPSTORE.i32", BIFROST_MESSAGE_ATOMIC, BI_SIZE_32,
        BI_SR_COUNT_2, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ACMPSTORE_I64] = {
        "ACMPSTORE.i64", BIFROST_MESSAGE_ATOMIC, BI_SIZE_64,
        BI_SR_COUNT_4, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ACMPXCHG_I32] = {
        "ACMPXCHG.i32", BIFROST_MESSAGE_ATOMIC, BI_SIZE_32,
        BI_SR_COUNT_2, 1, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ACMPXCHG_I64] = {
        "ACMPXCHG.i64", BIFROST_MESSAGE_ATOMIC, BI_SIZE_64,
        BI_SR_COUNT_4, 1, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ARSHIFT_I32] = {
        "ARSHIFT.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ARSHIFT_V2I16] = {
        "ARSHIFT.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ARSHIFT_V4I8] = {
        "ARSHIFT.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ARSHIFT_DOUBLE_I32] = {
        "ARSHIFT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATEST] = {
        "ATEST", BIFROST_MESSAGE_ATEST, BI_SIZE_32,
        BI_SR_COUNT_1, 0, 1, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C_I32] = {
        "ATOM_C.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C_I64] = {
        "ATOM_C.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C1_I32] = {
        "ATOM_C1.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C1_I64] = {
        "ATOM_C1.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C1_RETURN_I32] = {
        "ATOM_C1_RETURN.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C1_RETURN_I64] = {
        "ATOM_C1_RETURN.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_CX] = {
        "ATOM_CX", BIFROST_MESSAGE_ATOMIC, BI_SIZE_32,
        BI_SR_COUNT_SR_COUNT, 1, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C_RETURN_I32] = {
        "ATOM_C_RETURN.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_C_RETURN_I64] = {
        "ATOM_C_RETURN.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_POST_I32] = {
        "ATOM_POST.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_POST_I64] = {
        "ATOM_POST.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ATOM_PRE_I64] = {
        "ATOM_PRE.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_AXCHG_I32] = {
        "AXCHG.i32", BIFROST_MESSAGE_ATOMIC, BI_SIZE_32,
        BI_SR_COUNT_1, 1, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_AXCHG_I64] = {
        "AXCHG.i64", BIFROST_MESSAGE_ATOMIC, BI_SIZE_64,
        BI_SR_COUNT_2, 1, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BARRIER] = {
        "BARRIER", BIFROST_MESSAGE_BARRIER, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BITREV_I32] = {
        "BITREV.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BLEND] = {
        "BLEND", BIFROST_MESSAGE_BLEND, BI_SIZE_32,
        BI_SR_COUNT_SR_COUNT, 1, 0, 1, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_F16] = {
        "BRANCH.f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_F32] = {
        "BRANCH.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_I16] = {
        "BRANCH.i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_I32] = {
        "BRANCH.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_S16] = {
        "BRANCH.s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_S32] = {
        "BRANCH.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_U16] = {
        "BRANCH.u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_U32] = {
        "BRANCH.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHC_I16] = {
        "BRANCHC.i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHC_I32] = {
        "BRANCHC.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_F16] = {
        "BRANCHZ.f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_F32] = {
        "BRANCHZ.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_I16] = {
        "BRANCHZ.i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_I32] = {
        "BRANCHZ.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_S16] = {
        "BRANCHZ.s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_S32] = {
        "BRANCHZ.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_U16] = {
        "BRANCHZ.u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCHZ_U32] = {
        "BRANCHZ.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_DIVERG] = {
        "BRANCH_DIVERG", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_LOWBITS_F32] = {
        "BRANCH_LOWBITS.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_BRANCH_NO_DIVERG] = {
        "BRANCH_NO_DIVERG", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 1,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CLPER_I32] = {
        "CLPER.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CLPER_V6_I32] = {
        "CLPER_V6.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CLZ_U32] = {
        "CLZ.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CLZ_V2U16] = {
        "CLZ.v2u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CLZ_V4U8] = {
        "CLZ.v4u8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_F32] = {
        "CSEL.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_I32] = {
        "CSEL.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_S32] = {
        "CSEL.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_U32] = {
        "CSEL.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_V2F16] = {
        "CSEL.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_V2I16] = {
        "CSEL.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_V2S16] = {
        "CSEL.v2s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CSEL_V2U16] = {
        "CSEL.v2u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CUBEFACE] = {
        "CUBEFACE", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        7, 0,
    },
    
    [BI_OPCODE_CUBEFACE1] = {
        "CUBEFACE1", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        7, 0,
    },
    
    [BI_OPCODE_CUBEFACE2] = {
        "CUBEFACE2", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_CUBE_SSEL] = {
        "CUBE_SSEL", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        3, 0,
    },
    
    [BI_OPCODE_CUBE_TSEL] = {
        "CUBE_TSEL", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        3, 0,
    },
    
    [BI_OPCODE_DISCARD_B32] = {
        "DISCARD.b32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_DISCARD_F32] = {
        "DISCARD.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_DTSEL_IMM] = {
        "DTSEL_IMM", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_F16_TO_F32] = {
        "F16_TO_F32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_F16_TO_S32] = {
        "F16_TO_S32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_F16_TO_U32] = {
        "F16_TO_U32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_F32_TO_S32] = {
        "F32_TO_S32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_F32_TO_U32] = {
        "F32_TO_U32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FABSNEG_F32] = {
        "FABSNEG.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FABSNEG_V2F16] = {
        "FABSNEG.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FADD_F32] = {
        "FADD.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FADD_V2F16] = {
        "FADD.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FADD_IMM_F32] = {
        "FADD_IMM.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FADD_IMM_V2F16] = {
        "FADD_IMM.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FADD_LSCALE_F32] = {
        "FADD_LSCALE.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FADD_RSCALE_F32] = {
        "FADD_RSCALE.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FCLAMP_F32] = {
        "FCLAMP.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 1, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FCLAMP_V2F16] = {
        "FCLAMP.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 1, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FCMP_F32] = {
        "FCMP.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FCMP_V2F16] = {
        "FCMP.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FCOS_TABLE_U6] = {
        "FCOS_TABLE.u6", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FEXP_F32] = {
        "FEXP.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FEXP_TABLE_U4] = {
        "FEXP_TABLE.u4", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FLOGD_F32] = {
        "FLOGD.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FLOG_TABLE_F32] = {
        "FLOG_TABLE.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FLSHIFT_DOUBLE_I32] = {
        "FLSHIFT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FMA_F32] = {
        "FMA.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 1, 0, 7,
        7, 0,
    },
    
    [BI_OPCODE_FMA_V2F16] = {
        "FMA.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 1, 0, 0,
        7, 0,
    },
    
    [BI_OPCODE_FMAX_F32] = {
        "FMAX.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FMAX_V2F16] = {
        "FMAX.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FMA_RSCALE_F32] = {
        "FMA_RSCALE.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 1, 0, 1,
        7, 0,
    },
    
    [BI_OPCODE_FMA_RSCALE_V2F16] = {
        "FMA_RSCALE.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 1, 0, 1,
        7, 0,
    },
    
    [BI_OPCODE_FMIN_F32] = {
        "FMIN.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FMIN_V2F16] = {
        "FMIN.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FMUL_CSLICE] = {
        "FMUL_CSLICE", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FMUL_SLICE_F32] = {
        "FMUL_SLICE.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FPCLASS_F16] = {
        "FPCLASS.f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FPCLASS_F32] = {
        "FPCLASS.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FPOW_SC_APPLY] = {
        "FPOW_SC_APPLY", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FPOW_SC_DET_F16] = {
        "FPOW_SC_DET.f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FPOW_SC_DET_F32] = {
        "FPOW_SC_DET.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FRCP_F16] = {
        "FRCP.f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FRCP_F32] = {
        "FRCP.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FRCP_APPROX_F32] = {
        "FRCP_APPROX.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FREXPE_F32] = {
        "FREXPE.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        1, 0,
    },
    
    [BI_OPCODE_FREXPE_V2F16] = {
        "FREXPE.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        1, 0,
    },
    
    [BI_OPCODE_FREXPM_F32] = {
        "FREXPM.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FREXPM_V2F16] = {
        "FREXPM.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FROUND_F32] = {
        "FROUND.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FROUND_V2F16] = {
        "FROUND.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FRSCALE_F32] = {
        "FRSCALE.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FRSCALE_V2F16] = {
        "FRSCALE.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_FRSHIFT_DOUBLE_I32] = {
        "FRSHIFT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FRSQ_F16] = {
        "FRSQ.f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FRSQ_F32] = {
        "FRSQ.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FRSQ_APPROX_F32] = {
        "FRSQ_APPROX.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 1,
        1, 0,
    },
    
    [BI_OPCODE_FSINCOS_OFFSET_U6] = {
        "FSINCOS_OFFSET.u6", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_FSIN_TABLE_U6] = {
        "FSIN_TABLE.u6", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        1, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_HADD_S32] = {
        "HADD.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_HADD_U32] = {
        "HADD.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_HADD_V2S16] = {
        "HADD.v2s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_HADD_V2U16] = {
        "HADD.v2u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_HADD_V4S8] = {
        "HADD.v4s8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_HADD_V4U8] = {
        "HADD.v4u8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IABS_S32] = {
        "IABS.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IABS_V2S16] = {
        "IABS.v2s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IABS_V4S8] = {
        "IABS.v4s8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_S32] = {
        "IADD.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_U32] = {
        "IADD.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_V2S16] = {
        "IADD.v2s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_V2U16] = {
        "IADD.v2u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_V4S8] = {
        "IADD.v4s8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_V4U8] = {
        "IADD.v4u8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADDC_I32] = {
        "IADDC.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_IMM_I32] = {
        "IADD_IMM.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_IMM_V2I16] = {
        "IADD_IMM.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IADD_IMM_V4I8] = {
        "IADD_IMM.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_I32] = {
        "ICMP.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_S32] = {
        "ICMP.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_U32] = {
        "ICMP.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_V2I16] = {
        "ICMP.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_V2S16] = {
        "ICMP.v2s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_V2U16] = {
        "ICMP.v2u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_V4I8] = {
        "ICMP.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_V4S8] = {
        "ICMP.v4s8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMP_V4U8] = {
        "ICMP.v4u8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMPF_I32] = {
        "ICMPF.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMPI_I32] = {
        "ICMPI.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMPI_S32] = {
        "ICMPI.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMPI_U32] = {
        "ICMPI.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ICMPM_I32] = {
        "ICMPM.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IDP_V4I8] = {
        "IDP.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ILOGB_F32] = {
        "ILOGB.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ILOGB_V2F16] = {
        "ILOGB.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IMOV_FMA] = {
        "IMOV_FMA", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IMUL_I32] = {
        "IMUL.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IMUL_V2I16] = {
        "IMUL.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IMUL_V4I8] = {
        "IMUL.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_IMULD] = {
        "IMULD", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ISUB_S32] = {
        "ISUB.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ISUB_U32] = {
        "ISUB.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ISUB_V2S16] = {
        "ISUB.v2s16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ISUB_V2U16] = {
        "ISUB.v2u16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ISUB_V4S8] = {
        "ISUB.v4s8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ISUB_V4U8] = {
        "ISUB.v4u8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ISUBB_I32] = {
        "ISUBB.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_JUMP] = {
        "JUMP", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 1, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_JUMP_EX] = {
        "JUMP_EX", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LDEXP_F32] = {
        "LDEXP.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LDEXP_V2F16] = {
        "LDEXP.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_ATTR] = {
        "LD_ATTR", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_ATTR_IMM] = {
        "LD_ATTR_IMM", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_ATTR_TEX] = {
        "LD_ATTR_TEX", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_CVT] = {
        "LD_CVT", BIFROST_MESSAGE_LOAD, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_GCLK_U64] = {
        "LD_GCLK.u64", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_64,
        BI_SR_COUNT_2, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_TILE] = {
        "LD_TILE", BIFROST_MESSAGE_TILE, BI_SIZE_32,
        BI_SR_COUNT_VECSIZE, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_VAR] = {
        "LD_VAR", BIFROST_MESSAGE_VARYING, BI_SIZE_32,
        BI_SR_COUNT_VECSIZE, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_VAR_FLAT] = {
        "LD_VAR_FLAT", BIFROST_MESSAGE_VARYING, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_VAR_FLAT_IMM] = {
        "LD_VAR_FLAT_IMM", BIFROST_MESSAGE_VARYING, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_VAR_IMM] = {
        "LD_VAR_IMM", BIFROST_MESSAGE_VARYING, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LD_VAR_SPECIAL] = {
        "LD_VAR_SPECIAL", BIFROST_MESSAGE_VARYING, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LEA_ATTR] = {
        "LEA_ATTR", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_3, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LEA_ATTR_IMM] = {
        "LEA_ATTR_IMM", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_3, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LEA_ATTR_TEX] = {
        "LEA_ATTR_TEX", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_3, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LEA_TEX] = {
        "LEA_TEX", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_3, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LEA_TEX_IMM] = {
        "LEA_TEX_IMM", BIFROST_MESSAGE_ATTRIBUTE, BI_SIZE_32,
        BI_SR_COUNT_3, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I128] = {
        "LOAD.i128", BIFROST_MESSAGE_LOAD, BI_SIZE_128,
        BI_SR_COUNT_4, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I16] = {
        "LOAD.i16", BIFROST_MESSAGE_LOAD, BI_SIZE_16,
        BI_SR_COUNT_1, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I24] = {
        "LOAD.i24", BIFROST_MESSAGE_LOAD, BI_SIZE_24,
        BI_SR_COUNT_1, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I32] = {
        "LOAD.i32", BIFROST_MESSAGE_LOAD, BI_SIZE_32,
        BI_SR_COUNT_1, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I48] = {
        "LOAD.i48", BIFROST_MESSAGE_LOAD, BI_SIZE_48,
        BI_SR_COUNT_2, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I64] = {
        "LOAD.i64", BIFROST_MESSAGE_LOAD, BI_SIZE_64,
        BI_SR_COUNT_2, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I8] = {
        "LOAD.i8", BIFROST_MESSAGE_LOAD, BI_SIZE_8,
        BI_SR_COUNT_1, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOAD_I96] = {
        "LOAD.i96", BIFROST_MESSAGE_LOAD, BI_SIZE_96,
        BI_SR_COUNT_3, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOGB_F32] = {
        "LOGB.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LOGB_V2F16] = {
        "LOGB.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LROT_DOUBLE_I32] = {
        "LROT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LSHIFT_AND_I32] = {
        "LSHIFT_AND.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_LSHIFT_AND_V2I16] = {
        "LSHIFT_AND.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_LSHIFT_AND_V4I8] = {
        "LSHIFT_AND.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_LSHIFT_DOUBLE_I32] = {
        "LSHIFT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_LSHIFT_OR_I32] = {
        "LSHIFT_OR.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_LSHIFT_OR_V2I16] = {
        "LSHIFT_OR.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_LSHIFT_OR_V4I8] = {
        "LSHIFT_OR.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_LSHIFT_XOR_I32] = {
        "LSHIFT_XOR.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 0,
    },
    
    [BI_OPCODE_LSHIFT_XOR_V2I16] = {
        "LSHIFT_XOR.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 0,
    },
    
    [BI_OPCODE_LSHIFT_XOR_V4I8] = {
        "LSHIFT_XOR.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 0,
    },
    
    [BI_OPCODE_MKVEC_V2I16] = {
        "MKVEC.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_MKVEC_V4I8] = {
        "MKVEC.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_MOV_I32] = {
        "MOV.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_MUX_I32] = {
        "MUX.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_MUX_V2I16] = {
        "MUX.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_MUX_V4I8] = {
        "MUX.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_NOP] = {
        "NOP", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_PATOM_C_I32] = {
        "PATOM_C.i32", BIFROST_MESSAGE_ATOMIC, BI_SIZE_32,
        BI_SR_COUNT_SR_COUNT, 1, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_PATOM_C1_I32] = {
        "PATOM_C1.i32", BIFROST_MESSAGE_ATOMIC, BI_SIZE_32,
        BI_SR_COUNT_SR_COUNT, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_POPCOUNT_I32] = {
        "POPCOUNT.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_QUIET_F32] = {
        "QUIET.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_QUIET_V2F16] = {
        "QUIET.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_RROT_DOUBLE_I32] = {
        "RROT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_RSHIFT_AND_I32] = {
        "RSHIFT_AND.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_RSHIFT_AND_V2I16] = {
        "RSHIFT_AND.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_RSHIFT_AND_V4I8] = {
        "RSHIFT_AND.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_RSHIFT_DOUBLE_I32] = {
        "RSHIFT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_RSHIFT_OR_I32] = {
        "RSHIFT_OR.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_RSHIFT_OR_V2I16] = {
        "RSHIFT_OR.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_RSHIFT_OR_V4I8] = {
        "RSHIFT_OR.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 1,
    },
    
    [BI_OPCODE_RSHIFT_XOR_I32] = {
        "RSHIFT_XOR.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 0,
    },
    
    [BI_OPCODE_RSHIFT_XOR_V2I16] = {
        "RSHIFT_XOR.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 0,
    },
    
    [BI_OPCODE_RSHIFT_XOR_V4I8] = {
        "RSHIFT_XOR.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 1, 0,
        0, 0,
    },
    
    [BI_OPCODE_S16_TO_F32] = {
        "S16_TO_F32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_S16_TO_S32] = {
        "S16_TO_S32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_S32_TO_F32] = {
        "S32_TO_F32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_S8_TO_F32] = {
        "S8_TO_F32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_S8_TO_S32] = {
        "S8_TO_S32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SEG_ADD] = {
        "SEG_ADD", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SEG_ADD_I64] = {
        "SEG_ADD.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SHADDXH_I32] = {
        "SHADDXH.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SHADDXL_I64] = {
        "SHADDXL.i64", BIFROST_MESSAGE_NONE, BI_SIZE_64,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SHADDXL_S32] = {
        "SHADDXL.s32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SHADDXL_U32] = {
        "SHADDXL.u32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SHIFT_DOUBLE_I32] = {
        "SHIFT_DOUBLE.i32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I128] = {
        "STORE.i128", BIFROST_MESSAGE_STORE, BI_SIZE_128,
        BI_SR_COUNT_4, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I16] = {
        "STORE.i16", BIFROST_MESSAGE_STORE, BI_SIZE_16,
        BI_SR_COUNT_1, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I24] = {
        "STORE.i24", BIFROST_MESSAGE_STORE, BI_SIZE_24,
        BI_SR_COUNT_1, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I32] = {
        "STORE.i32", BIFROST_MESSAGE_STORE, BI_SIZE_32,
        BI_SR_COUNT_1, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I48] = {
        "STORE.i48", BIFROST_MESSAGE_STORE, BI_SIZE_48,
        BI_SR_COUNT_2, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I64] = {
        "STORE.i64", BIFROST_MESSAGE_STORE, BI_SIZE_64,
        BI_SR_COUNT_2, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I8] = {
        "STORE.i8", BIFROST_MESSAGE_STORE, BI_SIZE_8,
        BI_SR_COUNT_1, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_STORE_I96] = {
        "STORE.i96", BIFROST_MESSAGE_STORE, BI_SIZE_96,
        BI_SR_COUNT_3, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ST_CVT] = {
        "ST_CVT", BIFROST_MESSAGE_STORE, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ST_TILE] = {
        "ST_TILE", BIFROST_MESSAGE_TILE, BI_SIZE_32,
        BI_SR_COUNT_FORMAT, 1, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SWZ_V2I16] = {
        "SWZ.v2i16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_SWZ_V4I8] = {
        "SWZ.v4i8", BIFROST_MESSAGE_NONE, BI_SIZE_8,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_TEXC] = {
        "TEXC", BIFROST_MESSAGE_TEX, BI_SIZE_32,
        BI_SR_COUNT_SR_COUNT, 1, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_TEXS_2D_F16] = {
        "TEXS_2D.f16", BIFROST_MESSAGE_TEX, BI_SIZE_16,
        BI_SR_COUNT_2, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_TEXS_2D_F32] = {
        "TEXS_2D.f32", BIFROST_MESSAGE_TEX, BI_SIZE_32,
        BI_SR_COUNT_4, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_TEXS_CUBE_F16] = {
        "TEXS_CUBE.f16", BIFROST_MESSAGE_TEX, BI_SIZE_16,
        BI_SR_COUNT_2, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_TEXS_CUBE_F32] = {
        "TEXS_CUBE.f32", BIFROST_MESSAGE_TEX, BI_SIZE_32,
        BI_SR_COUNT_4, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_U16_TO_F32] = {
        "U16_TO_F32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_U16_TO_U32] = {
        "U16_TO_U32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_U32_TO_F32] = {
        "U32_TO_F32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_U8_TO_F32] = {
        "U8_TO_F32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_U8_TO_U32] = {
        "U8_TO_U32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2F16_TO_V2S16] = {
        "V2F16_TO_V2S16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2F16_TO_V2U16] = {
        "V2F16_TO_V2U16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2F32_TO_V2F16] = {
        "V2F32_TO_V2F16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 1, 1, 0, 3,
        3, 0,
    },
    
    [BI_OPCODE_V2S16_TO_V2F16] = {
        "V2S16_TO_V2F16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2S8_TO_V2F16] = {
        "V2S8_TO_V2F16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2S8_TO_V2S16] = {
        "V2S8_TO_V2S16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2U16_TO_V2F16] = {
        "V2U16_TO_V2F16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2U8_TO_V2F16] = {
        "V2U8_TO_V2F16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_V2U8_TO_V2U16] = {
        "V2U8_TO_V2U16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_VAR_TEX_F16] = {
        "VAR_TEX.f16", BIFROST_MESSAGE_VARTEX, BI_SIZE_16,
        BI_SR_COUNT_2, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_VAR_TEX_F32] = {
        "VAR_TEX.f32", BIFROST_MESSAGE_VARTEX, BI_SIZE_32,
        BI_SR_COUNT_4, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_VN_ASST1_F16] = {
        "VN_ASST1.f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        4, 0,
    },
    
    [BI_OPCODE_VN_ASST1_F32] = {
        "VN_ASST1.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 1, 0, 0, 0, 0,
        4, 0,
    },
    
    [BI_OPCODE_VN_ASST2_F32] = {
        "VN_ASST2.f32", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        1, 0,
    },
    
    [BI_OPCODE_VN_ASST2_V2F16] = {
        "VN_ASST2.v2f16", BIFROST_MESSAGE_NONE, BI_SIZE_16,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        1, 0,
    },
    
    [BI_OPCODE_WMASK] = {
        "WMASK", BIFROST_MESSAGE_NONE, BI_SIZE_32,
        BI_SR_COUNT_0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
    
    [BI_OPCODE_ZS_EMIT] = {
        "ZS_EMIT", BIFROST_MESSAGE_Z_STENCIL, BI_SIZE_32,
        BI_SR_COUNT_1, 0, 1, 0, 0,
        0, 0, 1, 0, 0, 0,
        0, 0,
    },
};
