/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.internal.ui.UpdateUI;

public class InstallationHistoryAction
extends Action {
    private BufferedReader buffRead;
    private PrintWriter htmlLog;
    private File tempFile;
    private String rowType;
    private IPath path;
    private static final String lightBlue = "#EEEEFF";
    private static final String white = "#FFFFFF";
    private static final String darkBlue = "#99AADD";
    private static final String ACTIVITY = "ACTIVITY";

    public InstallationHistoryAction(String text, ImageDescriptor desc) {
        super(text, desc);
        String location = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation().getFile();
        this.path = new Path(location).removeLastSegments(1).append("install.log");
        this.rowType = "light-row";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.openLog();
            this.parseLog();
            UpdateUI.showURL("file:" + this.getTempFile().getPath().toString());
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        finally {
            this.closeLog();
        }
    }

    private void openLog() throws CoreException {
        try {
            this.buffRead = new BufferedReader(new FileReader(this.path.toOSString()));
            this.htmlLog = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTempFile()), "UTF-8")));
        }
        catch (FileNotFoundException e) {
            this.throwCoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            this.throwCoreException(e);
        }
    }

    private File getTempFile() throws CoreException {
        if (this.tempFile == null) {
            try {
                this.tempFile = File.createTempFile("install-log", ".html");
                this.tempFile.deleteOnExit();
            }
            catch (IOException e) {
                this.throwCoreException(e);
            }
        }
        return this.tempFile;
    }

    private void parseLog() throws CoreException {
        try {
            this.htmlLog.println("<html>");
            this.htmlLog.println("<head>");
            this.htmlLog.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
            this.htmlLog.println("<title>Install-Log</title>");
            this.addCSS();
            this.htmlLog.println("</head>");
            this.htmlLog.println("<body>");
            String title = UpdateUI.getString("InstallationHistoryAction.title");
            String desc = UpdateUI.getString("InstallationHistoryAction.desc");
            this.htmlLog.println("<h1 class=title>" + title + "</h1>");
            this.htmlLog.println("<p class=bodyText>" + desc + "</p>");
            this.htmlLog.println("<center>");
            this.htmlLog.println("<table width =100% border=0 cellspacing=1 cellpadding=2>");
            while (this.buffRead.ready()) {
                String date;
                DateFormat df;
                Date d;
                StringTokenizer htmlCode = new StringTokenizer(this.buffRead.readLine());
                while (!htmlCode.hasMoreElements()) {
                    if (!this.buffRead.ready()) {
                        return;
                    }
                    htmlCode = new StringTokenizer(this.buffRead.readLine());
                }
                String type = htmlCode.nextToken();
                if ((type = type.substring(type.indexOf("!") + 1, type.length())).equals(ACTIVITY)) {
                    String target = "";
                    d = new Date(new Long(htmlCode.nextToken()));
                    df = DateFormat.getDateTimeInstance();
                    date = df.format(d);
                    htmlCode.nextToken(".");
                    htmlCode.nextToken(" ");
                    while (htmlCode.countTokens() > 2) {
                        target = target + " " + htmlCode.nextToken();
                    }
                    String action = htmlCode.nextToken();
                    String status = htmlCode.nextToken();
                    this.addActivity(action, date, status, target);
                    continue;
                }
                this.htmlLog.println();
                this.htmlLog.println("<tr id=separator><td colspan=4></td></tr>");
                this.htmlLog.println();
                d = new Date(new Long(htmlCode.nextToken()));
                df = DateFormat.getDateTimeInstance();
                date = df.format(d);
                this.addConfigurationHeader(date);
                this.addActivityHeader();
            }
            this.htmlLog.println("</table>");
            this.htmlLog.println("</body>");
            this.htmlLog.println("</html>");
        }
        catch (Exception e) {
            this.throwCoreException(e);
        }
    }

    private void addActivity(String type, String date, String status, String target) {
        this.htmlLog.print("<tr class=" + this.rowType + ">");
        this.htmlLog.print("<td class=log-text width=30%>");
        this.htmlLog.print(date);
        this.htmlLog.println("</td>");
        this.htmlLog.print("<td class=log-text width=40%>");
        this.htmlLog.print(target);
        this.htmlLog.println("</td>");
        this.htmlLog.print("<td class=log-text width=20%>");
        this.htmlLog.print(type);
        this.htmlLog.println("</td>");
        this.htmlLog.print("<td class=log-text width=10%>");
        this.htmlLog.print(status);
        this.htmlLog.println("</td></tr>");
        this.toggleRowColor();
    }

    private void addCSS() {
        this.htmlLog.println("<STYLE type=\"text/css\">");
        this.htmlLog.println("H1.title { font-family: sans-serif; color: #99AACC }");
        this.htmlLog.println("P.bodyText { font-family: sans-serif; font-size: 9pt; }");
        this.htmlLog.println("TD.log-header { font-family: sans-serif; font-style: normal; font-weight: bold; font-size: 9pt; color: white}");
        this.htmlLog.println("TD.log-text { font-family: sans-serif; font-style: normal; font-weight: lighter; font-size: 8pt; color:black}");
        this.htmlLog.println("TD.config-log-header { font-family: sans-serif; font-style: normal; font-weight: bold; font-size: 9pt; color: white; border-top:10px solid white}");
        this.htmlLog.println("TR.light-row {background:#FFFFFF}");
        this.htmlLog.println("TR.dark-row {background:#EEEEFF}");
        this.htmlLog.println("TR.header {background:#99AADD}");
        this.htmlLog.println("</STYLE>");
    }

    private void addActivityHeader() {
        this.htmlLog.print("<tr class=header>");
        this.htmlLog.print("<td class=log-header>");
        this.htmlLog.print(UpdateUI.getString("InstallationHistoryAction.dateTime"));
        this.htmlLog.print("</td>");
        this.htmlLog.print("<td class=log-header>");
        this.htmlLog.print(UpdateUI.getString("InstallationHistoryAction.target"));
        this.htmlLog.print("</td>");
        this.htmlLog.print("<td class=log-header>");
        this.htmlLog.print(UpdateUI.getString("InstallationHistoryAction.action"));
        this.htmlLog.print("</td>");
        this.htmlLog.print("<td class=log-header>");
        this.htmlLog.print(UpdateUI.getString("InstallationHistoryAction.status"));
        this.htmlLog.println("</td></tr>");
    }

    private void addConfigurationHeader(String date) {
        if (date == null) {
            return;
        }
        this.htmlLog.print("<tr class=header>");
        this.htmlLog.print("<td class=config-log-header colspan=4>");
        this.htmlLog.print(date);
        this.htmlLog.println("</td></tr>");
    }

    private void toggleRowColor() {
        this.rowType = this.rowType.equals("light-row") ? "dark-row" : "light-row";
    }

    private void throwCoreException(Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, UpdateUI.getPluginId(), 4, UpdateUI.getString("InstallationHistoryAction.errors"), e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLog() {
        try {
            if (this.buffRead != null) {
                this.buffRead.close();
            }
            if (this.htmlLog != null) {
                this.htmlLog.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.buffRead = null;
            this.htmlLog = null;
        }
    }
}

