/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PartListenerList;
import org.eclipse.ui.internal.PartListenerList2;
import org.eclipse.ui.internal.WindowSelectionService;
import org.eclipse.ui.internal.WorkbenchPage;

public class WWinPartService
implements IPartService {
    private PartListenerList listeners = new PartListenerList();
    private PartListenerList2 listeners2 = new PartListenerList2();
    private WindowSelectionService selectionService;
    private IWorkbenchPage activePage;
    private IPartListener2 partListner = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
            WWinPartService.this.firePartActivated(ref);
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            WWinPartService.this.firePartBroughtToTop(ref);
        }

        public void partClosed(IWorkbenchPartReference ref) {
            WWinPartService.this.firePartClosed(ref);
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
            WWinPartService.this.firePartDeactivated(ref);
        }

        public void partOpened(IWorkbenchPartReference ref) {
            WWinPartService.this.firePartOpened(ref);
        }

        public void partHidden(IWorkbenchPartReference ref) {
            WWinPartService.this.listeners2.firePartHidden(ref);
        }

        public void partVisible(IWorkbenchPartReference ref) {
            WWinPartService.this.listeners2.firePartVisible(ref);
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            WWinPartService.this.listeners2.firePartInputChanged(ref);
        }
    };

    public WWinPartService(IWorkbenchWindow window) {
        this.selectionService = new WindowSelectionService(window);
    }

    public void addPartListener(IPartListener l) {
        this.listeners.addPartListener(l);
    }

    public void addPartListener(IPartListener2 l) {
        this.listeners2.addPartListener(l);
    }

    public void removePartListener(IPartListener l) {
        this.listeners.removePartListener(l);
    }

    public void removePartListener(IPartListener2 l) {
        this.listeners2.removePartListener(l);
    }

    public IWorkbenchPart getActivePart() {
        if (this.activePage != null) {
            return this.activePage.getActivePart();
        }
        return null;
    }

    public IWorkbenchPartReference getActivePartReference() {
        if (this.activePage != null) {
            return this.activePage.getActivePartReference();
        }
        return null;
    }

    ISelectionService getSelectionService() {
        return this.selectionService;
    }

    void pageActivated(IWorkbenchPage newPage) {
        if (newPage == this.activePage) {
            return;
        }
        this.reset();
        this.activePage = newPage;
        if (this.activePage != null) {
            IWorkbenchPartReference[] refs = ((WorkbenchPage)this.activePage).getOpenParts();
            for (int i = 0; i < refs.length; ++i) {
                IWorkbenchPartReference reference = refs[i];
                this.firePartOpened(reference);
            }
            this.activePage.addPartListener(this.partListner);
            if (this.getActivePart() != null) {
                this.partListner.partActivated(this.getActivePartReference());
            }
        }
    }

    void pageClosed(IWorkbenchPage page) {
        if (page == this.activePage) {
            this.reset();
        }
    }

    void pageOpened(IWorkbenchPage page) {
        this.pageActivated(page);
    }

    private void reset() {
        if (this.activePage != null) {
            IWorkbenchPartReference[] refs = ((WorkbenchPage)this.activePage).getOpenParts();
            for (int i = 0; i < refs.length; ++i) {
                IWorkbenchPartReference reference = refs[i];
                this.firePartClosed(reference);
            }
            this.activePage.removePartListener(this.partListner);
            this.activePage = null;
        }
        this.selectionService.reset();
    }

    private void firePartActivated(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.listeners.firePartActivated(part);
            this.selectionService.partActivated(part);
        }
        this.listeners2.firePartActivated(ref);
    }

    private void firePartBroughtToTop(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.listeners.firePartBroughtToTop(part);
            this.selectionService.partBroughtToTop(part);
        }
        this.listeners2.firePartBroughtToTop(ref);
    }

    private void firePartClosed(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.listeners.firePartClosed(part);
            this.selectionService.partClosed(part);
        }
        this.listeners2.firePartClosed(ref);
    }

    private void firePartDeactivated(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.listeners.firePartDeactivated(part);
            this.selectionService.partDeactivated(part);
        }
        this.listeners2.firePartDeactivated(ref);
    }

    private void firePartOpened(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        if (part != null) {
            this.listeners.firePartOpened(part);
            this.selectionService.partOpened(part);
        }
        this.listeners2.firePartOpened(ref);
    }
}

