/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.layout.SizeCache;

public class ProxyControl {
    private Composite control;
    private SizeCache target;

    public ProxyControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setVisible(false);
        this.control.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                if (ProxyControl.this.target == null) {
                    return new Point(0, 0);
                }
                return ProxyControl.this.target.computeSize(wHint, hHint);
            }
        });
    }

    public void setTarget(SizeCache target) {
        if (this.target != target) {
            this.target = target;
        }
    }

    public Control getTargetControl() {
        if (this.target == null) {
            return null;
        }
        return this.target.getControl();
    }

    public Control getControl() {
        return this.control;
    }

    public void layout() {
        if (this.getTargetControl() == null) {
            return;
        }
        Rectangle parentBounds = DragUtil.getDisplayBounds((Control)this.control.getParent());
        Rectangle bounds = this.control.getBounds();
        bounds.x += parentBounds.x;
        bounds.y += parentBounds.y;
        bounds = bounds.intersection(parentBounds);
        Rectangle targetBounds = Geometry.toControl((Control)this.getTargetControl().getParent(), (Rectangle)bounds);
        this.getTargetControl().setBounds(targetBounds);
    }

    public void dispose() {
        if (this.control == null) {
            return;
        }
        this.target = null;
        this.control.dispose();
        this.control = null;
    }
}

