/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.display;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.display.DisplayCompletionProcessor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class DetailsCompletionProcessor
extends DisplayCompletionProcessor {
    static /* synthetic */ Class class$org$eclipse$jdt$debug$core$IJavaStackFrame;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null) {
            return new ICompletionProposal[0];
        }
        IJavaStackFrame stackFrame = (IJavaStackFrame)context.getAdapter(class$org$eclipse$jdt$debug$core$IJavaStackFrame == null ? (class$org$eclipse$jdt$debug$core$IJavaStackFrame = DetailsCompletionProcessor.class$("org.eclipse.jdt.debug.core.IJavaStackFrame")) : class$org$eclipse$jdt$debug$core$IJavaStackFrame);
        if (stackFrame == null) {
            return new ICompletionProposal[0];
        }
        IWorkbenchWindow window = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return new ICompletionProposal[0];
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return new ICompletionProposal[0];
        }
        IDebugView view = (IDebugView)page.getActivePart();
        if (view == null) {
            return new ICompletionProposal[0];
        }
        ISelection selection = view.getViewer().getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return super.computeCompletionProposals(stackFrame, viewer, documentOffset);
        }
        IStructuredSelection viewerSelection = (IStructuredSelection)selection;
        if (viewerSelection.size() > 1) {
            return new ICompletionProposal[0];
        }
        Object element = viewerSelection.getFirstElement();
        IJavaProject project = this.getJavaProject((IStackFrame)stackFrame);
        if (project != null) {
            try {
                ITextSelection textSelection = (ITextSelection)viewer.getSelectionProvider().getSelection();
                IType receivingType = this.getReceivingType(project, element);
                if (receivingType == null) {
                    return new ICompletionProposal[0];
                }
                this.configureResultCollector(project, textSelection);
                int insertionPosition = this.computeInsertionPosition(receivingType, stackFrame);
                receivingType.codeComplete(viewer.getDocument().get().toCharArray(), insertionPosition, documentOffset, (char[][])new char[0][], (char[][])new char[0][], new int[0], false, (ICompletionRequestor)this.getCollector());
                return this.order((IJavaCompletionProposal[])this.getCollector().getResults());
            }
            catch (JavaModelException x) {
                this.handle(viewer, (CoreException)((Object)x));
            }
            catch (DebugException de) {
                this.handle(viewer, (CoreException)((Object)de));
            }
        }
        return null;
    }

    private IType getReceivingType(IJavaProject project, Object element) throws DebugException {
        int index;
        String originalTypeName = this.getReceivingTypeName(element);
        if (originalTypeName == null) {
            return null;
        }
        String typeName = originalTypeName;
        int dollarIndex = typeName.indexOf(36);
        if (dollarIndex >= 0) {
            typeName = typeName.substring(0, dollarIndex);
        }
        if ((index = typeName.lastIndexOf(46)) >= 0) {
            typeName = typeName.replace('.', '/');
        }
        typeName = typeName + ".java";
        return this.getType(project, originalTypeName, typeName);
    }

    private String getReceivingTypeName(Object element) {
        IValue value = null;
        try {
            if (element instanceof IVariable) {
                value = ((IVariable)element).getValue();
                if (value instanceof IJavaArray) {
                    return null;
                }
            } else if (element instanceof IExpression) {
                value = ((IExpression)element).getValue();
            }
            if (value != null) {
                return value.getReferenceTypeName();
            }
        }
        catch (DebugException de) {
            JDIDebugUIPlugin.log(de);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

