/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ContainerGenerator {
    private IPath fContainerFullPath;
    private IContainer fContainer;
    private IWorkspace fWorkspace;

    public ContainerGenerator(IWorkspace workspace, IPath containerPath) {
        this.fWorkspace = workspace;
        this.fContainerFullPath = containerPath;
    }

    private IFolder createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        folderHandle.create(false, true, monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return folderHandle;
    }

    private IFolder createFolderHandle(IContainer container, String folderName) {
        return container.getFolder((IPath)new Path(folderName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject createProject(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
        return projectHandle;
    }

    private IProject createProjectHandle(IWorkspaceRoot root, String projectName) {
        return root.getProject(projectName);
    }

    public IContainer generateContainer(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(FileBuffersMessages.getString("ContainerGenerator.task.creatingContainer"), 1000 * ContainerGenerator.this.fContainerFullPath.segmentCount());
                if (ContainerGenerator.this.fContainer != null) {
                    return;
                }
                IWorkspaceRoot root = ContainerGenerator.this.fWorkspace.getRoot();
                IResource found = root.findMember(ContainerGenerator.this.fContainerFullPath);
                if (found instanceof IContainer) {
                    ContainerGenerator.this.fContainer = (IContainer)found;
                    return;
                }
                if (found != null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getFormattedString("ContainerGenerator.destinationMustBeAContainer", ContainerGenerator.this.fContainerFullPath), null));
                }
                ContainerGenerator.this.fContainer = (IContainer)root;
                for (int i = 0; i < ContainerGenerator.this.fContainerFullPath.segmentCount(); ++i) {
                    String currentSegment = ContainerGenerator.this.fContainerFullPath.segment(i);
                    IResource resource = ContainerGenerator.this.fContainer.findMember(currentSegment);
                    if (resource != null) {
                        if (resource instanceof IContainer) {
                            ContainerGenerator.this.fContainer = (IContainer)resource;
                            monitor.worked(1000);
                            continue;
                        }
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getFormattedString("ContainerGenerator.destinationMustBeAContainer", resource.getFullPath()), null));
                    }
                    if (i == 0) {
                        IProject projectHandle = ContainerGenerator.this.createProjectHandle(root, currentSegment);
                        ContainerGenerator.this.fContainer = (IContainer)ContainerGenerator.this.createProject(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        continue;
                    }
                    IFolder folderHandle = ContainerGenerator.this.createFolderHandle(ContainerGenerator.this.fContainer, currentSegment);
                    ContainerGenerator.this.fContainer = (IContainer)ContainerGenerator.this.createFolder(folderHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
            }
        };
        IWorkspaceRoot root = this.fWorkspace.getRoot();
        IPath existingParentPath = this.fContainerFullPath;
        while (!root.exists(existingParentPath)) {
            existingParentPath = existingParentPath.removeLastSegments(1);
        }
        IResource schedulingRule = root.findMember(existingParentPath);
        this.fWorkspace.run(runnable, (ISchedulingRule)schedulingRule, 1, monitor);
        return this.fContainer;
    }
}

