/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.StreamDocumentProvider;
import org.eclipse.ui.IStorageEditorInput;

public class StorageDocumentProvider
extends StreamDocumentProvider {
    public StorageDocumentProvider(IDocumentPartitioner partitioner) {
        this(partitioner, null);
    }

    public StorageDocumentProvider(IDocumentPartitioner partitioner, String encoding) {
        super(partitioner, encoding);
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof IStorageEditorInput) {
            IDocument document = this.createEmptyDocument();
            IDocumentPartitioner part = this.getPartitioner();
            if (part != null) {
                part.connect(document);
                document.setDocumentPartitioner(part);
            }
            IStorage storage = ((IStorageEditorInput)element).getStorage();
            this.setDocumentContent(document, storage);
            return document;
        }
        return null;
    }

    protected void setDocumentContent(IDocument document, IStorage storage) {
        try {
            InputStream contentStream = storage.getContents();
            this.setDocumentContent(document, contentStream);
            contentStream.close();
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }
}

