/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.editor.XMLDoubleClickStrategy;
import org.eclipse.pde.internal.ui.editor.XMLSourcePage;
import org.eclipse.pde.internal.ui.editor.text.AnnotationHover;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.IReconcilingParticipant;
import org.eclipse.pde.internal.ui.editor.text.NonRuleBasedDamagerRepairer;
import org.eclipse.pde.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.pde.internal.ui.editor.text.XMLScanner;
import org.eclipse.pde.internal.ui.editor.text.XMLTagScanner;

public class XMLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private AnnotationHover fAnnotationHover;
    private XMLDoubleClickStrategy fDoubleClickStrategy;
    private XMLTagScanner fTagScanner;
    private XMLScanner fPdeScanner;
    private IColorManager fColorManager;
    private XMLSourcePage fSourcePage;
    private MonoReconciler fReconciler;
    private NonRuleBasedDamagerRepairer fNdr;
    private TextAttribute fXMLCommentAttr;

    public XMLSourceViewerConfiguration(XMLSourcePage page, IColorManager colorManager) {
        this.fSourcePage = page;
        this.setColorManager(colorManager);
    }

    public void setColorManager(IColorManager colorManager) {
        this.fColorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    protected XMLScanner getPDEScanner() {
        if (this.fPdeScanner == null) {
            this.fPdeScanner = new XMLScanner(this.fColorManager);
            this.fPdeScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.fColorManager.getColor("editor.color.default"))));
        }
        return this.fPdeScanner;
    }

    public void applyColorPreferenceChange() {
        this.fPdeScanner = new XMLScanner(this.fColorManager);
        this.fPdeScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.fColorManager.getColor("editor.color.default"))));
        this.fTagScanner = new XMLTagScanner(this.fColorManager);
        this.fTagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.fColorManager.getColor("editor.color.tag"))));
    }

    protected XMLTagScanner getPDETagScanner() {
        if (this.fTagScanner == null) {
            this.fTagScanner = new XMLTagScanner(this.fColorManager);
            this.fTagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.fColorManager.getColor("editor.color.tag"))));
        }
        return this.fTagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer fDr = new DefaultDamagerRepairer((ITokenScanner)this.getPDEScanner());
        reconciler.setDamager((IPresentationDamager)fDr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)fDr, "__dftl_partition_content_type");
        fDr = new DefaultDamagerRepairer((ITokenScanner)this.getPDETagScanner());
        reconciler.setDamager((IPresentationDamager)fDr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)fDr, "__xml_tag");
        this.fXMLCommentAttr = new TextAttribute(this.fColorManager.getColor("editor.color.xml_comment"));
        this.fNdr = new NonRuleBasedDamagerRepairer(this.fXMLCommentAttr);
        reconciler.setDamager((IPresentationDamager)this.fNdr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)this.fNdr, "__xml_comment");
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationHover();
        }
        return this.fAnnotationHover;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IBaseModel model;
        if (this.fReconciler == null && (model = this.fSourcePage.getInputContext().getModel()) instanceof IReconcilingParticipant) {
            ReconcilingStrategy strategy = new ReconcilingStrategy();
            strategy.addParticipant((IReconcilingParticipant)model);
            if (this.fSourcePage.getContentOutline() instanceof IReconcilingParticipant) {
                strategy.addParticipant((IReconcilingParticipant)this.fSourcePage.getContentOutline());
            }
            this.fReconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            this.fReconciler.setDelay(500);
        }
        return this.fReconciler;
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTagScanner == null) {
            return;
        }
        this.fTagScanner.adaptToPreferenceChange((ColorManager)this.fColorManager, event);
        this.fPdeScanner.adaptToPreferenceChange((ColorManager)this.fColorManager, event);
        String property = event.getProperty();
        if (property.startsWith("editor.color.xml_comment")) {
            this.adaptToColorChange(event);
            this.fNdr.setDefaultTextAttribute(this.fXMLCommentAttr);
        }
    }

    private void adaptToColorChange(PropertyChangeEvent event) {
        ((ColorManager)this.fColorManager).updateProperty(event.getProperty());
        this.fXMLCommentAttr = new TextAttribute(((ColorManager)this.fColorManager).getColor(event.getProperty()), this.fXMLCommentAttr.getBackground(), this.fXMLCommentAttr.getStyle());
    }
}

