/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class WorkbenchLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILauncherSettings {
    private static final String KEY_BAD_FEATURE_SETUP = "WorkbenchLauncherConfigurationDelegate.badFeatureSetup";
    private static final String KEY_NO_STARTUP = "WorkbenchLauncherConfigurationDelegate.noStartup";
    private File fConfigDir = null;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.fConfigDir = null;
            monitor.beginTask("", 5);
            String workspace = configuration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
            if (!LauncherUtils.clearWorkspace(configuration, workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                monitor.setCanceled(true);
                return;
            }
            if (configuration.getAttribute("clearConfig", false)) {
                LauncherUtils.clearConfigArea(this.getConfigDir(configuration), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            launch.setAttribute("configLocation", this.getConfigDir(configuration).toString());
            IVMInstall launcher = LauncherUtils.createLauncher(configuration);
            monitor.worked(1);
            VMRunnerConfiguration runnerConfig = this.createVMRunner(configuration);
            if (runnerConfig == null) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            LauncherUtils.setDefaultSourceLocator(configuration, launch);
            PDEPlugin.getDefault().getLaunchesListener().manage(launch);
            launcher.getVMRunner(mode).run(runnerConfig, launch, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    private VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LauncherUtils.constructClasspath(configuration);
        if (classpath == null) {
            String message = PDEPlugin.getResourceString(KEY_NO_STARTUP);
            throw new CoreException(LauncherUtils.createErrorStatus(message));
        }
        String[] programArgs = this.getProgramArguments(configuration);
        if (programArgs == null) {
            return null;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration("org.eclipse.core.launcher.Main", classpath);
        runnerConfig.setVMArguments(this.getVMArguments(configuration));
        runnerConfig.setProgramArguments(programArgs);
        runnerConfig.setEnvironment(envp);
        return runnerConfig;
    }

    private String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        if (configuration.getAttribute("useProduct", false)) {
            programArgs.add("-product");
            programArgs.add(configuration.getAttribute("product", ""));
        } else {
            programArgs.add("-application");
            programArgs.add(configuration.getAttribute("application", LauncherUtils.getDefaultApplicationName()));
        }
        String targetWorkspace = configuration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
        programArgs.add("-data");
        programArgs.add(targetWorkspace);
        boolean isOSGI = PDECore.getDefault().getModelManager().isOSGiRuntime();
        if (configuration.getAttribute("usefeatures", false)) {
            this.validateFeatures();
            IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
            programArgs.add("-install");
            programArgs.add("file:" + installPath.removeLastSegments(1).addTrailingSeparator().toString());
            programArgs.add("-update");
        } else {
            TreeMap pluginMap = LauncherUtils.getPluginsToRun(configuration);
            if (pluginMap == null) {
                return null;
            }
            String primaryFeatureId = LauncherUtils.getPrimaryFeatureId();
            TargetPlatform.createPlatformConfigurationArea((TreeMap)pluginMap, (File)this.getConfigDir(configuration), (String)primaryFeatureId, (HashMap)LauncherUtils.getAutoStartPlugins(configuration));
            programArgs.add("-configuration");
            if (isOSGI) {
                programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
            } else {
                programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).append("platform.cfg").toString());
            }
            if (!isOSGI) {
                IPluginModelBase bootModel;
                String bootPath;
                if (primaryFeatureId != null) {
                    programArgs.add("-feature");
                    programArgs.add(primaryFeatureId);
                }
                if ((bootPath = LauncherUtils.getBootPath(bootModel = (IPluginModelBase)pluginMap.get("org.eclipse.core.boot"))) != null && !bootPath.endsWith(".jar")) {
                    programArgs.add("-boot");
                    programArgs.add("file:" + bootPath);
                }
            }
        }
        programArgs.add("-dev");
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            programArgs.add(ClasspathHelper.getDevEntriesProperties(this.getConfigDir(configuration).toString() + "/dev.properties", true));
        } else {
            programArgs.add(ClasspathHelper.getDevEntries(true));
        }
        programArgs.add("-pdelaunch");
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", (String)null))) {
            programArgs.add("-debug");
            programArgs.add(LauncherUtils.getTracingFileArgument(configuration, this.getConfigDir(configuration).toString() + '/' + ".options"));
        }
        StringTokenizer tokenizer = new StringTokenizer(configuration.getAttribute("progargs", ""));
        while (tokenizer.hasMoreTokens()) {
            programArgs.add(tokenizer.nextToken());
        }
        boolean showSplash = true;
        int index = programArgs.indexOf("-application");
        if (index != -1 && index <= programArgs.size() - 2 && !programArgs.get(index + 1).equals(LauncherUtils.getDefaultApplicationName())) {
            showSplash = false;
        }
        if (showSplash && !programArgs.contains("-nosplash")) {
            programArgs.add(0, "-showsplash");
            programArgs.add(1, this.computeShowsplashArgument());
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    private String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return new ExecutionArguments(configuration.getAttribute("vmargs", ""), "").getVMArgumentsArray();
    }

    private void validateFeatures() throws CoreException {
        boolean badStructure;
        IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
        String lastSegment = installPath.lastSegment();
        boolean bl = badStructure = lastSegment == null;
        if (!badStructure) {
            IPath featuresPath = installPath.removeLastSegments(1).append("features");
            boolean bl2 = badStructure = !lastSegment.equalsIgnoreCase("plugins") || !featuresPath.toFile().exists();
        }
        if (badStructure) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEPlugin.getResourceString(KEY_BAD_FEATURE_SETUP)));
        }
        this.ensureProductFilesExist(this.getProductPath());
    }

    private IPath getInstallPath() {
        return PDEPlugin.getWorkspace().getRoot().getLocation();
    }

    private IPath getProductPath() {
        return this.getInstallPath().removeLastSegments(1);
    }

    private String computeShowsplashArgument() {
        IPath eclipseHome = ExternalModelManager.getEclipseHome();
        IPath fullPath = eclipseHome.append("eclipse");
        return fullPath.toOSString() + " -showsplash 600";
    }

    private void ensureProductFilesExist(IPath productArea) {
        File productDir = productArea.toFile();
        File marker = new File(productDir, ".eclipseproduct");
        IPath eclipsePath = ExternalModelManager.getEclipseHome();
        if (!marker.exists()) {
            this.copyFile(eclipsePath, ".eclipseproduct", marker);
        }
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            File ini;
            File configDir = new File(productDir, "configuration");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!(ini = new File(configDir, "config.ini")).exists()) {
                this.copyFile(eclipsePath.append("configuration"), "config.ini", ini);
            }
        } else {
            File ini = new File(productDir, "install.ini");
            if (!ini.exists()) {
                this.copyFile(eclipsePath, "install.ini", ini);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copyFile(IPath eclipsePath, String name, File target) {
        block16: {
            File source = new File(eclipsePath.toFile(), name);
            if (!source.exists()) {
                return;
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            is = new FileInputStream(source);
            os = new FileOutputStream(target);
            byte[] buf = new byte[1024];
            long currentLen = 0L;
            int len = is.read(buf);
            while (len != -1) {
                currentLen += (long)len;
                os.write(buf, 0, len);
                len = is.read(buf);
            }
            Object var12_11 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                break block16;
            }
            catch (IOException e2) {}
            break block16;
            {
                catch (IOException e) {
                    Object var12_12 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LauncherUtils.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LauncherUtils.getAffectedProjects(configuration);
    }

    private File getConfigDir(ILaunchConfiguration config) {
        if (this.fConfigDir == null) {
            try {
                if (config.getAttribute("usefeatures", false)) {
                    String root = this.getProductPath().toString();
                    if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
                        root = root + "/configuration";
                    }
                    this.fConfigDir = new File(root);
                } else {
                    this.fConfigDir = LauncherUtils.createConfigArea(config.getName());
                }
            }
            catch (CoreException e) {
                this.fConfigDir = LauncherUtils.createConfigArea(config.getName());
            }
        }
        if (!this.fConfigDir.exists()) {
            this.fConfigDir.mkdirs();
        }
        return this.fConfigDir;
    }
}

