/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.SaveListener;
import org.osgi.framework.BundleContext;

public class RefactoringCorePlugin
extends Plugin {
    private static RefactoringCorePlugin fgDefault;

    public RefactoringCorePlugin() {
        fgDefault = this;
    }

    public static RefactoringCorePlugin getDefault() {
        return fgDefault;
    }

    public static String getPluginId() {
        return "org.eclipse.ltk.core.refactoring";
    }

    public static void log(IStatus status) {
        RefactoringCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10000, RefactoringCoreMessages.getString("RefactoringCorePlugin.internal_error"), t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static void logRemovedListener(Throwable t) {
        Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10000, RefactoringCoreMessages.getString("RefactoringCorePlugin.listener_removed"), t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static void logRemovedParticipant(ParticipantDescriptor descriptor, Throwable t) {
        Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10000, RefactoringCoreMessages.getFormattedString("RefactoringCorePlugin.participant_removed", descriptor.getId()), t);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static void logErrorMessage(String message) {
        RefactoringCorePlugin.log((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10000, message, null));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SaveListener.getInstance().startup();
    }

    public void stop(BundleContext context) throws Exception {
        SaveListener.getInstance().shutdown();
        super.stop(context);
    }
}

