/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.InstallCapabilityStep;
import org.eclipse.ui.internal.ide.dialogs.MultiStepCapabilityWizard;
import org.eclipse.ui.internal.ide.dialogs.RemoveCapabilityStep;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;

public class UpdateProjectCapabilityWizard
extends MultiStepCapabilityWizard {
    private IProject project;
    private Capability[] addCapabilities;
    private Capability[] removeCapabilities;

    public UpdateProjectCapabilityWizard(IProject project, Capability[] addCapabilities, Capability[] removeCapabilities) {
        this.project = project;
        this.addCapabilities = addCapabilities;
        this.removeCapabilities = removeCapabilities;
        this.initializeDefaultPageImageDescriptor();
        this.setWindowTitle(IDEWorkbenchMessages.getString("UpdateProjectCapabilityWizard.windowTitle"));
    }

    private void buildSteps() {
        int stepNumber = 1;
        ArrayList<WizardStep> steps = new ArrayList<WizardStep>(this.removeCapabilities.length + this.addCapabilities.length);
        if (this.removeCapabilities.length > 0) {
            for (int i = this.removeCapabilities.length - 1; i >= 0; --i) {
                if (this.removeCapabilities[i] == null) continue;
                ArrayList<String> natureIds = new ArrayList<String>();
                natureIds.add(this.removeCapabilities[i].getNatureId());
                ArrayList uiIds = this.removeCapabilities[i].getHandleUIs();
                if (uiIds != null) {
                    Iterator iterator = uiIds.iterator();
                    while (iterator.hasNext()) {
                        String id = (String)iterator.next();
                        for (int j = 0; j < this.removeCapabilities.length; ++j) {
                            if (this.removeCapabilities[j] == null || !this.removeCapabilities[j].getId().equals(id)) continue;
                            natureIds.add(this.removeCapabilities[j].getNatureId());
                            this.removeCapabilities[j] = null;
                        }
                    }
                }
                String[] ids = new String[natureIds.size()];
                natureIds.toArray(ids);
                steps.add(new RemoveCapabilityStep(stepNumber, this.removeCapabilities[i], ids, this.project));
                ++stepNumber;
            }
        }
        if (this.addCapabilities.length > 0) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            CapabilityRegistry reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
            Capability[] results = reg.pruneCapabilities(this.addCapabilities);
            int i = 0;
            while (i < results.length) {
                steps.add(new InstallCapabilityStep(stepNumber, results[i], workbench, this));
                ++i;
                ++stepNumber;
            }
        }
        WizardStep[] results = new WizardStep[steps.size()];
        steps.toArray(results);
        this.setSteps(results);
    }

    protected void addCustomPages() {
    }

    protected boolean canFinishOnReviewPage() {
        WizardStep[] steps = this.getSteps();
        return steps.length == 1 && steps[0] instanceof RemoveCapabilityStep;
    }

    protected String getConfigurePageTitle() {
        return IDEWorkbenchMessages.getString("UpdateProjectCapabilityWizard.title");
    }

    protected String getConfigurePageDescription() {
        return IDEWorkbenchMessages.getString("WizardProjectConfigurePage.description");
    }

    protected String getFinishStepLabel(WizardStep[] steps) {
        int count = 0;
        for (int i = 0; i < steps.length; ++i) {
            if (steps[i] instanceof RemoveCapabilityStep || ++count <= 1) continue;
            return super.getFinishStepLabel(steps);
        }
        return null;
    }

    protected String[] getPerspectiveChoices() {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < this.addCapabilities.length; ++i) {
            ArrayList ids = this.addCapabilities[i].getPerspectiveChoices();
            if (ids == null) continue;
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                if (results.contains(id)) continue;
                results.add(id);
            }
        }
        String[] ids = new String[results.size()];
        results.toArray(ids);
        return ids;
    }

    public IProject getProject() {
        return this.project;
    }

    protected String getReviewPageTitle() {
        return IDEWorkbenchMessages.getString("UpdateProjectCapabilityWizard.title");
    }

    protected String getReviewPageDescription() {
        return IDEWorkbenchMessages.getString("WizardProjectReviewPage.description");
    }

    public IWizardPage getStartingPage() {
        IWizardPage page = super.getStartingPage();
        this.buildSteps();
        return page;
    }

    boolean handleMissingStepWizard(WizardStep step) {
        MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("UpdateProjectCapabilityWizard.errorTitle"), (String)IDEWorkbenchMessages.format("UpdateProjectCapabilityWizard.noWizard", new Object[]{step.getLabel()}));
        return false;
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + "wizban/newprj_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

