/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class MarkCompletedAction
extends TaskAction {
    protected MarkCompletedAction(TaskList tasklist, String id) {
        super(tasklist, id);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.mark_completed_action_context");
    }

    public void run() {
        ISelection markers = this.getTaskList().getSelection();
        if (markers instanceof IStructuredSelection) {
            Iterator selections = ((IStructuredSelection)markers).iterator();
            while (selections.hasNext()) {
                IMarker nextMarker = (IMarker)selections.next();
                this.getTaskList().setProperty(nextMarker, "done", Boolean.TRUE);
            }
        }
    }

    public boolean shouldEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            IMarker marker = (IMarker)i.next();
            if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker") && !MarkerUtil.isComplete(marker) && MarkerUtil.isEditable(marker)) continue;
            return false;
        }
        return true;
    }
}

