/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticAccessMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class SourceTypeBinding
extends ReferenceBinding {
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    public FieldBinding[] fields;
    public MethodBinding[] methods;
    public ReferenceBinding[] memberTypes;
    public ClassScope scope;
    public static final int METHOD_EMUL = 0;
    public static final int FIELD_EMUL = 1;
    public static final int CLASS_LITERAL_EMUL = 2;
    public static final int RECEIVER_TYPE_EMUL = 3;
    Hashtable[] synthetics;

    public SourceTypeBinding(char[][] compoundName, PackageBinding fPackage, ClassScope scope) {
        this.compoundName = compoundName;
        this.fPackage = fPackage;
        this.fileName = scope.referenceCompilationUnit().getFileName();
        this.modifiers = scope.referenceContext.modifiers;
        this.sourceName = scope.referenceContext.name;
        this.scope = scope;
        this.fields = TypeConstants.NoFields;
        this.methods = TypeConstants.NoMethods;
        this.computeId();
    }

    private void addDefaultAbstractMethod(MethodBinding abstractMethod) {
        MethodBinding defaultAbstract = new MethodBinding(abstractMethod.modifiers | 0x80000, abstractMethod.selector, abstractMethod.returnType, abstractMethod.parameters, abstractMethod.thrownExceptions, this);
        MethodBinding[] temp = new MethodBinding[this.methods.length + 1];
        System.arraycopy(this.methods, 0, temp, 0, this.methods.length);
        temp[this.methods.length] = defaultAbstract;
        this.methods = temp;
    }

    public void addDefaultAbstractMethods() {
        if ((this.tagBits & 0x400) != 0) {
            return;
        }
        this.tagBits |= 0x400;
        if (this.isClass() && this.isAbstract()) {
            if (this.fPackage.environment.options.targetJDK >= 0x2E0000L) {
                return;
            }
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = 0;
            interfacesToVisit[lastPosition] = this.superInterfaces();
            for (int i = 0; i <= lastPosition; ++i) {
                ReferenceBinding[] interfaces = interfacesToVisit[i];
                int length = interfaces.length;
                for (int j = 0; j < length; ++j) {
                    ReferenceBinding superType = interfaces[j];
                    if (!superType.isValidBinding()) continue;
                    MethodBinding[] superMethods = superType.methods();
                    int m = superMethods.length;
                    while (--m >= 0) {
                        MethodBinding method = superMethods[m];
                        if (this.implementsMethod(method)) continue;
                        this.addDefaultAbstractMethod(method);
                    }
                    ReferenceBinding[] itsInterfaces = superType.superInterfaces();
                    if (itsInterfaces == TypeConstants.NoSuperInterfaces) continue;
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArrayArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArrayArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
            }
        }
    }

    public FieldBinding addSyntheticField(LocalVariableBinding actualOuterLocalVariable) {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new Hashtable(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(SyntheticArgumentBinding.OuterLocalPrefix, actualOuterLocalVariable.name), actualOuterLocalVariable.type, 4114, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(actualOuterLocalVariable, synthField);
        }
        int index = 1;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int max = typeDecl.fields.length;
            for (int i = 0; i < max; ++i) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding != existingField) continue;
                synthField.name = CharOperation.concat(SyntheticArgumentBinding.OuterLocalPrefix, actualOuterLocalVariable.name, ("$" + String.valueOf(index++)).toCharArray());
                needRecheck = true;
                continue block0;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticField(ReferenceBinding enclosingType) {
        FieldBinding existingField;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new Hashtable(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(enclosingType)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(SyntheticArgumentBinding.EnclosingInstancePrefix, String.valueOf(enclosingType.depth()).toCharArray()), enclosingType, 4112, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(enclosingType, synthField);
        }
        if ((existingField = this.getField(synthField.name, true)) != null) {
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int max = typeDecl.fields.length;
            for (int i = 0; i < max; ++i) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding != existingField) continue;
                this.scope.problemReporter().duplicateFieldInType(this, fieldDecl);
                break;
            }
        }
        return synthField;
    }

    public FieldBinding addSyntheticField(TypeBinding targetType, BlockScope blockScope) {
        FieldBinding existingField;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[2] == null) {
            this.synthetics[2] = new Hashtable(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[2].get(targetType)) == null) {
            synthField = new SyntheticFieldBinding(("class$" + this.synthetics[2].size()).toCharArray(), blockScope.getJavaLangClass(), 4104, this, Constant.NotAConstant, this.synthetics[2].size());
            this.synthetics[2].put(targetType, synthField);
        }
        if ((existingField = this.getField(synthField.name, true)) != null) {
            TypeDeclaration typeDecl = blockScope.referenceType();
            int max = typeDecl.fields.length;
            for (int i = 0; i < max; ++i) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding != existingField) continue;
                blockScope.problemReporter().duplicateFieldInType(this, fieldDecl);
                break;
            }
        }
        return synthField;
    }

    public FieldBinding addSyntheticField(AssertStatement assertStatement, BlockScope blockScope) {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new Hashtable(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get("assertionEmulation")) == null) {
            synthField = new SyntheticFieldBinding("$assertionsDisabled".toCharArray(), BaseTypes.BooleanBinding, 4120, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("assertionEmulation", synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.scope.referenceContext;
            int max = typeDecl.fields.length;
            for (int i = 0; i < max; ++i) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding != existingField) continue;
                synthField.name = CharOperation.concat("$assertionsDisabled".toCharArray(), ("_" + String.valueOf(index++)).toCharArray());
                needRecheck = true;
                continue block0;
            }
        } while (needRecheck);
        return synthField;
    }

    public SyntheticAccessMethodBinding addSyntheticMethod(FieldBinding targetField, boolean isReadAccess) {
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new Hashtable(5);
        }
        SyntheticAccessMethodBinding accessMethod = null;
        SyntheticAccessMethodBinding[] accessors = (SyntheticAccessMethodBinding[])this.synthetics[0].get(targetField);
        if (accessors == null) {
            accessMethod = new SyntheticAccessMethodBinding(targetField, isReadAccess, (ReferenceBinding)this);
            accessors = new SyntheticAccessMethodBinding[2];
            this.synthetics[0].put(targetField, accessors);
            accessors[isReadAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isReadAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticAccessMethodBinding(targetField, isReadAccess, (ReferenceBinding)this);
                accessors[isReadAccess ? 0 : 1] = accessMethod;
            }
        }
        return accessMethod;
    }

    public SyntheticAccessMethodBinding addSyntheticMethod(MethodBinding targetMethod, boolean isSuperAccess) {
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new Hashtable(5);
        }
        SyntheticAccessMethodBinding accessMethod = null;
        SyntheticAccessMethodBinding[] accessors = (SyntheticAccessMethodBinding[])this.synthetics[0].get(targetMethod);
        if (accessors == null) {
            accessMethod = new SyntheticAccessMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
            accessors = new SyntheticAccessMethodBinding[2];
            this.synthetics[0].put(targetMethod, accessors);
            accessors[isSuperAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isSuperAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticAccessMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
                accessors[isSuperAccess ? 0 : 1] = accessMethod;
            }
        }
        return accessMethod;
    }

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    void faultInTypesForFieldsAndMethods() {
        this.fields();
        this.methods();
        int length = this.memberTypes.length;
        for (int i = 0; i < length; ++i) {
            ((SourceTypeBinding)this.memberTypes[i]).faultInTypesForFieldsAndMethods();
        }
    }

    public FieldBinding[] fields() {
        try {
            int failed = 0;
            int max = this.fields.length;
            for (int f = 0; f < max; ++f) {
                if (this.resolveTypeFor(this.fields[f]) != null) continue;
                this.fields[f] = null;
                ++failed;
            }
            if (failed > 0) {
                int newSize = this.fields.length - failed;
                if (newSize == 0) {
                    this.fields = TypeConstants.NoFields;
                    return TypeConstants.NoFields;
                }
                FieldBinding[] newFields = new FieldBinding[newSize];
                int n = 0;
                int max2 = this.fields.length;
                for (int i = 0; i < max2; ++i) {
                    if (this.fields[i] == null) continue;
                    newFields[n++] = this.fields[i];
                }
                this.fields = newFields;
            }
        }
        catch (AbortCompilation e) {
            FieldBinding[] newFields = null;
            int count = 0;
            int max = this.fields.length;
            for (int i = 0; i < max; ++i) {
                FieldBinding field = this.fields[i];
                if (field == null && newFields == null) {
                    newFields = new FieldBinding[max];
                    System.arraycopy(this.fields, 0, newFields, 0, i);
                    continue;
                }
                if (newFields == null || field == null) continue;
                newFields[count++] = field;
            }
            if (newFields != null) {
                this.fields = new FieldBinding[count];
                System.arraycopy(newFields, 0, this.fields, 0, count);
            }
            throw e;
        }
        return this.fields;
    }

    public MethodBinding[] getDefaultAbstractMethods() {
        int count = 0;
        int i = this.methods.length;
        while (--i >= 0) {
            if (!this.methods[i].isDefaultAbstract()) continue;
            ++count;
        }
        if (count == 0) {
            return TypeConstants.NoMethods;
        }
        MethodBinding[] result = new MethodBinding[count];
        count = 0;
        int i2 = this.methods.length;
        while (--i2 >= 0) {
            if (!this.methods[i2].isDefaultAbstract()) continue;
            result[count++] = this.methods[i2];
        }
        return result;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        int argCount = argumentTypes.length;
        if ((this.modifiers & 0x2000000) == 0) {
            int m = this.methods.length;
            block0: while (--m >= 0) {
                MethodBinding method = this.methods[m];
                if (method.selector != ConstructorDeclaration.ConstantPoolName || method.parameters.length != argCount) continue;
                TypeBinding[] toMatch = method.parameters;
                for (int p = 0; p < argCount; ++p) {
                    if (toMatch[p] != argumentTypes[p]) continue block0;
                }
                return method;
            }
        } else {
            MethodBinding[] constructors = this.getMethods(ConstructorDeclaration.ConstantPoolName);
            int c = constructors.length;
            block2: while (--c >= 0) {
                MethodBinding constructor = constructors[c];
                TypeBinding[] toMatch = constructor.parameters;
                if (toMatch.length != argCount) continue;
                for (int p = 0; p < argCount; ++p) {
                    if (toMatch[p] != argumentTypes[p]) continue block2;
                }
                return constructor;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes) {
        int argCount = argumentTypes.length;
        int selectorLength = selector.length;
        boolean foundNothing = true;
        if ((this.modifiers & 0x2000000) == 0) {
            int m = this.methods.length;
            block0: while (--m >= 0) {
                MethodBinding method = this.methods[m];
                if (method.selector.length != selectorLength || !CharOperation.equals(method.selector, selector)) continue;
                foundNothing = false;
                if (method.parameters.length != argCount) continue;
                TypeBinding[] toMatch = method.parameters;
                for (int p = 0; p < argCount; ++p) {
                    if (toMatch[p] != argumentTypes[p]) continue block0;
                }
                return method;
            }
        } else {
            MethodBinding[] matchingMethods = this.getMethods(selector);
            foundNothing = matchingMethods == TypeConstants.NoMethods;
            int m = matchingMethods.length;
            block2: while (--m >= 0) {
                MethodBinding method = matchingMethods[m];
                TypeBinding[] toMatch = method.parameters;
                if (toMatch.length != argCount) continue;
                for (int p = 0; p < argCount; ++p) {
                    if (toMatch[p] != argumentTypes[p]) continue block2;
                }
                return method;
            }
        }
        if (foundNothing) {
            if (this.isInterface()) {
                if (this.superInterfaces.length == 1) {
                    return this.superInterfaces[0].getExactMethod(selector, argumentTypes);
                }
            } else if (this.superclass != null) {
                return this.superclass.getExactMethod(selector, argumentTypes);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        int fieldLength = fieldName.length;
        int f = this.fields.length;
        while (--f >= 0) {
            FieldBinding field = this.fields[f];
            if (field.name.length != fieldLength || !CharOperation.equals(field.name, fieldName)) continue;
            if (this.resolveTypeFor(field) != null) {
                return field;
            }
            int newSize = this.fields.length - 1;
            if (newSize == 0) {
                this.fields = TypeConstants.NoFields;
            } else {
                FieldBinding[] newFields = new FieldBinding[newSize];
                System.arraycopy(this.fields, 0, newFields, 0, f);
                System.arraycopy(this.fields, f + 1, newFields, f, newSize - f);
                this.fields = newFields;
            }
            return null;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        this.addDefaultAbstractMethods();
        try {
            int count = 0;
            int lastIndex = -1;
            int selectorLength = selector.length;
            if ((this.modifiers & 0x2000000) == 0) {
                int length = this.methods.length;
                for (int m = 0; m < length; ++m) {
                    MethodBinding method = this.methods[m];
                    if (method.selector.length != selectorLength || !CharOperation.equals(method.selector, selector)) continue;
                    ++count;
                    lastIndex = m;
                }
            } else {
                int m;
                boolean foundProblem = false;
                int failed = 0;
                int length = this.methods.length;
                for (m = 0; m < length; ++m) {
                    MethodBinding method = this.methods[m];
                    if (method.selector.length != selectorLength || !CharOperation.equals(method.selector, selector)) continue;
                    if (this.resolveTypesFor(method) == null) {
                        foundProblem = true;
                        this.methods[m] = null;
                        ++failed;
                        continue;
                    }
                    if (method.returnType == null) {
                        foundProblem = true;
                        continue;
                    }
                    ++count;
                    lastIndex = m;
                }
                if (foundProblem || count > 1) {
                    m = this.methods.length;
                    while (--m >= 0) {
                        MethodBinding method = this.methods[m];
                        if (method == null || method.selector.length != selectorLength || !CharOperation.equals(method.selector, selector)) continue;
                        AbstractMethodDeclaration methodDecl = null;
                        for (int i = 0; i < m; ++i) {
                            MethodBinding method2 = this.methods[i];
                            if (method2 == null || !CharOperation.equals(method.selector, method2.selector) || !method.areParametersEqual(method2)) continue;
                            if (methodDecl == null) {
                                methodDecl = method.sourceMethod();
                                this.scope.problemReporter().duplicateMethodInType(this, methodDecl);
                                methodDecl.binding = null;
                                this.methods[m] = null;
                                ++failed;
                            }
                            this.scope.problemReporter().duplicateMethodInType(this, method2.sourceMethod());
                            method2.sourceMethod().binding = null;
                            this.methods[i] = null;
                            ++failed;
                        }
                        if (method.returnType != null || methodDecl != null) continue;
                        method.sourceMethod().binding = null;
                        this.methods[m] = null;
                        ++failed;
                    }
                    if (failed > 0) {
                        int newSize = this.methods.length - failed;
                        if (newSize == 0) {
                            this.methods = TypeConstants.NoMethods;
                            return TypeConstants.NoMethods;
                        }
                        MethodBinding[] newMethods = new MethodBinding[newSize];
                        int n = 0;
                        int max = this.methods.length;
                        for (int i = 0; i < max; ++i) {
                            if (this.methods[i] == null) continue;
                            newMethods[n++] = this.methods[i];
                        }
                        this.methods = newMethods;
                        return this.getMethods(selector);
                    }
                }
            }
            if (count == 1) {
                return new MethodBinding[]{this.methods[lastIndex]};
            }
            if (count > 1) {
                MethodBinding[] result = new MethodBinding[count];
                count = 0;
                for (int m = 0; m <= lastIndex; ++m) {
                    MethodBinding method = this.methods[m];
                    if (method.selector.length != selectorLength || !CharOperation.equals(method.selector, selector)) continue;
                    result[count++] = method;
                }
                return result;
            }
        }
        catch (AbortCompilation e) {
            MethodBinding[] newMethods = null;
            int count = 0;
            int max = this.methods.length;
            for (int i = 0; i < max; ++i) {
                MethodBinding method = this.methods[i];
                if (method == null && newMethods == null) {
                    newMethods = new MethodBinding[max];
                    System.arraycopy(this.methods, 0, newMethods, 0, i);
                    continue;
                }
                if (newMethods == null || method == null) continue;
                newMethods[count++] = method;
            }
            if (newMethods != null) {
                this.methods = new MethodBinding[count];
                System.arraycopy(newMethods, 0, this.methods, 0, count);
            }
            this.modifiers ^= 0x2000000;
            throw e;
        }
        return TypeConstants.NoMethods;
    }

    public FieldBinding getSyntheticField(LocalVariableBinding actualOuterLocalVariable) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        return (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable);
    }

    public ReferenceBinding[] memberTypes() {
        return this.memberTypes;
    }

    public FieldBinding getUpdatedFieldBinding(FieldBinding targetField, ReferenceBinding newDeclaringClass) {
        FieldBinding updatedField;
        Hashtable<ReferenceBinding, FieldBinding> fieldMap;
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[3] == null) {
            this.synthetics[3] = new Hashtable(5);
        }
        if ((fieldMap = (Hashtable<ReferenceBinding, FieldBinding>)this.synthetics[3].get(targetField)) == null) {
            fieldMap = new Hashtable<ReferenceBinding, FieldBinding>(5);
            this.synthetics[3].put(targetField, fieldMap);
        }
        if ((updatedField = (FieldBinding)fieldMap.get(newDeclaringClass)) == null) {
            updatedField = new FieldBinding(targetField, newDeclaringClass);
            fieldMap.put(newDeclaringClass, updatedField);
        }
        return updatedField;
    }

    public MethodBinding getUpdatedMethodBinding(MethodBinding targetMethod, ReferenceBinding newDeclaringClass) {
        MethodBinding updatedMethod;
        Hashtable<ReferenceBinding, MethodBinding> methodMap;
        if (this.synthetics == null) {
            this.synthetics = new Hashtable[4];
        }
        if (this.synthetics[3] == null) {
            this.synthetics[3] = new Hashtable(5);
        }
        if ((methodMap = (Hashtable<ReferenceBinding, MethodBinding>)this.synthetics[3].get(targetMethod)) == null) {
            methodMap = new Hashtable<ReferenceBinding, MethodBinding>(5);
            this.synthetics[3].put(targetMethod, methodMap);
        }
        if ((updatedMethod = (MethodBinding)methodMap.get(newDeclaringClass)) == null) {
            updatedMethod = new MethodBinding(targetMethod, newDeclaringClass);
            methodMap.put(newDeclaringClass, updatedMethod);
        }
        return updatedMethod;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    public MethodBinding[] methods() {
        try {
            int m;
            if ((this.modifiers & 0x2000000) == 0) {
                return this.methods;
            }
            int failed = 0;
            int max = this.methods.length;
            for (m = 0; m < max; ++m) {
                if (this.resolveTypesFor(this.methods[m]) != null) continue;
                this.methods[m] = null;
                ++failed;
            }
            m = this.methods.length;
            while (--m >= 0) {
                MethodBinding method = this.methods[m];
                if (method == null) continue;
                AbstractMethodDeclaration methodDecl = null;
                for (int i = 0; i < m; ++i) {
                    MethodBinding method2 = this.methods[i];
                    if (method2 == null || !CharOperation.equals(method.selector, method2.selector) || !method.areParametersEqual(method2)) continue;
                    if (methodDecl == null) {
                        methodDecl = method.sourceMethod();
                        this.scope.problemReporter().duplicateMethodInType(this, methodDecl);
                        methodDecl.binding = null;
                        this.methods[m] = null;
                        ++failed;
                    }
                    this.scope.problemReporter().duplicateMethodInType(this, method2.sourceMethod());
                    method2.sourceMethod().binding = null;
                    this.methods[i] = null;
                    ++failed;
                }
                if (method.returnType != null || methodDecl != null) continue;
                method.sourceMethod().binding = null;
                this.methods[m] = null;
                ++failed;
            }
            if (failed > 0) {
                int newSize = this.methods.length - failed;
                if (newSize == 0) {
                    this.methods = TypeConstants.NoMethods;
                } else {
                    MethodBinding[] newMethods = new MethodBinding[newSize];
                    int n = 0;
                    int max2 = this.methods.length;
                    for (int m2 = 0; m2 < max2; ++m2) {
                        if (this.methods[m2] == null) continue;
                        newMethods[n++] = this.methods[m2];
                    }
                    this.methods = newMethods;
                }
            }
            this.addDefaultAbstractMethods();
        }
        catch (AbortCompilation e) {
            MethodBinding[] newMethods = null;
            int count = 0;
            int max = this.methods.length;
            for (int i = 0; i < max; ++i) {
                MethodBinding method = this.methods[i];
                if (method == null && newMethods == null) {
                    newMethods = new MethodBinding[max];
                    System.arraycopy(this.methods, 0, newMethods, 0, i);
                    continue;
                }
                if (newMethods == null || method == null) continue;
                newMethods[count++] = method;
            }
            if (newMethods != null) {
                this.methods = new MethodBinding[count];
                System.arraycopy(newMethods, 0, this.methods, 0, count);
            }
            this.modifiers ^= 0x2000000;
            throw e;
        }
        this.modifiers ^= 0x2000000;
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        FieldDeclaration[] fieldDecls = this.scope.referenceContext.fields;
        int length = fieldDecls.length;
        for (int f = 0; f < length; ++f) {
            if (fieldDecls[f].binding != field) continue;
            field.type = fieldDecls[f].getTypeBinding(this.scope);
            field.modifiers ^= 0x2000000;
            if (!field.type.isValidBinding()) {
                this.scope.problemReporter().fieldTypeProblem(this, fieldDecls[f], field.type);
                fieldDecls[f].binding = null;
                return null;
            }
            if (field.type == BaseTypes.VoidBinding) {
                this.scope.problemReporter().variableTypeCannotBeVoid(fieldDecls[f]);
                fieldDecls[f].binding = null;
                return null;
            }
            if (field.type.isArrayType() && ((ArrayBinding)field.type).leafComponentType == BaseTypes.VoidBinding) {
                this.scope.problemReporter().variableTypeCannotBeVoidArray(fieldDecls[f]);
                fieldDecls[f].binding = null;
                return null;
            }
            return field;
        }
        return null;
    }

    private MethodBinding resolveTypesFor(MethodBinding method) {
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        AbstractMethodDeclaration methodDecl = method.sourceMethod();
        TypeReference[] exceptionTypes = methodDecl.thrownExceptions;
        if (exceptionTypes != null) {
            int size = exceptionTypes.length;
            method.thrownExceptions = new ReferenceBinding[size];
            ReferenceBinding throwable = this.scope.getJavaLangThrowable();
            int count = 0;
            for (int i = 0; i < size; ++i) {
                ReferenceBinding resolvedExceptionType = (ReferenceBinding)exceptionTypes[i].getTypeBinding(this.scope);
                if (!resolvedExceptionType.isValidBinding()) {
                    methodDecl.scope.problemReporter().exceptionTypeProblem(this, methodDecl, exceptionTypes[i], resolvedExceptionType);
                    continue;
                }
                if (throwable != resolvedExceptionType && !throwable.isSuperclassOf(resolvedExceptionType)) {
                    methodDecl.scope.problemReporter().cannotThrowType(this, methodDecl, exceptionTypes[i], resolvedExceptionType);
                    continue;
                }
                method.thrownExceptions[count++] = resolvedExceptionType;
            }
            if (count < size) {
                method.thrownExceptions = new ReferenceBinding[count];
                System.arraycopy(method.thrownExceptions, 0, method.thrownExceptions, 0, count);
            }
        }
        boolean foundArgProblem = false;
        Argument[] arguments = methodDecl.arguments;
        if (arguments != null) {
            int size = arguments.length;
            method.parameters = new TypeBinding[size];
            for (int i = 0; i < size; ++i) {
                Argument arg = arguments[i];
                method.parameters[i] = arg.type.getTypeBinding(this.scope);
                if (!method.parameters[i].isValidBinding()) {
                    methodDecl.scope.problemReporter().argumentTypeProblem(this, methodDecl, arg, method.parameters[i]);
                    foundArgProblem = true;
                    continue;
                }
                if (method.parameters[i] == BaseTypes.VoidBinding) {
                    methodDecl.scope.problemReporter().argumentTypeCannotBeVoid(this, methodDecl, arg);
                    foundArgProblem = true;
                    continue;
                }
                if (!method.parameters[i].isArrayType() || ((ArrayBinding)method.parameters[i]).leafComponentType != BaseTypes.VoidBinding) continue;
                methodDecl.scope.problemReporter().argumentTypeCannotBeVoidArray(this, methodDecl, arg);
                foundArgProblem = true;
            }
        }
        boolean foundReturnTypeProblem = false;
        if (!method.isConstructor()) {
            TypeReference returnType = ((MethodDeclaration)methodDecl).returnType;
            if (returnType == null) {
                methodDecl.scope.problemReporter().missingReturnType(methodDecl);
                method.returnType = null;
                foundReturnTypeProblem = true;
            } else {
                method.returnType = returnType.getTypeBinding(this.scope);
                if (!method.returnType.isValidBinding()) {
                    methodDecl.scope.problemReporter().returnTypeProblem(this, (MethodDeclaration)methodDecl, method.returnType);
                    method.returnType = null;
                    foundReturnTypeProblem = true;
                } else if (method.returnType.isArrayType() && ((ArrayBinding)method.returnType).leafComponentType == BaseTypes.VoidBinding) {
                    methodDecl.scope.problemReporter().returnTypeCannotBeVoidArray(this, (MethodDeclaration)methodDecl);
                    method.returnType = null;
                    foundReturnTypeProblem = true;
                }
            }
        }
        if (foundArgProblem) {
            methodDecl.binding = null;
            return null;
        }
        if (foundReturnTypeProblem) {
            return method;
        }
        method.modifiers ^= 0x2000000;
        return method;
    }

    public final int sourceEnd() {
        return this.scope.referenceContext.sourceEnd;
    }

    public final int sourceStart() {
        return this.scope.referenceContext.sourceStart;
    }

    public ReferenceBinding superclass() {
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public SyntheticAccessMethodBinding[] syntheticAccessMethods() {
        if (this.synthetics == null || this.synthetics[0] == null || this.synthetics[0].size() == 0) {
            return null;
        }
        int index = 0;
        SyntheticAccessMethodBinding[] bindings = new SyntheticAccessMethodBinding[1];
        Enumeration fieldsOrMethods = this.synthetics[0].keys();
        while (fieldsOrMethods.hasMoreElements()) {
            int numberOfAccessors;
            Object fieldOrMethod = fieldsOrMethods.nextElement();
            if (fieldOrMethod instanceof MethodBinding) {
                SyntheticAccessMethodBinding[] methodAccessors = (SyntheticAccessMethodBinding[])this.synthetics[0].get(fieldOrMethod);
                numberOfAccessors = 0;
                if (methodAccessors[0] != null) {
                    ++numberOfAccessors;
                }
                if (methodAccessors[1] != null) {
                    ++numberOfAccessors;
                }
                if (index + numberOfAccessors > bindings.length) {
                    SyntheticAccessMethodBinding[] syntheticAccessMethodBindingArray = bindings;
                    bindings = new SyntheticAccessMethodBinding[index + numberOfAccessors];
                    System.arraycopy(syntheticAccessMethodBindingArray, 0, bindings, 0, index);
                }
                if (methodAccessors[0] != null) {
                    bindings[index++] = methodAccessors[0];
                }
                if (methodAccessors[1] == null) continue;
                bindings[index++] = methodAccessors[1];
                continue;
            }
            SyntheticAccessMethodBinding[] fieldAccessors = (SyntheticAccessMethodBinding[])this.synthetics[0].get(fieldOrMethod);
            numberOfAccessors = 0;
            if (fieldAccessors[0] != null) {
                ++numberOfAccessors;
            }
            if (fieldAccessors[1] != null) {
                ++numberOfAccessors;
            }
            if (index + numberOfAccessors > bindings.length) {
                SyntheticAccessMethodBinding[] syntheticAccessMethodBindingArray = bindings;
                bindings = new SyntheticAccessMethodBinding[index + numberOfAccessors];
                System.arraycopy(syntheticAccessMethodBindingArray, 0, bindings, 0, index);
            }
            if (fieldAccessors[0] != null) {
                bindings[index++] = fieldAccessors[0];
            }
            if (fieldAccessors[1] == null) continue;
            bindings[index++] = fieldAccessors[1];
        }
        int length = bindings.length;
        SyntheticAccessMethodBinding[] sortedBindings = new SyntheticAccessMethodBinding[length];
        for (int i = 0; i < length; ++i) {
            SyntheticAccessMethodBinding binding;
            sortedBindings[binding.index] = binding = bindings[i];
        }
        return sortedBindings;
    }

    public FieldBinding[] syntheticFields() {
        SyntheticFieldBinding synthBinding;
        int i;
        Enumeration elements;
        int literalSize;
        if (this.synthetics == null) {
            return null;
        }
        int fieldSize = this.synthetics[1] == null ? 0 : this.synthetics[1].size();
        int totalSize = fieldSize + (literalSize = this.synthetics[2] == null ? 0 : this.synthetics[2].size());
        if (totalSize == 0) {
            return null;
        }
        FieldBinding[] bindings = new FieldBinding[totalSize];
        if (this.synthetics[1] != null) {
            elements = this.synthetics[1].elements();
            for (i = 0; i < fieldSize; ++i) {
                synthBinding = (SyntheticFieldBinding)elements.nextElement();
                bindings[synthBinding.index] = synthBinding;
            }
        }
        if (this.synthetics[2] != null) {
            elements = this.synthetics[2].elements();
            for (i = 0; i < literalSize; ++i) {
                synthBinding = (SyntheticFieldBinding)elements.nextElement();
                bindings[fieldSize + synthBinding.index] = synthBinding;
            }
        }
        return bindings;
    }

    public String toString() {
        int i;
        int length;
        String s = "(id=" + (this.id == Integer.MAX_VALUE ? "NoId" : "" + this.id) + ")\n";
        if (this.isDeprecated()) {
            s = s + "deprecated ";
        }
        if (this.isPublic()) {
            s = s + "public ";
        }
        if (this.isProtected()) {
            s = s + "protected ";
        }
        if (this.isPrivate()) {
            s = s + "private ";
        }
        if (this.isAbstract() && this.isClass()) {
            s = s + "abstract ";
        }
        if (this.isStatic() && this.isNestedType()) {
            s = s + "static ";
        }
        if (this.isFinal()) {
            s = s + "final ";
        }
        s = s + (this.isInterface() ? "interface " : "class ");
        s = s + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        s = s + "\n\textends ";
        s = s + (this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != TypeConstants.NoSuperInterfaces) {
                s = s + "\n\timplements : ";
                length = this.superInterfaces.length;
                for (i = 0; i < length; ++i) {
                    if (i > 0) {
                        s = s + ", ";
                    }
                    s = s + (this.superInterfaces[i] != null ? this.superInterfaces[i].debugName() : "NULL TYPE");
                }
            }
        } else {
            s = s + "NULL SUPERINTERFACES";
        }
        if (this.enclosingType() != null) {
            s = s + "\n\tenclosing type : ";
            s = s + this.enclosingType().debugName();
        }
        if (this.fields != null) {
            if (this.fields != TypeConstants.NoFields) {
                s = s + "\n/*   fields   */";
                length = this.fields.length;
                for (i = 0; i < length; ++i) {
                    s = s + (this.fields[i] != null ? "\n" + this.fields[i].toString() : "\nNULL FIELD");
                }
            }
        } else {
            s = s + "NULL FIELDS";
        }
        if (this.methods != null) {
            if (this.methods != TypeConstants.NoMethods) {
                s = s + "\n/*   methods   */";
                length = this.methods.length;
                for (i = 0; i < length; ++i) {
                    s = s + (this.methods[i] != null ? "\n" + this.methods[i].toString() : "\nNULL METHOD");
                }
            }
        } else {
            s = s + "NULL METHODS";
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != TypeConstants.NoMemberTypes) {
                s = s + "\n/*   members   */";
                length = this.memberTypes.length;
                for (i = 0; i < length; ++i) {
                    s = s + (this.memberTypes[i] != null ? "\n" + this.memberTypes[i].toString() : "\nNULL TYPE");
                }
            }
        } else {
            s = s + "NULL MEMBER TYPES";
        }
        s = s + "\n\n\n";
        return s;
    }

    void verifyMethods(MethodVerifier verifier) {
        verifier.verify(this);
        int i = this.memberTypes.length;
        while (--i >= 0) {
            ((SourceTypeBinding)this.memberTypes[i]).verifyMethods(verifier);
        }
    }

    public FieldBinding getSyntheticField(ReferenceBinding targetEnclosingType, boolean onlyExactMatch) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        FieldBinding field = (FieldBinding)this.synthetics[1].get(targetEnclosingType);
        if (field != null) {
            return field;
        }
        if (!onlyExactMatch) {
            Enumeration accessFields = this.synthetics[1].elements();
            while (accessFields.hasMoreElements()) {
                field = (FieldBinding)accessFields.nextElement();
                if (!CharOperation.prefixEquals(SyntheticArgumentBinding.EnclosingInstancePrefix, field.name) || !targetEnclosingType.isSuperclassOf((ReferenceBinding)field.type)) continue;
                return field;
            }
        }
        return null;
    }
}

