/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IRegion;

public class Region
implements IRegion {
    protected ArrayList fRootElements = new ArrayList(1);

    public void add(IJavaElement element) {
        if (!this.contains(element)) {
            this.removeAllChildren(element);
            this.fRootElements.add(element);
            this.fRootElements.trimToSize();
        }
    }

    public boolean contains(IJavaElement element) {
        int size = this.fRootElements.size();
        ArrayList parents = this.getAncestors(element);
        for (int i = 0; i < size; ++i) {
            IJavaElement aTop = (IJavaElement)this.fRootElements.get(i);
            if (aTop.equals(element)) {
                return true;
            }
            int pSize = parents.size();
            for (int j = 0; j < pSize; ++j) {
                if (!aTop.equals(parents.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList getAncestors(IJavaElement element) {
        ArrayList<IJavaElement> parents = new ArrayList<IJavaElement>();
        for (IJavaElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            parents.add(parent);
        }
        parents.trimToSize();
        return parents;
    }

    public IJavaElement[] getElements() {
        int size = this.fRootElements.size();
        IJavaElement[] roots = new IJavaElement[size];
        for (int i = 0; i < size; ++i) {
            roots[i] = (IJavaElement)this.fRootElements.get(i);
        }
        return roots;
    }

    public boolean remove(IJavaElement element) {
        this.removeAllChildren(element);
        return this.fRootElements.remove(element);
    }

    private void removeAllChildren(IJavaElement element) {
        if (element instanceof IParent) {
            ArrayList<IJavaElement> newRootElements = new ArrayList<IJavaElement>();
            int size = this.fRootElements.size();
            for (int i = 0; i < size; ++i) {
                IJavaElement currentRoot = (IJavaElement)this.fRootElements.get(i);
                boolean isChild = false;
                for (IJavaElement parent = currentRoot.getParent(); parent != null; parent = parent.getParent()) {
                    if (!parent.equals(element)) continue;
                    isChild = true;
                    break;
                }
                if (isChild) continue;
                newRootElements.add(currentRoot);
            }
            this.fRootElements = newRootElements;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        IJavaElement[] roots = this.getElements();
        buffer.append('[');
        for (int i = 0; i < roots.length; ++i) {
            buffer.append(roots[i].getElementName());
            if (i >= roots.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }
}

