/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class IncrementalImageBuilder
extends AbstractImageBuilder {
    protected ArrayList sourceFiles;
    protected ArrayList previousSourceFiles;
    protected StringSet qualifiedStrings;
    protected StringSet simpleStrings;
    protected SimpleLookupTable secondaryTypesToRemove;
    protected boolean hasStructuralChanges;
    protected int compileLoop;
    public static int MaxCompileLoop = 5;

    protected IncrementalImageBuilder(JavaBuilder javaBuilder) {
        super(javaBuilder);
        this.nameEnvironment.isIncrementalBuild = true;
        this.newState.copyFrom(javaBuilder.lastState);
        this.sourceFiles = new ArrayList(33);
        this.previousSourceFiles = null;
        this.qualifiedStrings = new StringSet(3);
        this.simpleStrings = new StringSet(3);
        this.hasStructuralChanges = false;
        this.compileLoop = 0;
    }

    public boolean build(SimpleLookupTable deltas) {
        if (JavaBuilder.DEBUG) {
            System.out.println("INCREMENTAL build");
        }
        try {
            this.resetCollections();
            this.notifier.subTask(org.eclipse.jdt.internal.core.util.Util.bind("build.analyzingDeltas"));
            IResourceDelta sourceDelta = (IResourceDelta)deltas.get(this.javaBuilder.currentProject);
            if (sourceDelta != null && !this.findSourceFiles(sourceDelta)) {
                boolean bl = false;
                return bl;
            }
            this.notifier.updateProgressDelta(0.1f);
            Object[] keyTable = deltas.keyTable;
            Object[] valueTable = deltas.valueTable;
            boolean l = valueTable.length;
            for (boolean i = false; i < l; i += 1) {
                IProject p;
                ClasspathLocation[] classFoldersAndJars;
                IResourceDelta delta = (IResourceDelta)valueTable[i];
                if (delta == null || (classFoldersAndJars = (ClasspathLocation[])this.javaBuilder.binaryLocationsPerProject.get(p = (IProject)keyTable[i])) == null || this.findAffectedSourceFiles(delta, classFoldersAndJars, p)) continue;
                boolean bl = false;
                return bl;
            }
            this.notifier.updateProgressDelta(0.1f);
            this.notifier.subTask(org.eclipse.jdt.internal.core.util.Util.bind("build.analyzingSources"));
            this.addAffectedSourceFiles();
            this.notifier.updateProgressDelta(0.05f);
            this.compileLoop = 0;
            float increment = 0.4f;
            while (this.sourceFiles.size() > 0) {
                if (++this.compileLoop > MaxCompileLoop) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("ABORTING incremental build... exceeded loop count");
                    }
                    l = false;
                    return l;
                }
                this.notifier.checkCancel();
                SourceFile[] allSourceFiles = new SourceFile[this.sourceFiles.size()];
                this.sourceFiles.toArray(allSourceFiles);
                this.resetCollections();
                this.workQueue.addAll(allSourceFiles);
                this.notifier.setProgressPerCompilationUnit(increment / (float)allSourceFiles.length);
                increment /= 2.0f;
                this.compile(allSourceFiles);
                this.removeSecondaryTypes();
                this.addAffectedSourceFiles();
            }
            if (this.hasStructuralChanges && this.javaBuilder.javaProject.hasCycleMarker()) {
                this.javaBuilder.mustPropagateStructuralChanges();
            }
        }
        catch (AbortIncrementalBuildException e) {
            if (JavaBuilder.DEBUG) {
                System.out.println("ABORTING incremental build... problem with " + e.qualifiedTypeName + ". Likely renamed inside its existing source file.");
            }
            boolean bl = false;
            return bl;
        }
        catch (CoreException e) {
            throw this.internalException(e);
        }
        finally {
            this.cleanUp();
        }
        return true;
    }

    protected void addAffectedSourceFiles() {
        char[][] simpleNames;
        if (this.qualifiedStrings.elementSize == 0 && this.simpleStrings.elementSize == 0) {
            return;
        }
        char[][][] qualifiedNames = ReferenceCollection.internQualifiedNames(this.qualifiedStrings);
        if (qualifiedNames.length < this.qualifiedStrings.elementSize) {
            qualifiedNames = null;
        }
        if ((simpleNames = ReferenceCollection.internSimpleNames(this.simpleStrings)).length < this.simpleStrings.elementSize) {
            simpleNames = null;
        }
        Object[] keyTable = this.newState.references.keyTable;
        Object[] valueTable = this.newState.references.valueTable;
        int l = valueTable.length;
        for (int i = 0; i < l; ++i) {
            SourceFile sourceFile;
            String typeLocator;
            IFile file;
            ReferenceCollection refs = (ReferenceCollection)valueTable[i];
            if (refs == null || !refs.includes(qualifiedNames, simpleNames) || !(file = this.javaBuilder.currentProject.getFile(typeLocator = (String)keyTable[i])).exists()) continue;
            ClasspathMultiDirectory md = this.sourceLocations[0];
            if (this.sourceLocations.length > 1) {
                IPath sourceFileFullPath = file.getFullPath();
                int m = this.sourceLocations.length;
                for (int j = 0; j < m; ++j) {
                    if (!this.sourceLocations[j].sourceFolder.getFullPath().isPrefixOf(sourceFileFullPath)) continue;
                    md = this.sourceLocations[j];
                    if (md.exclusionPatterns == null && md.inclusionPatterns == null || !org.eclipse.jdt.internal.core.util.Util.isExcluded((IResource)file, md.inclusionPatterns, md.exclusionPatterns)) break;
                }
            }
            if (this.sourceFiles.contains(sourceFile = new SourceFile(file, md)) || this.compiledAllAtOnce && this.previousSourceFiles != null && this.previousSourceFiles.contains(sourceFile)) continue;
            if (JavaBuilder.DEBUG) {
                System.out.println("  adding affected source file " + typeLocator);
            }
            this.sourceFiles.add(sourceFile);
        }
    }

    protected void addDependentsOf(IPath path, boolean isStructuralChange) {
        if (isStructuralChange && !this.hasStructuralChanges) {
            this.newState.tagAsStructurallyChanged();
            this.hasStructuralChanges = true;
        }
        path = path.setDevice(null);
        String packageName = path.removeLastSegments(1).toString();
        this.qualifiedStrings.add(packageName);
        String typeName = path.lastSegment();
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        if (this.simpleStrings.add(typeName) && JavaBuilder.DEBUG) {
            System.out.println("  will look for dependents of " + typeName + " in " + packageName);
        }
    }

    protected void cleanUp() {
        super.cleanUp();
        this.sourceFiles = null;
        this.previousSourceFiles = null;
        this.qualifiedStrings = null;
        this.simpleStrings = null;
        this.secondaryTypesToRemove = null;
        this.hasStructuralChanges = false;
        this.compileLoop = 0;
    }

    protected boolean findAffectedSourceFiles(IResourceDelta delta, ClasspathLocation[] classFoldersAndJars, IProject prereqProject) {
        int l = classFoldersAndJars.length;
        for (int i = 0; i < l; ++i) {
            IResourceDelta binaryDelta;
            IPath p;
            ClasspathLocation bLocation = classFoldersAndJars[i];
            if (bLocation == null || (p = bLocation.getProjectRelativePath()) == null || (binaryDelta = delta.findMember(p)) == null) continue;
            if (bLocation instanceof ClasspathJar) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("ABORTING incremental build... found delta to jar/zip file");
                }
                return false;
            }
            if (binaryDelta.getKind() == 1 || binaryDelta.getKind() == 2) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("ABORTING incremental build... found added/removed binary folder");
                }
                return false;
            }
            int segmentCount = binaryDelta.getFullPath().segmentCount();
            IResourceDelta[] children = binaryDelta.getAffectedChildren();
            StringSet structurallyChangedTypes = null;
            if (bLocation.isOutputFolder()) {
                structurallyChangedTypes = this.newState.getStructurallyChangedTypes(this.javaBuilder.getLastState(prereqProject));
            }
            int m = children.length;
            for (int j = 0; j < m; ++j) {
                this.findAffectedSourceFiles(children[j], segmentCount, structurallyChangedTypes);
            }
            this.notifier.checkCancel();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void findAffectedSourceFiles(IResourceDelta binaryDelta, int segmentCount, StringSet structurallyChangedTypes) {
        resource = binaryDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                switch (binaryDelta.getKind()) {
                    case 1: 
                    case 2: {
                        packagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        packageName = packagePath.toString();
                        if (binaryDelta.getKind() != 1) ** GOTO lbl17
                        if (!this.newState.isKnownPackage(packageName)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found added package " + packageName);
                            }
                            this.addDependentsOf(packagePath, false);
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Skipped dependents of added package " + packageName);
                        }
                        ** GOTO lbl24
lbl17:
                        // 1 sources

                        if (!this.nameEnvironment.isPackage(packageName)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found removed package " + packageName);
                            }
                            this.addDependentsOf(packagePath, false);
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Skipped dependents of removed package " + packageName);
                        }
                    }
lbl24:
                    // 5 sources

                    case 4: {
                        children = binaryDelta.getAffectedChildren();
                        l = children.length;
                        for (i = 0; i < l; ++i) {
                            this.findAffectedSourceFiles(children[i], segmentCount, structurallyChangedTypes);
                        }
                        break;
                    }
                }
                return;
            }
            case 1: {
                if (!Util.isClassFileName(resource.getName())) break;
                typePath = resource.getFullPath().removeFirstSegments(segmentCount).removeFileExtension();
                switch (binaryDelta.getKind()) {
                    case 1: 
                    case 2: {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found added/removed class file " + typePath);
                        }
                        this.addDependentsOf(typePath, false);
                        return;
                    }
                    case 4: {
                        if ((binaryDelta.getFlags() & 256) == 0) {
                            return;
                        }
                        if (structurallyChangedTypes != null && !structurallyChangedTypes.includes(typePath.toString())) {
                            return;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found changed class file " + typePath);
                        }
                        this.addDependentsOf(typePath, false);
                    }
                }
                return;
            }
        }
    }

    protected boolean findSourceFiles(IResourceDelta delta) throws CoreException {
        int l = this.sourceLocations.length;
        for (int i = 0; i < l; ++i) {
            ClasspathMultiDirectory md = this.sourceLocations[i];
            if (md.sourceFolder.equals(this.javaBuilder.currentProject)) {
                int segmentCount = delta.getFullPath().segmentCount();
                IResourceDelta[] children = delta.getAffectedChildren();
                int m = children.length;
                for (int j = 0; j < m; ++j) {
                    if (this.isExcludedFromProject(children[j].getFullPath())) continue;
                    this.findSourceFiles(children[j], md, segmentCount);
                }
            } else {
                IResourceDelta sourceDelta = delta.findMember(md.sourceFolder.getProjectRelativePath());
                if (sourceDelta != null) {
                    if (sourceDelta.getKind() == 2) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("ABORTING incremental build... found removed source folder");
                        }
                        return false;
                    }
                    int segmentCount = sourceDelta.getFullPath().segmentCount();
                    IResourceDelta[] children = sourceDelta.getAffectedChildren();
                    try {
                        int m = children.length;
                        for (int j = 0; j < m; ++j) {
                            this.findSourceFiles(children[j], md, segmentCount);
                        }
                    }
                    catch (ResourceException e) {
                        if (e.getStatus().getCode() == 275) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("ABORTING incremental build... found renamed package");
                            }
                            return false;
                        }
                        throw e;
                    }
                }
            }
            this.notifier.checkCancel();
        }
        return true;
    }

    protected void findSourceFiles(IResourceDelta sourceDelta, ClasspathMultiDirectory md, int segmentCount) throws CoreException {
        IResource resource = sourceDelta.getResource();
        boolean isExcluded = (md.exclusionPatterns != null || md.inclusionPatterns != null) && org.eclipse.jdt.internal.core.util.Util.isExcluded(resource, md.inclusionPatterns, md.exclusionPatterns);
        switch (resource.getType()) {
            case 2: {
                if (isExcluded && md.inclusionPatterns == null) {
                    return;
                }
                switch (sourceDelta.getKind()) {
                    case 1: {
                        if (!isExcluded) {
                            IPath addedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                            this.createFolder(addedPackagePath, md.binaryFolder);
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found added package " + addedPackagePath);
                            }
                            this.addDependentsOf(addedPackagePath, true);
                        }
                    }
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int l = children.length;
                        for (int i = 0; i < l; ++i) {
                            this.findSourceFiles(children[i], md, segmentCount);
                        }
                        return;
                    }
                    case 2: {
                        IFolder removedPackageFolder;
                        if (isExcluded) {
                            IResourceDelta[] children = sourceDelta.getAffectedChildren();
                            int l = children.length;
                            for (int i = 0; i < l; ++i) {
                                this.findSourceFiles(children[i], md, segmentCount);
                            }
                            return;
                        }
                        IPath removedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        if (this.sourceLocations.length > 1) {
                            int l = this.sourceLocations.length;
                            for (int i = 0; i < l; ++i) {
                                if (!this.sourceLocations[i].sourceFolder.getFolder(removedPackagePath).exists()) continue;
                                this.createFolder(removedPackagePath, md.binaryFolder);
                                IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                int m = removedChildren.length;
                                for (int j = 0; j < m; ++j) {
                                    this.findSourceFiles(removedChildren[j], md, segmentCount);
                                }
                                return;
                            }
                        }
                        if ((removedPackageFolder = md.binaryFolder.getFolder(removedPackagePath)).exists()) {
                            removedPackageFolder.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found removed package " + removedPackagePath);
                        }
                        this.addDependentsOf(removedPackagePath, true);
                        this.newState.removePackage(sourceDelta);
                    }
                }
                return;
            }
            case 1: {
                if (isExcluded) {
                    return;
                }
                String resourceName = resource.getName();
                if (Util.isJavaFileName(resourceName)) {
                    IPath typePath = resource.getFullPath().removeFirstSegments(segmentCount).removeFileExtension();
                    String typeLocator = resource.getProjectRelativePath().toString();
                    switch (sourceDelta.getKind()) {
                        case 1: {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Compile this added source file " + typeLocator);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)resource, md, true));
                            String typeName = typePath.toString();
                            if (!this.newState.isDuplicateLocator(typeName, typeLocator)) {
                                if (JavaBuilder.DEBUG) {
                                    System.out.println("Found added source file " + typeName);
                                }
                                this.addDependentsOf(typePath, true);
                            }
                            return;
                        }
                        case 2: {
                            char[][] definedTypeNames = this.newState.getDefinedTypeNamesFor(typeLocator);
                            if (definedTypeNames == null) {
                                this.removeClassFile(typePath, md.binaryFolder);
                                if ((sourceDelta.getFlags() & 0x2000) != 0) {
                                    IFile movedFile = this.javaBuilder.workspaceRoot.getFile(sourceDelta.getMovedToPath());
                                    JavaBuilder.removeProblemsAndTasksFor((IResource)movedFile);
                                }
                            } else {
                                if (JavaBuilder.DEBUG) {
                                    System.out.println("Found removed source file " + typePath.toString());
                                }
                                this.addDependentsOf(typePath, true);
                                if (definedTypeNames.length > 0) {
                                    IPath packagePath = typePath.removeLastSegments(1);
                                    int l = definedTypeNames.length;
                                    for (int i = 0; i < l; ++i) {
                                        this.removeClassFile(packagePath.append(new String(definedTypeNames[i])), md.binaryFolder);
                                    }
                                }
                            }
                            this.newState.removeLocator(typeLocator);
                            return;
                        }
                        case 4: {
                            if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                                return;
                            }
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Compile this changed source file " + typeLocator);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)resource, md, true));
                        }
                    }
                    return;
                }
                if (Util.isClassFileName(resourceName)) {
                    return;
                }
                if (!md.hasIndependentOutputFolder) break;
                if (this.javaBuilder.filterExtraResource(resource)) {
                    return;
                }
                IPath resourcePath = resource.getFullPath().removeFirstSegments(segmentCount);
                IFile outputFile = md.binaryFolder.getFile(resourcePath);
                switch (sourceDelta.getKind()) {
                    case 1: {
                        if (outputFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting existing file " + resourcePath);
                            }
                            outputFile.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Copying added file " + resourcePath);
                        }
                        this.createFolder(resourcePath.removeLastSegments(1), md.binaryFolder);
                        resource.copy(outputFile.getFullPath(), 1, null);
                        outputFile.setDerived(true);
                        outputFile.setReadOnly(false);
                        return;
                    }
                    case 2: {
                        if (outputFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting removed file " + resourcePath);
                            }
                            outputFile.delete(1, null);
                        }
                        return;
                    }
                    case 4: {
                        if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                            return;
                        }
                        if (outputFile.exists()) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Deleting existing file " + resourcePath);
                            }
                            outputFile.delete(1, null);
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Copying changed file " + resourcePath);
                        }
                        this.createFolder(resourcePath.removeLastSegments(1), md.binaryFolder);
                        resource.copy(outputFile.getFullPath(), 1, null);
                        outputFile.setDerived(true);
                        outputFile.setReadOnly(false);
                    }
                }
                return;
            }
        }
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) {
        Object previousTypeNames = this.newState.getDefinedTypeNamesFor(sourceLocator);
        if (previousTypeNames == null) {
            previousTypeNames = new char[][]{mainTypeName};
        }
        IPath packagePath = null;
        int l = ((char[][])previousTypeNames).length;
        block0: for (int i = 0; i < l; ++i) {
            ArrayList<IPath> types;
            char[] previous = previousTypeNames[i];
            int m = definedTypeNames.size();
            for (int j = 0; j < m; ++j) {
                if (CharOperation.equals(previous, (char[])definedTypeNames.get(j))) continue block0;
            }
            SourceFile sourceFile = (SourceFile)result.getCompilationUnit();
            if (packagePath == null) {
                int count = sourceFile.sourceLocation.sourceFolder.getFullPath().segmentCount();
                packagePath = sourceFile.resource.getFullPath().removeFirstSegments(count).removeLastSegments(1);
            }
            if (this.secondaryTypesToRemove == null) {
                this.secondaryTypesToRemove = new SimpleLookupTable();
            }
            if ((types = (ArrayList<IPath>)this.secondaryTypesToRemove.get(sourceFile.sourceLocation.binaryFolder)) == null) {
                types = new ArrayList<IPath>(definedTypeNames.size());
            }
            types.add(packagePath.append(new String(previous)));
            this.secondaryTypesToRemove.put(sourceFile.sourceLocation.binaryFolder, types);
        }
        super.finishedWith(sourceLocator, result, mainTypeName, definedTypeNames, duplicateTypeNames);
    }

    protected void removeClassFile(IPath typePath, IContainer outputFolder) throws CoreException {
        IFile classFile;
        if (typePath.lastSegment().indexOf(36) == -1) {
            this.newState.removeQualifiedTypeName(typePath.toString());
            if (JavaBuilder.DEBUG) {
                System.out.println("Found removed type " + typePath);
            }
            this.addDependentsOf(typePath, true);
        }
        if ((classFile = outputFolder.getFile(typePath.addFileExtension("class"))).exists()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Deleting class file of removed type " + typePath);
            }
            classFile.delete(1, null);
        }
    }

    protected void removeSecondaryTypes() throws CoreException {
        if (this.secondaryTypesToRemove != null) {
            Object[] keyTable = this.secondaryTypesToRemove.keyTable;
            Object[] valueTable = this.secondaryTypesToRemove.valueTable;
            int l = keyTable.length;
            for (int i = 0; i < l; ++i) {
                IContainer outputFolder = (IContainer)keyTable[i];
                if (outputFolder == null) continue;
                ArrayList paths = (ArrayList)valueTable[i];
                int m = paths.size();
                for (int j = 0; j < m; ++j) {
                    this.removeClassFile((IPath)paths.get(j), outputFolder);
                }
            }
            this.secondaryTypesToRemove = null;
            if (this.previousSourceFiles != null && this.previousSourceFiles.size() > 1) {
                this.previousSourceFiles = null;
            }
        }
    }

    protected void resetCollections() {
        this.previousSourceFiles = this.sourceFiles.isEmpty() ? null : (ArrayList)this.sourceFiles.clone();
        this.sourceFiles.clear();
        this.qualifiedStrings.clear();
        this.simpleStrings.clear();
        this.workQueue.clear();
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IMarker[] markers = JavaBuilder.getProblemsFor((IResource)sourceFile.resource);
        IProblem[] problems = result.getProblems();
        if (problems == null && markers.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(markers, problems);
        JavaBuilder.removeProblemsFor((IResource)sourceFile.resource);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IMarker[] markers = JavaBuilder.getTasksFor((IResource)sourceFile.resource);
        IProblem[] tasks = result.getTasks();
        if (tasks == null && markers.length == 0) {
            return;
        }
        JavaBuilder.removeTasksFor((IResource)sourceFile.resource);
        this.storeTasksFor(sourceFile, tasks);
    }

    protected void writeClassFileBytes(byte[] bytes, IFile file, String qualifiedFileName, boolean isSecondaryType, boolean updateClassFile) throws CoreException {
        if (file.exists()) {
            if (this.writeClassFileCheck(file, qualifiedFileName, bytes) || updateClassFile) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Writing changed class file " + file.getName());
                }
                file.setContents((InputStream)new ByteArrayInputStream(bytes), true, false, null);
                if (!file.isDerived()) {
                    file.setDerived(true);
                }
            } else if (JavaBuilder.DEBUG) {
                System.out.println("Skipped over unchanged class file " + file.getName());
            }
        } else {
            if (isSecondaryType) {
                this.addDependentsOf((IPath)new Path(qualifiedFileName), true);
            }
            if (JavaBuilder.DEBUG) {
                System.out.println("Writing new class file " + file.getName());
            }
            try {
                file.create((InputStream)new ByteArrayInputStream(bytes), 1, null);
            }
            catch (ResourceException e) {
                if (e.getStatus().getCode() == 275) {
                    throw new AbortCompilation(true, new AbortIncrementalBuildException(qualifiedFileName));
                }
                throw e;
            }
            file.setDerived(true);
        }
    }

    protected boolean writeClassFileCheck(IFile file, String fileName, byte[] newBytes) throws CoreException {
        try {
            IPath location;
            byte[] oldBytes;
            block7: {
                oldBytes = org.eclipse.jdt.internal.core.util.Util.getResourceContentsAsByteArray(file);
                if (newBytes.length == oldBytes.length) {
                    int i = newBytes.length;
                    while (--i >= 0) {
                        if (newBytes[i] == oldBytes[i]) continue;
                        break block7;
                    }
                    return false;
                }
            }
            if ((location = file.getLocation()) == null) {
                return false;
            }
            ClassFileReader reader = new ClassFileReader(oldBytes, location.toString().toCharArray());
            if (!reader.isLocal() && !reader.isAnonymous() && reader.hasStructuralChanges(newBytes)) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Type has structural changes " + fileName);
                }
                this.addDependentsOf((IPath)new Path(fileName), true);
                this.newState.wasStructurallyChanged(fileName);
            }
        }
        catch (ClassFormatException e) {
            this.addDependentsOf((IPath)new Path(fileName), true);
            this.newState.wasStructurallyChanged(fileName);
        }
        return true;
    }

    public String toString() {
        return "incremental image builder for:\n\tnew state: " + this.newState;
    }
}

