/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.LocalVariableDeclarationMatch;
import org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.PackageDeclarationMatch;
import org.eclipse.jdt.core.search.PackageReferenceMatch;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocImportReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfIntValues;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.IndexSelector;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;
import org.eclipse.jdt.internal.core.search.matching.ClassFileMatchLocator;
import org.eclipse.jdt.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatchSet;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.jdt.internal.core.util.HandleFactory;
import org.eclipse.jdt.internal.core.util.SimpleSet;
import org.eclipse.jdt.internal.core.util.Util;

public class MatchLocator
implements ITypeRequestor {
    public static final int MAX_AT_ONCE = 400;
    public SearchPattern pattern;
    public PatternLocator patternLocator;
    public int matchContainer;
    public SearchRequestor requestor;
    public IJavaSearchScope scope;
    public IProgressMonitor progressMonitor;
    public ICompilationUnit[] workingCopies;
    public HandleFactory handleFactory;
    public char[][][] allSuperTypeNames;
    public MatchLocatorParser parser;
    private Parser basicParser;
    public INameEnvironment nameEnvironment;
    public NameLookup nameLookup;
    public LookupEnvironment lookupEnvironment;
    public HierarchyResolver hierarchyResolver;
    public CompilerOptions options;
    public int numberOfMatches;
    public PossibleMatch[] matchesToProcess;
    public PossibleMatch currentPossibleMatch;
    public long resultCollectorTime = 0L;

    public static SearchDocument[] addWorkingCopies(InternalSearchPattern pattern, SearchDocument[] indexMatches, ICompilationUnit[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        HashMap workingCopyDocuments = MatchLocator.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        for (int i = 0; i < length; ++i) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() != participant || (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) == null) continue;
            if (matches == null) {
                matches = new SearchDocument[length];
                System.arraycopy(indexMatches, 0, matches, 0, length);
            }
            matches[i] = workingCopyDocument;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        return matches;
    }

    public static void setFocus(InternalSearchPattern pattern, IJavaElement focus) {
        pattern.focus = focus;
    }

    private static HashMap workingCopiesThatCanSeeFocus(ICompilationUnit[] copies, IJavaElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IJavaProject) && !(focus instanceof JarPackageFragmentRoot)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int length = copies.length;
        for (int i = 0; i < length; ++i) {
            ICompilationUnit workingCopy = copies[i];
            IPath projectOrJar = MatchLocator.getProjectOrJar(workingCopy).getPath();
            if (focus != null && !IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) continue;
            result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFileReader classFileReader(IType type) {
        IPath zipPath;
        IClassFile classFile = type.getClassFile();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (classFile.isOpen()) {
            return (ClassFileReader)manager.getInfo(type);
        }
        IPackageFragment pkg = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        if (!root.isArchive()) {
            return ClassFileReader.read(type.getPath().toOSString());
        }
        IPath iPath = zipPath = root.isExternal() ? root.getPath() : root.getResource().getLocation();
        if (zipPath == null) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [MatchLocator.classFileReader()] Creating ZipFile on " + zipPath);
            }
            zipFile = manager.getZipFile(zipPath);
            char[] pkgPath = pkg.getElementName().toCharArray();
            CharOperation.replace(pkgPath, '.', '/');
            char[] classFileName = classFile.getElementName().toCharArray();
            char[] path = pkgPath.length == 0 ? classFileName : CharOperation.concat(pkgPath, classFileName, '/');
            ClassFileReader classFileReader = ClassFileReader.read(zipFile, new String(path));
            manager.closeZipFile(zipFile);
            return classFileReader;
        }
        catch (Throwable throwable) {
            try {
                manager.closeZipFile(zipFile);
                throw throwable;
            }
            catch (ClassFormatException e) {
            }
            catch (CoreException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static SearchPattern createAndPattern(final SearchPattern leftPattern, final SearchPattern rightPattern) {
        return new AndPattern(0, 0){
            SearchPattern current;
            {
                this.current = leftPattern;
            }

            public SearchPattern currentPattern() {
                return this.current;
            }

            protected boolean hasNextQuery() {
                if (this.current == leftPattern) {
                    this.current = rightPattern;
                    return true;
                }
                return false;
            }

            protected void resetQuery() {
                this.current = leftPattern;
            }
        };
    }

    public static void findIndexMatches(InternalSearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, monitor);
    }

    public static IJavaElement getProjectOrJar(IJavaElement element) {
        while (!(element instanceof IJavaProject) && !(element instanceof JarPackageFragmentRoot)) {
            element = element.getParent();
        }
        return element;
    }

    public static boolean isPolymorphicSearch(InternalSearchPattern pattern) {
        return pattern.isPolymorphicSearch();
    }

    public static IJavaElement projectOrJarFocus(InternalSearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrJar(pattern.focus);
    }

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.patternLocator = PatternLocator.patternLocator(this.pattern);
        this.matchContainer = this.patternLocator.matchContainer();
        this.requestor = requestor;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
    }

    public void accept(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit) {
        block2: {
            CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit = this.basicParser().dietParse(sourceUnit, unitResult);
                this.lookupEnvironment.buildTypeBindings(parsedUnit);
                this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
            }
            catch (AbortCompilationUnit e) {
                if (unitResult.compilationUnit == sourceUnit) break block2;
                throw e;
            }
        }
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)type.getCompilationUnit());
            this.accept(sourceUnit);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
        }
        return this.basicParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseAndBuildBindings(PossibleMatch possibleMatch, boolean mustResolve) {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (SearchEngine.VERBOSE) {
                System.out.println("Parsing " + possibleMatch.openable.toStringWithAncestors());
            }
            this.parser.nodeSet = possibleMatch.nodeSet;
            CompilationResult unitResult = new CompilationResult(possibleMatch, 1, 1, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parser.dietParse(possibleMatch, unitResult);
            if (parsedUnit != null) {
                if (mustResolve && !parsedUnit.isEmpty()) {
                    this.lookupEnvironment.buildTypeBindings(parsedUnit);
                }
                possibleMatch.parsedUnit = parsedUnit;
                int size = this.matchesToProcess.length;
                if (this.numberOfMatches == size) {
                    this.matchesToProcess = new PossibleMatch[size == 0 ? 1 : size * 2];
                    System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.numberOfMatches);
                }
                this.matchesToProcess[this.numberOfMatches++] = possibleMatch;
            }
        }
        finally {
            this.parser.nodeSet = null;
        }
    }

    protected BinaryTypeBinding cacheBinaryType(IType type, IBinaryType binaryType) throws JavaModelException {
        char[][] compoundName;
        ReferenceBinding referenceBinding;
        BinaryTypeBinding binding;
        IType enclosingType = type.getDeclaringType();
        if (enclosingType != null) {
            this.cacheBinaryType(enclosingType, null);
        }
        if (binaryType == null) {
            ClassFile classFile = (ClassFile)type.getClassFile();
            try {
                binaryType = this.getBinaryInfo(classFile, classFile.getResource());
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        if ((binding = this.lookupEnvironment.cacheBinaryType(binaryType)) == null && (referenceBinding = this.lookupEnvironment.getCachedType(compoundName = CharOperation.splitOn('.', type.getFullyQualifiedName().toCharArray()))) != null && referenceBinding instanceof BinaryTypeBinding) {
            binding = (BinaryTypeBinding)referenceBinding;
        }
        return binding;
    }

    protected char[][][] computeSuperTypeNames(IType focusType) {
        String fullyQualifiedName = focusType.getFullyQualifiedName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        char[] qualification = lastDot == -1 ? CharOperation.NO_CHAR : fullyQualifiedName.substring(0, lastDot).toCharArray();
        char[] simpleName = focusType.getElementName().toCharArray();
        SuperTypeNamesCollector superTypeNamesCollector = new SuperTypeNamesCollector(this.pattern, simpleName, qualification, new MatchLocator(this.pattern, this.requestor, this.scope, this.progressMonitor), focusType, this.progressMonitor);
        try {
            this.allSuperTypeNames = superTypeNamesCollector.collect();
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        return this.allSuperTypeNames;
    }

    protected IJavaElement createHandle(AbstractMethodDeclaration method, IJavaElement parent) {
        int argCount;
        if (!(parent instanceof IType)) {
            return parent;
        }
        IType type = (IType)parent;
        Argument[] arguments = method.arguments;
        int n = argCount = arguments == null ? 0 : arguments.length;
        if (type.isBinary()) {
            IBinaryMethod[] methods;
            ClassFileReader reader = MatchLocator.classFileReader(type);
            if (reader != null && (methods = reader.getMethods()) != null) {
                boolean firstIsSynthetic = false;
                if (reader.isMember() && method.isConstructor() && !Flags.isStatic(reader.getModifiers())) {
                    firstIsSynthetic = true;
                    ++argCount;
                }
                int methodsLength = methods.length;
                block0: for (int i = 0; i < methodsLength; ++i) {
                    char[][] parameterTypes;
                    char[] selector;
                    IBinaryMethod binaryMethod = methods[i];
                    char[] cArray = selector = binaryMethod.isConstructor() ? type.getElementName().toCharArray() : binaryMethod.getSelector();
                    if (!CharOperation.equals(selector, method.selector) || argCount != (parameterTypes = Signature.getParameterTypes(binaryMethod.getMethodDescriptor())).length) continue;
                    for (int j = 0; j < argCount; ++j) {
                        char[] typeName;
                        if (j == 0 && firstIsSynthetic) {
                            typeName = type.getDeclaringType().getFullyQualifiedName().toCharArray();
                        } else {
                            TypeReference typeRef = arguments[firstIsSynthetic ? j - 1 : j].type;
                            typeName = CharOperation.concatWith(typeRef.getTypeName(), '.');
                            int dim = typeRef.dimensions();
                            for (int k = 0; k < dim; ++k) {
                                typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                            }
                        }
                        char[] parameterTypeName = ClassFileMatchLocator.convertClassFileFormat(parameterTypes[j]);
                        if (!CharOperation.endsWith(Signature.toCharArray(parameterTypeName), typeName)) continue block0;
                        parameterTypes[j] = parameterTypeName;
                    }
                    return type.getMethod(new String(selector), CharOperation.toStrings(parameterTypes));
                }
            }
            return null;
        }
        String[] parameterTypeSignatures = new String[argCount];
        for (int i = 0; i < argCount; ++i) {
            TypeReference typeRef = arguments[i].type;
            char[] typeName = CharOperation.concatWith(typeRef.getTypeName(), '.');
            int dim = typeRef.dimensions();
            for (int j = 0; j < dim; ++j) {
                typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
            }
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
        }
        return type.getMethod(new String(method.selector), parameterTypeSignatures);
    }

    protected IJavaElement createHandle(FieldDeclaration fieldDeclaration, TypeDeclaration typeDeclaration, IJavaElement parent) {
        if (!(parent instanceof IType)) {
            return parent;
        }
        if (fieldDeclaration.isField()) {
            return ((IType)parent).getField(new String(fieldDeclaration.name));
        }
        int occurrenceCount = 0;
        FieldDeclaration[] fields = typeDeclaration.fields;
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            if (fields[i].isField()) continue;
            ++occurrenceCount;
            if (fields[i].equals(fieldDeclaration)) break;
        }
        return ((IType)parent).getInitializer(occurrenceCount);
    }

    protected boolean createHierarchyResolver(IType focusType, PossibleMatch[] possibleMatches) {
        char[][] compoundName = CharOperation.splitOn('.', focusType.getFullyQualifiedName().toCharArray());
        boolean isPossibleMatch = false;
        int length = possibleMatches.length;
        for (int i = 0; i < length; ++i) {
            if (!CharOperation.equals(possibleMatches[i].compoundName, compoundName)) continue;
            isPossibleMatch = true;
            break;
        }
        if (!isPossibleMatch) {
            if (focusType.isBinary()) {
                try {
                    this.cacheBinaryType(focusType, null);
                }
                catch (JavaModelException e) {
                    return false;
                }
            } else {
                this.accept((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)focusType.getCompilationUnit()));
            }
        }
        this.hierarchyResolver = new HierarchyResolver(this.lookupEnvironment, null);
        ReferenceBinding binding = this.hierarchyResolver.setFocusType(compoundName);
        return binding != null && binding.isValidBinding() && (binding.tagBits & 0x8000) == 0;
    }

    protected IJavaElement createImportHandle(ImportReference importRef) {
        Openable openable;
        char[] importName = CharOperation.concatWith(importRef.getImportName(), '.');
        if (importRef.onDemand) {
            importName = CharOperation.concat(importName, ".*".toCharArray());
        }
        if ((openable = this.currentPossibleMatch.openable) instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getImport(new String(importName));
        }
        IType binaryType = ((ClassFile)openable).getType();
        String typeName = binaryType.getElementName();
        int lastDollar = typeName.lastIndexOf(36);
        if (lastDollar == -1) {
            return binaryType;
        }
        return this.createTypeHandle(typeName.substring(0, lastDollar));
    }

    protected IType createTypeHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getType(simpleTypeName);
        }
        IType binaryType = ((ClassFile)openable).getType();
        if (simpleTypeName.equals(binaryType.getTypeQualifiedName())) {
            return binaryType;
        }
        try {
            IClassFile classFile = binaryType.getPackageFragment().getClassFile(simpleTypeName + ".class");
            return classFile.getType();
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    protected boolean encloses(IJavaElement element) {
        return element != null && this.scope.encloses(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return (IBinaryType)binaryType.getElementInfo();
        }
        try {
            ClassFileReader info;
            IJavaElement pkg = classFile.getParent();
            PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
            if (root.isArchive()) {
                String pkgPath = pkg.getElementName().replace('.', '/');
                String classFilePath = pkgPath.length() > 0 ? pkgPath + "/" + classFile.getElementName() : classFile.getElementName();
                ZipFile zipFile = null;
                try {
                    zipFile = ((JarPackageFragmentRoot)root).getJar();
                    info = ClassFileReader.read(zipFile, classFilePath);
                }
                finally {
                    JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                }
            } else {
                String osPath = resource.getLocation().toOSString();
                info = ClassFileReader.read(osPath);
            }
            if (info == null) {
                throw binaryType.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    protected IType getFocusType() {
        return this.scope instanceof HierarchyScope ? ((HierarchyScope)this.scope).focusType : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMethodBodies(CompilationUnitDeclaration unit) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        int[] oldLineEnds = this.parser.scanner.lineEnds;
        int oldLinePtr = this.parser.scanner.linePtr;
        try {
            char[] contents = unit.compilationResult.compilationUnit.getContents();
            this.parser.scanner.setSource(contents);
            int[] lineSeparatorPositions = unit.compilationResult.lineSeparatorPositions;
            this.parser.scanner.lineEnds = lineSeparatorPositions;
            this.parser.scanner.linePtr = lineSeparatorPositions.length - 1;
            if (this.parser.javadocParser.checkDocComment) {
                this.parser.javadocParser.scanner.setSource(contents);
            }
            this.parser.nodeSet = this.currentPossibleMatch.nodeSet;
            this.parser.parseBodies(unit);
            Object var7_6 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            throw throwable;
        }
    }

    protected boolean hasAlreadyDefinedType(CompilationUnitDeclaration parsedUnit) {
        CompilationResult result = parsedUnit.compilationResult;
        if (result == null) {
            return false;
        }
        for (int i = 0; i < result.problemCount; ++i) {
            if (result.problems[i].getID() != 16777539) continue;
            return true;
        }
        return false;
    }

    public void initialize(JavaProject project, int possibleMatchSize) throws JavaModelException {
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        SearchableEnvironment searchableEnvironment = (SearchableEnvironment)project.newSearchableNameEnvironment(this.workingCopies);
        this.nameEnvironment = possibleMatchSize == 1 ? searchableEnvironment : new JavaSearchNameEnvironment(project, this.workingCopies);
        this.options = new CompilerOptions(project.getOptions(true));
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
        this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, this.nameEnvironment);
        this.parser = MatchLocatorParser.createParser(problemReporter, this);
        this.nameLookup = searchableEnvironment.nameLookup;
        this.numberOfMatches = 0;
        this.matchesToProcess = new PossibleMatch[possibleMatchSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void locateMatches(JavaProject javaProject, PossibleMatch[] possibleMatches, int start, int length) throws CoreException {
        boolean mustResolve;
        this.initialize(javaProject, length);
        boolean bindingsWereCreated = mustResolve = this.pattern.mustResolve;
        try {
            IType focusType;
            int maxUnits = start + length;
            for (int i = start; i < maxUnits; ++i) {
                PossibleMatch possibleMatch = possibleMatches[i];
                try {
                    this.parseAndBuildBindings(possibleMatch, mustResolve);
                    if (mustResolve) continue;
                    this.process(possibleMatch, bindingsWereCreated);
                    continue;
                }
                finally {
                    if (!mustResolve) {
                        possibleMatch.cleanUp();
                    }
                }
            }
            if (mustResolve) {
                this.lookupEnvironment.completeTypeBindings();
            }
            if ((focusType = this.getFocusType()) == null) {
                this.hierarchyResolver = null;
            } else if (!this.createHierarchyResolver(focusType, possibleMatches) && this.computeSuperTypeNames(focusType) == null) {
                return;
            }
        }
        catch (AbortCompilation e) {
            bindingsWereCreated = false;
        }
        if (!mustResolve) {
            return;
        }
        int i = 0;
        while (true) {
            block24: {
                PossibleMatch possibleMatch;
                block25: {
                    Object var12_17;
                    if (i >= this.numberOfMatches) {
                        return;
                    }
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    possibleMatch = this.matchesToProcess[i];
                    this.matchesToProcess[i] = null;
                    try {
                        try {
                            this.process(possibleMatch, bindingsWereCreated);
                        }
                        catch (AbortCompilation e) {
                            bindingsWereCreated = false;
                            var12_17 = null;
                            if (this.options.verbose) {
                                System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                            }
                            possibleMatch.cleanUp();
                            break block24;
                        }
                        catch (JavaModelException e) {
                            bindingsWereCreated = false;
                            var12_17 = null;
                            if (this.options.verbose) {
                                System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                            }
                            possibleMatch.cleanUp();
                            break block24;
                        }
                        var12_17 = null;
                        if (!this.options.verbose) break block25;
                    }
                    catch (Throwable throwable) {
                        var12_17 = null;
                        if (this.options.verbose) {
                            System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                        }
                        possibleMatch.cleanUp();
                        throw throwable;
                    }
                    System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                }
                possibleMatch.cleanUp();
            }
            ++i;
        }
    }

    protected void locateMatches(JavaProject javaProject, PossibleMatchSet matchSet) throws CoreException {
        int max;
        PossibleMatch[] possibleMatches = matchSet.getPossibleMatches(javaProject.getPackageFragmentRoots());
        int length = possibleMatches.length;
        for (int index = 0; index < length; index += max) {
            max = Math.min(400, length - index);
            this.locateMatches(javaProject, possibleMatches, index, max);
            if (this.progressMonitor == null) continue;
            this.progressMonitor.worked(max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        if (SearchEngine.VERBOSE) {
            System.out.println("Locating matches in documents [");
            int length = searchDocuments.length;
            for (int i = 0; i < length; ++i) {
                System.out.println("\t" + searchDocuments[i]);
            }
            System.out.println("]");
        }
        ArrayList<ICompilationUnit> copies = new ArrayList<ICompilationUnit>();
        int length = searchDocuments.length;
        for (int i = 0; i < length; ++i) {
            SearchDocument document = searchDocuments[i];
            if (!(document instanceof WorkingCopyDocument)) continue;
            copies.add(((WorkingCopyDocument)document).workingCopy);
        }
        int copiesLength = copies.size();
        this.workingCopies = new ICompilationUnit[copiesLength];
        copies.toArray(this.workingCopies);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            if (this.handleFactory == null) {
                this.handleFactory = new HandleFactory();
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.beginTask("", searchDocuments.length);
            }
            this.patternLocator.initializePolymorphicSearch(this);
            JavaProject previousJavaProject = null;
            int skipped = 0;
            PossibleMatchSet matchSet = new PossibleMatchSet();
            Util.sort((Object[])searchDocuments, new Util.Comparer(){

                public int compare(Object a, Object b) {
                    return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                }
            });
            int l = searchDocuments.length;
            for (int i = 0; i < l; ++i) {
                Openable openable;
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchDocument searchDocument = searchDocuments[i];
                String pathString = searchDocument.getPath();
                if (i > 0 && pathString.equals(searchDocuments[i - 1].getPath())) {
                    ++skipped;
                    continue;
                }
                ICompilationUnit workingCopy = null;
                if (searchDocument instanceof WorkingCopyDocument) {
                    workingCopy = ((WorkingCopyDocument)searchDocument).workingCopy;
                    openable = (Openable)((Object)workingCopy);
                } else {
                    openable = this.handleFactory.createOpenable(pathString, this.scope);
                    if (openable == null) continue;
                }
                IResource resource = null;
                JavaProject javaProject = (JavaProject)openable.getJavaProject();
                IResource iResource = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                if (resource == null) {
                    resource = javaProject.getProject();
                }
                if (!javaProject.equals(previousJavaProject)) {
                    if (previousJavaProject != null) {
                        try {
                            this.locateMatches(previousJavaProject, matchSet);
                        }
                        catch (JavaModelException e) {
                            // empty catch block
                        }
                        if (this.progressMonitor != null) {
                            this.progressMonitor.worked(skipped);
                        }
                        matchSet.reset();
                    }
                    previousJavaProject = javaProject;
                    skipped = 0;
                }
                matchSet.add(new PossibleMatch(this, resource, openable, searchDocument));
                ++skipped;
            }
            if (previousJavaProject != null) {
                try {
                    this.locateMatches(previousJavaProject, matchSet);
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(skipped);
                }
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
            Object var18_20 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            throw throwable;
        }
    }

    public void locatePackageDeclarations(SearchParticipant participant) throws CoreException {
        this.locatePackageDeclarations(this.pattern, participant);
    }

    protected void locatePackageDeclarations(SearchPattern searchPattern, SearchParticipant participant) throws CoreException {
        block11: {
            block10: {
                if (!(searchPattern instanceof OrPattern)) break block10;
                SearchPattern[] patterns = ((OrPattern)searchPattern).patterns;
                int length = patterns.length;
                for (int i = 0; i < length; ++i) {
                    this.locatePackageDeclarations(patterns[i], participant);
                }
                break block11;
            }
            if (!(searchPattern instanceof PackageDeclarationPattern)) break block11;
            IJavaElement focus = searchPattern.focus;
            if (focus != null) {
                SearchDocument document = participant.getDocument(focus.getPath().toString());
                this.currentPossibleMatch = new PossibleMatch(this, focus.getResource(), null, document);
                if (this.encloses(focus)) {
                    SearchMatch match = this.newDeclarationMatch(focus, 0, -1, -1);
                    this.report(match);
                }
                return;
            }
            PackageDeclarationPattern pkgPattern = (PackageDeclarationPattern)searchPattern;
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int length = projects.length;
            for (int i = 0; i < length; ++i) {
                IJavaProject javaProject = projects[i];
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int rootsLength = roots.length;
                for (int j = 0; j < rootsLength; ++j) {
                    IJavaElement[] pkgs = roots[j].getChildren();
                    int pksLength = pkgs.length;
                    for (int k = 0; k < pksLength; ++k) {
                        IPackageFragment pkg = (IPackageFragment)pkgs[k];
                        if (pkg.getChildren().length <= 0 || !pkgPattern.matchesName(pkgPattern.pkgName, pkg.getElementName().toCharArray())) continue;
                        IResource resource = pkg.getResource();
                        if (resource == null) {
                            resource = javaProject.getProject();
                        }
                        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
                        this.currentPossibleMatch = new PossibleMatch(this, resource, null, document);
                        try {
                            if (!this.encloses(pkg)) continue;
                            SearchMatch match = this.newDeclarationMatch(pkg, 0, -1, -1);
                            this.report(match);
                            continue;
                        }
                        catch (JavaModelException e) {
                            throw e;
                        }
                        catch (CoreException e) {
                            throw new JavaModelException(e);
                        }
                    }
                }
            }
        }
    }

    protected IType lookupType(ReferenceBinding typeBinding) {
        IType type;
        int length;
        if (typeBinding == null) {
            return null;
        }
        char[] packageName = typeBinding.qualifiedPackageName();
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
        char[] sourceName = typeBinding.qualifiedSourceName();
        String typeName = new String(sourceName);
        int n = length = pkgs == null ? 0 : pkgs.length;
        for (int i = 0; i < length; ++i) {
            type = this.nameLookup.findType(typeName, pkgs[i], false, typeBinding.isClass() ? 2 : 4);
            if (type == null) continue;
            return type;
        }
        char[][] qualifiedName = CharOperation.splitOn('.', sourceName);
        length = qualifiedName.length;
        if (length == 0) {
            return null;
        }
        type = this.createTypeHandle(new String(qualifiedName[0]));
        if (type == null) {
            return null;
        }
        for (int i = 1; i < length; ++i) {
            if ((type = type.getType(new String(qualifiedName[i]))) != null) continue;
            return null;
        }
        if (type.exists()) {
            return type;
        }
        return null;
    }

    public SearchMatch newDeclarationMatch(IJavaElement element, int accuracy, int offset, int length) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return this.newDeclarationMatch(element, accuracy, offset, length, participant, resource);
    }

    public SearchMatch newDeclarationMatch(IJavaElement element, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
        switch (element.getElementType()) {
            case 4: {
                return new PackageDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 7: {
                return new TypeDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 8: {
                return new FieldDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 9: {
                return new MethodDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 14: {
                return new LocalVariableDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
        }
        return null;
    }

    public SearchMatch newFieldReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new FieldReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newLocalVariableReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new LocalVariableReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newMethodReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new MethodReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public SearchMatch newPackageReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new PackageReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public SearchMatch newTypeReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new TypeReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(PossibleMatch possibleMatch, boolean bindingsWereCreated) throws CoreException {
        this.currentPossibleMatch = possibleMatch;
        CompilationUnitDeclaration unit = possibleMatch.parsedUnit;
        try {
            if (unit.isEmpty()) {
                ClassFile classFile;
                IBinaryType info;
                if (this.currentPossibleMatch.openable instanceof ClassFile && (info = this.getBinaryInfo(classFile = (ClassFile)this.currentPossibleMatch.openable, this.currentPossibleMatch.resource)) != null) {
                    new ClassFileMatchLocator().locateMatches(this, classFile, info);
                }
                return;
            }
            if (this.hasAlreadyDefinedType(unit)) {
                return;
            }
            this.getMethodBodies(unit);
            if (bindingsWereCreated && this.pattern.mustResolve && unit.types != null) {
                if (SearchEngine.VERBOSE) {
                    System.out.println("Resolving " + this.currentPossibleMatch.openable.toStringWithAncestors());
                }
                this.reduceParseTree(unit);
                if (unit.scope != null) {
                    unit.scope.faultInTypes();
                }
                unit.resolve();
                this.reportMatching(unit, true);
            } else {
                this.reportMatching(unit, this.pattern.mustResolve);
            }
        }
        catch (AbortCompilation e) {
            this.reportMatching(unit, true);
            if (!(e instanceof AbortCompilationUnit)) {
                throw e;
            }
        }
        finally {
            this.currentPossibleMatch = null;
        }
    }

    protected void purgeMethodStatements(TypeDeclaration type, boolean checkEachMethod) {
        TypeDeclaration[] memberTypes;
        checkEachMethod = checkEachMethod && this.currentPossibleMatch.nodeSet.hasPossibleNodes(type.declarationSourceStart, type.declarationSourceEnd);
        AbstractMethodDeclaration[] methods = type.methods;
        if (methods != null) {
            int j;
            int length;
            if (checkEachMethod) {
                length = methods.length;
                for (j = 0; j < length; ++j) {
                    AbstractMethodDeclaration method = methods[j];
                    if (this.currentPossibleMatch.nodeSet.hasPossibleNodes(method.declarationSourceStart, method.declarationSourceEnd)) continue;
                    method.statements = null;
                    method.javadoc = null;
                }
            } else {
                length = methods.length;
                for (j = 0; j < length; ++j) {
                    methods[j].statements = null;
                    methods[j].javadoc = null;
                }
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int l = memberTypes.length;
            for (int i = 0; i < l; ++i) {
                this.purgeMethodStatements(memberTypes[i], checkEachMethod);
            }
        }
    }

    protected void reduceParseTree(CompilationUnitDeclaration unit) {
        TypeDeclaration[] types = unit.types;
        int l = types.length;
        for (int i = 0; i < l; ++i) {
            this.purgeMethodStatements(types[i], true);
        }
    }

    public SearchParticipant getParticipant() {
        return this.currentPossibleMatch.document.getParticipant();
    }

    protected void report(SearchMatch match) throws CoreException {
        long start = -1L;
        if (SearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
            System.out.println("Reporting match");
            System.out.println("\tResource: " + match.getResource());
            System.out.println("\tPositions: [offset=" + match.getOffset() + ", length=" + match.getLength() + "]");
            System.out.println("\tJava element: " + ((JavaElement)match.getElement()).toStringWithAncestors());
            System.out.println(match.getAccuracy() == 0 ? "\tAccuracy: EXACT_MATCH" : "\tAccuracy: POTENTIAL_MATCH");
        }
        this.requestor.acceptSearchMatch(match);
        if (SearchEngine.VERBOSE) {
            this.resultCollectorTime += System.currentTimeMillis() - start;
        }
    }

    protected void reportAccurateTypeReference(ASTNode typeRef, char[] name, IJavaElement element, int accuracy) throws CoreException {
        if (accuracy == -1) {
            return;
        }
        if (!this.encloses(element)) {
            return;
        }
        int sourceStart = typeRef.sourceStart;
        int sourceEnd = typeRef.sourceEnd;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int token = -1;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException e) {
                // empty catch block
            }
            if (token != 28 || !this.pattern.matchesName(name, scanner.getCurrentTokenSource())) continue;
            int length = scanner.currentPosition - currentPosition;
            SearchMatch match = this.newTypeReferenceMatch(element, accuracy, currentPosition, length, typeRef);
            this.report(match);
            return;
        } while (token != 54);
        SearchMatch match = this.newTypeReferenceMatch(element, accuracy, sourceStart, sourceEnd - sourceStart + 1, typeRef);
        this.report(match);
    }

    protected void reportAccurateFieldReference(QualifiedNameReference qNameRef, IJavaElement element, int[] accuracies) throws CoreException {
        if (!this.encloses(element)) {
            return;
        }
        int sourceStart = qNameRef.sourceStart;
        int sourceEnd = qNameRef.sourceEnd;
        char[][] tokens = qNameRef.tokens;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int length = tokens.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        int accuracyIndex = 0;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException e) {
                // empty catch block
            }
            if (token != 54) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < length && !(equals = this.pattern.matchesName(tokens[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException e) {
                    // empty catch block
                }
            }
            if (accuracies[accuracyIndex] != -1) {
                SearchMatch match;
                if (refSourceStart != -1) {
                    match = this.newFieldReferenceMatch(element, accuracies[accuracyIndex], refSourceStart, refSourceEnd - refSourceStart + 1, qNameRef);
                    this.report(match);
                } else {
                    match = this.newFieldReferenceMatch(element, accuracies[accuracyIndex], sourceStart, sourceEnd - sourceStart + 1, qNameRef);
                    this.report(match);
                }
                i = 0;
            }
            refSourceStart = -1;
            previousValid = -1;
            if (accuracyIndex >= accuracies.length - 1) continue;
            ++accuracyIndex;
        } while (token != 54);
    }

    protected void reportBinaryMemberDeclaration(IResource resource, IMember binaryMember, IBinaryType info, int accuracy) throws CoreException {
        char[] contents;
        IType type;
        String sourceFileName;
        SourceMapper mapper;
        ISourceRange range;
        ClassFile classFile = (ClassFile)binaryMember.getClassFile();
        ISourceRange iSourceRange = range = classFile.isOpen() ? binaryMember.getNameRange() : SourceMapper.fgUnknownRange;
        if (range.getOffset() == -1 && (mapper = classFile.getSourceMapper()) != null && (sourceFileName = mapper.findSourceFileName(type = classFile.getType(), info)) != null && (contents = mapper.findSource(type, sourceFileName)) != null) {
            range = mapper.mapSource(type, contents, binaryMember);
        }
        if (resource == null) {
            resource = this.currentPossibleMatch.resource;
        }
        SearchMatch match = this.newDeclarationMatch(binaryMember, accuracy, range.getOffset(), range.getLength(), this.getParticipant(), resource);
        this.report(match);
    }

    protected void reportMatching(AbstractMethodDeclaration method, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IJavaElement enclosingElement = null;
        if (accuracy > -1 && (enclosingElement = this.createHandle(method, parent)) != null) {
            Scanner scanner = this.parser.scanner;
            int nameSourceStart = method.sourceStart;
            scanner.setSource(this.currentPossibleMatch.getContents());
            scanner.resetTo(nameSourceStart, method.sourceEnd);
            try {
                scanner.getNextToken();
            }
            catch (InvalidInputException e) {
                // empty catch block
            }
            if (this.encloses(enclosingElement)) {
                int length = scanner.currentPosition - nameSourceStart;
                SearchMatch match = this.newDeclarationMatch(enclosingElement, accuracy, nameSourceStart, length);
                this.report(match);
            }
        }
        if ((method.bits & 2) != 0) {
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(method, parent);
            }
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
            try {
                method.traverse((ASTVisitor)localDeclarationVisitor, (ClassScope)null);
            }
            catch (WrappedCoreException e) {
                throw e.coreException;
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(method.declarationSourceStart, method.declarationSourceEnd)) != null) {
            int i;
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    int l = nodes.length;
                    for (i = 0; i < l; ++i) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        this.patternLocator.matchReportReference(node, enclosingElement, level, this);
                    }
                    return;
                }
            }
            int l = nodes.length;
            for (i = 0; i < l; ++i) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
            }
        }
    }

    protected void reportMatching(CompilationUnitDeclaration unit, boolean mustResolve) throws CoreException {
        TypeDeclaration[] types;
        Integer level;
        int i;
        ImportReference[] imports;
        boolean matchedUnitContainer;
        ImportReference importRef;
        MatchingNodeSet nodeSet = this.currentPossibleMatch.nodeSet;
        if (mustResolve) {
            Object[] nodes = nodeSet.possibleMatchingNodesSet.values;
            int l = nodes.length;
            for (int i2 = 0; i2 < l; ++i2) {
                JavadocImportReference importRef2;
                int tagEnd;
                int tagStart;
                long[] positions;
                Object tokens;
                ASTNode node = (ASTNode)nodes[i2];
                if (node == null) continue;
                if (node instanceof ImportReference) {
                    if (this.hierarchyResolver != null) continue;
                    importRef = (ImportReference)node;
                    Binding binding = importRef.onDemand ? unit.scope.getTypeOrPackage(CharOperation.subarray(importRef.tokens, 0, importRef.tokens.length)) : unit.scope.getTypeOrPackage(importRef.tokens);
                    this.patternLocator.matchLevelAndReportImportRef(importRef, binding, this);
                } else if (node instanceof JavadocSingleTypeReference) {
                    JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)node;
                    if (singleRef.packageBinding != null) {
                        tokens = new char[][]{singleRef.token};
                        positions = new long[]{((long)singleRef.sourceStart << 32) + (long)singleRef.sourceEnd};
                        tagStart = singleRef.tagSourceStart;
                        tagEnd = singleRef.tagSourceEnd;
                        importRef2 = new JavadocImportReference((char[][])tokens, positions, tagStart, tagEnd);
                        this.patternLocator.matchLevelAndReportImportRef(importRef2, singleRef.packageBinding, this);
                        continue;
                    }
                } else if (node instanceof JavadocQualifiedTypeReference) {
                    JavadocQualifiedTypeReference qualifRef = (JavadocQualifiedTypeReference)node;
                    if (qualifRef.packageBinding != null) {
                        tokens = qualifRef.tokens;
                        positions = qualifRef.sourcePositions;
                        tagStart = qualifRef.tagSourceStart;
                        tagEnd = qualifRef.tagSourceEnd;
                        importRef2 = new JavadocImportReference((char[][])tokens, positions, tagStart, tagEnd);
                        this.patternLocator.matchLevelAndReportImportRef(importRef2, qualifRef.packageBinding, this);
                        continue;
                    }
                }
                nodeSet.addMatch(node, this.patternLocator.resolveLevel(node));
            }
            nodeSet.possibleMatchingNodesSet = new SimpleSet(3);
        }
        if (nodeSet.matchingNodes.elementSize == 0) {
            return;
        }
        boolean bl = matchedUnitContainer = (this.matchContainer & 1) != 0;
        if (matchedUnitContainer && (imports = unit.imports) != null) {
            int l = imports.length;
            for (i = 0; i < l; ++i) {
                importRef = imports[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(importRef);
                if (level == null) continue;
                this.patternLocator.matchReportImportRef(importRef, null, this.createImportHandle(importRef), level, this);
            }
        }
        if ((types = unit.types) != null) {
            int l = types.length;
            for (i = 0; i < l; ++i) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration type = types[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(type);
                int accuracy = level != null && matchedUnitContainer ? level : -1;
                this.reportMatching(type, null, accuracy, nodeSet, 1);
            }
        }
    }

    protected void reportMatching(FieldDeclaration field, TypeDeclaration type, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        block8: {
            ASTNode[] nodes;
            IJavaElement enclosingElement;
            block9: {
                enclosingElement = null;
                if (accuracy > -1 && this.encloses(enclosingElement = this.createHandle(field, type, parent))) {
                    int offset = field.sourceStart;
                    SearchMatch match = this.newDeclarationMatch(enclosingElement, accuracy, offset, field.sourceEnd - offset + 1);
                    this.report(match);
                }
                if ((field.bits & 2) != 0) {
                    if (enclosingElement == null) {
                        enclosingElement = this.createHandle(field, type, parent);
                    }
                    LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
                    try {
                        field.traverse((ASTVisitor)localDeclarationVisitor, null);
                    }
                    catch (WrappedCoreException e) {
                        throw e.coreException;
                    }
                }
                if (!typeInHierarchy || (nodes = nodeSet.matchingNodes(field.declarationSourceStart, field.declarationSourceEnd)) == null) break block8;
                if ((this.matchContainer & 8) != 0) break block9;
                int l = nodes.length;
                for (int i = 0; i < l; ++i) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                }
                break block8;
            }
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(field, type, parent);
            }
            if (!this.encloses(enclosingElement)) break block8;
            int l = nodes.length;
            for (int i = 0; i < l; ++i) {
                ASTNode node = nodes[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                this.patternLocator.matchReportReference(node, enclosingElement, level, this);
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, IJavaElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        TypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        Integer level;
        int i;
        ASTNode[] nodes;
        boolean matchedClassContainer;
        IJavaElement enclosingElement = parent;
        if (enclosingElement == null) {
            enclosingElement = this.createTypeHandle(new String(type.name));
        } else if (enclosingElement instanceof IType) {
            enclosingElement = ((IType)parent).getType(new String(type.name));
        } else if (enclosingElement instanceof IMember) {
            IMember member = (IMember)parent;
            enclosingElement = member.isBinary() ? parent : member.getType(new String(type.name), occurrenceCount);
        }
        if (enclosingElement == null) {
            return;
        }
        if (accuracy > -1 && this.encloses(enclosingElement)) {
            int offset = type.sourceStart;
            SearchMatch match = this.newDeclarationMatch(enclosingElement, accuracy, offset, type.sourceEnd - offset + 1);
            this.report(match);
        }
        boolean bl = matchedClassContainer = (this.matchContainer & 2) != 0;
        if (type.javadoc != null && (nodes = nodeSet.matchingNodes(type.declarationSourceStart, type.sourceStart)) != null) {
            int i2;
            int l;
            if (!matchedClassContainer) {
                l = nodes.length;
                for (i2 = 0; i2 < l; ++i2) {
                    nodeSet.matchingNodes.removeKey(nodes[i2]);
                }
            } else {
                l = nodes.length;
                for (i2 = 0; i2 < l; ++i2) {
                    ASTNode node = nodes[i2];
                    Integer level2 = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (!this.encloses(enclosingElement)) continue;
                    this.patternLocator.matchReportReference(node, enclosingElement, level2, this);
                }
            }
        }
        if ((type.bits & 0x200) != 0) {
            Integer level3;
            TypeReference superType = type.allocation.type;
            if (superType != null && (level3 = (Integer)nodeSet.matchingNodes.removeKey(superType)) != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superType, enclosingElement, level3, this);
            }
        } else {
            TypeReference[] superInterfaces;
            Integer level4;
            TypeReference superClass = type.superclass;
            if (superClass != null && (level4 = (Integer)nodeSet.matchingNodes.removeKey(superClass)) != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superClass, enclosingElement, level4, this);
            }
            if ((superInterfaces = type.superInterfaces) != null) {
                int l = superInterfaces.length;
                for (i = 0; i < l; ++i) {
                    TypeReference superInterface = superInterfaces[i];
                    level = (Integer)nodeSet.matchingNodes.removeKey(superInterface);
                    if (level == null || !matchedClassContainer) continue;
                    this.patternLocator.matchReportReference(superInterface, enclosingElement, level, this);
                }
            }
        }
        boolean typeInHierarchy = type.binding == null || this.typeInHierarchy(type.binding);
        matchedClassContainer = matchedClassContainer && typeInHierarchy;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int l = fields.length;
            for (i = 0; i < l; ++i) {
                FieldDeclaration field = fields[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(field);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(field, type, enclosingElement, value, typeInHierarchy, nodeSet);
            }
        }
        if ((methods = type.methods) != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int l = methods.length;
            for (int i3 = 0; i3 < l; ++i3) {
                AbstractMethodDeclaration method = methods[i3];
                Integer level5 = (Integer)nodeSet.matchingNodes.removeKey(method);
                int value = level5 != null && matchedClassContainer ? level5 : -1;
                this.reportMatching(method, enclosingElement, value, typeInHierarchy, nodeSet);
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int l = memberTypes.length;
            for (int i4 = 0; i4 < l; ++i4) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration memberType = memberTypes[i4];
                Integer level6 = (Integer)nodeSet.matchingNodes.removeKey(memberType);
                int value = level6 != null && matchedClassContainer ? level6 : -1;
                this.reportMatching(memberType, enclosingElement, value, nodeSet, 1);
            }
        }
    }

    protected boolean typeInHierarchy(ReferenceBinding binding) {
        if (this.hierarchyResolver == null) {
            return true;
        }
        if (this.hierarchyResolver.subOrSuperOfFocus(binding)) {
            return true;
        }
        if (this.allSuperTypeNames != null) {
            char[][] compoundName = binding.compoundName;
            int length = this.allSuperTypeNames.length;
            for (int i = 0; i < length; ++i) {
                if (!CharOperation.equals(compoundName, this.allSuperTypeNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    public class WrappedCoreException
    extends RuntimeException {
        public CoreException coreException;
        private static final long serialVersionUID = 8354329870126121212L;

        public WrappedCoreException(CoreException coreException) {
            this.coreException = coreException;
        }
    }

    public static class WorkingCopyDocument
    extends JavaSearchDocument {
        public ICompilationUnit workingCopy;

        WorkingCopyDocument(ICompilationUnit workingCopy, SearchParticipant participant) {
            super(workingCopy.getPath().toString(), participant);
            this.charContents = ((CompilationUnit)workingCopy).getContents();
            this.workingCopy = workingCopy;
        }

        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        IJavaElement enclosingElement;
        MatchingNodeSet nodeSet;
        HashtableOfIntValues occurrencesCounts = new HashtableOfIntValues();

        public LocalDeclarationVisitor(IJavaElement enclosingElement, MatchingNodeSet nodeSet) {
            this.enclosingElement = enclosingElement;
            this.nodeSet = nodeSet;
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope unused) {
            try {
                char[] simpleName = (typeDeclaration.bits & 0x200) != 0 ? CharOperation.NO_CHAR : typeDeclaration.name;
                int occurrenceCount = this.occurrencesCounts.get(simpleName);
                occurrenceCount = occurrenceCount == Integer.MIN_VALUE ? 1 : ++occurrenceCount;
                this.occurrencesCounts.put(simpleName, occurrenceCount);
                if ((typeDeclaration.bits & 0x200) != 0) {
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, -1, this.nodeSet, occurrenceCount);
                } else {
                    Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(typeDeclaration);
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, level != null ? level : -1, this.nodeSet, occurrenceCount);
                }
                return false;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
    }
}

