/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;

public abstract class CoreFileSystemLibrary {
    private static final boolean caseSensitive = new File("a").compareTo(new File("A")) != 0;
    private static final long STAT_RESERVED = Long.MIN_VALUE;
    private static final long STAT_VALID = 0x4000000000000000L;
    private static final long STAT_FOLDER = 0x2000000000000000L;
    private static final long STAT_READ_ONLY = 0x1000000000000000L;
    private static final long STAT_LASTMODIFIED = 0xFFFFFFFFFFFFFFFL;
    private static final String LIBRARY_NAME = "core_2_1_0b";
    private static boolean hasNatives = false;
    private static boolean isUnicode = false;

    public static long getLastModified(long stat) {
        return stat & 0xFFFFFFFFFFFFFFFL;
    }

    public static long getLastModified(String fileName) {
        if (hasNatives) {
            return CoreFileSystemLibrary.getLastModified(CoreFileSystemLibrary.getStat(fileName));
        }
        return new File(fileName).lastModified();
    }

    public static long getStat(String fileName) {
        if (hasNatives) {
            return isUnicode ? CoreFileSystemLibrary.internalGetStatW(fileName.toCharArray()) : CoreFileSystemLibrary.internalGetStat(Convert.toPlatformBytes(fileName));
        }
        File target = new File(fileName);
        long result = target.lastModified();
        if (result == 0L) {
            return result;
        }
        result |= 0x4000000000000000L;
        if (target.isDirectory()) {
            result |= 0x2000000000000000L;
        }
        if (!new File(fileName).canWrite()) {
            result |= 0x1000000000000000L;
        }
        return result;
    }

    private static void logMissingNativeLibrary(UnsatisfiedLinkError e) {
        String libName = System.mapLibraryName(LIBRARY_NAME);
        String message = Policy.bind("localstore.couldNotLoadLibrary", libName);
        ResourceStatus status = new ResourceStatus(1, null, message, null);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    private static final native long internalGetStat(byte[] var0);

    private static final native long internalGetStatW(char[] var0);

    private static final native boolean internalIsUnicode();

    private static final native boolean internalSetReadOnlyW(char[] var0, boolean var1);

    private static final native boolean internalSetReadOnly(byte[] var0, boolean var1);

    public static boolean isFile(long stat) {
        return CoreFileSystemLibrary.isSet(stat, 0x4000000000000000L) && !CoreFileSystemLibrary.isSet(stat, 0x2000000000000000L);
    }

    public static boolean isFolder(long stat) {
        return CoreFileSystemLibrary.isSet(stat, 0x4000000000000000L) && CoreFileSystemLibrary.isSet(stat, 0x2000000000000000L);
    }

    public static boolean isReadOnly(String fileName) {
        return CoreFileSystemLibrary.isSet(CoreFileSystemLibrary.getStat(fileName), 0x1000000000000000L);
    }

    public static boolean isReadOnly(long stat) {
        return CoreFileSystemLibrary.isSet(stat, 0x1000000000000000L);
    }

    private static boolean isSet(long stat, long mask) {
        return (stat & mask) != 0L;
    }

    public static boolean setReadOnly(String fileName, boolean readOnly) {
        if (hasNatives) {
            return isUnicode ? CoreFileSystemLibrary.internalSetReadOnlyW(fileName.toCharArray(), readOnly) : CoreFileSystemLibrary.internalSetReadOnly(Convert.toPlatformBytes(fileName), readOnly);
        }
        if (!readOnly) {
            return false;
        }
        return new File(fileName).setReadOnly();
    }

    public static boolean isCaseSensitive() {
        return caseSensitive;
    }

    public static boolean copyAttributes(String source, String destination, boolean copyLastModified) {
        if (hasNatives) {
            return isUnicode ? CoreFileSystemLibrary.internalCopyAttributesW(source.toCharArray(), destination.toCharArray(), copyLastModified) : CoreFileSystemLibrary.internalCopyAttributes(Convert.toPlatformBytes(source), Convert.toPlatformBytes(destination), copyLastModified);
        }
        return false;
    }

    public static boolean usingNatives() {
        return hasNatives;
    }

    private static final native boolean internalCopyAttributes(byte[] var0, byte[] var1, boolean var2);

    private static final native boolean internalCopyAttributesW(char[] var0, char[] var1, boolean var2);

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            hasNatives = true;
            isUnicode = CoreFileSystemLibrary.internalIsUnicode();
        }
        catch (UnsatisfiedLinkError e) {
            CoreFileSystemLibrary.logMissingNativeLibrary(e);
        }
    }
}

